/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.web.controller.notice;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.egov.config.search.Index;
import org.egov.config.search.IndexType;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.utils.FileStoreUtils;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.search.domain.Document;
import org.egov.search.domain.Page;
import org.egov.search.domain.SearchResult;
import org.egov.search.domain.Sort;
import org.egov.search.service.SearchService;
import org.egov.stms.elasticSearch.entity.SewerageNoticeSearchRequest;
import org.egov.stms.notice.entity.SewerageNotice;
import org.egov.stms.notice.service.SewerageNoticeService;
import org.egov.stms.utils.SewerageTaxUtils;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/reports"})
public class SewerageNoticeController {
    String noticeType = null;
    String noticeTypeInput = null;
    private static final Logger LOGGER = Logger.getLogger(SewerageNoticeController.class);
    @Autowired
    private SewerageTaxUtils sewerageTaxUtils;
    @Autowired
    private SearchService searchService;
    @Autowired
    private CityService cityService;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private SewerageNoticeService sewerageNoticeService;
    @Autowired
    @Qualifier(value="fileStoreService")
    protected FileStoreService fileStoreService;
    @Autowired
    private FileStoreUtils fileStoreUtils;

    @RequestMapping(value={"/search-notice"}, method={RequestMethod.GET})
    public String newSearchNoticeForm(Model model) {
        model.addAttribute("revenueWards", (Object)this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("WARD", "REVENUE"));
        return "searchSewerageNotices";
    }

    @RequestMapping(value={"/searchResult"}, method={RequestMethod.POST})
    @ResponseBody
    public List<Document> searchApplication(@ModelAttribute SewerageNoticeSearchRequest searchRequest) {
        City cityWebsite = this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName());
        searchRequest.setUlbName(cityWebsite.getName());
        Sort sort = Sort.by().field("searchable.consumername", SortOrder.DESC);
        SearchResult searchResult = this.searchService.search(Arrays.asList(Index.SEWARAGE.toString()), Arrays.asList(IndexType.SEWARAGESEARCH.toString()), searchRequest.searchQuery(), searchRequest.searchFilters(), sort, Page.NULL);
        ArrayList<Document> searchResultFomatted = new ArrayList<Document>(0);
        for (Document document : searchResult.getDocuments()) {
            searchResultFomatted.add(document);
        }
        return searchResultFomatted;
    }

    @RequestMapping(value={"/search-NoticeResultSize"}, method={RequestMethod.GET})
    @ResponseBody
    public int getSerachResultCount(@ModelAttribute SewerageNoticeSearchRequest searchRequest) {
        City cityWebsite = this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName());
        searchRequest.setUlbName(cityWebsite.getName());
        Sort sort = Sort.by().field("searchable.consumername", SortOrder.DESC);
        SearchResult searchResult = this.searchService.search(Arrays.asList(Index.SEWARAGE.toString()), Arrays.asList(IndexType.SEWARAGESEARCH.toString()), searchRequest.searchQuery(), searchRequest.searchFilters(), sort, Page.NULL);
        return searchResult.getDocuments().size();
    }

    @RequestMapping(value={"/searchNotices-mergeAndDownload"}, method={RequestMethod.GET})
    public String mergeAndDownload(@ModelAttribute SewerageNoticeSearchRequest searchRequest, HttpServletResponse response) throws Exception {
        String noticeNo = null;
        City cityWebsite = this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName());
        searchRequest.setUlbName(cityWebsite.getName());
        Sort sort = Sort.by().field("searchable.consumername", SortOrder.DESC);
        SearchResult searchResult = this.searchService.search(Arrays.asList(Index.SEWARAGE.toString()), Arrays.asList(IndexType.SEWARAGESEARCH.toString()), searchRequest.searchQuery(), searchRequest.searchFilters(), sort, Page.NULL);
        ArrayList<SewerageNotice> noticeList = new ArrayList<SewerageNotice>(0);
        for (Document document : searchResult.getDocuments()) {
            Map searchableObjects = (Map)document.getResource().get((Object)"searchable");
            this.noticeTypeInput = searchRequest.getNoticeType();
            if (this.noticeTypeInput != null && this.noticeTypeInput.equals("WO")) {
                noticeNo = (String)searchableObjects.get("workordernumber");
            } else if (this.noticeTypeInput != null && this.noticeTypeInput.equals("EM")) {
                noticeNo = (String)searchableObjects.get("estimationnumber");
            } else if (this.noticeTypeInput != null && this.noticeTypeInput.equals("CC")) {
                noticeNo = (String)searchableObjects.get("closurenoticenumber");
            }
            if (noticeNo == null) continue;
            this.getSewerageNoticeType(noticeNo, this.noticeTypeInput);
            SewerageNotice sewerageNotice = this.sewerageNoticeService.findByNoticeNoAndNoticeType(noticeNo, this.noticeType);
            if (sewerageNotice == null) continue;
            noticeList.add(sewerageNotice);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Entered into mergeAndDownload method");
        }
        long startTime = System.currentTimeMillis();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("mergeAndDownload : Start Time : " + startTime));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Number of notices : " + (noticeList != null ? Integer.valueOf(noticeList.size()) : BigDecimal.ZERO)));
        }
        if (null == noticeList || noticeList.size() <= 0) {
            // empty if block
        }
        ArrayList<ByteArrayInputStream> pdfs = new ArrayList<ByteArrayInputStream>();
        if (noticeList != null && noticeList.size() > 0) {
            for (SewerageNotice sewerageNotice : noticeList) {
                try {
                    if (sewerageNotice == null || sewerageNotice.getFileStore() == null) continue;
                    sewerageNotice.getApplicationDetails().getConnectionDetail().getPropertyIdentifier();
                    FileStoreMapper fsm = sewerageNotice.getFileStore();
                    File file = this.fileStoreService.fetch(fsm, "STMS");
                    if (file.length() <= 0L) continue;
                    byte[] bFile = FileUtils.readFileToByteArray((File)file);
                    pdfs.add(new ByteArrayInputStream(bFile));
                }
                catch (Exception e) {
                    LOGGER.error((Object)("mergeAndDownload : Getting notice failed for notice " + sewerageNotice), (Throwable)e);
                }
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Number of pdfs : " + (pdfs != null ? Integer.valueOf(pdfs.size()) : BigDecimal.ZERO)));
        }
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] data = this.sewerageNoticeService.mergePdfFiles(pdfs, (OutputStream)output);
            response.setHeader("Content-disposition", "attachment;filename=notice_" + this.noticeType + ".pdf");
            response.setContentType("application/pdf");
            response.setContentLength(data.length);
            response.getOutputStream().write(data);
        }
        catch (IOException e) {
            LOGGER.error((Object)"Exception in Merge and Download : ", (Throwable)e);
            throw new ValidationException(Arrays.asList(new ValidationError("error", e.getMessage())));
        }
        long endTime = System.currentTimeMillis();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("mergeAndDownload : End Time : " + endTime));
            LOGGER.debug((Object)("SearchNoticesAction | mergeAndDownload | Time taken(ms) " + (endTime - startTime)));
            LOGGER.debug((Object)"Exit from mergeAndDownload method");
        }
        return null;
    }

    @RequestMapping(value={"/searchNotices-seweragezipAndDownload"})
    public String zipAndDownload(@ModelAttribute SewerageNoticeSearchRequest searchRequest, HttpServletResponse response) throws ValidationException {
        String noticeNo = null;
        City cityWebsite = this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName());
        searchRequest.setUlbName(cityWebsite.getName());
        Sort sort = Sort.by().field("searchable.consumername", SortOrder.DESC);
        SearchResult searchResult = this.searchService.search(Arrays.asList(Index.SEWARAGE.toString()), Arrays.asList(IndexType.SEWARAGESEARCH.toString()), searchRequest.searchQuery(), searchRequest.searchFilters(), sort, Page.NULL);
        ArrayList<SewerageNotice> noticeList = new ArrayList<SewerageNotice>(0);
        for (Document document : searchResult.getDocuments()) {
            Map searchableObjects = (Map)document.getResource().get((Object)"searchable");
            this.noticeTypeInput = searchRequest.getNoticeType();
            if (this.noticeTypeInput != null && this.noticeTypeInput.equals("WO")) {
                noticeNo = (String)searchableObjects.get("workordernumber");
            } else if (this.noticeTypeInput != null && this.noticeTypeInput.equals("EM")) {
                noticeNo = (String)searchableObjects.get("estimationnumber");
            } else if (this.noticeTypeInput != null && this.noticeTypeInput.equals("CC")) {
                noticeNo = (String)searchableObjects.get("closurenoticenumber");
            }
            if (noticeNo == null) continue;
            this.getSewerageNoticeType(noticeNo, this.noticeTypeInput);
            SewerageNotice sewerageNotice = this.sewerageNoticeService.findByNoticeNoAndNoticeType(noticeNo, this.noticeType);
            if (sewerageNotice == null) continue;
            noticeList.add(sewerageNotice);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Entered into zipAndDownload method");
        }
        long startTime = System.currentTimeMillis();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("zipAndDownload : Start Time : " + startTime));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Number of notices : " + (noticeList != null ? Integer.valueOf(noticeList.size()) : BigDecimal.ZERO)));
        }
        try {
            ZipOutputStream zipOutputStream = null;
            if (noticeList != null && noticeList.size() > 0) {
                zipOutputStream = new ZipOutputStream((OutputStream)response.getOutputStream());
                response.setHeader("Content-disposition", "attachment;filename=notice_.zip");
                response.setContentType("application/zip");
            }
            for (SewerageNotice sewerageNotice : noticeList) {
                try {
                    if (sewerageNotice == null || sewerageNotice.getFileStore() == null) continue;
                    FileStoreMapper fsm = sewerageNotice.getFileStore();
                    File file = this.fileStoreService.fetch(fsm, "STMS");
                    byte[] bFile = FileUtils.readFileToByteArray((File)file);
                    zipOutputStream = this.sewerageNoticeService.addFilesToZip((InputStream)new ByteArrayInputStream(bFile), file.getName(), zipOutputStream);
                }
                catch (Exception e) {
                    LOGGER.error((Object)("zipAndDownload : Getting notice failed for notice " + sewerageNotice), (Throwable)e);
                }
            }
            zipOutputStream.closeEntry();
            zipOutputStream.close();
        }
        catch (IOException e) {
            LOGGER.error((Object)"Exception in Zip and Download : ", (Throwable)e);
            throw new ValidationException(Arrays.asList(new ValidationError("error", e.getMessage())));
        }
        long endTime = System.currentTimeMillis();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("zipAndDownload : End Time : " + endTime));
            LOGGER.debug((Object)("SewerageNoticeController | zipAndDownload | Time taken(ms) " + (endTime - startTime)));
            LOGGER.debug((Object)"Exit from zipAndDownload method");
        }
        return null;
    }

    public void getSewerageNoticeType(String noticeNo, String noticeTypeInput) {
        if (noticeNo != null && noticeTypeInput.equals("WO")) {
            this.noticeType = "Workorder Notice";
        } else if (noticeNo != null && noticeTypeInput.equals("EM")) {
            this.noticeType = "Estimation Notice";
        } else if (noticeNo != null && noticeTypeInput.equals("CC")) {
            this.noticeType = "Close Connection Notice";
        }
    }

    @RequestMapping(value={"/searchNotices-showSewerageNotice/{noticeNo}/{noticeType}"}, method={RequestMethod.GET})
    public String showNotice(@PathVariable(value="noticeNo") String noticeNo, @PathVariable(value="noticeType") String noticeTypeInput, Model model, HttpServletResponse response) throws IOException {
        if (noticeNo != null) {
            this.getSewerageNoticeType(noticeNo, noticeTypeInput);
            SewerageNotice sewerageNotice = this.sewerageNoticeService.findByNoticeNoAndNoticeType(noticeNo, this.noticeType);
            if (sewerageNotice != null) {
                int len;
                FileStoreMapper fsm = sewerageNotice.getFileStore();
                File file = this.fileStoreService.fetch(fsm, "STMS");
                FileInputStream is = new FileInputStream(file);
                response.setContentType("application/pdf");
                response.setHeader("Content-Disposition", "attachment; filename=\"" + sewerageNotice.getNoticeNo() + ".pdf\"");
                ServletOutputStream os = response.getOutputStream();
                byte[] buffer = new byte[1024];
                while ((len = ((InputStream)is).read(buffer)) != -1) {
                    os.write(buffer, 0, len);
                }
                os.flush();
                os.close();
                ((InputStream)is).close();
            } else {
                model.addAttribute("message", (Object)"msg.notice.not.found");
                return "common-error";
            }
        }
        return null;
    }
}

