/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.web.controller.masters;

import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.egov.config.search.Index;
import org.egov.config.search.IndexType;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.config.properties.ApplicationProperties;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.search.domain.Document;
import org.egov.search.domain.Page;
import org.egov.search.domain.SearchResult;
import org.egov.search.domain.Sort;
import org.egov.search.service.SearchService;
import org.egov.stms.masters.entity.enums.PropertyType;
import org.egov.stms.masters.pojo.DCBReportWardwiseResult;
import org.egov.stms.transactions.entity.SewerageApplicationDetails;
import org.egov.stms.transactions.service.SewerageApplicationDetailsService;
import org.egov.stms.transactions.service.SewerageDCBReporService;
import org.egov.stms.transactions.service.SewerageThirdPartyServices;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/reports"})
public class SewerageRateDCBReportController {
    @Autowired
    private SewerageApplicationDetailsService sewerageApplicationDetailsService;
    @Autowired
    private SewerageDCBReporService sewerageDCBReporService;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private SewerageThirdPartyServices sewerageThirdPartyServices;
    @PersistenceContext
    EntityManager entityManager;
    @Autowired
    private SearchService searchService;
    @Autowired
    private CityService cityService;
    @Autowired
    private ApplicationProperties applicationProperties;

    @ModelAttribute
    public DCBReportWardwiseResult dCBReportWardWise() {
        return new DCBReportWardwiseResult();
    }

    @RequestMapping(value={"/sewerageRateReportView/{consumernumber}/{assessmentnumber}"}, method={RequestMethod.GET})
    public ModelAndView getSewerageRateReport(@ModelAttribute SewerageApplicationDetails sewerageApplicationDetails, @PathVariable String consumernumber, @PathVariable String assessmentnumber, Model model, ModelMap modelMap, HttpServletRequest request) {
        SimpleDateFormat formatter = new SimpleDateFormat("dd-MM-yyyy");
        String currentDate = formatter.format(new Date());
        if (consumernumber != null && (sewerageApplicationDetails = this.sewerageApplicationDetailsService.findByApplicationNumber(consumernumber)) != null) {
            AssessmentDetails propertyOwnerDetails = this.sewerageThirdPartyServices.getPropertyDetails(assessmentnumber, request);
            model.addAttribute("applicationNumber", (Object)sewerageApplicationDetails.getApplicationNumber());
            model.addAttribute("propertyOwnerDetails", (Object)propertyOwnerDetails);
            model.addAttribute("assessmentnumber", (Object)assessmentnumber);
            model.addAttribute("currentDate", (Object)currentDate);
            model.addAttribute("dcbResultList", (Object)this.sewerageDCBReporService.getSewerageRateDCBReport(sewerageApplicationDetails));
        }
        return new ModelAndView("report-sewerageRate-view", "sewerageApplicationDetails", (Object)sewerageApplicationDetails);
    }

    @RequestMapping(value={"/dcb-report-wardwise"}, method={RequestMethod.GET})
    public String WardwiseSearch(@ModelAttribute DCBReportWardwiseResult dcbReportWardwiseResult, Model model) {
        model.addAttribute("dcbReportWardwiseResult", (Object)dcbReportWardwiseResult);
        ArrayList<String> propertytype = new ArrayList<String>();
        for (PropertyType s : PropertyType.values()) {
            propertytype.add(s.toString());
        }
        ArrayList<String> boundaryList = new ArrayList<String>();
        List bList = new ArrayList();
        boundaryList.add("ALL");
        bList = this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Ward", "REVENUE");
        for (Boundary b : bList) {
            boundaryList.add(b.toString());
        }
        model.addAttribute("propertyType", propertytype);
        model.addAttribute("wards", (Object)this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Ward", "REVENUE"));
        return "sewerage-dcbwardwise";
    }

    @RequestMapping(value={"/dcbReportWardwiseList"}, method={RequestMethod.GET})
    @ResponseBody
    public void searchApplication(@ModelAttribute DCBReportWardwiseResult searchRequest, Model model, HttpServletResponse response) throws IOException {
        ArrayList<Boundary> wardList = new ArrayList<Boundary>();
        ArrayList wards = new ArrayList();
        String wardValue = null;
        HashMap dcbMap = new HashMap();
        if (searchRequest.getMode() != null) {
            String[] wardIds;
            for (String idValue : wardIds = searchRequest.getMode().split("~")) {
                Boundary ward = this.boundaryService.getBoundaryById(Long.valueOf(Long.parseLong(idValue)));
                if (ward == null) continue;
                wardList.add(ward);
            }
        }
        if (wardList != null && !wardList.isEmpty()) {
            searchRequest.setWards(wardList);
        }
        City cityWebsite = this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName());
        searchRequest.setUlbName(cityWebsite.getName());
        Sort sort = Sort.by().field("clauses.applicationdate", SortOrder.DESC);
        if (null != searchRequest.getWards() && !searchRequest.getWards().isEmpty() && searchRequest.getWards().get(0) != null) {
            wards.addAll(searchRequest.getWards());
        } else {
            wards.addAll(this.boundaryService.getBoundariesByBndryTypeNameAndHierarchyTypeName("Ward", "REVENUE"));
        }
        for (Boundary boundary : wards) {
            if (boundary != null) {
                searchRequest.setRevenueWard(boundary.getLocalName());
                model.addAttribute("wardId", (Object)boundary.getId());
            }
            SearchResult searchResult = this.searchService.search(Arrays.asList(Index.SEWARAGE.toString()), Arrays.asList(IndexType.SEWARAGESEARCH.toString()), searchRequest.searchQuery(), searchRequest.searchFilters(), sort, Page.NULL);
            for (Document document : searchResult.getDocuments()) {
                Map searchableObjects = (Map)document.getResource().get((Object)"searchable");
                Map clausesObject = (Map)document.getResource().get((Object)"clauses");
                ArrayList<SewerageApplicationDetails> appList = null;
                wardValue = (String)clausesObject.get("revwardname");
                SewerageApplicationDetails sewerageAppDtl = this.sewerageApplicationDetailsService.findByApplicationNumber((String)searchableObjects.get("consumernumber"));
                if (sewerageAppDtl == null || sewerageAppDtl.getApplicationType().getCode().equals("CLOSESEWERAGECONNECTION")) continue;
                if (null != dcbMap.get(wardValue)) {
                    ((List)dcbMap.get(wardValue)).add(sewerageAppDtl);
                    continue;
                }
                appList = new ArrayList<SewerageApplicationDetails>();
                appList.add(sewerageAppDtl);
                dcbMap.put(wardValue, appList);
            }
        }
        IOUtils.write((String)("{ \"data\":" + new GsonBuilder().setDateFormat(this.applicationProperties.defaultDatePattern()).create().toJson((Object)this.sewerageDCBReporService.getSewerageRateDCBWardwiseReport(dcbMap, searchRequest.getPropertyType())) + "}"), (Writer)response.getWriter());
    }

    @RequestMapping(value={"/dcbViewWardConnections/{id}"}, method={RequestMethod.GET})
    public String getConnectionDCBReport(@ModelAttribute DCBReportWardwiseResult searchRequest, Model model, @PathVariable String id, HttpServletRequest request) {
        String propType = null;
        Long wardId = null;
        String revenueWard = null;
        String[] wardDtl = id.split("~");
        ArrayList<String> wardList = new ArrayList<String>();
        ArrayList<SewerageApplicationDetails> applicationDetailList = new ArrayList<SewerageApplicationDetails>();
        HashMap wardConnectionMap = new HashMap();
        for (String value : wardDtl) {
            wardList.add(value);
        }
        wardId = Long.parseLong((String)wardList.get(0));
        if (wardId != null) {
            Boundary boundary = this.boundaryService.getBoundaryById(wardId);
            revenueWard = boundary.getLocalName();
        }
        if (wardList.size() == 2 && (null != wardList.get(1) || wardList.get(1) != "")) {
            propType = (String)wardList.get(1);
        }
        City cityWebsite = this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName());
        searchRequest.setUlbName(cityWebsite.getName());
        Sort sort = Sort.by().field("clauses.applicationdate", SortOrder.DESC);
        searchRequest.setPropertyType(propType);
        searchRequest.setRevenueWard(revenueWard);
        SearchResult searchResult = this.searchService.search(Arrays.asList(Index.SEWARAGE.toString()), Arrays.asList(IndexType.SEWARAGESEARCH.toString()), searchRequest.searchQuery(), searchRequest.searchFilters(), sort, Page.NULL);
        for (Document document : searchResult.getDocuments()) {
            Map searchableObjects = (Map)document.getResource().get((Object)"searchable");
            ArrayList<SewerageApplicationDetails> appList = new ArrayList<SewerageApplicationDetails>();
            SewerageApplicationDetails sewerageAppDtl = this.sewerageApplicationDetailsService.findByApplicationNumber((String)searchableObjects.get("consumernumber"));
            if (sewerageAppDtl != null) {
                sewerageAppDtl.setOwnerName((String)searchableObjects.get("consumername"));
            }
            if (applicationDetailList.isEmpty() && sewerageAppDtl != null) {
                applicationDetailList.add(sewerageAppDtl);
            }
            if (null == sewerageAppDtl) continue;
            if (wardConnectionMap.isEmpty()) {
                wardConnectionMap.put(sewerageAppDtl.getApplicationNumber(), applicationDetailList);
                continue;
            }
            if (wardConnectionMap.get(sewerageAppDtl.getApplicationNumber()) != null) {
                ((List)wardConnectionMap.get(sewerageAppDtl.getApplicationNumber())).add(sewerageAppDtl);
                continue;
            }
            appList.add(sewerageAppDtl);
            wardConnectionMap.put(sewerageAppDtl.getApplicationNumber(), appList);
        }
        model.addAttribute("revenueWard", (Object)revenueWard);
        model.addAttribute("dcbResultList", (Object)this.sewerageDCBReporService.getSewerageDCBWardConnections(wardConnectionMap, propType, request));
        return "sewerage-dcbWardConnections";
    }
}

