/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.web.controller.elasticSearch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.egov.config.search.Index;
import org.egov.config.search.IndexType;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.search.domain.Document;
import org.egov.search.domain.Page;
import org.egov.search.domain.SearchResult;
import org.egov.search.domain.Sort;
import org.egov.search.service.SearchService;
import org.egov.stms.elasticSearch.entity.SewerageCollectFeeSearchRequest;
import org.egov.stms.elasticSearch.entity.SewerageSearchResult;
import org.egov.stms.transactions.entity.SewerageApplicationDetails;
import org.egov.stms.transactions.service.SewerageApplicationDetailsService;
import org.egov.stms.transactions.service.SewerageConnectionService;
import org.egov.stms.transactions.service.SewerageThirdPartyServices;
import org.egov.stms.utils.SewerageActionDropDownUtil;
import org.egov.stms.utils.SewerageTaxUtils;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/collectfee/search"})
public class SewerageCollectFeeSearchController {
    @Autowired
    private SearchService searchService;
    @Autowired
    private CityService cityService;
    @Autowired
    private SewerageApplicationDetailsService sewerageApplicationDetailsService;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private SewerageTaxUtils sewerageTaxUtils;
    @Autowired
    private SewerageConnectionService sewerageConnectionService;
    @Autowired
    private SewerageThirdPartyServices sewerageThirdPartyServices;
    private static final Logger LOGGER = Logger.getLogger(SewerageCollectFeeSearchController.class);

    @ModelAttribute
    public SewerageCollectFeeSearchRequest searchRequest() {
        return new SewerageCollectFeeSearchRequest();
    }

    @RequestMapping(method={RequestMethod.GET})
    public String newSearchForm(Model model) {
        return "seweragecollectcharges-form";
    }

    @ModelAttribute(value="revenueWards")
    public List<Boundary> revenueWardList() {
        return this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("WARD", "REVENUE");
    }

    @RequestMapping(value={"/view/{consumernumber}/{assessmentnumber}"}, method={RequestMethod.GET})
    public ModelAndView view(@PathVariable String consumernumber, @PathVariable String assessmentnumber, Model model, ModelMap modelMap, @ModelAttribute SewerageApplicationDetails sewerageApplicationDetails, HttpServletRequest request) {
        AssessmentDetails propertyOwnerDetails;
        if (consumernumber != null) {
            sewerageApplicationDetails = this.sewerageApplicationDetailsService.findByApplicationNumber(consumernumber);
        }
        if ((propertyOwnerDetails = this.sewerageThirdPartyServices.getPropertyDetails(assessmentnumber, request)) != null) {
            modelMap.addAttribute("propertyOwnerDetails", (Object)propertyOwnerDetails);
        }
        model.addAttribute("applicationHistory", (Object)this.sewerageApplicationDetailsService.getHistory(sewerageApplicationDetails));
        model.addAttribute("documentNamesList", (Object)this.sewerageConnectionService.getSewerageApplicationDoc(sewerageApplicationDetails));
        return new ModelAndView("viewseweragedetails", "sewerageApplicationDetails", (Object)sewerageApplicationDetails);
    }

    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public List<SewerageSearchResult> searchApplication(@ModelAttribute SewerageCollectFeeSearchRequest searchRequest) {
        City cityWebsite = this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName());
        searchRequest.setUlbName(cityWebsite.getName());
        Sort sort = Sort.by().field("searchable.shscnumber", SortOrder.DESC);
        SearchResult searchResult = this.searchService.search(Arrays.asList(Index.SEWARAGE.toString()), Arrays.asList(IndexType.SEWARAGESEARCH.toString()), searchRequest.searchQuery(), searchRequest.searchFilters(), sort, Page.NULL);
        ArrayList<String> roleList = new ArrayList<String>();
        for (Role userrole : this.sewerageTaxUtils.getLoginUserRoles()) {
            roleList.add(userrole.getName());
        }
        ArrayList<SewerageSearchResult> searchResultFomatted = new ArrayList<SewerageSearchResult>(0);
        SewerageApplicationDetails sewerageApplicationDetails = new SewerageApplicationDetails();
        for (Document document : searchResult.getDocuments()) {
            SewerageSearchResult searchActions;
            HashMap actionMap = new HashMap();
            Map searchableObjects = (Map)document.getResource().get((Object)"searchable");
            if (searchableObjects == null) continue;
            String consumernumber = (String)searchableObjects.get("consumernumber");
            String status = (String)searchableObjects.get("status");
            if ("Rejected".equals(status) || "Canceled".equals(status)) continue;
            if (consumernumber != null) {
                sewerageApplicationDetails = this.sewerageApplicationDetailsService.findByApplicationNumber(consumernumber);
            }
            if ((searchActions = SewerageActionDropDownUtil.getSearchResultWithActions(roleList, (String)((String)searchableObjects.get("status")), (SewerageApplicationDetails)sewerageApplicationDetails)) == null) continue;
            for (Map.Entry entry : searchActions.getActions().entrySet()) {
                if (!((String)entry.getValue()).equals("Collect Fee")) continue;
                actionMap.put(entry.getKey(), entry.getValue());
                break;
            }
            searchActions.setActions(actionMap);
            searchActions.setDocument(document);
            searchResultFomatted.add(searchActions);
        }
        return searchResultFomatted;
    }
}

