/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.web.controller.transactions;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.eis.web.controller.workflow.GenericWorkFlowController;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.PropertyTaxDetails;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.stms.masters.entity.DocumentTypeMaster;
import org.egov.stms.masters.entity.FeesDetailMaster;
import org.egov.stms.masters.entity.SewerageApplicationType;
import org.egov.stms.masters.entity.enums.PropertyType;
import org.egov.stms.masters.entity.enums.SewerageConnectionStatus;
import org.egov.stms.masters.service.DocumentTypeMasterService;
import org.egov.stms.masters.service.FeesDetailMasterService;
import org.egov.stms.masters.service.SewerageApplicationTypeService;
import org.egov.stms.transactions.entity.SewerageApplicationDetails;
import org.egov.stms.transactions.entity.SewerageApplicationDetailsDocument;
import org.egov.stms.transactions.entity.SewerageConnection;
import org.egov.stms.transactions.entity.SewerageConnectionFee;
import org.egov.stms.transactions.service.SewerageApplicationDetailsService;
import org.egov.stms.transactions.service.SewerageConnectionService;
import org.egov.stms.transactions.service.SewerageThirdPartyServices;
import org.egov.stms.utils.SewerageTaxUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/transactions"})
public class SewerageConnectionController
extends GenericWorkFlowController {
    private static final Logger LOG = LoggerFactory.getLogger(SewerageConnectionController.class);
    private final SewerageTaxUtils sewerageTaxUtils;
    private final SewerageApplicationDetailsService sewerageApplicationDetailsService;
    @Autowired
    private SewerageConnectionService sewerageConnectionService;
    @Autowired
    private SewerageApplicationTypeService sewerageApplicationTypeService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    protected AssignmentService assignmentService;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private PropertyExternalService propertyExternalService;
    @Autowired
    private FeesDetailMasterService feesDetailMasterService;
    @Autowired
    @Qualifier(value="fileStoreService")
    protected FileStoreService fileStoreService;
    @Autowired
    private SewerageThirdPartyServices sewerageThirdPartyServices;
    @Autowired
    private DocumentTypeMasterService documentTypeMasterService;

    @Autowired
    public SewerageConnectionController(SewerageTaxUtils sewerageTaxUtils, SewerageApplicationDetailsService sewerageApplicationDetailsService) {
        this.sewerageTaxUtils = sewerageTaxUtils;
        this.sewerageApplicationDetailsService = sewerageApplicationDetailsService;
    }

    @ModelAttribute(value="documentNamesList")
    public List<SewerageApplicationDetailsDocument> documentTypeMasterList(@ModelAttribute SewerageApplicationDetails sewerageApplicationDetails) {
        ArrayList<SewerageApplicationDetailsDocument> tempDocList = new ArrayList<SewerageApplicationDetailsDocument>(0);
        SewerageApplicationType applicationType = this.sewerageApplicationTypeService.findByCode("NEWSEWERAGECONNECTION");
        List documentTypeMasterList = this.documentTypeMasterService.getAllActiveDocumentTypeMasterByApplicationType(applicationType);
        if (sewerageApplicationDetails != null) {
            for (DocumentTypeMaster dtm : documentTypeMasterList) {
                SewerageApplicationDetailsDocument sad = new SewerageApplicationDetailsDocument();
                if (dtm == null) continue;
                sad.setDocumentTypeMaster(dtm);
                tempDocList.add(sad);
            }
        }
        return tempDocList;
    }

    @RequestMapping(value={"/newConnection-newform"}, method={RequestMethod.GET})
    public String showNewApplicationForm(@ModelAttribute SewerageApplicationDetails sewerageApplicationDetails, Model model, HttpServletRequest request) {
        LOG.debug("Inside showNewApplicationForm method");
        SewerageApplicationType applicationType = this.sewerageApplicationTypeService.findByCode("NEWSEWERAGECONNECTION");
        sewerageApplicationDetails.setApplicationType(applicationType);
        sewerageApplicationDetails.setApplicationDate(new Date());
        SewerageConnection connection = new SewerageConnection();
        connection.setStatus(SewerageConnectionStatus.INPROGRESS);
        sewerageApplicationDetails.setConnection(connection);
        model.addAttribute("allowIfPTDueExists", (Object)this.sewerageTaxUtils.isNewConnectionAllowedIfPTDuePresent());
        model.addAttribute("propertyTypes", (Object)PropertyType.values());
        model.addAttribute("additionalRule", (Object)sewerageApplicationDetails.getApplicationType().getCode());
        WorkflowContainer workFlowContainer = new WorkflowContainer();
        workFlowContainer.setAdditionalRule(sewerageApplicationDetails.getApplicationType().getCode());
        this.prepareWorkflow(model, (StateAware)sewerageApplicationDetails, workFlowContainer);
        model.addAttribute("currentUser", (Object)this.sewerageTaxUtils.getCurrentUserRole(this.securityUtils.getCurrentUser()));
        model.addAttribute("stateType", (Object)sewerageApplicationDetails.getClass().getSimpleName());
        model.addAttribute("typeOfConnection", (Object)"NEWSEWERAGECONNECTION");
        boolean inspectionFeeCollectionRequired = this.sewerageTaxUtils.isInspectionFeeCollectionRequired();
        model.addAttribute("inspectionFeesCollectionRequired", (Object)inspectionFeeCollectionRequired);
        if (inspectionFeeCollectionRequired) {
            this.createSewerageConnectionFee(sewerageApplicationDetails, "INSPECTIONCHARGE");
        }
        model.addAttribute("mode", null);
        return "newconnection-form";
    }

    private void createSewerageConnectionFee(SewerageApplicationDetails sewerageApplicationDetails, String feeCode) {
        List inspectionFeeList = this.feesDetailMasterService.findAllActiveFeesDetailByFeesCode(feeCode);
        for (FeesDetailMaster feeDetailMaster : inspectionFeeList) {
            SewerageConnectionFee connectionFee = new SewerageConnectionFee();
            connectionFee.setFeesDetail(feeDetailMaster);
            if (feeDetailMaster.getIsFixedRate().booleanValue()) {
                connectionFee.setAmount(feeDetailMaster.getAmount().doubleValue());
            }
            connectionFee.setApplicationDetails(sewerageApplicationDetails);
            sewerageApplicationDetails.getConnectionFees().add(connectionFee);
        }
    }

    @RequestMapping(value={"/newConnection-create"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute SewerageApplicationDetails sewerageApplicationDetails, BindingResult resultBinder, RedirectAttributes redirectAttributes, HttpServletRequest request, Model model, @RequestParam String workFlowAction, BindingResult errors, @RequestParam(value="files") MultipartFile[] files) {
        this.validatePropertyID(sewerageApplicationDetails, resultBinder, request);
        ArrayList applicationDocs = new ArrayList();
        int i = 0;
        if (!sewerageApplicationDetails.getAppDetailsDocument().isEmpty()) {
            for (SewerageApplicationDetailsDocument applicationDocument : sewerageApplicationDetails.getAppDetailsDocument()) {
                this.sewerageConnectionService.validateDocuments(applicationDocs, applicationDocument, i, resultBinder);
                ++i;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.error("Model Level Validation occurs = " + resultBinder);
        }
        if (resultBinder.hasErrors()) {
            sewerageApplicationDetails.setApplicationDate(new Date());
            model.addAttribute("validateIfPTDueExists", (Object)this.sewerageTaxUtils.isNewConnectionAllowedIfPTDuePresent());
            model.addAttribute("propertyTypes", (Object)PropertyType.values());
            this.prepareWorkflow(model, (StateAware)sewerageApplicationDetails, new WorkflowContainer());
            model.addAttribute("additionalRule", (Object)sewerageApplicationDetails.getApplicationType().getCode());
            model.addAttribute("currentUser", (Object)this.sewerageTaxUtils.getCurrentUserRole(this.securityUtils.getCurrentUser()));
            model.addAttribute("approvalPosOnValidate", (Object)request.getParameter("approvalPosition"));
            model.addAttribute("stateType", (Object)sewerageApplicationDetails.getClass().getSimpleName());
            return "newconnection-form";
        }
        if (sewerageApplicationDetails.getState() == null) {
            if (this.sewerageTaxUtils.isInspectionFeeCollectionRequired()) {
                sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("COLLECTINSPECTIONFEE", "SEWERAGETAXAPPLICATION"));
            } else {
                sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("CREATED", "SEWERAGETAXAPPLICATION"));
            }
        }
        sewerageApplicationDetails.getAppDetailsDocument().clear();
        sewerageApplicationDetails.setAppDetailsDocument(applicationDocs);
        this.sewerageConnectionService.processAndStoreApplicationDocuments(sewerageApplicationDetails);
        Long approvalPosition = 0L;
        String approvalComment = "";
        if (request.getParameter("approvalComment") != null) {
            approvalComment = request.getParameter("approvalComent");
        }
        if (request.getParameter("workFlowAction") != null) {
            workFlowAction = request.getParameter("workFlowAction");
        }
        if (request.getParameter("approvalPosition") != null && !request.getParameter("approvalPosition").isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter("approvalPosition"));
        }
        this.populateFeesDetails(sewerageApplicationDetails);
        SewerageApplicationDetails newSewerageApplicationDetails = this.sewerageApplicationDetailsService.createNewSewerageConnection(sewerageApplicationDetails, approvalPosition, approvalComment, sewerageApplicationDetails.getApplicationType().getCode(), files, workFlowAction, request);
        Assignment currentUserAssignment = this.assignmentService.getPrimaryAssignmentForGivenRange(this.securityUtils.getCurrentUser().getId(), new Date(), new Date());
        Assignment assignObj = null;
        List<Object> asignList = null;
        if (approvalPosition != null) {
            assignObj = this.assignmentService.getPrimaryAssignmentForPositon(approvalPosition);
        }
        if (assignObj != null) {
            asignList = new ArrayList<Assignment>();
            asignList.add(assignObj);
        } else if (assignObj == null && approvalPosition != null) {
            asignList = this.assignmentService.getAssignmentsForPosition(approvalPosition, new Date());
        }
        String nextDesign = !asignList.isEmpty() ? ((Assignment)asignList.get(0)).getDesignation().getName() : "";
        String pathVars = newSewerageApplicationDetails.getApplicationNumber() + "," + this.sewerageTaxUtils.getApproverName(approvalPosition) + "," + (currentUserAssignment != null ? currentUserAssignment.getDesignation().getName() : "") + "," + (nextDesign != null ? nextDesign : "");
        return "redirect:/transactions/application-success?pathVars=" + pathVars;
    }

    private void populateFeesDetails(SewerageApplicationDetails sewerageApplicationDetails) {
        if (sewerageApplicationDetails.getConnectionFees() != null && !sewerageApplicationDetails.getConnectionFees().isEmpty()) {
            for (SewerageConnectionFee scf : sewerageApplicationDetails.getConnectionFees()) {
                scf.setApplicationDetails(sewerageApplicationDetails);
            }
        }
    }

    @RequestMapping(value={"/application-success"}, method={RequestMethod.GET})
    public ModelAndView successView(@ModelAttribute SewerageApplicationDetails sewerageApplicationDetails, HttpServletRequest request, Model model, ModelMap modelMap) {
        String[] keyNameArray = request.getParameter("pathVars").split(",");
        String applicationNumber = "";
        String approverName = "";
        String currentUserDesgn = "";
        String nextDesign = "";
        if (keyNameArray.length != 0 && keyNameArray.length > 0) {
            if (keyNameArray.length == 1) {
                applicationNumber = keyNameArray[0];
            } else if (keyNameArray.length == 3) {
                applicationNumber = keyNameArray[0];
                approverName = keyNameArray[1];
                currentUserDesgn = keyNameArray[2];
            } else {
                applicationNumber = keyNameArray[0];
                approverName = keyNameArray[1];
                currentUserDesgn = keyNameArray[2];
                nextDesign = keyNameArray[3];
            }
        }
        if (applicationNumber != null) {
            sewerageApplicationDetails = this.sewerageApplicationDetailsService.findByApplicationNumber(applicationNumber);
        }
        model.addAttribute("approverName", (Object)approverName);
        model.addAttribute("currentUserDesgn", (Object)currentUserDesgn);
        model.addAttribute("nextDesign", (Object)nextDesign);
        model.addAttribute("cityName", (Object)ApplicationThreadLocals.getCityName());
        model.addAttribute("mode", (Object)"ack");
        this.setCommonDetails(sewerageApplicationDetails, modelMap, request);
        boolean inspectionFeeCollectionRequired = this.sewerageTaxUtils.isInspectionFeeCollectionRequired();
        model.addAttribute("inspectionFeesCollectionRequired", (Object)inspectionFeeCollectionRequired);
        if (inspectionFeeCollectionRequired) {
            model.addAttribute("inspectionDetails", (Object)sewerageApplicationDetails.getConnectionFees());
        }
        model.addAttribute("documentNamesList", (Object)this.sewerageConnectionService.getSewerageApplicationDoc(sewerageApplicationDetails));
        return new ModelAndView("application-success", "sewerageApplicationDetails", (Object)sewerageApplicationDetails);
    }

    private void setCommonDetails(SewerageApplicationDetails sewerageApplicationDetails, ModelMap modelMap, HttpServletRequest request) {
        String assessmentNumber = sewerageApplicationDetails.getConnectionDetail().getPropertyIdentifier();
        AssessmentDetails propertyOwnerDetails = this.sewerageThirdPartyServices.getPropertyDetails(assessmentNumber, request);
        if (propertyOwnerDetails != null) {
            modelMap.addAttribute("propertyOwnerDetails", (Object)propertyOwnerDetails);
        }
        PropertyTaxDetails propertyTaxDetails = this.propertyExternalService.getPropertyTaxDetails(assessmentNumber, null);
        modelMap.addAttribute("propertyTax", (Object)propertyTaxDetails.getTotalTaxAmt());
    }

    private void validatePropertyID(SewerageApplicationDetails sewerageApplicationDetails, BindingResult errors, HttpServletRequest request) {
        if (sewerageApplicationDetails.getConnectionDetail() != null && sewerageApplicationDetails.getConnectionDetail().getPropertyIdentifier() != null && !sewerageApplicationDetails.getConnectionDetail().getPropertyIdentifier().equals("")) {
            String errorMessage = this.sewerageApplicationDetailsService.checkValidPropertyAssessmentNumber(sewerageApplicationDetails.getConnectionDetail().getPropertyIdentifier());
            if (errorMessage != null && !errorMessage.equals("")) {
                errors.reject("err.connectionDetail.propertyIdentifier.validate", (Object[])new String[]{errorMessage}, null);
            } else {
                errorMessage = this.sewerageApplicationDetailsService.checkConnectionPresentForProperty(sewerageApplicationDetails.getConnectionDetail().getPropertyIdentifier());
                if (errorMessage != null && !errorMessage.equals("")) {
                    errors.reject("err.connectionDetail.propertyIdentifier.validate", (Object[])new String[]{errorMessage}, null);
                } else {
                    HashMap result = this.sewerageThirdPartyServices.getWaterTaxDueAndCurrentTax(sewerageApplicationDetails.getConnectionDetail().getPropertyIdentifier(), request);
                    BigDecimal waterTaxDue = (BigDecimal)result.get("WATERTAXDUE");
                    String consumerCode = result.get("CONSUMERCODE").toString();
                    if (consumerCode != "" && consumerCode != null) {
                        consumerCode = consumerCode.substring(1, consumerCode.length() - 1);
                    }
                    if (waterTaxDue.compareTo(BigDecimal.ZERO) > 0) {
                        errorMessage = "For Entered Property tax Assessment number " + sewerageApplicationDetails.getConnectionDetail().getPropertyIdentifier() + " linked water tap connection demand with Consumer code:" + consumerCode + " is due Rs." + waterTaxDue + "/- . Please clear demand and create new sewerage connection.";
                        errors.reject("err.connectionDetail.propertyIdentifier.validate", (Object[])new String[]{errorMessage}, null);
                    }
                }
            }
        }
    }
}

