/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.web.controller.notice;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.utils.FileStoreUtils;
import org.egov.stms.notice.entity.SewerageNotice;
import org.egov.stms.notice.service.SewerageNoticeService;
import org.egov.stms.utils.SewerageTaxUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/reports"})
public class SewerageNoticeController {
    String noticeType = null;
    String noticeTypeInput = null;
    private static final Logger LOGGER = Logger.getLogger(SewerageNoticeController.class);
    @Autowired
    private SewerageTaxUtils sewerageTaxUtils;
    @Autowired
    private CityService cityService;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private SewerageNoticeService sewerageNoticeService;
    @Autowired
    @Qualifier(value="fileStoreService")
    protected FileStoreService fileStoreService;
    @Autowired
    private FileStoreUtils fileStoreUtils;

    @RequestMapping(value={"/search-notice"}, method={RequestMethod.GET})
    public String newSearchNoticeForm(Model model) {
        model.addAttribute("revenueWards", (Object)this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("WARD", "REVENUE"));
        return "searchSewerageNotices";
    }

    public void getSewerageNoticeType(String noticeNo, String noticeTypeInput) {
        if (noticeNo != null && noticeTypeInput.equals("WO")) {
            this.noticeType = "Workorder Notice";
        } else if (noticeNo != null && noticeTypeInput.equals("EM")) {
            this.noticeType = "Estimation Notice";
        } else if (noticeNo != null && noticeTypeInput.equals("CC")) {
            this.noticeType = "Close Connection Notice";
        }
    }

    @RequestMapping(value={"/searchNotices-showSewerageNotice/{noticeNo}/{noticeType}"}, method={RequestMethod.GET})
    public String showNotice(@PathVariable(value="noticeNo") String noticeNo, @PathVariable(value="noticeType") String noticeTypeInput, Model model, HttpServletResponse response) throws IOException {
        if (noticeNo != null) {
            this.getSewerageNoticeType(noticeNo, noticeTypeInput);
            SewerageNotice sewerageNotice = this.sewerageNoticeService.findByNoticeNoAndNoticeType(noticeNo, this.noticeType);
            if (sewerageNotice != null) {
                int len;
                FileStoreMapper fsm = sewerageNotice.getFileStore();
                File file = this.fileStoreService.fetch(fsm, "STMS");
                FileInputStream is = new FileInputStream(file);
                response.setContentType("application/pdf");
                response.setHeader("Content-Disposition", "attachment; filename=\"" + sewerageNotice.getNoticeNo() + ".pdf\"");
                ServletOutputStream os = response.getOutputStream();
                byte[] buffer = new byte[1024];
                while ((len = ((InputStream)is).read(buffer)) != -1) {
                    os.write(buffer, 0, len);
                }
                os.flush();
                os.close();
                ((InputStream)is).close();
            } else {
                model.addAttribute("message", (Object)"msg.notice.not.found");
                return "common-error";
            }
        }
        return null;
    }
}

