/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.web.controller.masters;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.servlet.http.HttpServletRequest;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.config.properties.ApplicationProperties;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.stms.masters.entity.enums.PropertyType;
import org.egov.stms.masters.pojo.DCBReportWardwiseResult;
import org.egov.stms.transactions.entity.SewerageApplicationDetails;
import org.egov.stms.transactions.service.SewerageApplicationDetailsService;
import org.egov.stms.transactions.service.SewerageDCBReporService;
import org.egov.stms.transactions.service.SewerageThirdPartyServices;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/reports"})
public class SewerageRateDCBReportController {
    @Autowired
    private SewerageApplicationDetailsService sewerageApplicationDetailsService;
    @Autowired
    private SewerageDCBReporService sewerageDCBReporService;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private SewerageThirdPartyServices sewerageThirdPartyServices;
    @PersistenceContext
    EntityManager entityManager;
    @Autowired
    private CityService cityService;
    @Autowired
    private ApplicationProperties applicationProperties;

    @ModelAttribute
    public DCBReportWardwiseResult dCBReportWardWise() {
        return new DCBReportWardwiseResult();
    }

    @RequestMapping(value={"/sewerageRateReportView/{consumernumber}/{assessmentnumber}"}, method={RequestMethod.GET})
    public ModelAndView getSewerageRateReport(@ModelAttribute SewerageApplicationDetails sewerageApplicationDetails, @PathVariable String consumernumber, @PathVariable String assessmentnumber, Model model, ModelMap modelMap, HttpServletRequest request) {
        SimpleDateFormat formatter = new SimpleDateFormat("dd-MM-yyyy");
        String currentDate = formatter.format(new Date());
        if (consumernumber != null && (sewerageApplicationDetails = this.sewerageApplicationDetailsService.findByApplicationNumber(consumernumber)) != null) {
            AssessmentDetails propertyOwnerDetails = this.sewerageThirdPartyServices.getPropertyDetails(assessmentnumber, request);
            model.addAttribute("applicationNumber", (Object)sewerageApplicationDetails.getApplicationNumber());
            model.addAttribute("propertyOwnerDetails", (Object)propertyOwnerDetails);
            model.addAttribute("assessmentnumber", (Object)assessmentnumber);
            model.addAttribute("currentDate", (Object)currentDate);
            model.addAttribute("dcbResultList", (Object)this.sewerageDCBReporService.getSewerageRateDCBReport(sewerageApplicationDetails));
        }
        return new ModelAndView("report-sewerageRate-view", "sewerageApplicationDetails", (Object)sewerageApplicationDetails);
    }

    @RequestMapping(value={"/dcb-report-wardwise"}, method={RequestMethod.GET})
    public String WardwiseSearch(@ModelAttribute DCBReportWardwiseResult dcbReportWardwiseResult, Model model) {
        model.addAttribute("dcbReportWardwiseResult", (Object)dcbReportWardwiseResult);
        ArrayList<String> propertytype = new ArrayList<String>();
        for (PropertyType s : PropertyType.values()) {
            propertytype.add(s.toString());
        }
        ArrayList<String> boundaryList = new ArrayList<String>();
        List bList = new ArrayList();
        boundaryList.add("ALL");
        bList = this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Ward", "REVENUE");
        for (Boundary b : bList) {
            boundaryList.add(b.toString());
        }
        model.addAttribute("propertyType", propertytype);
        model.addAttribute("wards", (Object)this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Ward", "REVENUE"));
        return "sewerage-dcbwardwise";
    }
}

