/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.web.controller.masters;

import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.egov.commons.CFinancialYear;
import org.egov.commons.service.FinancialYearService;
import org.egov.infra.config.properties.ApplicationProperties;
import org.egov.infra.utils.DateUtils;
import org.egov.stms.masters.entity.DonationDetailMaster;
import org.egov.stms.masters.entity.DonationMaster;
import org.egov.stms.masters.entity.enums.PropertyType;
import org.egov.stms.masters.entity.enums.SewerageRateStatus;
import org.egov.stms.masters.pojo.DonationMasterSearch;
import org.egov.stms.masters.pojo.DonationRateComparatorOrderById;
import org.egov.stms.masters.service.DonationMasterService;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/masters"})
public class DonationMasterController {
    @Autowired
    private DonationMasterService donationMasterService;
    @Autowired
    private FinancialYearService financialYearService;
    @Autowired
    private ApplicationProperties applicationProperties;

    @RequestMapping(value={"/donationmaster"}, method={RequestMethod.GET})
    public String showForm(@ModelAttribute DonationMaster donationMaster, Model model) {
        donationMaster = new DonationMaster();
        CFinancialYear financialYear = this.financialYearService.getCurrentFinancialYear();
        if (financialYear != null) {
            model.addAttribute("endDate", (Object)financialYear.getEndingDate());
        }
        model.addAttribute("donationmaster", (Object)donationMaster);
        model.addAttribute("propertyTypes", (Object)PropertyType.values());
        return "donation-master";
    }

    @RequestMapping(value={"/donationmaster"}, method={RequestMethod.POST}, produces={"application/json"})
    public String createDonationMaster(@ModelAttribute DonationMaster donationMaster, BindingResult errors, RedirectAttributes redirectAttrs, Model model) {
        ArrayList<DonationDetailMaster> donationMasterDetailList = new ArrayList<DonationDetailMaster>();
        List existingdonationMaster = this.donationMasterService.getLatestActiveRecordByPropertyTypeAndActive(donationMaster.getPropertyType(), true);
        DonationMaster donationMasterExist = this.donationMasterService.findByPropertyTypeAndFromDateAndActive(donationMaster.getPropertyType(), donationMaster.getFromDate(), true);
        if (donationMasterExist != null) {
            DateTime dateTime = DateUtils.endOfGivenDate((DateTime)new DateTime((Object)donationMaster.getFromDate()));
            Date dateformat = dateTime.toDate();
            donationMasterExist.setActive(false);
            donationMasterExist.setToDate(dateformat);
            donationMaster.setActive(true);
            for (DonationDetailMaster donationDetailMaster : donationMaster.getDonationDetail()) {
                donationDetailMaster.setDonation(donationMaster);
                donationMasterDetailList.add(donationDetailMaster);
            }
            donationMaster.getDonationDetail().addAll(donationMasterDetailList);
            donationMaster = this.donationMasterService.createDonationRate(donationMaster);
        } else {
            DonationMaster donationMasterOld = null;
            if (!existingdonationMaster.isEmpty()) {
                donationMasterOld = (DonationMaster)existingdonationMaster.get(0);
            }
            if (donationMasterOld != null) {
                if (donationMaster.getFromDate().compareTo(new Date()) < 0) {
                    donationMasterOld.setActive(false);
                }
                DateTime dateTime = DateUtils.endOfGivenDate((DateTime)new DateTime((Object)donationMaster.getFromDate()).minusDays(1));
                Date dateformat = dateTime.toDate();
                donationMasterOld.setToDate(dateformat);
                this.donationMasterService.update(donationMasterOld);
            }
            donationMaster.setActive(true);
            for (DonationDetailMaster donationDetailMaster : donationMaster.getDonationDetail()) {
                donationDetailMaster.setDonation(donationMaster);
                donationMasterDetailList.add(donationDetailMaster);
            }
            donationMaster.getDonationDetail().clear();
            donationMaster.getDonationDetail().addAll(donationMasterDetailList);
            donationMaster = this.donationMasterService.createDonationRate(donationMaster);
        }
        redirectAttrs.addFlashAttribute("message", (Object)"msg.donationrate.creation.success");
        return "redirect:/masters/success/" + donationMaster.getId();
    }

    @RequestMapping(value={"/success/{id}"}, method={RequestMethod.GET})
    public String getSeweragerates(@ModelAttribute DonationMaster donationMaster, @PathVariable(value="id") Long id, RedirectAttributes redirectAttrs, Model model) {
        DonationMaster donationMaster1 = this.donationMasterService.findById(id);
        for (DonationDetailMaster ddm : donationMaster1.getDonationDetail()) {
            ddm.setAmount(BigDecimal.valueOf(ddm.getAmount()).setScale(2, 6).doubleValue());
        }
        Collections.sort(donationMaster1.getDonationDetail(), new DonationRateComparatorOrderById());
        model.addAttribute("donationMaster", (Object)donationMaster1);
        return "donation-master-success";
    }

    @RequestMapping(value={"/fromDateValidationWithActiveRecord"}, method={RequestMethod.GET})
    @ResponseBody
    public String validateFromDateWithActiveDate(@RequestParam(value="propertyType") PropertyType propertyType, @RequestParam(value="fromDate") Date date, Model model) {
        DonationMaster existingActiveDonationObject;
        List donationList = this.donationMasterService.getLatestActiveRecordByPropertyTypeAndActive(propertyType, true);
        if (!donationList.isEmpty() && date.compareTo((existingActiveDonationObject = (DonationMaster)donationList.get(0)).getFromDate()) < 0) {
            SimpleDateFormat formatter = new SimpleDateFormat("dd-MM-yyyy");
            String activeDate = formatter.format(existingActiveDonationObject.getFromDate());
            return activeDate;
        }
        return "true";
    }

    @RequestMapping(value={"/ajaxexistingdonationvalidate"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public double geWaterRatesByAllCombinatons(@RequestParam(value="propertyType") PropertyType propertyType, @RequestParam(value="fromDate") Date fromDate) {
        DonationMaster donationMasterMaster = null;
        donationMasterMaster = this.donationMasterService.findByPropertyTypeAndFromDateAndActive(propertyType, fromDate, true);
        if (donationMasterMaster != null) {
            return 1.0;
        }
        return 0.0;
    }

    @RequestMapping(value={"/view"}, method={RequestMethod.GET})
    public String viewDonationMaster(Model model, @ModelAttribute DonationMasterSearch donationMasterSearch) {
        model.addAttribute("propertyType", (Object)PropertyType.values());
        model.addAttribute("statusValues", (Object)SewerageRateStatus.values());
        return "donationMaster-view";
    }

    @RequestMapping(value={"/search-donation-master"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public void searchDonationMaster(@ModelAttribute DonationMasterSearch donationMasterSearch, HttpServletResponse response) throws IOException, ParseException {
        PropertyType type = null;
        String effectivefromDate = null;
        if (donationMasterSearch.getPropertyType() != null) {
            type = PropertyType.valueOf((String)donationMasterSearch.getPropertyType());
        }
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
        SimpleDateFormat myFormat = new SimpleDateFormat("dd-MM-yyyy");
        if (donationMasterSearch.getFromDate() != null) {
            effectivefromDate = myFormat.format(formatter.parse(donationMasterSearch.getFromDate()));
        }
        IOUtils.write((String)("{ \"data\":" + new GsonBuilder().setDateFormat(this.applicationProperties.defaultDatePattern()).create().toJson((Object)this.donationMasterService.getDonationMasters(type, effectivefromDate, donationMasterSearch.getStatus())) + "}"), (Writer)response.getWriter());
    }

    @RequestMapping(value={"/fromDate-by-propertyType"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<Date> effectiveFromDates(@RequestParam PropertyType propertyType) {
        return this.donationMasterService.findFromDateByPropertyType(propertyType);
    }

    @RequestMapping(value={"/donationView/{id}"}, method={RequestMethod.GET})
    public String ViewDonation(@PathVariable Long id, Model model, RedirectAttributes redirectAttrs) {
        return "redirect:/masters/success/" + id;
    }

    @RequestMapping(value={"/donationUpdate/{id}"}, method={RequestMethod.GET})
    public String UpdateDonation(@PathVariable Long id, Model model) {
        DonationMaster dm = this.donationMasterService.findById(id);
        Collections.sort(dm.getDonationDetail(), new DonationRateComparatorOrderById());
        model.addAttribute("donationMaster", (Object)dm);
        model.addAttribute("donationDetail", (Object)dm.getDonationDetail());
        return "donation-master-update";
    }

    @RequestMapping(value={"/donationUpdate/{id}"}, method={RequestMethod.POST})
    public String updateDonationValues(@ModelAttribute DonationMaster donationMaster, @PathVariable Long id, Model model, RedirectAttributes redirectAttrs) throws ParseException {
        DonationMaster donationMstr = this.donationMasterService.findById(id);
        if (donationMstr != null) {
            Date currentDate;
            SimpleDateFormat myFormat = new SimpleDateFormat("dd-MM-yyyy");
            String todaysdate = myFormat.format(new Date());
            String effectiveFromDate = myFormat.format(donationMstr.getFromDate());
            Date effectiveDate = myFormat.parse(effectiveFromDate);
            if (effectiveDate.compareTo(currentDate = myFormat.parse(todaysdate)) < 0) {
                model.addAttribute("message", (Object)"msg.donationrate.modification.rejected");
                return "donation-master-update";
            }
            donationMstr.setLastModifiedDate(new Date());
            ArrayList existingdonationDetailList = new ArrayList();
            if (!donationMaster.getDonationDetail().isEmpty()) {
                existingdonationDetailList.addAll(donationMstr.getDonationDetail());
            }
            if (donationMaster != null && donationMaster.getDonationDetail() != null) {
                if (!existingdonationDetailList.isEmpty()) {
                    for (DonationDetailMaster dtlObject : existingdonationDetailList) {
                        if (donationMaster.getDonationDetail().contains(dtlObject)) continue;
                        donationMstr.deleteDonationDetail(dtlObject);
                    }
                    for (DonationDetailMaster dtlMaster : donationMaster.getDonationDetail()) {
                        if (dtlMaster.getId() == null) {
                            DonationDetailMaster donationDetailObject = new DonationDetailMaster();
                            donationDetailObject.setNoOfClosets(dtlMaster.getNoOfClosets());
                            donationDetailObject.setAmount(dtlMaster.getAmount());
                            donationDetailObject.setDonation(donationMstr);
                            donationMstr.addDonationDetail(donationDetailObject);
                            continue;
                        }
                        if (dtlMaster.getId() == null || !existingdonationDetailList.contains(dtlMaster)) continue;
                        for (DonationDetailMaster dtlObject : donationMstr.getDonationDetail()) {
                            if (!dtlObject.getId().equals(dtlMaster.getId())) continue;
                            dtlObject.setAmount(dtlMaster.getAmount());
                            dtlObject.setNoOfClosets(dtlMaster.getNoOfClosets());
                        }
                    }
                }
                this.donationMasterService.update(donationMstr);
            }
        } else {
            model.addAttribute("message", (Object)"msg.donationrate.notfound");
            return "donation-master-update";
        }
        redirectAttrs.addFlashAttribute("message", (Object)"msg.donationrate.update.success");
        return "redirect:/masters/success/" + id;
    }
}

