/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.web.controller.elasticSearch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.stms.elasticSearch.entity.SewerageCollectFeeSearchRequest;
import org.egov.stms.elasticSearch.entity.SewerageSearchResult;
import org.egov.stms.entity.es.SewerageIndex;
import org.egov.stms.service.es.SewerageIndexService;
import org.egov.stms.transactions.entity.SewerageApplicationDetails;
import org.egov.stms.transactions.service.SewerageApplicationDetailsService;
import org.egov.stms.transactions.service.SewerageConnectionService;
import org.egov.stms.transactions.service.SewerageThirdPartyServices;
import org.egov.stms.utils.SewerageActionDropDownUtil;
import org.egov.stms.utils.SewerageTaxUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/collectfee/search"})
public class SewerageCollectFeeSearchController {
    @Autowired
    private CityService cityService;
    @Autowired
    private SewerageApplicationDetailsService sewerageApplicationDetailsService;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private SewerageTaxUtils sewerageTaxUtils;
    @Autowired
    private SewerageConnectionService sewerageConnectionService;
    @Autowired
    private SewerageThirdPartyServices sewerageThirdPartyServices;
    @Autowired
    private SewerageIndexService sewerageIndexService;

    @ModelAttribute
    public SewerageCollectFeeSearchRequest searchRequest() {
        return new SewerageCollectFeeSearchRequest();
    }

    @RequestMapping(method={RequestMethod.GET})
    public String newSearchForm(Model model) {
        return "seweragecollectcharges-form";
    }

    @ModelAttribute(value="revenueWards")
    public List<Boundary> revenueWardList() {
        return this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("WARD", "REVENUE");
    }

    @RequestMapping(value={"/view/{consumernumber}/{assessmentnumber}"}, method={RequestMethod.GET})
    public ModelAndView view(@PathVariable String consumernumber, @PathVariable String assessmentnumber, Model model, ModelMap modelMap, @ModelAttribute SewerageApplicationDetails sewerageApplicationDetails, HttpServletRequest request) {
        AssessmentDetails propertyOwnerDetails;
        if (consumernumber != null) {
            sewerageApplicationDetails = this.sewerageApplicationDetailsService.findByApplicationNumber(consumernumber);
        }
        if ((propertyOwnerDetails = this.sewerageThirdPartyServices.getPropertyDetails(assessmentnumber, request)) != null) {
            modelMap.addAttribute("propertyOwnerDetails", (Object)propertyOwnerDetails);
        }
        model.addAttribute("applicationHistory", (Object)this.sewerageApplicationDetailsService.getHistory(sewerageApplicationDetails));
        model.addAttribute("documentNamesList", (Object)this.sewerageConnectionService.getSewerageApplicationDoc(sewerageApplicationDetails));
        return new ModelAndView("viewseweragedetails", "sewerageApplicationDetails", (Object)sewerageApplicationDetails);
    }

    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public List<SewerageSearchResult> searchApplication(@ModelAttribute SewerageCollectFeeSearchRequest searchRequest) {
        ArrayList<SewerageSearchResult> searchResultList = new ArrayList<SewerageSearchResult>();
        List resultList = new ArrayList();
        ArrayList<String> roleList = new ArrayList<String>();
        HashMap actionMap = new HashMap();
        SewerageApplicationDetails sewerageApplicationDetails = null;
        SewerageSearchResult searchActions = null;
        City cityWebsite = this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName());
        if (cityWebsite != null) {
            searchRequest.setUlbName(cityWebsite.getName());
        }
        BoolQueryBuilder boolQuery = this.sewerageIndexService.getSearchQueryFilter(searchRequest);
        resultList = this.sewerageIndexService.getCollectSearchResult(boolQuery);
        for (SewerageIndex sewerageIndex : resultList) {
            SewerageSearchResult searchResult = new SewerageSearchResult();
            searchResult.setApplicationNumber(sewerageIndex.getApplicationNumber());
            searchResult.setAssessmentNumber(sewerageIndex.getPropertyIdentifier());
            searchResult.setShscNumber(sewerageIndex.getShscNumber());
            searchResult.setApplicantName(sewerageIndex.getConsumerName());
            searchResult.setApplicationType(sewerageIndex.getApplicationType());
            searchResult.setPropertyType(sewerageIndex.getPropertyType());
            searchResult.setRevenueWard(sewerageIndex.getWard());
            searchResult.setAddress(sewerageIndex.getAddress());
            searchResult.setApplicationStatus(sewerageIndex.getApplicationStatus());
            if (searchRequest.getConsumerNumber() != null) {
                sewerageApplicationDetails = this.sewerageApplicationDetailsService.findByApplicationNumber(searchRequest.getConsumerNumber());
            }
            for (Role role : this.sewerageTaxUtils.getLoginUserRoles()) {
                roleList.add(role.getName());
            }
            if (sewerageApplicationDetails != null) {
                searchActions = SewerageActionDropDownUtil.getSearchResultWithActions(roleList, (String)sewerageIndex.getApplicationStatus(), (SewerageApplicationDetails)sewerageApplicationDetails);
            }
            if (searchActions != null && searchActions.getActions() != null) {
                for (Map.Entry entry : searchActions.getActions().entrySet()) {
                    if (entry.getValue() != "Collect Fee") continue;
                    actionMap.put(entry.getKey(), entry.getValue());
                }
            }
            searchResult.setActions(actionMap);
            searchResultList.add(searchResult);
        }
        return searchResultList;
    }
}

