/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.egov.stms.elasticsearch.entity.SewerageSearchResult;
import org.egov.stms.transactions.entity.SewerageApplicationDetails;

public class SewerageActionDropDownUtil {
    private static final String DEFAULT = "DEFAULT";
    private static final Map<String, Map<String, String>> actionUrlMap = new HashMap<String, Map<String, String>>();
    private static final Map<String, List<String>> STATUSACTIONMAP = new HashMap<String, List<String>>();
    private static Logger logger = Logger.getLogger(SewerageActionDropDownUtil.class);

    private static Map<String, String> getActionWithUrl(String url, String action) {
        LinkedHashMap<String, String> actionwithurl = new LinkedHashMap<String, String>();
        actionwithurl.put(url, action);
        return actionwithurl;
    }

    public static Map<String, String> filterActionsByStatus(List<String> actions, String status, SewerageApplicationDetails sewerageApplicationDetails) {
        if (actions != null && !actions.isEmpty()) {
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            if (status != null && !"".equals(status)) {
                logger.info((Object)(" ***** registrationStatus  " + status));
                List<String> statusActionList = STATUSACTIONMAP.get(status.toUpperCase());
                logger.info((Object)(" ....... statusActionList  " + statusActionList));
                SewerageActionDropDownUtil.selectUserMappingActions(actions, result, statusActionList);
                if (status.equalsIgnoreCase("SANCTIONED") && sewerageApplicationDetails.getCurrentDemand().getBaseDemand().compareTo(sewerageApplicationDetails.getCurrentDemand().getAmtCollected()) > 0) {
                    logger.info((Object)(" ************ registrationStatus  " + status));
                    statusActionList = STATUSACTIONMAP.get("SANCTIONEDWITHDEMAND");
                    logger.info((Object)(" ....... statusActionList  " + statusActionList));
                    SewerageActionDropDownUtil.selectUserMappingActions(actions, result, statusActionList);
                }
                if (result.size() == 0) {
                    statusActionList = STATUSACTIONMAP.get(DEFAULT);
                    SewerageActionDropDownUtil.selectUserMappingActions(actions, result, statusActionList);
                }
                return result;
            }
            return Collections.emptyMap();
        }
        return Collections.emptyMap();
    }

    private static void selectUserMappingActions(List<String> actions, Map<String, String> result, List<String> statusActionList) {
        for (String action : actions) {
            if (statusActionList == null || !statusActionList.contains(action)) continue;
            result.putAll(actionUrlMap.get(action));
        }
    }

    public static Map<String, String> getActionsByRoles(List<String> roleName, String collectionStatus, SewerageApplicationDetails sewerageApplicationDetails) {
        HashSet<String> actionList = new HashSet<String>();
        logger.debug((Object)(" ************ Role Name " + roleName));
        logger.debug((Object)(" ************ registrationStatus  " + collectionStatus));
        for (String role : roleName) {
            if (role.equalsIgnoreCase("Sewerage Tax Creator") || role.equalsIgnoreCase("Sewerage Tax Approver")) {
                actionList.add("View DCB");
            }
            if (role.equalsIgnoreCase("ULB Operator") || role.equalsIgnoreCase("Sewerage Tax Report Viewer") || role.equalsIgnoreCase("STMS_VIEW_ACCESS_ROLE")) {
                actionList.add("View DCB");
            }
            if (role.equalsIgnoreCase("Sewerage Tax Creator") || role.equalsIgnoreCase("ULB Operator")) {
                actionList.add("Close Sewerage Connection");
                actionList.add("Generate Demand Bill");
            }
            if (role.equalsIgnoreCase("ULB Operator") || role.equalsIgnoreCase("Sewerage Tax Creator") || role.equalsIgnoreCase("Sewerage Tax Approver") || role.equalsIgnoreCase("CITIZEN")) {
                actionList.add("Change number of seats");
            }
            if (role.equalsIgnoreCase("CSC Operator") || role.equalsIgnoreCase("ULB Operator") || role.equalsIgnoreCase("Collection Operator") || role.equalsIgnoreCase("SYSTEM")) {
                actionList.add("Collect Fee");
            }
            if (!role.equalsIgnoreCase("Sewerage Tax Administrator") && !role.equalsIgnoreCase("SYSTEM")) continue;
            actionList.add("MODIFYLEGACYCONNECTION");
        }
        actionList.add("View");
        return SewerageActionDropDownUtil.filterActionsByStatus(new ArrayList<String>(actionList), collectionStatus, sewerageApplicationDetails);
    }

    public static final SewerageSearchResult getSearchResultWithActions(List<String> roleName, String status, SewerageApplicationDetails sewerageApplicationDetails) {
        SewerageSearchResult searchActions = new SewerageSearchResult();
        if (status != null && sewerageApplicationDetails != null) {
            searchActions.setActions(SewerageActionDropDownUtil.getActionsByRoles(roleName, status, sewerageApplicationDetails));
        }
        return searchActions;
    }

    static {
        STATUSACTIONMAP.put(DEFAULT, Arrays.asList("View"));
        STATUSACTIONMAP.put("CREATED", Arrays.asList("View"));
        STATUSACTIONMAP.put("COLLECTINSPECTIONFEE", Arrays.asList("View", "View DCB", "Collect Fee"));
        STATUSACTIONMAP.put("INITIAL APPROVED", Arrays.asList("View", "View DCB"));
        STATUSACTIONMAP.put("ESTIMATION NOTICE GENERATED", Arrays.asList("View", "View DCB", "Collect Fee"));
        STATUSACTIONMAP.put("ESTIMATION AMOUNT PAID", Arrays.asList("View", "View DCB"));
        STATUSACTIONMAP.put("WORK ORDER GENERATED", Arrays.asList("View", "View DCB"));
        STATUSACTIONMAP.put("FINAL APPROVED", Arrays.asList("View", "View DCB"));
        STATUSACTIONMAP.put("SANCTIONED", Arrays.asList("View", "View DCB", "Change number of seats", "Close Sewerage Connection", "Generate Demand Bill", "MODIFYLEGACYCONNECTION"));
        STATUSACTIONMAP.put("SANCTIONEDWITHDEMAND", Arrays.asList("View", "View DCB", "Change number of seats", "Collect Fee"));
        actionUrlMap.put("View", SewerageActionDropDownUtil.getActionWithUrl("/stms/existing/sewerage/view/{consumerno}/{assessmentno}", "View"));
        actionUrlMap.put("Collect Fee", SewerageActionDropDownUtil.getActionWithUrl("/stms/collection/generatebill/{consumerno}/{assessmentno}", "Collect Fee"));
        actionUrlMap.put("View DCB", SewerageActionDropDownUtil.getActionWithUrl("/stms/reports/sewerageRateReportView/{consumerno}/{assessmentno}", "View DCB"));
        actionUrlMap.put("Change number of seats", SewerageActionDropDownUtil.getActionWithUrl("/stms/transactions/modifyConnection/{shscNumber}", "Change number of seats"));
        actionUrlMap.put("Close Sewerage Connection", SewerageActionDropDownUtil.getActionWithUrl("/stms/transactions/closeConnection/{shscNumber}", "Close Sewerage Connection"));
        actionUrlMap.put("Generate Demand Bill", SewerageActionDropDownUtil.getActionWithUrl("/stms/reports/generate-sewerage-demand-bill/{consumerno}/{assessmentno}", "Generate Demand Bill"));
        actionUrlMap.put("MODIFYLEGACYCONNECTION", SewerageActionDropDownUtil.getActionWithUrl("/stms/transactions/sewerage/sewerageLegacyApplication-updateForm/{consumerno}/{assessmentno}", "Modify Legacy Connection"));
    }
}

