/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.transactions.workflow;

import java.math.BigDecimal;
import java.util.Date;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.workflow.entity.OwnerGroup;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.pims.commons.Position;
import org.egov.stms.transactions.entity.SewerageApplicationDetails;
import org.egov.stms.transactions.service.SewerageDemandService;
import org.egov.stms.transactions.service.SewerageWorkflowService;
import org.egov.stms.transactions.workflow.ApplicationWorkflowCustom;
import org.egov.stms.utils.SewerageTaxUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class ApplicationWorkflowCustomImpl
implements ApplicationWorkflowCustom {
    private static final String ANONYMOUS_CREATED = "Anonymous  Created";
    private static final String THIRD_PARTY_OPERATOR_CREATED = "Third Party operator created";
    private static final String CITIZEN_CREATED = "Citizen created";
    private static final String NEW = "NEW";
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationWorkflowCustomImpl.class);
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    private SewerageTaxUtils sewerageTaxUtils;
    @Autowired
    private SewerageWorkflowService sewerageWorkflowService;
    @Autowired
    private SewerageDemandService sewerageDemandService;
    @Autowired
    @Qualifier(value="workflowService")
    private SimpleWorkflowService<SewerageApplicationDetails> sewerageApplicationWorkflowService;

    @Autowired
    public ApplicationWorkflowCustomImpl() {
    }

    @Override
    public void createCommonWorkflowTransition(SewerageApplicationDetails sewerageApplicationDetails, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(" Create WorkFlow Transition Started  ...");
        }
        User user = this.securityUtils.getCurrentUser();
        DateTime currentDate = new DateTime();
        Position pos = null;
        Assignment wfInitiator = null;
        String currState = "";
        WorkFlowMatrix wfmatrix = null;
        String natureOfwork = sewerageApplicationDetails.getApplicationType().getName();
        if (null != sewerageApplicationDetails.getId()) {
            wfInitiator = this.sewerageWorkflowService.getWorkFlowInitiator(sewerageApplicationDetails);
        }
        if ("Reject".equalsIgnoreCase(workFlowAction)) {
            String stateValue = "Rejected";
            wfmatrix = this.sewerageTaxUtils.isInspectionFeeCollectionRequired() ? this.sewerageApplicationWorkflowService.getWfMatrix(sewerageApplicationDetails.getStateType(), null, null, additionalRule, "Rejected", "Rejected Inspection Fee Collection") : this.sewerageApplicationWorkflowService.getWfMatrix(sewerageApplicationDetails.getStateType(), null, null, additionalRule, "Rejected", "Rejected");
            sewerageApplicationDetails.transition().progressWithStateCopy().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue("Rejected").withDateInfo(currentDate.toDate()).withOwner((OwnerGroup)wfInitiator.getPosition()).withNextAction("Application Rejected").withNatureOfTask(natureOfwork);
        } else if ("Cancel".equalsIgnoreCase(workFlowAction)) {
            sewerageApplicationDetails.transition().end().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withDateInfo(currentDate.toDate()).withNatureOfTask(natureOfwork);
        } else {
            pos = null != approvalPosition && approvalPosition != -1L && !approvalPosition.equals(0L) ? this.positionMasterService.getPositionById(approvalPosition) : wfInitiator.getPosition();
            Boolean cscOperatorLoggedIn = this.sewerageWorkflowService.isCscOperator(user);
            Boolean citizenPortalUser = this.sewerageWorkflowService.isCitizenPortalUser(user);
            if (null == sewerageApplicationDetails.getState() && (cscOperatorLoggedIn.booleanValue() || citizenPortalUser.booleanValue() || "Anonymous".equalsIgnoreCase(this.securityUtils.getCurrentUser().getUsername()))) {
                currState = cscOperatorLoggedIn != false ? THIRD_PARTY_OPERATOR_CREATED : (citizenPortalUser != false && sewerageApplicationDetails.getState() == null ? CITIZEN_CREATED : (citizenPortalUser != false && "Fee collection Pending".equals(sewerageApplicationDetails.getState().getValue()) ? sewerageApplicationDetails.getState().getValue() : ANONYMOUS_CREATED));
                wfmatrix = this.sewerageApplicationWorkflowService.getWfMatrix(sewerageApplicationDetails.getStateType(), null, null, additionalRule, currState, null);
                if (citizenPortalUser.booleanValue()) {
                    if (sewerageApplicationDetails.getCurrentDemand() != null && !this.sewerageDemandService.checkAnyTaxIsPendingToCollect(sewerageApplicationDetails.getCurrentDemand()).booleanValue()) {
                        sewerageApplicationDetails.transition().start().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withComments(approvalComent).withInitiator((OwnerGroup)(wfInitiator != null ? wfInitiator.getPosition() : null)).withStateValue(wfmatrix.getNextState()).withDateInfo(new Date()).withOwner((OwnerGroup)pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask(natureOfwork);
                    } else {
                        sewerageApplicationDetails.transition().start().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withComments(approvalComent).withInitiator((OwnerGroup)(wfInitiator != null ? wfInitiator.getPosition() : null)).withStateValue(wfmatrix.getNextState()).withDateInfo(new Date()).withOwner(user).withNextAction(wfmatrix.getNextAction()).withNatureOfTask(natureOfwork);
                    }
                } else {
                    sewerageApplicationDetails.transition().start().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withComments(approvalComent).withInitiator((OwnerGroup)(wfInitiator != null ? wfInitiator.getPosition() : null)).withStateValue(wfmatrix.getNextState()).withDateInfo(new Date()).withOwner((OwnerGroup)pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask(natureOfwork);
                }
            } else if (null == sewerageApplicationDetails.getState()) {
                wfmatrix = this.sewerageTaxUtils.isInspectionFeeCollectionRequired() ? this.sewerageApplicationWorkflowService.getWfMatrix(sewerageApplicationDetails.getStateType(), null, null, additionalRule, currState, "Inspection Fee Collection") : this.sewerageApplicationWorkflowService.getWfMatrix(sewerageApplicationDetails.getStateType(), null, null, additionalRule, currState, null);
                sewerageApplicationDetails.transition().start().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(wfmatrix.getNextState()).withDateInfo(new Date()).withOwner((OwnerGroup)pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask(natureOfwork);
            } else if (sewerageApplicationDetails.getState() != null && NEW.equalsIgnoreCase(sewerageApplicationDetails.getState().getValue()) && "COLLECTINSPECTIONFEE".equalsIgnoreCase(sewerageApplicationDetails.getStatus().getCode()) && (this.sewerageWorkflowService.isCscOperator(sewerageApplicationDetails.getCreatedBy()).booleanValue() || "Anonymous".equalsIgnoreCase(sewerageApplicationDetails.getCreatedBy().getUsername()) || this.sewerageWorkflowService.isCitizenPortalUser(sewerageApplicationDetails.getCreatedBy()).booleanValue())) {
                wfmatrix = this.sewerageTaxUtils.isInspectionFeeCollectionRequired() ? this.sewerageApplicationWorkflowService.getWfMatrix(sewerageApplicationDetails.getStateType(), null, null, additionalRule, NEW, "Inspection Fee Collection") : this.sewerageApplicationWorkflowService.getWfMatrix(sewerageApplicationDetails.getStateType(), null, null, additionalRule, NEW, null);
                sewerageApplicationDetails.transition().progressWithStateCopy().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner((OwnerGroup)pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask(natureOfwork);
            } else if ("Approve".equalsIgnoreCase(workFlowAction) && "Payment Done Against Estimation".equalsIgnoreCase(sewerageApplicationDetails.getState().getValue())) {
                sewerageApplicationDetails.transition().end().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withDateInfo(currentDate.toDate()).withNatureOfTask(natureOfwork);
            } else if ("Execute Connection".equalsIgnoreCase(workFlowAction)) {
                wfmatrix = this.sewerageApplicationWorkflowService.getWfMatrix(sewerageApplicationDetails.getStateType(), null, null, additionalRule, sewerageApplicationDetails.getCurrentState().getValue(), null);
                sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("SANCTIONED", "SEWERAGETAXAPPLICATION"));
                if (wfmatrix.getNextAction().equalsIgnoreCase("END")) {
                    sewerageApplicationDetails.transition().end().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withDateInfo(currentDate.toDate()).withNatureOfTask(natureOfwork);
                }
            } else if ("Deputy Exe Engineer Approved".equalsIgnoreCase(sewerageApplicationDetails.getState().getValue()) && "CHANGEINCLOSETS NOCOLLECTION".equalsIgnoreCase(additionalRule)) {
                sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("FINALAPPROVED", "SEWERAGETAXAPPLICATION"));
                sewerageApplicationDetails.transition().end().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withDateInfo(currentDate.toDate()).withNatureOfTask(natureOfwork);
            } else if (null != approvalComent && "Receipt Cancelled".equalsIgnoreCase(approvalComent)) {
                wfmatrix = this.sewerageApplicationWorkflowService.getWfMatrix(sewerageApplicationDetails.getStateType(), null, null, additionalRule, "Assistant Engineer Approved", null);
                sewerageApplicationDetails.transition().progressWithStateCopy().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner((OwnerGroup)pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask(natureOfwork);
            } else {
                String pendingActions = null;
                if (sewerageApplicationDetails.getCurrentState().getValue().equalsIgnoreCase("Rejected")) {
                    pendingActions = this.sewerageTaxUtils.isInspectionFeeCollectionRequired() ? "Rejected Inspection Fee Collection" : "Rejected";
                    wfmatrix = this.sewerageApplicationWorkflowService.getWfMatrix(sewerageApplicationDetails.getStateType(), null, null, additionalRule, sewerageApplicationDetails.getCurrentState().getValue(), pendingActions);
                    String nextState = null;
                    nextState = this.sewerageTaxUtils.isInspectionFeeCollectionRequired() ? (sewerageApplicationDetails.getCurrentDemand().getAmtCollected().compareTo(BigDecimal.ZERO) == 0 ? "Inspection Fee Pending" : "Inspection Fee Collected") : wfmatrix.getNextState();
                    sewerageApplicationDetails.transition().progressWithStateCopy().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(nextState).withDateInfo(currentDate.toDate()).withOwner((OwnerGroup)pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask(natureOfwork);
                } else {
                    wfmatrix = this.sewerageApplicationWorkflowService.getWfMatrix(sewerageApplicationDetails.getStateType(), null, null, additionalRule, sewerageApplicationDetails.getCurrentState().getValue(), pendingActions);
                    sewerageApplicationDetails.transition().progressWithStateCopy().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner((OwnerGroup)pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask(natureOfwork);
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(" WorkFlow Transition Completed  ...");
        }
    }

    @Override
    public void createCloseConnectionWorkflowTransition(SewerageApplicationDetails sewerageApplicationDetails, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(" Create WorkFlow Transition Started  ...");
        }
        User user = this.securityUtils.getCurrentUser();
        DateTime currentDate = new DateTime();
        Position pos = null;
        Assignment wfInitiator = null;
        String currState = "";
        WorkFlowMatrix wfmatrix = null;
        String natureOfwork = sewerageApplicationDetails.getApplicationType().getName();
        if (null != sewerageApplicationDetails.getId()) {
            wfInitiator = this.sewerageWorkflowService.getWorkFlowInitiator(sewerageApplicationDetails);
        }
        if ("Reject".equalsIgnoreCase(workFlowAction)) {
            String stateValue = "Rejected";
            wfmatrix = this.sewerageApplicationWorkflowService.getWfMatrix(sewerageApplicationDetails.getStateType(), null, null, additionalRule, "Rejected", "Rejected");
            sewerageApplicationDetails.transition().progressWithStateCopy().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue("Rejected").withDateInfo(currentDate.toDate()).withOwner((OwnerGroup)wfInitiator.getPosition()).withNextAction("Application Rejected").withNatureOfTask(natureOfwork);
        } else if ("Cancel".equalsIgnoreCase(workFlowAction)) {
            sewerageApplicationDetails.transition().end().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withDateInfo(currentDate.toDate()).withNatureOfTask(natureOfwork);
        } else {
            pos = null != approvalPosition && approvalPosition != -1L && !approvalPosition.equals(0L) ? this.positionMasterService.getPositionById(approvalPosition) : wfInitiator.getPosition();
            if (null == sewerageApplicationDetails.getState()) {
                wfmatrix = this.sewerageApplicationWorkflowService.getWfMatrix(sewerageApplicationDetails.getStateType(), null, null, additionalRule, currState, null);
                sewerageApplicationDetails.transition().start().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(wfmatrix.getNextState()).withDateInfo(new Date()).withOwner((OwnerGroup)pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask(natureOfwork);
            } else if ("Deputy Exe Engineer Approved".equalsIgnoreCase(sewerageApplicationDetails.getState().getValue())) {
                sewerageApplicationDetails.transition().end().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withDateInfo(currentDate.toDate()).withNatureOfTask(natureOfwork);
            } else if ("Generate Close Connection Notice".equalsIgnoreCase(workFlowAction)) {
                wfmatrix = this.sewerageApplicationWorkflowService.getWfMatrix(sewerageApplicationDetails.getStateType(), null, null, additionalRule, sewerageApplicationDetails.getCurrentState().getValue(), "Close Connection Notice Generation Pending");
                if (wfmatrix.getNextAction().equalsIgnoreCase("END")) {
                    sewerageApplicationDetails.transition().end().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withDateInfo(currentDate.toDate()).withNatureOfTask(natureOfwork);
                }
            } else {
                String pendingActions = null;
                if (sewerageApplicationDetails.getCurrentState().getValue().equalsIgnoreCase("Rejected")) {
                    pendingActions = "Rejected";
                    wfmatrix = this.sewerageApplicationWorkflowService.getWfMatrix(sewerageApplicationDetails.getStateType(), null, null, additionalRule, sewerageApplicationDetails.getCurrentState().getValue(), pendingActions);
                    String nextState = wfmatrix.getNextState();
                    sewerageApplicationDetails.transition().progressWithStateCopy().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(nextState).withDateInfo(currentDate.toDate()).withOwner((OwnerGroup)pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask(natureOfwork);
                } else {
                    wfmatrix = this.sewerageApplicationWorkflowService.getWfMatrix(sewerageApplicationDetails.getStateType(), null, null, additionalRule, sewerageApplicationDetails.getCurrentState().getValue(), pendingActions);
                    sewerageApplicationDetails.transition().progressWithStateCopy().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner((OwnerGroup)pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask(natureOfwork);
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(" WorkFlow Transition Completed  ...");
        }
    }
}

