/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.transactions.service.collection;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.log4j.Logger;
import org.egov.collection.entity.ReceiptDetail;
import org.egov.collection.integration.models.BillReceiptInfo;
import org.egov.collection.integration.models.BillReceiptInfoImpl;
import org.egov.collection.integration.models.ReceiptAccountInfo;
import org.egov.collection.integration.models.ReceiptAmountInfo;
import org.egov.commons.Installment;
import org.egov.demand.dao.EgBillDao;
import org.egov.demand.integration.TaxCollection;
import org.egov.demand.model.EgBill;
import org.egov.demand.model.EgDemand;
import org.egov.demand.model.EgDemandDetails;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.pims.commons.Position;
import org.egov.stms.masters.entity.enums.SewerageConnectionStatus;
import org.egov.stms.transactions.entity.SewerageApplicationDetails;
import org.egov.stms.transactions.entity.SewerageDemandConnection;
import org.egov.stms.transactions.service.SewerageApplicationDetailsService;
import org.egov.stms.transactions.service.SewerageDemandConnectionService;
import org.egov.stms.transactions.service.SewerageDemandService;
import org.egov.stms.transactions.service.collection.SewerageCollectionApportioner;
import org.egov.stms.utils.SewerageTaxUtils;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class SewerageTaxCollection
extends TaxCollection {
    private static final Logger LOGGER = Logger.getLogger(SewerageTaxCollection.class);
    @Autowired
    private EgBillDao egBillDAO;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private SewerageTaxUtils sewerageTaxUtils;
    @Autowired
    private SewerageDemandService sewerageDemandService;
    @Autowired
    private SewerageApplicationDetailsService sewerageApplicationDetailsService;
    @Autowired
    private SewerageDemandConnectionService sewerageDemandConnectionService;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public List<ReceiptDetail> reconstructReceiptDetail(String billReferenceNumber, BigDecimal actualAmountPaid, List<ReceiptDetail> receiptDetailList) {
        return null;
    }

    @Transactional
    public void updateDemandDetails(BillReceiptInfo billRcptInfo) {
        BigDecimal totalAmount = billRcptInfo.getTotalAmount();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"updateDemandDetails : Demand updation for advertisement started. ");
        }
        EgDemand demand = this.getDemandByBillReferenceNumber(Long.valueOf(billRcptInfo.getBillReferenceNum()));
        String indexNo = ((BillReceiptInfoImpl)billRcptInfo).getReceiptMisc().getReceiptHeader().getConsumerCode();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("updateDemandDetails : Demand before proceeding : " + demand));
            LOGGER.debug((Object)("updateDemandDetails : collection back update started for property : " + indexNo + " and receipt event is " + billRcptInfo.getEvent() + ". Total Receipt amount is." + totalAmount + " with receipt no." + billRcptInfo.getReceiptNum()));
        }
        if (billRcptInfo.getEvent().equals("INSTRUMENT_BOUNCED")) {
            this.updateDemandWithcollectdTaxDetails(demand, billRcptInfo, "INSTRUMENT_BOUNCED", totalAmount);
        } else if (billRcptInfo.getEvent().equals("RECEIPT_CREATED")) {
            this.updateDemandWithcollectdTaxDetails(demand, billRcptInfo, "RECEIPT_CREATED", totalAmount);
        } else if (billRcptInfo.getEvent().equals("RECEIPT_CANCELLED")) {
            this.updateDemandWithcollectdTaxDetails(demand, billRcptInfo, "RECEIPT_CANCELLED", totalAmount);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"updateDemandDetails : Demand updation processed. ");
        }
    }

    @Transactional
    private BigDecimal updateDemandWithcollectdTaxDetails(EgDemand demand, BillReceiptInfo billReceiptInfo, String eventType, BigDecimal totalAmount) {
        BigDecimal totalAmountCollected = BigDecimal.ZERO;
        for (ReceiptAccountInfo recAccInfo : billReceiptInfo.getAccountDetails()) {
            String demandMasterReasonDesc = null;
            String financialYearDesc = null;
            if (recAccInfo.getDescription() == null) continue;
            demandMasterReasonDesc = recAccInfo.getDescription().substring(0, recAccInfo.getDescription().indexOf("Collection")).trim();
            financialYearDesc = recAccInfo.getDescription().substring(recAccInfo.getDescription().indexOf("Collection") + "Collection".length()).trim();
            if (!eventType.equals("RECEIPT_CREATED")) continue;
            totalAmountCollected = totalAmountCollected.add(this.createOrUpdateDemandDetails(demandMasterReasonDesc, financialYearDesc, demand, billReceiptInfo, recAccInfo, totalAmount));
        }
        LOGGER.info((Object)("Demand before updateDemandDetails() processing: " + demand.getAmtCollected() + demand));
        if (eventType.equals("RECEIPT_CANCELLED")) {
            this.cancelBill(Long.valueOf(billReceiptInfo.getBillReferenceNum()));
            demand.setAmtCollected(demand.getAmtCollected().subtract(totalAmount));
            this.updateDmdDetForRcptCancel(demand, billReceiptInfo);
        } else if (eventType.equals("INSTRUMENT_BOUNCED")) {
            this.cancelBill(Long.valueOf(billReceiptInfo.getBillReferenceNum()));
            demand.setAmtCollected(demand.getAmtCollected().subtract(totalAmount));
            this.updateDmdDetForRcptCancel(demand, billReceiptInfo);
        }
        demand.setModifiedDate(new Date());
        return totalAmountCollected;
    }

    @Transactional
    private void updateDmdDetForRcptCancel(EgDemand demand, BillReceiptInfo billRcptInfo) {
        LOGGER.debug((Object)"Entering method updateDmdDetForRcptCancel");
        String demandMasterReasonDesc = null;
        String financialYearDesc = null;
        for (ReceiptAccountInfo rcptAccInfo : billRcptInfo.getAccountDetails()) {
            if (rcptAccInfo.getCrAmount() == null || rcptAccInfo.getCrAmount().compareTo(BigDecimal.ZERO) != 1 || rcptAccInfo.getIsRevenueAccount() || rcptAccInfo.getDescription() == null) continue;
            demandMasterReasonDesc = rcptAccInfo.getDescription().substring(0, rcptAccInfo.getDescription().indexOf("Collection")).trim();
            financialYearDesc = rcptAccInfo.getDescription().substring(rcptAccInfo.getDescription().indexOf("Collection") + "Collection".length()).trim();
            for (EgDemandDetails demandDetail : demand.getEgDemandDetails()) {
                if (!demandMasterReasonDesc.equalsIgnoreCase(demandDetail.getEgDemandReason().getEgDemandReasonMaster().getReasonMaster()) || financialYearDesc == null || !demandDetail.getEgDemandReason().getEgInstallmentMaster().getDescription().equalsIgnoreCase(financialYearDesc)) continue;
                if (demandDetail.getAmtCollected().compareTo(rcptAccInfo.getCrAmount()) < 0) {
                    throw new ApplicationRuntimeException("updateDmdDetForRcptCancel : Exception while updating cancel receipt, to be deducted amount " + rcptAccInfo.getCrAmount() + " is greater than the collected amount " + demandDetail.getAmtCollected() + " for demandDetail " + demandDetail);
                }
                demandDetail.setAmtCollected(demandDetail.getAmtCollected().subtract(rcptAccInfo.getCrAmount()));
            }
        }
        this.updateReceiptStatusWhenCancelled(billRcptInfo.getReceiptNum());
        LOGGER.debug((Object)"Exiting method updateDmdDetForRcptCancel");
    }

    @Transactional
    private void cancelBill(Long billId) {
        if (billId != null) {
            EgBill egBill = this.egBillDAO.findById(billId, false);
            egBill.setIs_Cancelled("Y");
        }
    }

    @Transactional
    private BigDecimal createOrUpdateDemandDetails(String demandMasterReasonDesc, String financialYearDesc, EgDemand demand, BillReceiptInfo billReceiptInfo, ReceiptAccountInfo recAccInfo, BigDecimal totalAmount) {
        BigDecimal totalAmountCollected = BigDecimal.ZERO;
        Boolean demandReasonPartOfDemand = false;
        if (recAccInfo.getCrAmount() != null && recAccInfo.getCrAmount().compareTo(BigDecimal.ZERO) > 0) {
            for (EgDemandDetails demandDetail : demand.getEgDemandDetails()) {
                if (demandDetail.getEgDemandReason() == null || demandDetail.getEgDemandReason().getEgDemandReasonMaster() == null || !demandDetail.getEgDemandReason().getEgDemandReasonMaster().getReasonMaster().trim().equalsIgnoreCase(demandMasterReasonDesc) || financialYearDesc == null || !financialYearDesc.equalsIgnoreCase(demandDetail.getEgDemandReason().getEgInstallmentMaster().getDescription())) continue;
                demandDetail.addCollected(recAccInfo.getCrAmount());
                this.persistCollectedReceipts(demandDetail, billReceiptInfo.getReceiptNum(), totalAmount, billReceiptInfo.getReceiptDate(), recAccInfo.getCrAmount());
                demand.setAmtCollected(demand.getAmtCollected().add(recAccInfo.getCrAmount()));
                totalAmountCollected = totalAmountCollected.add(recAccInfo.getCrAmount());
                demandDetail.setModifiedDate(new Date());
                demandReasonPartOfDemand = true;
            }
            if (!demandReasonPartOfDemand.booleanValue()) {
                EgDemandDetails demandDetail = this.sewerageDemandService.createDemandDetails(recAccInfo.getCrAmount(), this.sewerageDemandService.getDemandReasonByCodeAndInstallment(demandMasterReasonDesc, this.sewerageDemandService.getInstallmentByDescription(financialYearDesc).getId()), recAccInfo.getCrAmount());
                demand.addEgDemandDetails(demandDetail);
                this.getCurrentSession().flush();
                this.persistCollectedReceipts(demandDetail, billReceiptInfo.getReceiptNum(), totalAmount, billReceiptInfo.getReceiptDate(), recAccInfo.getCrAmount());
            }
            demand.setModifiedDate(new Date());
        }
        this.updateWorkflowState(demand);
        return totalAmountCollected;
    }

    private EgDemand getDemandByBillReferenceNumber(Long billId) {
        EgBill egBill;
        EgDemand egDemand = null;
        if (billId != null && (egBill = this.egBillDAO.findById(billId, false)) != null) {
            egDemand = egBill.getEgDemand();
        }
        return egDemand;
    }

    protected Module module() {
        return null;
    }

    public String constructAdditionalInfoForReceipt(BillReceiptInfo billReceiptInfo) {
        return null;
    }

    @Transactional
    private void updateWorkflowState(EgDemand demand) {
        SewerageApplicationDetails sewerageApplicationDetails;
        if (demand != null && (sewerageApplicationDetails = this.sewerageDemandConnectionService.getSewerageDemandConnectionByDemand(demand).getApplicationDetails()) != null && sewerageApplicationDetails.getStatus() != null) {
            if (sewerageApplicationDetails.getStatus().getCode().equalsIgnoreCase("COLLECTINSPECTIONFEE")) {
                sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("INSPECTIONFEEPAID", "SEWERAGETAXAPPLICATION"));
                if (sewerageApplicationDetails.getState() != null) {
                    this.sewerageApplicationDetailsService.updateStateTransition(sewerageApplicationDetails, ((Position)sewerageApplicationDetails.getState().getOwnerPosition()).getId(), "Collection done", sewerageApplicationDetails.getApplicationType().getCode(), "Forward");
                }
            } else if (sewerageApplicationDetails.getStatus().getCode().equalsIgnoreCase("ESTIMATIONNOTICEGENERATED")) {
                sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("ESTIMATIONAMOUNTPAID", "SEWERAGETAXAPPLICATION"));
            }
            this.sewerageApplicationDetailsService.save(sewerageApplicationDetails);
            if (this.sewerageApplicationDetailsService.getPortalInbox(sewerageApplicationDetails.getApplicationNumber()) != null) {
                this.sewerageApplicationDetailsService.updatePortalMessage(sewerageApplicationDetails);
            }
            this.sewerageApplicationDetailsService.updateIndexes(sewerageApplicationDetails);
        }
    }

    public ReceiptAmountInfo receiptAmountBifurcation(BillReceiptInfo billReceiptInfo) {
        EgBill egBill;
        ReceiptAmountInfo receiptAmountInfo = new ReceiptAmountInfo();
        BigDecimal currentInstallmentAmount = BigDecimal.ZERO;
        BigDecimal advanceInstallmentAmount = BigDecimal.ZERO;
        BigDecimal arrearAmount = BigDecimal.ZERO;
        if (billReceiptInfo != null && billReceiptInfo.getBillReferenceNum() != null && (egBill = this.egBillDAO.findById(Long.valueOf(billReceiptInfo.getBillReferenceNum()), false)) != null) {
            Installment currentInstallment = this.sewerageDemandService.getCurrentInstallment();
            Installment nextInstallment = this.sewerageDemandService.getNextInstallment();
            SewerageDemandConnection sewerageDemandConnection = this.sewerageDemandConnectionService.getSewerageDemandConnectionByDemand(egBill.getEgDemand());
            for (ReceiptAccountInfo rcptAccInfo : billReceiptInfo.getAccountDetails()) {
                if (rcptAccInfo.getCrAmount() == null || rcptAccInfo.getCrAmount().compareTo(BigDecimal.ZERO) != 1) continue;
                String installment = rcptAccInfo.getDescription().substring(rcptAccInfo.getDescription().indexOf("Collection") + "Collection".length()).trim();
                if (sewerageDemandConnection == null || !sewerageDemandConnection.getApplicationDetails().getConnection().getStatus().equals((Object)SewerageConnectionStatus.INPROGRESS)) continue;
                if (installment.equals(currentInstallment.toString())) {
                    currentInstallmentAmount = currentInstallmentAmount.add(rcptAccInfo.getCrAmount());
                    continue;
                }
                if (nextInstallment != null && installment.equals(nextInstallment.toString())) {
                    advanceInstallmentAmount = advanceInstallmentAmount.add(rcptAccInfo.getCrAmount());
                    continue;
                }
                arrearAmount = arrearAmount.add(rcptAccInfo.getCrAmount());
            }
        }
        receiptAmountInfo.setArrearsAmount(arrearAmount);
        receiptAmountInfo.setAdvanceAmount(advanceInstallmentAmount);
        receiptAmountInfo.setCurrentInstallmentAmount(currentInstallmentAmount);
        return receiptAmountInfo;
    }

    @Transactional
    public void apportionCollection(String billRefNo, BigDecimal amtPaid, List<ReceiptDetail> receiptDetails) {
        SewerageCollectionApportioner apportioner = new SewerageCollectionApportioner();
        apportioner.apportion(amtPaid, receiptDetails);
    }
}

