/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.transactions.service.collection;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.egov.collection.entity.ReceiptDetail;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;

public class SewerageCollectionApportioner {
    public static final String STRING_FULLTAX = "FULLTAX";
    public static final String STRING_ADVANCE = "ADVANCE";
    private static final Logger LOGGER = Logger.getLogger(SewerageCollectionApportioner.class);

    public void apportion(BigDecimal amtPaid, List<ReceiptDetail> receiptDetails) {
        LOGGER.info((Object)("receiptDetails before apportioning amount " + amtPaid + ": " + receiptDetails));
        Amount balance = new Amount(amtPaid);
        BigDecimal crAmountToBePaid = BigDecimal.ZERO;
        for (ReceiptDetail rd : receiptDetails) {
            if (balance.isZero()) {
                rd.zeroDrAndCrAmounts();
                continue;
            }
            crAmountToBePaid = rd.getCramountToBePaid();
            if (balance.isLessThanOrEqualTo(crAmountToBePaid)) {
                rd.setCramount(balance.amount);
                balance = Amount.ZERO;
                continue;
            }
            rd.setCramount(crAmountToBePaid);
            balance = balance.minus(crAmountToBePaid);
        }
        if (balance.isGreaterThanZero()) {
            LOGGER.error((Object)"Apportioning failed: excess payment!");
            throw new ValidationException(Arrays.asList(new ValidationError("Paid Amount is greater than Total Amount to be paid", "Paid Amount is greater than Total Amount to be paid")));
        }
        LOGGER.info((Object)("receiptDetails after apportioning: " + receiptDetails));
    }

    private static class Amount {
        private final BigDecimal amount;
        private static Amount ZERO = new Amount(BigDecimal.ZERO);

        private Amount(BigDecimal amount) {
            this.amount = amount;
        }

        private boolean isZero() {
            return this.amount.compareTo(BigDecimal.ZERO) == 0;
        }

        private boolean isGreaterThan(BigDecimal bd) {
            return this.amount.compareTo(bd) > 0;
        }

        private boolean isGreaterThanZero() {
            return this.isGreaterThan(BigDecimal.ZERO);
        }

        private boolean isLessThanOrEqualTo(BigDecimal bd) {
            return this.amount.compareTo(bd) <= 0;
        }

        private Amount minus(BigDecimal bd) {
            return new Amount(this.amount.subtract(bd));
        }
    }
}

