/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.transactions.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.DesignationService;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.pims.commons.Position;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.enums.BasicPropertyStatus;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.stms.transactions.entity.SewerageApplicationDetails;
import org.egov.wtms.utils.PropertyExtnUtils;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class SewerageWorkflowService {
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private DesignationService designationService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    protected AssignmentService assignmentService;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private PropertyExtnUtils propertyExtnUtils;
    @PersistenceContext
    private EntityManager entityManager;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public Boolean isEmployee(User user) {
        for (Role role : user.getRoles()) {
            for (AppConfigValues appconfig : this.getThirdPartyUserRoles()) {
                if (role == null || appconfig == null || !role.getName().equals(appconfig.getValue())) continue;
                return false;
            }
        }
        return true;
    }

    public Boolean isCitizenPortalUser(User user) {
        for (Role role : user.getRoles()) {
            if (role == null || !role.getName().equalsIgnoreCase("CITIZEN")) continue;
            return true;
        }
        return false;
    }

    public List<AppConfigValues> getThirdPartyUserRoles() {
        List<AppConfigValues> appConfigValueList = this.appConfigValuesService.getConfigValuesByModuleAndKey("Sewerage Tax Management", "SEWERAGEROLEFORNONEMPLOYEE");
        return !appConfigValueList.isEmpty() ? appConfigValueList : Collections.emptyList();
    }

    public Assignment getMappedAssignmentForCscOperator(String asessmentNumber) {
        AssessmentDetails assessmentDetails = this.propertyExtnUtils.getAssessmentDetailsForFlag(asessmentNumber, PropertyExternalService.FLAG_FULL_DETAILS, BasicPropertyStatus.ALL);
        Assignment assignmentObj = null;
        Boundary boundaryObj = this.boundaryService.getBoundaryById(assessmentDetails.getBoundaryDetails().getAdminWardId());
        assignmentObj = this.getUserPositionByZone(boundaryObj);
        return assignmentObj;
    }

    private Assignment getUserPositionByZone(Boundary boundaryObj) {
        String designationStr = this.getDesignationForCscOperatorWorkFlow();
        String departmentStr = this.getDepartmentForCscOperatorWorkFlow();
        String[] department = departmentStr.split(",");
        String[] designation = designationStr.split(",");
        List assignment = new ArrayList();
        for (String dept : department) {
            for (String desg : designation) {
                assignment = this.assignmentService.findByDepartmentDesignationAndBoundary(this.departmentService.getDepartmentByName(dept).getId(), this.designationService.getDesignationByName(desg).getId(), boundaryObj.getId());
                if (assignment.isEmpty()) {
                    if (boundaryObj.getParent() != null && boundaryObj.getParent().getBoundaryType() != null && boundaryObj.getParent().getBoundaryType().equals((Object)"Zone") && (assignment = this.assignmentService.findByDeptDesgnAndParentAndActiveChildBoundaries(this.departmentService.getDepartmentByName(dept).getId(), this.designationService.getDesignationByName(desg).getId(), boundaryObj.getParent().getId())).isEmpty() && boundaryObj.getParent() != null && boundaryObj.getParent().getParent() != null && boundaryObj.getParent().getParent().getBoundaryType().getName().equals("City")) {
                        assignment = this.assignmentService.findByDeptDesgnAndParentAndActiveChildBoundaries(this.departmentService.getDepartmentByName(dept).getId(), this.designationService.getDesignationByName(desg).getId(), boundaryObj.getParent().getParent().getId());
                    }
                    if (assignment.isEmpty() && boundaryObj.getParent() != null && boundaryObj.getParent().getBoundaryType().getName().equals("City")) {
                        assignment = this.assignmentService.findByDeptDesgnAndParentAndActiveChildBoundaries(this.departmentService.getDepartmentByName(dept).getId(), this.designationService.getDesignationByName(desg).getId(), boundaryObj.getParent().getId());
                    }
                }
                if (!assignment.isEmpty()) break;
            }
            if (!assignment.isEmpty()) break;
        }
        return !assignment.isEmpty() ? (Assignment)assignment.get(0) : null;
    }

    public String getDepartmentForCscOperatorWorkFlow() {
        List appConfigValue = this.appConfigValuesService.getConfigValuesByModuleAndKey("Sewerage Tax Management", "SEWERAGEDEPARTMENTFORCSCOPERATORWORKFLOW");
        return !appConfigValue.isEmpty() ? ((AppConfigValues)appConfigValue.get(0)).getValue() : null;
    }

    public String getDesignationForCscOperatorWorkFlow() {
        List appConfigValue = this.appConfigValuesService.getConfigValuesByModuleAndKey("Sewerage Tax Management", "SEWERAGEDESIGNATIONFORCSCOPERATORWORKFLOW");
        return !appConfigValue.isEmpty() ? ((AppConfigValues)appConfigValue.get(0)).getValue() : null;
    }

    public Assignment getWorkFlowInitiator(SewerageApplicationDetails sewerageApplicationDetails) {
        Assignment wfInitiator = null;
        if (sewerageApplicationDetails != null) {
            if (sewerageApplicationDetails.getState() != null && sewerageApplicationDetails.getState().getInitiatorPosition() != null) {
                wfInitiator = this.getUserAssignmentByPassingPositionAndUser(sewerageApplicationDetails.getCreatedBy(), (Position)sewerageApplicationDetails.getState().getInitiatorPosition());
                if (wfInitiator == null) {
                    List assignment = this.assignmentService.getAssignmentsForPosition(((Position)sewerageApplicationDetails.getState().getInitiatorPosition()).getId(), new Date());
                    wfInitiator = this.getActiveAssignment(assignment);
                }
            } else {
                wfInitiator = this.isEmployee(sewerageApplicationDetails.getCreatedBy()) == false || "Anonymous".equalsIgnoreCase(sewerageApplicationDetails.getCreatedBy().getUsername()) || this.isCitizenPortalUser(sewerageApplicationDetails.getCreatedBy()) != false ? this.getUserAssignment(sewerageApplicationDetails.getCreatedBy(), sewerageApplicationDetails) : this.assignmentService.getPrimaryAssignmentForUser(sewerageApplicationDetails.getCreatedBy().getId());
            }
        }
        return wfInitiator;
    }

    private Assignment getUserAssignment(User user, SewerageApplicationDetails sewerageApplicationDetails) {
        Assignment assignment = this.isCscOperator(user) != false || user.getUsername().equalsIgnoreCase("anonymous") || this.isCitizenPortalUser(user) != false ? this.getMappedAssignmentForCscOperator(sewerageApplicationDetails.getConnectionDetail().getPropertyIdentifier()) : this.getWorkFlowInitiator(sewerageApplicationDetails);
        return assignment;
    }

    private Assignment getActiveAssignment(List<Assignment> assignment) {
        Assignment wfInitiator = null;
        for (Assignment assign : assignment) {
            if (!assign.getEmployee().isActive()) continue;
            wfInitiator = assign;
            break;
        }
        return wfInitiator;
    }

    private Assignment getUserAssignmentByPassingPositionAndUser(User user, Position position) {
        Assignment wfInitiatorAssignment = null;
        if (user != null && position != null) {
            List assignmentList = this.assignmentService.findByEmployeeAndGivenDate(user.getId(), new Date());
            for (Assignment assignment : assignmentList) {
                if (position.getId() != assignment.getPosition().getId()) continue;
                wfInitiatorAssignment = assignment;
            }
        }
        return wfInitiatorAssignment;
    }

    public Boolean isCscOperator(User user) {
        List appConfigValue = this.appConfigValuesService.getConfigValuesByModuleAndKey("Sewerage Tax Management", "SEWERAGEROLEFORNONEMPLOYEE");
        String rolesForNonEmployee = !appConfigValue.isEmpty() ? ((AppConfigValues)appConfigValue.get(0)).getValue() : null;
        for (Role role : user.getRoles()) {
            if (role == null || rolesForNonEmployee == null || !role.getName().equalsIgnoreCase(rolesForNonEmployee)) continue;
            return true;
        }
        return false;
    }

    public String getDepartmentForReassignment() {
        List appConfigValue = this.appConfigValuesService.getConfigValuesByModuleAndKey("Sewerage Tax Management", "SEWERAGEDEPARTMENTFORREASSIGNMENT");
        return !appConfigValue.isEmpty() ? ((AppConfigValues)appConfigValue.get(0)).getValue() : null;
    }
}

