/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.transactions.service;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.egov.collection.entity.ReceiptDetail;
import org.egov.collection.integration.models.BillAccountDetails;
import org.egov.collection.integration.models.BillDetails;
import org.egov.collection.integration.models.BillInfo;
import org.egov.collection.integration.models.BillInfoImpl;
import org.egov.collection.integration.models.BillPayeeDetails;
import org.egov.collection.integration.models.BillReceiptInfo;
import org.egov.collection.integration.models.PaymentInfo;
import org.egov.collection.integration.models.PaymentInfoCard;
import org.egov.collection.integration.models.PaymentInfoCash;
import org.egov.collection.integration.models.PaymentInfoChequeDD;
import org.egov.collection.integration.models.ReceiptAccountInfo;
import org.egov.collection.integration.services.CollectionIntegrationService;
import org.egov.commons.Bank;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.CFinancialYear;
import org.egov.commons.Installment;
import org.egov.commons.dao.BankHibernateDAO;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.commons.dao.InstallmentDao;
import org.egov.dcb.bean.CashPayment;
import org.egov.dcb.bean.ChequePayment;
import org.egov.dcb.bean.CreditCardPayment;
import org.egov.dcb.bean.DDPayment;
import org.egov.dcb.bean.Payment;
import org.egov.demand.dao.EgBillDao;
import org.egov.demand.interfaces.Billable;
import org.egov.demand.model.EgBill;
import org.egov.demand.model.EgBillDetails;
import org.egov.demand.model.EgDemand;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.persistence.utils.SequenceNumberGenerator;
import org.egov.infra.rest.client.SimpleRestClient;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.web.utils.WebUtils;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.ErrorDetails;
import org.egov.ptis.domain.model.enums.BasicPropertyStatus;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.stms.entity.PaySewerageTaxDetails;
import org.egov.stms.entity.SewerageReceiptDetails;
import org.egov.stms.transactions.entity.SewerageApplicationDetails;
import org.egov.stms.transactions.service.SewerageApplicationDetailsService;
import org.egov.stms.transactions.service.collection.SewerageBillServiceImpl;
import org.egov.stms.transactions.service.collection.SewerageBillable;
import org.egov.stms.transactions.service.collection.SewerageTaxCollection;
import org.egov.wtms.utils.PropertyExtnUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.client.RestTemplate;

@Service
@Transactional(readOnly=true)
public class SewerageThirdPartyServices {
    @Autowired
    private SimpleRestClient simpleRestClient;
    @Autowired
    private CollectionIntegrationService collectionService;
    @Autowired
    private EgBillDao egBillDAO;
    @Autowired
    private BankHibernateDAO bankHibernateDAO;
    @Autowired
    private SewerageApplicationDetailsService sewerageApplicationDetailsService;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private SequenceNumberGenerator sequenceNumberGenerator;
    @Autowired
    private InstallmentDao installmentDao;
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private FinancialYearDAO financialYearDAO;
    @Autowired
    private PropertyExtnUtils propertyExtnUtils;
    @Autowired
    private SewerageBillServiceImpl sewerageBillServiceImpl;
    private String currentDemand = "currentDemand";
    private static final String WTMS_TAXDUE_RESTURL = "%s/wtms/rest/watertax/due/byptno/%s";

    public AssessmentDetails getPropertyDetails(String assessmentNumber, HttpServletRequest request) {
        RestTemplate restTemplate = new RestTemplate();
        String url = "http://" + request.getServerName() + ":" + request.getServerPort() + "/ptis/rest/property/{assessmentNumber}";
        return (AssessmentDetails)restTemplate.getForObject(url, AssessmentDetails.class, new Object[]{assessmentNumber});
    }

    public HashMap<String, Object> getWaterTaxDueAndCurrentTax(String assessmentNo, HttpServletRequest request) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("WATERTAXDUE", BigDecimal.ZERO);
        result.put("CURRENTWATERCHARGE", BigDecimal.ZERO);
        String wtmsRestURL = String.format(WTMS_TAXDUE_RESTURL, WebUtils.extractRequestDomainURL((HttpServletRequest)request, (boolean)false), assessmentNo);
        HashMap waterTaxInfo = this.simpleRestClient.getRESTResponseAsMap(wtmsRestURL);
        result.put("WATERTAXDUE", waterTaxInfo.get("totalTaxDue") == null ? BigDecimal.ZERO : new BigDecimal((Double)waterTaxInfo.get("totalTaxDue")));
        result.put("CURRENTWATERCHARGE", waterTaxInfo.get(this.currentDemand) == null ? BigDecimal.ZERO : new BigDecimal((Double)waterTaxInfo.get(this.currentDemand)));
        result.put("PROPERTYID", waterTaxInfo.get("propertyID"));
        result.put("CONSUMERCODE", waterTaxInfo.get("consumerCode"));
        return result;
    }

    public BigDecimal getCurrentWaterTax(String assessmentNo, HttpServletRequest request) {
        String wtmsRestURL = String.format(WTMS_TAXDUE_RESTURL, WebUtils.extractRequestDomainURL((HttpServletRequest)request, (boolean)false), assessmentNo);
        HashMap waterTaxInfo = this.simpleRestClient.getRESTResponseAsMap(wtmsRestURL);
        return waterTaxInfo.get(this.currentDemand) == null ? BigDecimal.ZERO : new BigDecimal((Double)waterTaxInfo.get(this.currentDemand));
    }

    public BillReceiptInfo validateTransanctionIdPresent(String transantion) {
        return this.collectionService.getReceiptInfo("STAX", transantion);
    }

    public SewerageReceiptDetails paySewerageTax(PaySewerageTaxDetails paySewerageTaxDetails, HttpServletRequest request) {
        SewerageReceiptDetails sewerageReceiptDetails = null;
        BigDecimal totalAmountToBePaid = BigDecimal.ZERO;
        SewerageApplicationDetails sewerageApplicationDetails = null;
        if (paySewerageTaxDetails.getApplicaionNumber() != null && !"".equals(paySewerageTaxDetails.getApplicaionNumber())) {
            sewerageApplicationDetails = this.sewerageApplicationDetailsService.findByApplicationNumber(paySewerageTaxDetails.getApplicaionNumber());
        } else if (paySewerageTaxDetails.getConsumerNo() != null) {
            sewerageApplicationDetails = this.sewerageApplicationDetailsService.findByConnection_ShscNumberAndIsActive(paySewerageTaxDetails.getConsumerNo());
        }
        SewerageBillable sewerageBillable = this.buildSewerageBillableObject(paySewerageTaxDetails, request, sewerageApplicationDetails);
        EgBill egBill = this.generateBillForConnection(sewerageBillable);
        for (EgBillDetails billDetails : egBill.getEgBillDetails()) {
            totalAmountToBePaid = totalAmountToBePaid.add(billDetails.getCrAmount());
        }
        BillReceiptInfo billReceiptInfo = this.getBillReceiptInforForSewerageTax(paySewerageTaxDetails, egBill);
        if (null != billReceiptInfo) {
            sewerageReceiptDetails = this.buildSewerageReceiptDetailObject(paySewerageTaxDetails, totalAmountToBePaid, billReceiptInfo);
        }
        return sewerageReceiptDetails;
    }

    private SewerageReceiptDetails buildSewerageReceiptDetailObject(PaySewerageTaxDetails paySewerageTaxDetails, BigDecimal totalAmountToBePaid, BillReceiptInfo billReceiptInfo) {
        SewerageReceiptDetails sewerageReceiptDetails = new SewerageReceiptDetails();
        sewerageReceiptDetails.setReceiptNo(billReceiptInfo.getReceiptNum());
        sewerageReceiptDetails.setReceiptDate(this.formatDate(billReceiptInfo.getReceiptDate()));
        sewerageReceiptDetails.setPayeeName(billReceiptInfo.getPayeeName());
        sewerageReceiptDetails.setPayeeAddress(billReceiptInfo.getPayeeAddress());
        sewerageReceiptDetails.setBillReferenceNo(billReceiptInfo.getBillReferenceNum());
        sewerageReceiptDetails.setServiceName(billReceiptInfo.getServiceName());
        sewerageReceiptDetails.setDescription(billReceiptInfo.getDescription());
        sewerageReceiptDetails.setPaidBy(billReceiptInfo.getPaidBy());
        sewerageReceiptDetails.setPaymentMode(paySewerageTaxDetails.getPaymentMode());
        sewerageReceiptDetails.setPaymentAmount(billReceiptInfo.getTotalAmount());
        sewerageReceiptDetails.setTransactionId(billReceiptInfo.getManualReceiptNumber());
        String[] paidFrom = null;
        String[] paidTo = null;
        Installment fromInstallment = null;
        Installment toInstallment = null;
        if (totalAmountToBePaid.compareTo(BigDecimal.ZERO) > 0) {
            ArrayList receiptAccountsList = new ArrayList(billReceiptInfo.getAccountDetails());
            Collections.sort(receiptAccountsList, (rcptAcctInfo1, rcptAcctInfo2) -> {
                if (rcptAcctInfo1.getOrderNumber() != null && rcptAcctInfo2.getOrderNumber() != null) {
                    return rcptAcctInfo1.getOrderNumber().compareTo(rcptAcctInfo2.getOrderNumber());
                }
                return 0;
            });
            for (ReceiptAccountInfo rcptAcctInfo : receiptAccountsList) {
                if (rcptAcctInfo.getCrAmount().compareTo(BigDecimal.ZERO) <= 0 || rcptAcctInfo.getDescription().contains("SEWERAGEADVANCE")) continue;
                if (paidFrom == null) {
                    paidFrom = rcptAcctInfo.getDescription().split("Sewerage Tax Collection ", 2);
                    paidFrom = paidFrom[1].split("#", 2);
                }
                paidTo = rcptAcctInfo.getDescription().split("Sewerage Tax Collection ", 2);
                paidTo = paidTo[1].split("#", 2);
            }
            if (paidFrom != null) {
                fromInstallment = this.installmentDao.getInsatllmentByModuleAndDescription(this.moduleService.getModuleByName("Sewerage Tax Management"), paidFrom[0].trim());
            }
            if (paidTo != null) {
                toInstallment = this.installmentDao.getInsatllmentByModuleAndDescription(this.moduleService.getModuleByName("Sewerage Tax Management"), paidTo[0].trim());
            }
        }
        if (totalAmountToBePaid.compareTo(BigDecimal.ZERO) == 0) {
            sewerageReceiptDetails.setPaymentPeriod("");
            sewerageReceiptDetails.setPaymentType("SEWERAGEADVANCE");
        } else {
            sewerageReceiptDetails.setPaymentPeriod((fromInstallment != null ? DateUtils.getDefaultFormattedDate((Date)fromInstallment.getFromDate()) : "").concat(" to ").concat(toInstallment != null ? DateUtils.getDefaultFormattedDate((Date)toInstallment.getToDate()) : ""));
        }
        if (paySewerageTaxDetails.getPaymentAmount().compareTo(totalAmountToBePaid) > 0) {
            sewerageReceiptDetails.setPaymentType("SEWERAGEADVANCE");
        } else if (totalAmountToBePaid.compareTo(paySewerageTaxDetails.getPaymentAmount()) > 0) {
            sewerageReceiptDetails.setPaymentType("Partially");
        } else {
            sewerageReceiptDetails.setPaymentType("Fully");
        }
        ErrorDetails errorDetails = new ErrorDetails();
        errorDetails.setErrorCode("STAX-REST-0");
        errorDetails.setErrorMessage("SUCCESS");
        sewerageReceiptDetails.setErrorDetails(errorDetails);
        return sewerageReceiptDetails;
    }

    private SewerageBillable buildSewerageBillableObject(PaySewerageTaxDetails paySewerageTaxDetails, HttpServletRequest request, SewerageApplicationDetails sewerageApplicationDetails) {
        SewerageBillable sewerageBillable = (SewerageBillable)((Object)this.context.getBean("sewerageBillable"));
        AssessmentDetails assessmentDetails = this.propertyExtnUtils.getAssessmentDetailsForFlag(sewerageApplicationDetails.getConnectionDetail().getPropertyIdentifier(), PropertyExternalService.FLAG_FULL_DETAILS, BasicPropertyStatus.ALL);
        sewerageBillable.setSewerageApplicationDetails(sewerageApplicationDetails);
        sewerageBillable.setAssessmentDetails(assessmentDetails);
        sewerageBillable.setUserId(2L);
        ApplicationThreadLocals.setUserId((Long)2L);
        Serializable referenceNumber = this.sequenceNumberGenerator.getNextSequence("SEQ_SEWERAGEBILL_NUMBER");
        sewerageBillable.setReferenceNumber(String.format("%s%06d", "", referenceNumber));
        sewerageBillable.setBillType(this.egBillDAO.getBillTypeByCode("MANUAL"));
        sewerageBillable.setTransanctionReferenceNumber(paySewerageTaxDetails.getTransactionId());
        return sewerageBillable;
    }

    public EgBill generateBillForConnection(Billable billObj) {
        EgBill bill = new EgBill();
        bill.setBillNo(billObj.getReferenceNumber());
        bill.setBoundaryNum(billObj.getBoundaryNum() != null ? Integer.valueOf(billObj.getBoundaryNum().intValue()) : null);
        bill.setTransanctionReferenceNumber(billObj.getTransanctionReferenceNumber());
        bill.setBoundaryType(billObj.getBoundaryType());
        bill.setCitizenAddress(billObj.getBillAddress());
        bill.setCitizenName(billObj.getBillPayee());
        bill.setCollModesNotAllowed(billObj.getCollModesNotAllowed());
        bill.setDepartmentCode(billObj.getDepartmentCode());
        bill.setEgBillType(billObj.getBillType());
        bill.setFunctionaryCode(billObj.getFunctionaryCode());
        bill.setFundCode(billObj.getFundCode());
        bill.setFundSourceCode(billObj.getFundSourceCode());
        bill.setIssueDate(new Date());
        bill.setLastDate(billObj.getBillLastDueDate());
        bill.setModule(billObj.getModule());
        bill.setOverrideAccountHeadsAllowed(billObj.getOverrideAccountHeadsAllowed());
        bill.setPartPaymentAllowed(Boolean.TRUE);
        bill.setServiceCode(billObj.getServiceCode());
        bill.setIs_Cancelled("N");
        bill.setIs_History("N");
        bill.setModifiedDate(new Date());
        bill.setTotalAmount(billObj.getTotalAmount());
        bill.setUserId(billObj.getUserId());
        bill.setCreateDate(new Date());
        EgDemand demandObject = billObj.getCurrentDemand();
        bill.setEgDemand(demandObject);
        bill.setDescription(billObj.getDescription());
        bill.setDisplayMessage(billObj.getDisplayMessage());
        bill.setEmailId(billObj.getEmailId());
        if (demandObject != null && demandObject.getMinAmtPayable() != null) {
            bill.setMinAmtPayable(demandObject.getMinAmtPayable());
        } else {
            bill.setMinAmtPayable(BigDecimal.ZERO);
        }
        List<EgBillDetails> bd = this.sewerageBillServiceImpl.getSewerageTaxTypeBilldetails(billObj);
        for (EgBillDetails billdetails : bd) {
            bill.addEgBillDetails(billdetails);
            billdetails.setEgBill(bill);
            billdetails.setPurpose(this.getPurpose(billdetails).toString());
        }
        bill.setConsumerId(billObj.getConsumerId());
        bill.setConsumerType(billObj.getConsumerType());
        bill.setCallBackForApportion(Boolean.TRUE);
        this.egBillDAO.create(bill);
        return bill;
    }

    private String formatDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
        return sdf.format(date);
    }

    public BillReceiptInfo getBillReceiptInforForSewerageTax(PaySewerageTaxDetails paySewerageTaxDetails, EgBill egBill) {
        HashMap<String, String> paymentDetailsMap = new HashMap<String, String>(0);
        paymentDetailsMap.put("amount", paySewerageTaxDetails.getPaymentAmount().toString());
        paymentDetailsMap.put("paidBy", paySewerageTaxDetails.getPaidBy());
        if ("CHEQUE".equalsIgnoreCase(paySewerageTaxDetails.getPaymentMode().toLowerCase()) || "DD".equalsIgnoreCase(paySewerageTaxDetails.getPaymentMode().toLowerCase())) {
            paymentDetailsMap.put("instrumentNumber", paySewerageTaxDetails.getChqddNo());
            paymentDetailsMap.put("instrumentDate", paySewerageTaxDetails.getChqddDate());
            paymentDetailsMap.put("branchName", paySewerageTaxDetails.getBranchName());
            Long validatesBankId = this.getBankId(paySewerageTaxDetails.getBankName());
            paymentDetailsMap.put("bankId", validatesBankId.toString());
            paymentDetailsMap.put("bankName", paySewerageTaxDetails.getBankName());
        }
        Payment payment = Payment.create((String)paySewerageTaxDetails.getPaymentMode().toLowerCase(), paymentDetailsMap);
        return this.executeCollection(payment, egBill, paySewerageTaxDetails.getSource());
    }

    private Long getBankId(String bankCodeOrName) {
        Bank bank = this.bankHibernateDAO.getBankByCode(bankCodeOrName);
        return bank != null ? Long.valueOf(bank.getId().intValue()) : Long.valueOf(0L);
    }

    @Transactional
    public BillReceiptInfo executeCollection(Payment payment, EgBill bill, String source) {
        if (!this.isCollectionPermitted(bill)) {
            throw new ApplicationRuntimeException("Collection is not allowed - current balance is zero .");
        }
        if (payment != null) {
            List<PaymentInfo> paymentInfoList = this.preparePaymentInfo(payment);
            BillInfoImpl billInfo = this.prepareBillInfo(payment.getAmount(), BillInfo.COLLECTIONTYPE.F, bill, source);
            return this.collectionService.createReceipt((BillInfo)billInfo, paymentInfoList);
        }
        return null;
    }

    private List<PaymentInfo> preparePaymentInfo(Payment payment) {
        ArrayList<PaymentInfo> paymentInfoList = new ArrayList<PaymentInfo>();
        PaymentInfoCard paymentInfo = null;
        if (payment != null) {
            if (payment instanceof ChequePayment) {
                ChequePayment chequePayment = (ChequePayment)payment;
                paymentInfo = new PaymentInfoChequeDD(chequePayment.getBankId(), chequePayment.getBranchName(), chequePayment.getInstrumentDate(), chequePayment.getInstrumentNumber(), PaymentInfo.TYPE.cheque, payment.getAmount());
            } else if (payment instanceof DDPayment) {
                DDPayment chequePayment = (DDPayment)payment;
                paymentInfo = new PaymentInfoChequeDD(chequePayment.getBankId(), chequePayment.getBranchName(), chequePayment.getInstrumentDate(), chequePayment.getInstrumentNumber(), PaymentInfo.TYPE.dd, payment.getAmount());
            } else if (payment instanceof CreditCardPayment) {
                paymentInfo = this.prepareCardPaymentInfo((CreditCardPayment)payment, new PaymentInfoCard());
            } else if (payment instanceof CashPayment) {
                paymentInfo = new PaymentInfoCash(payment.getAmount());
            }
        }
        paymentInfoList.add((PaymentInfo)paymentInfo);
        return paymentInfoList;
    }

    private PaymentInfoCard prepareCardPaymentInfo(CreditCardPayment cardPayment, PaymentInfoCard paymentInfoCard) {
        paymentInfoCard.setInstrumentNumber(cardPayment.getCreditCardNo());
        paymentInfoCard.setInstrumentAmount(cardPayment.getAmount());
        paymentInfoCard.setExpMonth(cardPayment.getExpMonth());
        paymentInfoCard.setExpYear(cardPayment.getExpYear());
        paymentInfoCard.setCvvNumber(cardPayment.getCvv());
        paymentInfoCard.setCardTypeValue(cardPayment.getCardType());
        paymentInfoCard.setTransactionNumber(cardPayment.getTransactionNumber());
        return paymentInfoCard;
    }

    public BillInfoImpl prepareBillInfo(BigDecimal amountPaid, BillInfo.COLLECTIONTYPE collType, EgBill bill, String source) {
        BillInfoImpl billInfoImpl = this.initialiseFromBill(amountPaid, collType, bill);
        ArrayList<ReceiptDetail> receiptDetails = new ArrayList<ReceiptDetail>(0);
        ArrayList billDetails = new ArrayList(bill.getEgBillDetails());
        if (!billDetails.isEmpty()) {
            Collections.sort(billDetails, (c1, c2) -> c1.getEgDemandReason().getEgInstallmentMaster().getFromDate().compareTo(c2.getEgDemandReason().getEgInstallmentMaster().getFromDate()));
        }
        for (EgBillDetails billDet : billDetails) {
            receiptDetails.add(this.initReceiptDetail(billDet.getGlcode(), BigDecimal.ZERO, billDet.getCrAmount(), billDet.getDrAmount(), billDet.getDescription()));
        }
        new SewerageTaxCollection().apportionPaidAmount(String.valueOf(bill.getId()), amountPaid, receiptDetails);
        block1: for (EgBillDetails billDet : bill.getEgBillDetails()) {
            for (ReceiptDetail rd : receiptDetails) {
                if (rd.getCramount().compareTo(BigDecimal.ZERO) <= 0 || !billDet.getGlcode().equals(rd.getAccounthead().getGlcode()) || !billDet.getDescription().equals(rd.getDescription())) continue;
                BillAccountDetails billAccDetails = new BillAccountDetails(billDet.getGlcode(), billDet.getOrderNo(), rd.getCramount(), rd.getDramount(), billDet.getFunctionCode(), billDet.getDescription(), Boolean.valueOf(billDet.getAdditionalFlag() == 1), this.getPurpose(billDet));
                ((BillDetails)((BillPayeeDetails)billInfoImpl.getPayees().get(0)).getBillDetails().get(0)).addBillAccountDetails(billAccDetails);
                continue block1;
            }
        }
        billInfoImpl.setTransactionReferenceNumber(bill.getTransanctionReferenceNumber());
        billInfoImpl.setSource(source);
        return billInfoImpl;
    }

    public BillAccountDetails.PURPOSE getPurpose(EgBillDetails billDet) {
        CFinancialYear finYear = this.financialYearDAO.getFinancialYearByDate(new Date());
        if (billDet.getDescription().contains("SEWERAGEADVANCE")) {
            return BillAccountDetails.PURPOSE.ADVANCE_AMOUNT;
        }
        if (billDet.getEgDemandReason() != null && billDet.getEgDemandReason().getEgInstallmentMaster().getToDate().compareTo(finYear.getStartingDate()) < 0) {
            return BillAccountDetails.PURPOSE.ARREAR_AMOUNT;
        }
        if (billDet.getEgDemandReason() != null && billDet.getEgDemandReason().getEgInstallmentMaster().getFromDate().compareTo(finYear.getStartingDate()) >= 0 && billDet.getEgDemandReason().getEgInstallmentMaster().getFromDate().compareTo(finYear.getEndingDate()) < 0) {
            return BillAccountDetails.PURPOSE.CURRENT_AMOUNT;
        }
        return BillAccountDetails.PURPOSE.OTHERS;
    }

    private BillInfoImpl initialiseFromBill(BigDecimal amountPaid, BillInfo.COLLECTIONTYPE collType, EgBill bill) {
        String[] collModes;
        ArrayList<BillPayeeDetails> billPayeeDetList = new ArrayList<BillPayeeDetails>(0);
        ArrayList<String> collModesList = new ArrayList<String>();
        for (String coll : collModes = bill.getCollModesNotAllowed().split(",")) {
            collModesList.add(coll);
        }
        BillInfoImpl billInfoImpl = new BillInfoImpl(bill.getServiceCode(), bill.getFundCode(), bill.getFunctionaryCode(), bill.getFundSourceCode(), bill.getDepartmentCode(), "Sewerage Tax Collection", bill.getCitizenName(), bill.getPartPaymentAllowed(), bill.getOverrideAccountHeadsAllowed(), collModesList, collType);
        BillPayeeDetails billPayeeDet = new BillPayeeDetails(bill.getCitizenName(), bill.getCitizenAddress(), bill.getEmailId());
        BillDetails billDetails = new BillDetails(bill.getId().toString(), bill.getCreateDate(), bill.getConsumerId(), bill.getConsumerType(), bill.getBoundaryNum().toString(), bill.getBoundaryType(), bill.getDescription(), amountPaid, bill.getMinAmtPayable());
        billPayeeDet.addBillDetails(billDetails);
        billPayeeDetList.add(billPayeeDet);
        billInfoImpl.setPayees(billPayeeDetList);
        return billInfoImpl;
    }

    private ReceiptDetail initReceiptDetail(String glCode, BigDecimal crAmount, BigDecimal crAmountToBePaid, BigDecimal drAmount, String description) {
        ReceiptDetail receiptDetail = new ReceiptDetail();
        CChartOfAccounts accountHead = new CChartOfAccounts();
        accountHead.setGlcode(glCode);
        receiptDetail.setAccounthead(accountHead);
        receiptDetail.setDescription(description);
        receiptDetail.setCramount(crAmount);
        receiptDetail.setCramountToBePaid(crAmountToBePaid);
        receiptDetail.setDramount(drAmount);
        return receiptDetail;
    }

    private boolean isCollectionPermitted(EgBill bill) {
        boolean result = false;
        for (EgBillDetails bd : bill.getEgBillDetails()) {
            if (bd.getCrAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
            result = true;
        }
        return result;
    }
}

