/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.transactions.service;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.DesignationService;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.workflow.entity.OwnerGroup;
import org.egov.pims.commons.Designation;
import org.egov.pims.commons.Position;
import org.egov.stms.entity.SewerageReassignDetails;
import org.egov.stms.transactions.entity.SewerageApplicationDetails;
import org.egov.stms.transactions.service.SewerageApplicationDetailsService;
import org.egov.stms.transactions.service.SewerageWorkflowService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SewerageReassignService {
    private static final String NEWSEWERAGECONNECTION = "NEWSEWERAGECONNECTION";
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private DesignationService designationService;
    @Autowired
    private SewerageApplicationDetailsService sewerageApplicationDetailsService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private SewerageWorkflowService sewerageWorkflowService;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    private AppConfigValueService appConfigValuesService;

    public User getLoggedInUser() {
        return this.securityUtils.getCurrentUser();
    }

    public Long getLoggedInPositiontionId() {
        Position position = null;
        Long userId = ApplicationThreadLocals.getUserId();
        if (userId != null && userId.intValue() != 0) {
            position = this.positionMasterService.getPositionByUserId(userId);
        }
        return position.getId();
    }

    public Map<Long, String> getemployees() {
        String designationStr = this.sewerageWorkflowService.getDesignationForCscOperatorWorkFlow();
        String departmentStr = this.sewerageWorkflowService.getDepartmentForReassignment();
        String[] departments = departmentStr.split(",");
        String[] designations = designationStr.split(",");
        Department dept = null;
        HashMap<Long, String> empWithPosition = new HashMap<Long, String>();
        for (String department : departments) {
            dept = this.departmentService.getDepartmentByName(department);
            for (String designationName : Arrays.asList(designations)) {
                List desig = this.designationService.getDesignationsByName(designationName);
                for (Designation designation : desig) {
                    List assignments = this.assignmentService.findAllAssignmentsByDeptDesigAndDates(dept.getId(), designation.getId(), new Date());
                    if (assignments.isEmpty()) continue;
                    for (Assignment assignment : assignments) {
                        if (assignment == null || assignment.getPosition() == null || this.getLoggedInPositiontionId().equals(assignment.getPosition().getId())) continue;
                        empWithPosition.put(assignment.getPosition().getId(), assignment.getEmployee().getName().concat("/").concat(assignment.getPosition().getName()));
                    }
                }
            }
        }
        return empWithPosition;
    }

    public String getSewerageApplication(SewerageReassignDetails sewerageReassignDetails, Position position) {
        String applicationType = sewerageReassignDetails.getStateType();
        if (NEWSEWERAGECONNECTION.equalsIgnoreCase(applicationType)) {
            SewerageApplicationDetails sewerageApplicationDetails = this.sewerageApplicationDetailsService.findByApplicationNumber(sewerageReassignDetails.getApplicationNo());
            sewerageApplicationDetails.changeProcessInitiator((OwnerGroup)position);
            sewerageApplicationDetails.changeProcessOwner((OwnerGroup)position);
            this.sewerageApplicationDetailsService.updateSewerageApplicationDetails(sewerageApplicationDetails);
            this.sewerageApplicationDetailsService.updateIndexes(sewerageApplicationDetails);
            return sewerageApplicationDetails.getApplicationNumber();
        }
        return "";
    }

    public boolean isReassignEnabled() {
        List appConfigValues = this.appConfigValuesService.getConfigValuesByModuleAndKey("Sewerage Tax Management", "REASSIGN_BUTTONENABLED_SEWERAGE");
        return !appConfigValues.isEmpty() && "YES".equals(((AppConfigValues)appConfigValues.get(0)).getValue());
    }
}

