/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.transactions.service;

import java.util.ArrayList;
import java.util.List;
import org.egov.stms.entity.SewerageDemandGenerationLog;
import org.egov.stms.entity.SewerageDemandGenerationLogDetail;
import org.egov.stms.masters.entity.enums.SewerageProcessStatus;
import org.egov.stms.transactions.entity.SewerageApplicationDetails;
import org.egov.stms.transactions.entity.SewerageDemandStatusDetails;
import org.egov.stms.transactions.repository.SewerageDemandGenerationLogDetailRepository;
import org.egov.stms.transactions.repository.SewerageDemandGenerationLogRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@Transactional(readOnly=true)
public class SewerageDemandGenerationLogService {
    @Autowired
    private SewerageDemandGenerationLogRepository demandGenerationLogRepository;
    @Autowired
    private SewerageDemandGenerationLogDetailRepository demandGenerationLogDetailRepository;

    public SewerageDemandGenerationLog getDemandGenerationLogByInstallmentYear(String installmentYearRange) {
        return this.demandGenerationLogRepository.findByInstallmentYear(installmentYearRange);
    }

    public List<SewerageDemandGenerationLog> getDemandGenerationLogListByInstallmentYear(String installmentYear) {
        return this.demandGenerationLogRepository.findByInstallmentYearOrderByIdDesc(installmentYear);
    }

    public SewerageDemandGenerationLog createDemandGenerationLog(String installmentYearRange) {
        return (SewerageDemandGenerationLog)((Object)this.demandGenerationLogRepository.saveAndFlush((Object)new SewerageDemandGenerationLog(installmentYearRange)));
    }

    public List<SewerageDemandGenerationLogDetail> getDemandGenerationLogDetailByDemandGenerationLog(SewerageDemandGenerationLog demandGenerationLog) {
        return this.demandGenerationLogDetailRepository.findByDemandGenerationLogIdOrderByIdDesc(demandGenerationLog.getId());
    }

    @Transactional
    public SewerageDemandGenerationLog completeDemandGenerationLog(SewerageDemandGenerationLog demandGenerationLog) {
        demandGenerationLog.setDemandGenerationStatus(SewerageProcessStatus.COMPLETED);
        for (SewerageDemandGenerationLogDetail detail : demandGenerationLog.getDetails()) {
            if (!detail.getStatus().equals((Object)SewerageProcessStatus.INCOMPLETE)) continue;
            demandGenerationLog.setDemandGenerationStatus(SewerageProcessStatus.INCOMPLETE);
            break;
        }
        demandGenerationLog.setExecutionStatus(SewerageProcessStatus.COMPLETED);
        return (SewerageDemandGenerationLog)((Object)this.demandGenerationLogRepository.saveAndFlush((Object)demandGenerationLog));
    }

    public SewerageDemandGenerationLogDetail createOrGetDemandGenerationLogDetail(SewerageDemandGenerationLog demandGenerationLog, SewerageApplicationDetails applicationDetails, SewerageProcessStatus status, String detailMsg) {
        SewerageDemandGenerationLogDetail logDetail = this.demandGenerationLogDetailRepository.findByDemandGenerationLogIdAndSewerageApplicationDetailsId(demandGenerationLog.getId(), applicationDetails.getId());
        if (logDetail == null) {
            logDetail = new SewerageDemandGenerationLogDetail();
            logDetail.setSewerageApplicationDetails(applicationDetails);
            logDetail.setDemandGenerationLog(demandGenerationLog);
            logDetail.setStatus(status);
            logDetail.setDetail(detailMsg);
            demandGenerationLog.getDetails().add(logDetail);
            logDetail = (SewerageDemandGenerationLogDetail)((Object)this.demandGenerationLogDetailRepository.saveAndFlush((Object)logDetail));
        }
        return logDetail;
    }

    @Transactional
    public SewerageDemandGenerationLogDetail completeDemandGenerationLogDetail(SewerageDemandGenerationLogDetail demandGenerationLogDetail) {
        return (SewerageDemandGenerationLogDetail)((Object)this.demandGenerationLogDetailRepository.saveAndFlush((Object)demandGenerationLogDetail));
    }

    public SewerageDemandStatusDetails getDemandStatusResult(List<SewerageDemandGenerationLog> logList) {
        SewerageDemandStatusDetails demandStatus = new SewerageDemandStatusDetails();
        Long noOfSuccess = 0L;
        Long noOfFailure = 0L;
        ArrayList<String> sewrageList = new ArrayList<String>();
        for (SewerageDemandGenerationLog log : logList) {
            List<SewerageDemandGenerationLogDetail> logDetailList = this.getDemandGenerationLogDetailByDemandGenerationLog(log);
            for (SewerageDemandGenerationLogDetail logDetail : logDetailList) {
                if (StringUtils.isEmpty(sewrageList)) {
                    sewrageList.add(logDetail.getSewerageApplicationDetails().getApplicationNumber());
                } else if (!sewrageList.contains(logDetail.getSewerageApplicationDetails().getApplicationNumber())) {
                    Long l;
                    Long l2;
                    if (SewerageProcessStatus.COMPLETED.equals((Object)logDetail.getStatus())) {
                        l2 = noOfSuccess;
                        l = noOfSuccess = Long.valueOf(noOfSuccess + 1L);
                    } else if (SewerageProcessStatus.INCOMPLETE.equals((Object)logDetail.getStatus())) {
                        l2 = noOfFailure;
                        l = noOfFailure = Long.valueOf(noOfFailure + 1L);
                    }
                }
                sewrageList.add(logDetail.getSewerageApplicationDetails().getApplicationNumber());
            }
        }
        demandStatus.setNoOfSuccess(noOfSuccess);
        demandStatus.setNoOfFailure(noOfFailure);
        return demandStatus;
    }

    public List<SewerageDemandStatusDetails> getLogDetailResultList(List<SewerageDemandGenerationLogDetail> logDetail, SewerageDemandGenerationLog demandGenerationLog, List<Long> detailList, boolean value) {
        ArrayList<SewerageDemandStatusDetails> successRecordsList = new ArrayList<SewerageDemandStatusDetails>();
        ArrayList<SewerageDemandStatusDetails> failedRecordsList = new ArrayList<SewerageDemandStatusDetails>();
        ArrayList<SewerageDemandStatusDetails> resultList = new ArrayList<SewerageDemandStatusDetails>();
        for (SewerageDemandGenerationLogDetail detail : logDetail) {
            if (detailList.contains(detail.getSewerageApplicationDetails().getApplicationNumber())) continue;
            SewerageDemandStatusDetails statusObject = new SewerageDemandStatusDetails();
            statusObject.setFinancialYear(demandGenerationLog.getInstallmentYear());
            SewerageApplicationDetails sewerageApplicationDetails = detail.getSewerageApplicationDetails();
            statusObject.setSewerageApplicationNumber(sewerageApplicationDetails.getApplicationNumber());
            statusObject.setStatus(detail.getStatus().toString());
            statusObject.setDetails(detail.getDetail());
            if (SewerageProcessStatus.COMPLETED.equals((Object)detail.getStatus())) {
                successRecordsList.add(statusObject);
            } else if (SewerageProcessStatus.INCOMPLETE.equals((Object)detail.getStatus())) {
                failedRecordsList.add(statusObject);
            }
            detailList.add(detail.getSewerageApplicationDetails().getId());
        }
        if (value) {
            resultList.addAll(successRecordsList);
        } else {
            resultList.addAll(failedRecordsList);
        }
        return resultList;
    }
}

