/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.transactions.service;

import java.io.ByteArrayInputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.egov.commons.Installment;
import org.egov.commons.dao.InstallmentDao;
import org.egov.demand.model.EgDemandDetails;
import org.egov.demand.model.EgdmCollectedReceipt;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.BoundaryType;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.BoundaryTypeService;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.utils.autonumber.AutonumberServiceBeanResolver;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.OwnerName;
import org.egov.stms.autonumber.SewerageDemandBillNumberGenerator;
import org.egov.stms.entity.SewerageDCBReportResult;
import org.egov.stms.masters.pojo.DCBReportWardwiseResult;
import org.egov.stms.masters.pojo.SewerageRateDCBResult;
import org.egov.stms.masters.pojo.SewerageRateResultComparatorByInstallment;
import org.egov.stms.notice.entity.SewerageNotice;
import org.egov.stms.notice.service.SewerageNoticeService;
import org.egov.stms.transactions.entity.SewerageApplicationDetails;
import org.egov.stms.transactions.service.SewerageApplicationDetailsService;
import org.egov.stms.transactions.service.SewerageThirdPartyServices;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class SewerageDCBReporService {
    public static final String SEWERAGEDEMANDBILL = "sewerageDemandBill";
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    SewerageThirdPartyServices sewerageThirdPartyServices;
    @Autowired
    private BoundaryTypeService boundaryTypeService;
    @Autowired
    private ReportService reportService;
    @Autowired
    private InstallmentDao installmentDao;
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private AutonumberServiceBeanResolver beanResolver;
    @Autowired
    private SewerageNoticeService sewerageNoticeService;
    @Autowired
    private SewerageApplicationDetailsService sewerageApplicationDetailsService;
    @Autowired
    private CityService cityService;

    public List<SewerageRateDCBResult> getSewerageRateDCBReport(SewerageApplicationDetails sewerageApplicationDetails) {
        ArrayList<SewerageRateDCBResult> rateResultList = new ArrayList<SewerageRateDCBResult>();
        HashMap<String, SewerageRateDCBResult> sewerageReportMap = new HashMap<String, SewerageRateDCBResult>();
        if (sewerageApplicationDetails.getConnection() != null) {
            SewerageRateDCBResult dcbResult = new SewerageRateDCBResult();
            if (sewerageApplicationDetails.getCurrentDemand() != null && sewerageApplicationDetails.getCurrentDemand().getEgDemandDetails() != null) {
                for (EgDemandDetails demandDtl : sewerageApplicationDetails.getCurrentDemand().getEgDemandDetails()) {
                    SewerageRateDCBResult rateResult = (SewerageRateDCBResult)sewerageReportMap.get(demandDtl.getEgDemandReason().getEgInstallmentMaster().getDescription());
                    if (rateResult == null) {
                        if (demandDtl.getAmtCollected() == null) {
                            demandDtl.setAmtCollected(BigDecimal.ZERO);
                        }
                        dcbResult = new SewerageRateDCBResult();
                        dcbResult.setInstallmentYearDescription(demandDtl.getEgDemandReason().getEgInstallmentMaster().getDescription());
                        dcbResult.setInstallmentYearId(demandDtl.getEgDemandReason().getEgInstallmentMaster().getId());
                        if (demandDtl.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("ArrearSewrgeTax")) {
                            dcbResult.setArrearAmount(demandDtl.getAmount().setScale(2, 4));
                            dcbResult.setCollectedArrearAmount(demandDtl.getAmtCollected().setScale(2, 4));
                        } else if (demandDtl.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("SEWERAGETAX")) {
                            dcbResult.setDemandAmount(dcbResult.getDemandAmount().add(demandDtl.getAmount()));
                            dcbResult.setCollectedDemandAmount(dcbResult.getCollectedDemandAmount().add(demandDtl.getAmtCollected()));
                        } else if (demandDtl.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("SEWERAGEADVANCE")) {
                            dcbResult.setAdvanceAmount(demandDtl.getAmount().setScale(2, 4));
                            dcbResult.setCollectedAdvanceAmount(demandDtl.getAmtCollected().setScale(2, 4));
                        }
                        sewerageReportMap.put(demandDtl.getEgDemandReason().getEgInstallmentMaster().getDescription(), dcbResult);
                        continue;
                    }
                    dcbResult = (SewerageRateDCBResult)sewerageReportMap.get(demandDtl.getEgDemandReason().getEgInstallmentMaster().getDescription());
                    if (demandDtl.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("ArrearSewrgeTax")) {
                        dcbResult.setArrearAmount(dcbResult.getArrearAmount().add(demandDtl.getAmount().setScale(2, 4)));
                        dcbResult.setCollectedArrearAmount(dcbResult.getCollectedArrearAmount().add(demandDtl.getAmtCollected().setScale(2, 4)));
                    } else if (demandDtl.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("SEWERAGETAX")) {
                        dcbResult.setDemandAmount(dcbResult.getDemandAmount().add(demandDtl.getAmount().setScale(2, 4)));
                        dcbResult.setCollectedDemandAmount(dcbResult.getCollectedDemandAmount().add(demandDtl.getAmtCollected().setScale(2, 4)));
                    } else if (demandDtl.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("SEWERAGEADVANCE")) {
                        dcbResult.setAdvanceAmount(dcbResult.getAdvanceAmount().add(demandDtl.getAmount().setScale(2, 4)));
                        dcbResult.setCollectedAdvanceAmount(dcbResult.getCollectedAdvanceAmount().add(demandDtl.getAmtCollected().setScale(2, 4)));
                    }
                    sewerageReportMap.put(demandDtl.getEgDemandReason().getEgInstallmentMaster().getDescription(), dcbResult);
                }
            }
            TreeMap<String, Map<String, Map<Date, BigDecimal>>> receiptApplDtlMap = new TreeMap<String, Map<String, Map<Date, BigDecimal>>>();
            for (SewerageApplicationDetails detail : sewerageApplicationDetails.getConnection().getApplicationDetails()) {
                TreeMap receiptMap = new TreeMap();
                if (detail.getCurrentDemand() == null || detail.getCurrentDemand().getEgDemandDetails().isEmpty()) continue;
                for (EgDemandDetails demandDetail : detail.getCurrentDemand().getEgDemandDetails()) {
                    for (EgdmCollectedReceipt receipt : demandDetail.getEgdmCollectedReceipts()) {
                        HashMap<Date, BigDecimal> receiptDtlMap = new HashMap<Date, BigDecimal>();
                        receiptDtlMap.put(receipt.getReceiptDate(), receipt.getAmount().setScale(2, 4));
                        receiptMap.put(receipt.getReceiptNumber(), receiptDtlMap);
                    }
                    if (receiptMap.isEmpty()) continue;
                    receiptApplDtlMap.put(detail.getApplicationNumber(), receiptMap);
                }
            }
            dcbResult.setReceipts(receiptApplDtlMap);
            if (sewerageReportMap.size() > 0) {
                sewerageReportMap.forEach((key, value) -> rateResultList.add((SewerageRateDCBResult)value));
            }
        }
        Collections.sort(rateResultList, new SewerageRateResultComparatorByInstallment());
        return rateResultList;
    }

    public List<DCBReportWardwiseResult> getSewerageRateDCBWardwiseReport(Map<String, List<SewerageApplicationDetails>> applicationDtlMap, String propertyType) {
        ArrayList<DCBReportWardwiseResult> dcbReportList = new ArrayList<DCBReportWardwiseResult>();
        HashMap<String, DCBReportWardwiseResult> dcbReportMap = new HashMap<String, DCBReportWardwiseResult>();
        HashMap<String, DCBReportWardwiseResult> dcbMap = new HashMap<String, DCBReportWardwiseResult>();
        for (Map.Entry<String, List<SewerageApplicationDetails>> entry : applicationDtlMap.entrySet()) {
            Boundary boundary = null;
            ArrayList boundaryList = new ArrayList();
            DCBReportWardwiseResult dcbResult = new DCBReportWardwiseResult();
            for (SewerageApplicationDetails appDetails : entry.getValue()) {
                if (appDetails == null || appDetails.getCurrentDemand() == null || appDetails.getCurrentDemand().getEgDemandDetails() == null) continue;
                dcbResult.setNoofassessments(entry.getValue().size());
                for (EgDemandDetails demandDetails : appDetails.getCurrentDemand().getEgDemandDetails()) {
                    DCBReportWardwiseResult rateResult;
                    dcbResult.setRevenueWard(entry.getKey());
                    if (null != propertyType) {
                        dcbResult.setPropertyType(propertyType);
                    }
                    BoundaryType boundaryType = this.boundaryTypeService.getBoundaryTypeByNameAndHierarchyTypeName("Ward", "REVENUE");
                    boundaryList.addAll(this.boundaryService.getBondariesByNameAndTypeOrderByBoundaryNumAsc(entry.getKey(), boundaryType.getId()));
                    if (!boundaryList.isEmpty()) {
                        boundary = (Boundary)boundaryList.get(0);
                    }
                    if (boundary != null) {
                        dcbResult.setWardId(boundary.getId());
                    }
                    if ((rateResult = (DCBReportWardwiseResult)dcbReportMap.get(entry.getKey())) == null) {
                        dcbResult.setInstallmentYearDescription(demandDetails.getEgDemandReason().getEgInstallmentMaster().getDescription());
                        this.buildArrearAndCurrentDemandTax(dcbResult, demandDetails);
                    } else {
                        dcbResult = (DCBReportWardwiseResult)dcbReportMap.get(entry.getKey());
                        this.buildArrearAndCurrentDemandTax(dcbResult, demandDetails);
                    }
                    dcbResult.setTotal_demand(dcbResult.getArr_demand().add(dcbResult.getCurr_demand()));
                    dcbResult.setTotal_collection(dcbResult.getArr_collection().add(dcbResult.getCurr_collection()));
                    dcbResult.setTotal_balance(dcbResult.getArr_balance().add(dcbResult.getCurr_balance()));
                    dcbReportMap.put(entry.getKey(), dcbResult);
                }
            }
            dcbMap.put(entry.getKey(), dcbResult);
        }
        if (dcbMap.size() > 0) {
            dcbMap.forEach((key, value) -> dcbReportList.add((DCBReportWardwiseResult)value));
        }
        return dcbReportList;
    }

    private void buildArrearAndCurrentDemandTax(DCBReportWardwiseResult dcbResult, EgDemandDetails demandDetails) {
        if (demandDetails.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("ArrearSewrgeTax")) {
            dcbResult.setArr_demand(dcbResult.getArr_demand().add(demandDetails.getAmount().setScale(2, 4)));
            dcbResult.setArr_collection(dcbResult.getArr_collection().add(demandDetails.getAmtCollected().setScale(2, 4)));
            dcbResult.setArr_balance(dcbResult.getArr_balance().add(demandDetails.getAmount().setScale(2, 4).subtract(demandDetails.getAmtCollected().setScale(2, 4))));
        } else if (demandDetails.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("SEWERAGETAX")) {
            dcbResult.setCurr_demand(dcbResult.getCurr_demand().add(demandDetails.getAmount().setScale(2, 4)));
            dcbResult.setCurr_collection(dcbResult.getCurr_collection().add(demandDetails.getAmtCollected().setScale(2, 4)));
            dcbResult.setCurr_balance(dcbResult.getCurr_balance().add(demandDetails.getAmount().subtract(demandDetails.getAmtCollected()).setScale(2, 4)));
        }
    }

    public List<DCBReportWardwiseResult> getSewerageDCBWardConnections(Map<String, List<SewerageApplicationDetails>> applicationDtlMap, String propertyType) {
        ArrayList<DCBReportWardwiseResult> dcbReportList = new ArrayList<DCBReportWardwiseResult>();
        HashMap<String, DCBReportWardwiseResult> dcbReportMap = new HashMap<String, DCBReportWardwiseResult>();
        for (Map.Entry<String, List<SewerageApplicationDetails>> entry : applicationDtlMap.entrySet()) {
            ArrayList applicationList = new ArrayList();
            if (entry.getValue() != null) {
                applicationList.addAll(entry.getValue());
            }
            for (SewerageApplicationDetails detail : applicationList) {
                DCBReportWardwiseResult dcbResult = new DCBReportWardwiseResult();
                if (detail == null || detail.getCurrentDemand() == null || detail.getCurrentDemand().getEgDemandDetails() == null) continue;
                dcbResult.setShscnumber(detail.getConnection().getShscNumber());
                dcbResult.setOwnerName(detail.getOwnerName());
                for (EgDemandDetails demandDetails : detail.getCurrentDemand().getEgDemandDetails()) {
                    DCBReportWardwiseResult rateResult;
                    dcbResult.setApplicationNumber(entry.getKey());
                    if (propertyType != null) {
                        dcbResult.setPropertyType(propertyType);
                    }
                    if ((rateResult = (DCBReportWardwiseResult)dcbReportMap.get(entry.getKey())) == null) {
                        dcbResult.setInstallmentYearDescription(demandDetails.getEgDemandReason().getEgInstallmentMaster().getDescription());
                        this.buildArrearAndCurrentDemandTax(dcbResult, demandDetails);
                        dcbReportMap.put(entry.getKey(), dcbResult);
                        continue;
                    }
                    dcbResult = (DCBReportWardwiseResult)dcbReportMap.get(entry.getKey());
                    if (demandDetails.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("ArrearSewrgeTax")) {
                        dcbResult.setArr_demand(dcbResult.getArr_demand().add(demandDetails.getAmount().setScale(2, 4)));
                        dcbResult.setArr_collection(dcbResult.getArr_collection().add(demandDetails.getAmtCollected()).setScale(2, 4));
                        dcbResult.setArr_balance(dcbResult.getArr_balance().add(demandDetails.getAmount().subtract(demandDetails.getAmtCollected()).setScale(2, 4)));
                    } else if (demandDetails.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("SEWERAGEADVANCE")) {
                        dcbResult.setAdvanceAmount(demandDetails.getAmtCollected().setScale(2, 4));
                    } else if (demandDetails.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("SEWERAGETAX")) {
                        dcbResult.setCurr_demand(dcbResult.getCurr_demand().add(demandDetails.getAmount().setScale(2, 4)));
                        dcbResult.setCurr_collection(dcbResult.getCurr_collection().add(demandDetails.getAmtCollected().setScale(2, 4)));
                        dcbResult.setCurr_balance(dcbResult.getCurr_balance().add(demandDetails.getAmount().subtract(demandDetails.getAmtCollected()).setScale(2, 4)));
                        dcbResult.setTotal_demand(dcbResult.getArr_demand().add(dcbResult.getCurr_demand()));
                        dcbResult.setTotal_collection(dcbResult.getArr_collection().add(dcbResult.getCurr_collection()));
                        dcbResult.setTotal_balance(dcbResult.getArr_balance().add(dcbResult.getCurr_balance()));
                    }
                    dcbReportMap.put(entry.getKey(), dcbResult);
                }
            }
        }
        if (dcbReportMap.size() > 0) {
            dcbReportMap.forEach((key, value) -> dcbReportList.add((DCBReportWardwiseResult)value));
        }
        return dcbReportList;
    }

    @Transactional
    public ReportOutput generateAndSaveDemandBillNotice(SewerageApplicationDetails sewerageApplicationDetails, AssessmentDetails propertyOwnerDetails) {
        SewerageNotice sewerageNotice = null;
        SewerageDemandBillNumberGenerator demandBillNumberGenerator = (SewerageDemandBillNumberGenerator)this.beanResolver.getAutoNumberServiceFor(SewerageDemandBillNumberGenerator.class);
        String demandBillNumber = demandBillNumberGenerator.generateSewerageDemandBillNumber(sewerageApplicationDetails);
        ReportOutput reportOutput = this.generateSewerageDemandBillNotice(sewerageApplicationDetails, demandBillNumber, propertyOwnerDetails);
        if (reportOutput != null && reportOutput.getReportOutputData() != null) {
            ByteArrayInputStream generateNoticePDF = new ByteArrayInputStream(reportOutput.getReportOutputData());
            sewerageNotice = this.sewerageNoticeService.buildDemandBillNotice(sewerageApplicationDetails, generateNoticePDF, demandBillNumber);
        }
        if (sewerageNotice != null) {
            sewerageApplicationDetails.addNotice(sewerageNotice);
            this.sewerageApplicationDetailsService.save(sewerageApplicationDetails);
        }
        return reportOutput;
    }

    public ReportOutput generateSewerageDemandBillNotice(SewerageApplicationDetails sewerageApplicationDetails, String demandBillNumber, AssessmentDetails propertyOwnerDetails) {
        HashMap<String, Object> reportParams = new HashMap<String, Object>();
        BigDecimal sewerageTax = BigDecimal.ZERO;
        Installment currentInstallment = this.installmentDao.getInsatllmentByModuleForGivenDate(this.moduleService.getModuleByName("Sewerage Tax Management"), new Date());
        List<SewerageRateDCBResult> dcbResultList = this.getPendingSewerageTaxForCurrentYearInstallment(sewerageApplicationDetails);
        reportParams.put("demandBillNumber", demandBillNumber);
        SimpleDateFormat date = new SimpleDateFormat("dd/MM/yyyy");
        String fromDate = date.format(currentInstallment.getFromDate());
        reportParams.put("cityLogo", this.cityService.getCityLogoURL());
        reportParams.put("currInstallmentFromDate", fromDate);
        reportParams.put("financialYear", currentInstallment.getFinYearRange());
        reportParams.put("shscnumber", sewerageApplicationDetails.getConnection().getShscNumber());
        reportParams.put("houseno", propertyOwnerDetails.getHouseNo());
        reportParams.put("municipality", this.cityService.getMunicipalityName());
        reportParams.put("district", this.cityService.getDistrictName());
        if (propertyOwnerDetails.getOwnerNames() != null && !propertyOwnerDetails.getOwnerNames().isEmpty()) {
            for (OwnerName propertyOwner : propertyOwnerDetails.getOwnerNames()) {
                reportParams.put("ownername", propertyOwner.getOwnerName());
            }
        }
        if (propertyOwnerDetails.getBoundaryDetails() != null) {
            reportParams.put("localityname", propertyOwnerDetails.getBoundaryDetails().getLocalityName());
            reportParams.put("revenueWardNo", propertyOwnerDetails.getBoundaryDetails().getWardName());
            reportParams.put("blockname", propertyOwnerDetails.getBoundaryDetails().getBlockName());
        }
        SewerageDCBReportResult reportResultList = new SewerageDCBReportResult();
        reportResultList.setDcbReportList(dcbResultList);
        for (SewerageRateDCBResult dcbresultObject : dcbResultList) {
            sewerageTax = sewerageTax.add(dcbresultObject.getDemandAmount());
        }
        reportParams.put("seweragetax", sewerageTax);
        ReportRequest reportInput = new ReportRequest(SEWERAGEDEMANDBILL, (Object)reportResultList, reportParams);
        return this.reportService.createReport(reportInput);
    }

    public List<SewerageRateDCBResult> getPendingSewerageTaxForCurrentYearInstallment(SewerageApplicationDetails sewerageApplicationDetails) {
        ArrayList<SewerageRateDCBResult> rateResultList = new ArrayList<SewerageRateDCBResult>();
        HashMap<String, SewerageRateDCBResult> sewerageReportMap = new HashMap<String, SewerageRateDCBResult>();
        if (sewerageApplicationDetails.getConnection() != null) {
            if (sewerageApplicationDetails.getCurrentDemand() != null && sewerageApplicationDetails.getCurrentDemand().getEgDemandDetails() != null) {
                for (EgDemandDetails demandDtl : sewerageApplicationDetails.getCurrentDemand().getEgDemandDetails()) {
                    SewerageRateDCBResult dcbResult;
                    if (!demandDtl.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("SEWERAGETAX") || demandDtl.getAmount().subtract(demandDtl.getAmtCollected()).compareTo(BigDecimal.ZERO) <= 0) continue;
                    SewerageRateDCBResult rateResult = (SewerageRateDCBResult)sewerageReportMap.get(demandDtl.getEgDemandReason().getEgInstallmentMaster().getDescription());
                    if (rateResult == null) {
                        dcbResult = new SewerageRateDCBResult();
                        dcbResult.setInstallmentYearDescription(demandDtl.getEgDemandReason().getEgInstallmentMaster().getDescription());
                        dcbResult.setDemandAmount(dcbResult.getDemandAmount().add(demandDtl.getAmount().subtract(demandDtl.getAmtCollected())));
                        sewerageReportMap.put(demandDtl.getEgDemandReason().getEgInstallmentMaster().getDescription(), dcbResult);
                        continue;
                    }
                    dcbResult = (SewerageRateDCBResult)sewerageReportMap.get(demandDtl.getEgDemandReason().getEgInstallmentMaster().getDescription());
                    dcbResult.setDemandAmount(dcbResult.getDemandAmount().add(demandDtl.getAmount().subtract(demandDtl.getAmtCollected())));
                    sewerageReportMap.put(demandDtl.getEgDemandReason().getEgInstallmentMaster().getDescription(), dcbResult);
                }
            }
            if (sewerageReportMap.size() > 0) {
                sewerageReportMap.forEach((key, value) -> rateResultList.add((SewerageRateDCBResult)value));
            }
        }
        return rateResultList;
    }
}

