/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.transactions.service;

import java.math.BigDecimal;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.notification.service.NotificationService;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.OwnerName;
import org.egov.stms.transactions.entity.SewerageApplicationDetails;
import org.egov.stms.transactions.entity.SewerageConnectionFee;
import org.egov.stms.transactions.service.SewerageApplicationDetailsService;
import org.egov.stms.transactions.service.SewerageThirdPartyServices;
import org.egov.stms.utils.SewerageTaxUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Scope;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class SewerageConnectionSmsAndEmailService {
    private String muncipalityName;
    @Autowired
    @Qualifier(value="parentMessageSource")
    private MessageSource stmsMessageSource;
    @Autowired
    private SewerageTaxUtils sewerageTaxUtils;
    @Autowired
    private SewerageThirdPartyServices sewerageThirdPartyServices;
    @Autowired
    private NotificationService notificationService;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private SewerageApplicationDetailsService sewerageApplicationDetailsService;

    public void sendSmsAndEmail(SewerageApplicationDetails sewerageApplicationDetails, HttpServletRequest request) {
        AssessmentDetails assessmentDetails = this.sewerageThirdPartyServices.getPropertyDetails(sewerageApplicationDetails.getConnectionDetail().getPropertyIdentifier(), request);
        String email = assessmentDetails.getPrimaryEmail();
        String mobileNumber = assessmentDetails.getPrimaryMobileNo();
        this.muncipalityName = this.sewerageTaxUtils.getMunicipalityName();
        if (sewerageApplicationDetails != null && sewerageApplicationDetails.getApplicationType() != null && sewerageApplicationDetails.getApplicationType().getCode() != null && sewerageApplicationDetails.getStatus() != null && sewerageApplicationDetails.getStatus().getCode() != null) {
            for (OwnerName owner : assessmentDetails.getOwnerNames()) {
                String applicantName = owner.getOwnerName();
                if (assessmentDetails.getPrimaryEmail() != null || assessmentDetails.getPrimaryMobileNo() != null) {
                    if ("NEWSEWERAGECONNECTION".equalsIgnoreCase(sewerageApplicationDetails.getApplicationType().getCode())) {
                        this.getSmsAndEmailForNewConnection(sewerageApplicationDetails, email, mobileNumber, applicantName);
                        continue;
                    }
                    if ("CHANGEINCLOSETS".equalsIgnoreCase(sewerageApplicationDetails.getApplicationType().getCode())) {
                        this.getSmsAndEmailForChangeInClosets(sewerageApplicationDetails, email, mobileNumber, applicantName);
                        continue;
                    }
                    if (!"CLOSESEWERAGECONNECTION".equalsIgnoreCase(sewerageApplicationDetails.getApplicationType().getCode())) continue;
                    this.getSmsAndEmailForCloseConnection(sewerageApplicationDetails, email, mobileNumber, applicantName);
                    continue;
                }
                String emailId = owner.getEmailId();
                String mobileNo = owner.getMobileNumber();
                if (emailId == null && mobileNo == null) continue;
                if ("NEWSEWERAGECONNECTION".equalsIgnoreCase(sewerageApplicationDetails.getApplicationType().getCode())) {
                    this.getSmsAndEmailForNewConnection(sewerageApplicationDetails, emailId, mobileNo, applicantName);
                    continue;
                }
                if ("CHANGEINCLOSETS".equalsIgnoreCase(sewerageApplicationDetails.getApplicationType().getCode())) {
                    this.getSmsAndEmailForChangeInClosets(sewerageApplicationDetails, emailId, mobileNo, applicantName);
                    continue;
                }
                if (!"CLOSESEWERAGECONNECTION".equalsIgnoreCase(sewerageApplicationDetails.getApplicationType().getCode())) continue;
                this.getSmsAndEmailForCloseConnection(sewerageApplicationDetails, emailId, mobileNo, applicantName);
            }
        }
    }

    public void getSmsAndEmailForNewConnection(SewerageApplicationDetails sewerageApplicationDetails, String email, String mobileNumber, String applicantName) {
        String smsMsg = "";
        String body = "";
        String subject = "";
        if ("COLLECTINSPECTIONFEE".equalsIgnoreCase(sewerageApplicationDetails.getStatus().getCode()) || "CREATED".equalsIgnoreCase(sewerageApplicationDetails.getStatus().getCode())) {
            if (this.sewerageTaxUtils.isInspectionFeeCollectionRequired()) {
                smsMsg = this.SmsBodyByCodeAndArgsWithType("msg.newconnectioncreate.sms", sewerageApplicationDetails, applicantName, "newconnectioncreate");
                body = this.EmailBodyByCodeAndArgsWithType("msg.newconnectioncreate.email.body", sewerageApplicationDetails, applicantName, "newconnectioncreate");
                subject = this.emailSubjectforEmailByCodeAndArgs("msg.newconnectioncreate.email.subject", sewerageApplicationDetails.getApplicationNumber());
            } else {
                smsMsg = this.SmsBodyByCodeAndArgsWithType("msg.newconnectioncreateForNoInsFee.sms", sewerageApplicationDetails, applicantName, "newconnectioncreatefornoinsfee");
                body = this.EmailBodyByCodeAndArgsWithType("msg.newconnectioncreateForNoInsFee.email.body", sewerageApplicationDetails, applicantName, "newconnectioncreatefornoinsfee");
                subject = this.emailSubjectforEmailByCodeAndArgs("msg.newconnectioncreateForNoInsFee.email.subject", sewerageApplicationDetails.getApplicationNumber());
            }
        }
        if ("DEEAPPROVED".equalsIgnoreCase(sewerageApplicationDetails.getStatus().getCode())) {
            smsMsg = this.SmsBodyByCodeAndArgsWithType("msg.newconnectiondeeapproval.sms", sewerageApplicationDetails, applicantName, "newconnectiondeeapprove");
            body = this.EmailBodyByCodeAndArgsWithType("msg.newconnectiondeeapproval.email.body", sewerageApplicationDetails, applicantName, "newconnectiondeeapprove");
            subject = this.emailSubjectforEmailByCodeAndArgs("msg.newconnectiondeeapproval.email.subject", sewerageApplicationDetails.getApplicationNumber());
        } else if ("ESTIMATIONAMOUNTPAID".equalsIgnoreCase(sewerageApplicationDetails.getStatus().getCode())) {
            smsMsg = this.SmsBodyByCodeAndArgsWithType("msg.newconnectionOnDemandAndDonation.sms", sewerageApplicationDetails, applicantName, "newconnectionfeepaid");
            body = this.EmailBodyByCodeAndArgsWithType("msg.newconnectionOnDemandAndDonation.email.body", sewerageApplicationDetails, applicantName, "newconnectionfeepaid");
            subject = this.emailSubjectforEmailByCodeAndArgs("msg.newconnectionOnDemandAndDonation.email.subject", sewerageApplicationDetails.getApplicationNumber());
        } else if ("FINALAPPROVED".equalsIgnoreCase(sewerageApplicationDetails.getStatus().getCode())) {
            smsMsg = this.SmsBodyByCodeAndArgsWithType("msg.newsewerageconnectionapprove.sms", sewerageApplicationDetails, applicantName, "newconnectionfinalapprove");
            body = this.EmailBodyByCodeAndArgsWithType("msg.newsewerageconnectionapprove.email.body", sewerageApplicationDetails, applicantName, "newconnectionfinalapprove");
            subject = this.emailSubjectforEmailByCodeAndArgs("msg.newsewerageconnectionapprove.email.subject", sewerageApplicationDetails.getApplicationNumber());
        } else if ("REJECTED".equalsIgnoreCase(sewerageApplicationDetails.getStatus().getCode())) {
            smsMsg = this.SmsBodyByCodeAndArgsWithType("msg.newconnectionRejection.sms", sewerageApplicationDetails, applicantName, "newconnectionreject");
            body = this.EmailBodyByCodeAndArgsWithType("msg.newconnectionrejection.email.body", sewerageApplicationDetails, applicantName, "newconnectionreject");
            subject = this.emailSubjectforEmailByCodeAndArgs("msg.newconnectionrejection.email.subject", sewerageApplicationDetails.getApplicationNumber());
        }
        if (mobileNumber != null && StringUtils.isNotBlank((CharSequence)smsMsg)) {
            this.sendSMSOnSewerageConnection(mobileNumber, smsMsg);
        }
        if (email != null && StringUtils.isNotBlank((CharSequence)body)) {
            this.sendEmailOnSewerageConnection(email, body, subject);
        }
    }

    public void getSmsAndEmailForChangeInClosets(SewerageApplicationDetails sewerageApplicationDetails, String email, String mobileNumber, String applicantName) {
        String smsMsg = "";
        String body = "";
        String subject = "";
        if ("COLLECTINSPECTIONFEE".equalsIgnoreCase(sewerageApplicationDetails.getStatus().getCode()) || "CREATED".equalsIgnoreCase(sewerageApplicationDetails.getStatus().getCode())) {
            if (this.sewerageTaxUtils.isInspectionFeeCollectionRequired()) {
                smsMsg = this.SmsBodyByCodeAndArgsWithType("msg.changeincloset.sms", sewerageApplicationDetails, applicantName, "changeinclosetsofconnectionupdate");
                body = this.EmailBodyByCodeAndArgsWithType("msg.changeincloset.email.body", sewerageApplicationDetails, applicantName, "changeinclosetsofconnectionupdate");
                subject = this.emailSubjectforEmailByCodeAndArgs("msg.changeincloset.email.subject", sewerageApplicationDetails.getConnection().getShscNumber());
            } else {
                smsMsg = this.SmsBodyByCodeAndArgsWithType("msg.changeinclosetForNoInsFee.sms", sewerageApplicationDetails, applicantName, "changeinclosetsofconnectionupdatefornoinsfee");
                body = this.EmailBodyByCodeAndArgsWithType("msg.changeinclosetForNoInsFee.email.body", sewerageApplicationDetails, applicantName, "changeinclosetsofconnectionupdatefornoinsfee");
                subject = this.emailSubjectforEmailByCodeAndArgs("msg.changeinclosetForNoInsFee.email.subject", sewerageApplicationDetails.getConnection().getShscNumber());
            }
        }
        if ("DEEAPPROVED".equalsIgnoreCase(sewerageApplicationDetails.getStatus().getCode())) {
            smsMsg = this.SmsBodyByCodeAndArgsWithType("msg.changeinclosetdeeapproval.sms", sewerageApplicationDetails, applicantName, "changeinclosetsofconnectiondeeapprove");
            body = this.EmailBodyByCodeAndArgsWithType("msg.changeinclosetdeeapproval.email.body", sewerageApplicationDetails, applicantName, "changeinclosetsofconnectiondeeapprove");
            subject = this.emailSubjectforEmailByCodeAndArgs("msg.changeinclosetdeeapproval.email.subject", sewerageApplicationDetails.getConnection().getShscNumber());
        } else if ("ESTIMATIONAMOUNTPAID".equalsIgnoreCase(sewerageApplicationDetails.getStatus().getCode())) {
            smsMsg = this.SmsBodyByCodeAndArgsWithType("msg.changeinclosetOnDemandAndDonation.sms", sewerageApplicationDetails, applicantName, "changeinclosetsofconnectionfeepaid");
            body = this.EmailBodyByCodeAndArgsWithType("msg.changeinclosetOnDemandAndDonation.email.body", sewerageApplicationDetails, applicantName, "changeinclosetsofconnectionfeepaid");
            subject = this.emailSubjectforEmailByCodeAndArgs("msg.changeinclosetOnDemandAndDonation.email.subject", sewerageApplicationDetails.getConnection().getShscNumber());
        } else if ("FINALAPPROVED".equalsIgnoreCase(sewerageApplicationDetails.getStatus().getCode())) {
            smsMsg = this.SmsBodyByCodeAndArgsWithType("msg.changeinclosetapproval.sms", sewerageApplicationDetails, applicantName, "changeinclosetsofconnectionfinalapprove");
            body = this.EmailBodyByCodeAndArgsWithType("msg.changeinclosetapproval.email.body", sewerageApplicationDetails, applicantName, "changeinclosetsofconnectionfinalapprove");
            subject = this.emailSubjectforEmailByCodeAndArgs("msg.changeinclosetapproval.email.subject", sewerageApplicationDetails.getConnection().getShscNumber());
        } else if ("REJECTED".equalsIgnoreCase(sewerageApplicationDetails.getStatus().getCode())) {
            smsMsg = this.SmsBodyByCodeAndArgsWithType("msg.changeinclosetRejection.sms", sewerageApplicationDetails, applicantName, "changeinclosetsofconnectionreject");
            body = this.EmailBodyByCodeAndArgsWithType("msg.changeinclosetrejection.email.body", sewerageApplicationDetails, applicantName, "changeinclosetsofconnectionreject");
            subject = this.emailSubjectforEmailByCodeAndArgs("msg.changeinclosetrejection.email.subject", sewerageApplicationDetails.getConnection().getShscNumber());
        }
        if (mobileNumber != null && StringUtils.isNotBlank((CharSequence)smsMsg)) {
            this.sendSMSOnSewerageConnection(mobileNumber, smsMsg);
        }
        if (email != null && StringUtils.isNotBlank((CharSequence)body)) {
            this.sendEmailOnSewerageConnection(email, body, subject);
        }
    }

    public void getSmsAndEmailForCloseConnection(SewerageApplicationDetails sewerageApplicationDetails, String email, String mobileNumber, String applicantName) {
        String smsMsg = "";
        String body = "";
        String subject = "";
        if ("CREATED".equalsIgnoreCase(sewerageApplicationDetails.getStatus().getCode())) {
            smsMsg = this.SmsBodyByCodeAndArgsWithType("msg.closeofconnectioncreated.sms", sewerageApplicationDetails, applicantName, "closesewerageconnectioncreate");
            body = this.EmailBodyByCodeAndArgsWithType("msg.closeofconnectioncreated.email.body", sewerageApplicationDetails, applicantName, "closesewerageconnectioncreate");
            subject = this.emailSubjectforEmailByCodeAndArgs("msg.closeofconnectioncreated.email.subject", sewerageApplicationDetails.getConnection().getShscNumber());
        } else if ("CLOSERSANCTIONED".equalsIgnoreCase(sewerageApplicationDetails.getStatus().getCode())) {
            smsMsg = this.SmsBodyByCodeAndArgsWithType("msg.closeofconnectioneeapproval.sms", sewerageApplicationDetails, applicantName, "closesewerageconnectioneeapprove");
            body = this.EmailBodyByCodeAndArgsWithType("msg.closeofconnectioneeapproval.email.body", sewerageApplicationDetails, applicantName, "closesewerageconnectioneeapprove");
            subject = this.emailSubjectforEmailByCodeAndArgs("msg.closeofconnectioneeapproval.email.subject", sewerageApplicationDetails.getConnection().getShscNumber());
        } else if ("REJECTED".equalsIgnoreCase(sewerageApplicationDetails.getStatus().getCode())) {
            smsMsg = this.SmsBodyByCodeAndArgsWithType("msg.closeofconnectionrejection.sms", sewerageApplicationDetails, applicantName, "closesewerageconnectionreject");
            body = this.EmailBodyByCodeAndArgsWithType("msg.closeofconnectionrejection.email.body", sewerageApplicationDetails, applicantName, "closesewerageconnectionreject");
            subject = this.emailSubjectforEmailByCodeAndArgs("msg.closeofconnectionrejection.email.subject", sewerageApplicationDetails.getConnection().getShscNumber());
        }
        if (mobileNumber != null && StringUtils.isNotBlank((CharSequence)smsMsg)) {
            this.sendSMSOnSewerageConnection(mobileNumber, smsMsg);
        }
        if (email != null && StringUtils.isNotBlank((CharSequence)body)) {
            this.sendEmailOnSewerageConnection(email, body, subject);
        }
    }

    public String smsAndEmailBodyByCodeAndArgs(String code, SewerageApplicationDetails sewerageApplicationDetails, String applicantName) {
        return this.stmsMessageSource.getMessage(code, (Object[])new String[]{applicantName, sewerageApplicationDetails.getApplicationNumber(), this.muncipalityName}, null);
    }

    public String EmailBodyByCodeAndArgsWithType(String code, SewerageApplicationDetails sewerageApplicationDetails, String applicantName, String type) {
        String emailBody = "";
        String emailPdfLink = this.getNoticePdfLink(sewerageApplicationDetails);
        if (type.equalsIgnoreCase("newconnectioncreate") || type.equalsIgnoreCase("changeinclosetsofconnectionupdate") || type.equalsIgnoreCase("closesewerageconnectioncreate")) {
            emailBody = this.stmsMessageSource.getMessage(code, (Object[])new String[]{applicantName, sewerageApplicationDetails.getApplicationNumber(), this.muncipalityName, String.valueOf(this.getInspectionFeeForSewerage(sewerageApplicationDetails)), sewerageApplicationDetails.getConnection().getShscNumber()}, null);
        } else if (type.equalsIgnoreCase("newconnectioncreatefornoinsfee") || type.equalsIgnoreCase("changeinclosetsofconnectionupdatefornoinsfee")) {
            emailBody = this.stmsMessageSource.getMessage(code, (Object[])new String[]{applicantName, sewerageApplicationDetails.getApplicationNumber(), this.muncipalityName, sewerageApplicationDetails.getConnection().getShscNumber()}, null);
        } else if (type.equalsIgnoreCase("newconnectiondeeapprove")) {
            emailBody = this.stmsMessageSource.getMessage(code, (Object[])new String[]{applicantName, sewerageApplicationDetails.getApplicationNumber(), String.valueOf(this.sumOfSewerageApplnCharges(sewerageApplicationDetails)), this.muncipalityName, sewerageApplicationDetails.getConnection().getShscNumber()}, null);
        } else if (type.equalsIgnoreCase("changeinclosetsofconnectiondeeapprove")) {
            emailBody = this.stmsMessageSource.getMessage(code, (Object[])new String[]{applicantName, sewerageApplicationDetails.getApplicationNumber(), String.valueOf(this.sumOfChangeClosetSewerageApplnCharges(sewerageApplicationDetails)), this.muncipalityName, sewerageApplicationDetails.getConnection().getShscNumber()}, null);
        } else if (type.equalsIgnoreCase("closesewerageconnectioneeapprove")) {
            emailBody = this.stmsMessageSource.getMessage(code, (Object[])new String[]{applicantName, sewerageApplicationDetails.getApplicationNumber(), this.muncipalityName, sewerageApplicationDetails.getConnection().getShscNumber(), emailPdfLink}, null);
        } else if (type.equalsIgnoreCase("newconnectionfeepaid") || type.equalsIgnoreCase("changeinclosetsofconnectionfeepaid")) {
            emailBody = this.stmsMessageSource.getMessage(code, (Object[])new String[]{applicantName, String.valueOf(this.sumOfSewerageApplnCharges(sewerageApplicationDetails)), sewerageApplicationDetails.getApplicationNumber(), this.muncipalityName, sewerageApplicationDetails.getConnection().getShscNumber()}, null);
        } else if (type.equalsIgnoreCase("newconnectionfinalapprove") || type.equalsIgnoreCase("changeinclosetsofconnectionfinalapprove")) {
            emailBody = this.stmsMessageSource.getMessage(code, (Object[])new String[]{applicantName, sewerageApplicationDetails.getApplicationNumber(), this.muncipalityName, sewerageApplicationDetails.getConnection().getShscNumber(), emailPdfLink}, null);
        } else if ("closureofconnectionapprove".equalsIgnoreCase(type)) {
            emailBody = this.stmsMessageSource.getMessage(code, (Object[])new String[]{applicantName, sewerageApplicationDetails.getApplicationNumber(), this.muncipalityName}, null);
        } else if ("closureofconnectionsanctioned".equalsIgnoreCase(type) || type.equalsIgnoreCase("changeinclosetsofconnectionsanctioned")) {
            emailBody = this.stmsMessageSource.getMessage(code, (Object[])new String[]{applicantName, sewerageApplicationDetails.getApplicationNumber(), this.muncipalityName, sewerageApplicationDetails.getConnection().getShscNumber()}, null);
        } else if ("newconnectionreject".equalsIgnoreCase(type) || type.equalsIgnoreCase("changeinclosetsofconnectionreject") || type.equalsIgnoreCase("closesewerageconnectionreject")) {
            emailBody = this.stmsMessageSource.getMessage(code, (Object[])new String[]{applicantName, sewerageApplicationDetails.getApprovalComent(), this.muncipalityName, sewerageApplicationDetails.getApplicationNumber(), sewerageApplicationDetails.getConnection().getShscNumber()}, null);
        }
        return emailBody;
    }

    private String getNoticePdfLink(SewerageApplicationDetails sewerageApplicationDetails) {
        String noticePdfLink = "";
        if (null != sewerageApplicationDetails.getApplicationNumber()) {
            noticePdfLink = "CLOSESEWERAGECONNECTION".equalsIgnoreCase(sewerageApplicationDetails.getApplicationType().getCode()) ? ApplicationThreadLocals.getDomainURL() + "/stms/transactions/viewcloseconnectionnotice/" + sewerageApplicationDetails.getApplicationNumber() + "?closureNoticeNumber=" + sewerageApplicationDetails.getClosureNoticeNumber() : ApplicationThreadLocals.getDomainURL() + "/stms/transactions/workordernotice?pathVar=" + sewerageApplicationDetails.getApplicationNumber();
        }
        return noticePdfLink;
    }

    public BigDecimal sumOfSewerageApplnCharges(SewerageApplicationDetails sewerageApplicationDetails) {
        BigDecimal totalAmt = BigDecimal.ZERO;
        for (SewerageConnectionFee sewerageConnFee : sewerageApplicationDetails.getConnectionFees()) {
            if (sewerageConnFee.getFeesDetail().getDescription().equals("Inspection Charges")) continue;
            totalAmt = totalAmt.add(BigDecimal.valueOf(sewerageConnFee.getAmount()));
        }
        return totalAmt;
    }

    public BigDecimal sumOfChangeClosetSewerageApplnCharges(SewerageApplicationDetails sewerageApplicationDetails) {
        BigDecimal totalAmt = BigDecimal.ZERO;
        BigDecimal oldDonationCharge = BigDecimal.ZERO;
        BigDecimal oldSewerageTax = BigDecimal.ZERO;
        BigDecimal currentDonationCharge = BigDecimal.ZERO;
        BigDecimal currentSewerageTax = BigDecimal.ZERO;
        BigDecimal currentEstimationCharges = BigDecimal.ZERO;
        BigDecimal totalDonationCharge = BigDecimal.ZERO;
        BigDecimal totalSewerageTax = BigDecimal.ZERO;
        if (sewerageApplicationDetails.getCurrentDemand() != null) {
            SewerageApplicationDetails oldApplicationDtl = this.sewerageApplicationDetailsService.findByConnection_ShscNumberAndIsActive(sewerageApplicationDetails.getConnection().getShscNumber());
            if (oldApplicationDtl != null) {
                for (SewerageConnectionFee oldSewerageConnectionFee : oldApplicationDtl.getConnectionFees()) {
                    if (oldSewerageConnectionFee.getFeesDetail().getCode().equalsIgnoreCase("SEWERAGETAX")) {
                        oldSewerageTax = oldSewerageTax.add(BigDecimal.valueOf(oldSewerageConnectionFee.getAmount()));
                    }
                    if (!oldSewerageConnectionFee.getFeesDetail().getCode().equalsIgnoreCase("DONATIONCHARGE")) continue;
                    oldDonationCharge = oldDonationCharge.add(BigDecimal.valueOf(oldSewerageConnectionFee.getAmount()));
                }
            }
            for (SewerageConnectionFee scf : sewerageApplicationDetails.getConnectionFees()) {
                if (scf.getFeesDetail().getCode().equalsIgnoreCase("SEWERAGETAX")) {
                    currentSewerageTax = currentSewerageTax.add(BigDecimal.valueOf(scf.getAmount()));
                }
                if (scf.getFeesDetail().getCode().equalsIgnoreCase("DONATIONCHARGE")) {
                    currentDonationCharge = currentDonationCharge.add(BigDecimal.valueOf(scf.getAmount()));
                }
                if (!scf.getFeesDetail().getCode().equalsIgnoreCase("ESTIMATIONCHARGE")) continue;
                currentEstimationCharges = BigDecimal.valueOf(scf.getAmount());
            }
            if (currentDonationCharge.compareTo(oldDonationCharge) > 0) {
                totalDonationCharge = currentDonationCharge.subtract(oldDonationCharge);
            }
            if (currentSewerageTax.compareTo(oldSewerageTax) > 0) {
                totalSewerageTax = currentSewerageTax.subtract(oldSewerageTax);
            }
            totalAmt = totalSewerageTax.add(totalDonationCharge).add(currentEstimationCharges);
        }
        return totalAmt;
    }

    public BigDecimal getInspectionFeeForSewerage(SewerageApplicationDetails sewerageApplicationDetails) {
        BigDecimal totalAmt = BigDecimal.ZERO;
        for (SewerageConnectionFee sewerageConnFee : sewerageApplicationDetails.getConnectionFees()) {
            if (!sewerageConnFee.getFeesDetail().getDescription().equals("Inspection Charges")) continue;
            totalAmt = totalAmt.add(BigDecimal.valueOf(sewerageConnFee.getAmount()));
        }
        return totalAmt;
    }

    public String SmsBodyByCodeAndArgsWithType(String code, SewerageApplicationDetails sewerageApplicationDetails, String applicantName, String type) {
        String smsMsg = "";
        String pdfLink = this.getNoticePdfLink(sewerageApplicationDetails);
        if (type.equalsIgnoreCase("newconnectioncreate") || type.equalsIgnoreCase("changeinclosetsofconnectionupdate") || type.equalsIgnoreCase("closesewerageconnectioncreate")) {
            smsMsg = this.stmsMessageSource.getMessage(code, (Object[])new String[]{applicantName, sewerageApplicationDetails.getApplicationNumber(), this.muncipalityName, String.valueOf(this.getInspectionFeeForSewerage(sewerageApplicationDetails)), sewerageApplicationDetails.getConnection().getShscNumber()}, null);
        } else if (type.equalsIgnoreCase("newconnectioncreatefornoinsfee") || type.equalsIgnoreCase("changeinclosetsofconnectionupdatefornoinsfee")) {
            smsMsg = this.stmsMessageSource.getMessage(code, (Object[])new String[]{applicantName, sewerageApplicationDetails.getApplicationNumber(), this.muncipalityName, sewerageApplicationDetails.getConnection().getShscNumber()}, null);
        }
        if (type.equalsIgnoreCase("newconnectiondeeapprove")) {
            smsMsg = this.stmsMessageSource.getMessage(code, (Object[])new String[]{applicantName, sewerageApplicationDetails.getApplicationNumber(), String.valueOf(this.sumOfSewerageApplnCharges(sewerageApplicationDetails)), this.muncipalityName, sewerageApplicationDetails.getConnection().getShscNumber()}, null);
        } else if (type.equalsIgnoreCase("changeinclosetsofconnectiondeeapprove")) {
            smsMsg = this.stmsMessageSource.getMessage(code, (Object[])new String[]{applicantName, sewerageApplicationDetails.getApplicationNumber(), String.valueOf(this.sumOfChangeClosetSewerageApplnCharges(sewerageApplicationDetails)), this.muncipalityName, sewerageApplicationDetails.getConnection().getShscNumber()}, null);
        } else if (type.equalsIgnoreCase("closesewerageconnectioneeapprove")) {
            smsMsg = this.stmsMessageSource.getMessage(code, (Object[])new String[]{applicantName, sewerageApplicationDetails.getApplicationNumber(), this.muncipalityName, sewerageApplicationDetails.getConnection().getShscNumber(), pdfLink}, null);
        } else if (type.equalsIgnoreCase("newconnectionfeepaid") || type.equalsIgnoreCase("changeinclosetsofconnectionfeepaid")) {
            smsMsg = this.stmsMessageSource.getMessage(code, (Object[])new String[]{applicantName, String.valueOf(this.sumOfSewerageApplnCharges(sewerageApplicationDetails)), sewerageApplicationDetails.getApplicationNumber(), this.muncipalityName, sewerageApplicationDetails.getConnection().getShscNumber()}, null);
        } else if ("closureofconnectionapprove".equalsIgnoreCase(type)) {
            smsMsg = this.stmsMessageSource.getMessage(code, (Object[])new String[]{applicantName, sewerageApplicationDetails.getApplicationNumber(), this.muncipalityName, sewerageApplicationDetails.getConnection().getShscNumber()}, null);
        } else if (type.equalsIgnoreCase("newconnectionfinalapprove") || type.equalsIgnoreCase("changeinclosetsofconnectionfinalapprove")) {
            smsMsg = this.stmsMessageSource.getMessage(code, (Object[])new String[]{applicantName, sewerageApplicationDetails.getApplicationNumber(), this.muncipalityName, sewerageApplicationDetails.getConnection().getShscNumber(), pdfLink}, null);
        } else if ("closureofconnectionsanctioned".equalsIgnoreCase(type) || type.equalsIgnoreCase("changeinclosetsofconnectionsanctioned")) {
            smsMsg = this.stmsMessageSource.getMessage(code, (Object[])new String[]{applicantName, sewerageApplicationDetails.getApplicationNumber(), this.muncipalityName, sewerageApplicationDetails.getConnection().getShscNumber()}, null);
        } else if ("newconnectionreject".equalsIgnoreCase(type) || type.equalsIgnoreCase("changeinclosetsofconnectionreject") || type.equalsIgnoreCase("closesewerageconnectionreject")) {
            smsMsg = this.stmsMessageSource.getMessage(code, (Object[])new String[]{applicantName, sewerageApplicationDetails.getApprovalComent(), this.muncipalityName, sewerageApplicationDetails.getApplicationNumber(), sewerageApplicationDetails.getConnection().getShscNumber()}, null);
        }
        return smsMsg;
    }

    public Boolean isSmsEnabled() {
        AppConfigValues appConfigValue = (AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey("Sewerage Tax Management", "SENDSMSFORSEWERAGETAX").get(0);
        return "YES".equalsIgnoreCase(appConfigValue.getValue());
    }

    public Boolean isEmailEnabled() {
        AppConfigValues appConfigValue = (AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey("Sewerage Tax Management", "SENDEMAILFORSEWERAGETAX").get(0);
        return "YES".equalsIgnoreCase(appConfigValue.getValue());
    }

    public String smsAndEmailBodyByCodeAndArgsForRejection(String code, String approvalComment, String applicantName) {
        Locale locale = LocaleContextHolder.getLocale();
        return this.stmsMessageSource.getMessage(code, (Object[])new String[]{applicantName, approvalComment, this.muncipalityName}, locale);
    }

    public String emailBodyforApprovalEmailByCodeAndArgs(String code, SewerageApplicationDetails sewerageApplicationDetails, String applicantName) {
        Locale locale = LocaleContextHolder.getLocale();
        return this.stmsMessageSource.getMessage(code, (Object[])new String[]{applicantName, sewerageApplicationDetails.getApplicationNumber(), sewerageApplicationDetails.getConnection().getShscNumber(), this.muncipalityName}, locale);
    }

    public String emailSubjectforEmailByCodeAndArgs(String code, String applicationNumber) {
        Locale locale = LocaleContextHolder.getLocale();
        return this.stmsMessageSource.getMessage(code, (Object[])new String[]{applicationNumber}, locale);
    }

    public void sendSMSOnSewerageConnection(String mobileNumber, String smsBody) {
        this.notificationService.sendSMS(mobileNumber, smsBody);
    }

    public void sendEmailOnSewerageConnection(String email, String emailBody, String emailSubject) {
        this.notificationService.sendEmail(email, emailSubject, emailBody);
    }
}

