/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.transactions.service;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.egov.commons.Installment;
import org.egov.commons.entity.Source;
import org.egov.demand.model.EgDemand;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.EisCommonService;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.elasticsearch.entity.ApplicationIndex;
import org.egov.infra.elasticsearch.entity.enums.ApprovalStatus;
import org.egov.infra.elasticsearch.entity.enums.ClosureStatus;
import org.egov.infra.elasticsearch.service.ApplicationIndexService;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.utils.autonumber.AutonumberServiceBeanResolver;
import org.egov.infra.workflow.entity.State;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.pims.commons.Position;
import org.egov.portal.entity.PortalInbox;
import org.egov.portal.entity.PortalInboxBuilder;
import org.egov.portal.service.PortalInboxService;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.OwnerName;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.stms.autonumber.SewerageApplicationNumberGenerator;
import org.egov.stms.autonumber.SewerageCloseConnectionNoticeNumberGenerator;
import org.egov.stms.autonumber.SewerageEstimationNumberGenerator;
import org.egov.stms.autonumber.SewerageRejectionNoticeNumberGenerator;
import org.egov.stms.autonumber.SewerageSHSCNumberGenerator;
import org.egov.stms.autonumber.SewerageWorkOrderNumberGenerator;
import org.egov.stms.masters.entity.enums.SewerageConnectionStatus;
import org.egov.stms.masters.service.DocumentTypeMasterService;
import org.egov.stms.notice.entity.SewerageNotice;
import org.egov.stms.notice.service.SewerageNoticeService;
import org.egov.stms.service.es.SewerageIndexService;
import org.egov.stms.transactions.entity.SewerageApplicationDetails;
import org.egov.stms.transactions.entity.SewerageApplicationDetailsDocument;
import org.egov.stms.transactions.entity.SewerageConnection;
import org.egov.stms.transactions.entity.SewerageConnectionFee;
import org.egov.stms.transactions.entity.SewerageDemandConnection;
import org.egov.stms.transactions.entity.SewerageDemandDetail;
import org.egov.stms.transactions.repository.SewerageApplicationDetailsRepository;
import org.egov.stms.transactions.service.SewerageConnectionSmsAndEmailService;
import org.egov.stms.transactions.service.SewerageDemandService;
import org.egov.stms.transactions.service.SewerageWorkflowService;
import org.egov.stms.transactions.workflow.ApplicationWorkflowCustomDefaultImpl;
import org.egov.stms.utils.SewerageTaxUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional(readOnly=true)
public class SewerageApplicationDetailsService {
    private static final String ELECTION_WARD = "electionWard";
    private static final String APPLICATION_CENTRE = "ApplicationCentre";
    private static final String DUE_DATE = "dueDate";
    private static final String ADDRESS = "address";
    private static final String CURRENT_DATE = "currentDate";
    private static final String ACKNOWLEDGEMENT_NO = "acknowledgementNo";
    private static final String APPLICANT_NAME = "applicantName";
    private static final String ZONE_NAME = "zoneName";
    private static final String CITYNAME = "cityname";
    private static final String MUNICIPALITY = "municipality";
    private static final String OFFICE_S_COPY = "Office's Copy";
    private static final String PARTY_S_COPY = "Party's Copy";
    private static final String APP_TYPE = "appType";
    private static final Logger LOG = LoggerFactory.getLogger(SewerageApplicationDetailsService.class);
    private static final String STMS_APPLICATION_VIEW = "/stms/existing/sewerage/view/%s/%s";
    private static final String STMS_APPLICATION_UPDATE = "/stms/transactions/citizenupdate/%s";
    private static final String APPLICATION_WORKFLOW_INITIALIZATION_DONE = "applicationWorkflowCustomDefaultImpl initialization is done";
    private static final String DEPARTMENT = "department";
    protected SewerageApplicationDetailsRepository sewerageApplicationDetailsRepository;
    @Autowired
    private SewerageTaxUtils sewerageTaxUtils;
    @Autowired
    @Qualifier(value="parentMessageSource")
    private MessageSource stmsMessageSource;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private UserService userService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private ApplicationIndexService applicationIndexService;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private AutonumberServiceBeanResolver beanResolver;
    @Autowired
    private SewerageDemandService sewerageDemandService;
    @Autowired
    @Qualifier(value="seweargeApplicationWorkflowCustomDefaultImpl")
    private ApplicationWorkflowCustomDefaultImpl applicationWorkflowCustomDefaultImpl;
    @Autowired
    private EisCommonService eisCommonService;
    @Autowired
    private SewerageIndexService sewerageIndexService;
    @Autowired
    private SewerageConnectionSmsAndEmailService sewerageConnectionSmsAndEmailService;
    @Autowired
    private SewerageNoticeService sewerageNoticeService;
    @Autowired
    private DocumentTypeMasterService documentTypeMasterService;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private ReportService reportService;
    @Autowired
    private SewerageWorkflowService sewerageWorkflowService;
    @Autowired
    private PortalInboxService portalInboxService;
    @Autowired
    private ModuleService moduleDao;

    @Autowired
    public SewerageApplicationDetailsService(SewerageApplicationDetailsRepository sewerageApplicationDetailsRepository) {
        this.sewerageApplicationDetailsRepository = sewerageApplicationDetailsRepository;
    }

    public SewerageApplicationDetails findBy(Long id) {
        return (SewerageApplicationDetails)((Object)this.sewerageApplicationDetailsRepository.findOne(id));
    }

    public SewerageApplicationDetails findByApplicationNumber(String applicationNumber) {
        return this.sewerageApplicationDetailsRepository.findByApplicationNumber(applicationNumber);
    }

    public SewerageApplicationDetails findByApplicationNumberAndConnectionStatus(String applicationNumber, SewerageConnectionStatus status) {
        return this.sewerageApplicationDetailsRepository.findByApplicationNumberAndConnection_Status(applicationNumber, status);
    }

    public SewerageApplicationDetails findByConnectionShscNumberAndConnectionStatus(String shscNumber, SewerageConnectionStatus status) {
        return this.sewerageApplicationDetailsRepository.findByConnection_ShscNumberAndConnection_Status(shscNumber, status);
    }

    public List<SewerageApplicationDetails> findByConnectionShscNumber(String shscNumber) {
        return this.sewerageApplicationDetailsRepository.findByConnection_ShscNumber(shscNumber);
    }

    @Transactional
    public void updateExecutionDate(SewerageApplicationDetails connectionExeList) {
        this.sewerageApplicationDetailsRepository.saveAndFlush((Object)connectionExeList);
    }

    @Transactional
    public SewerageApplicationDetails createLegacySewerageConnection(SewerageApplicationDetails sewerageApplicationDetails, HttpServletRequest request) {
        EgDemand demand;
        SewerageApplicationNumberGenerator sewerageApplnNumberGenerator;
        if (sewerageApplicationDetails.getApplicationNumber() == null && (sewerageApplnNumberGenerator = (SewerageApplicationNumberGenerator)this.beanResolver.getAutoNumberServiceFor(SewerageApplicationNumberGenerator.class)) != null) {
            sewerageApplicationDetails.setApplicationNumber(sewerageApplnNumberGenerator.generateNextApplicationNumber(sewerageApplicationDetails));
        }
        sewerageApplicationDetails.getConnection().setLegacy(true);
        sewerageApplicationDetails.getConnection().setStatus(SewerageConnectionStatus.ACTIVE);
        sewerageApplicationDetails.setActive(true);
        sewerageApplicationDetails.setApplicationDate(new Date());
        Date disposalDate = this.getDisposalDate(sewerageApplicationDetails, sewerageApplicationDetails.getApplicationType().getProcessingTime());
        sewerageApplicationDetails.setDisposalDate(disposalDate);
        if (this.sewerageTaxUtils.isDonationChargeCollectionRequiredForLegacy()) {
            SewerageDemandDetail sewerageDemandDetail = new SewerageDemandDetail();
            BigDecimal donationaAmtCollected = new BigDecimal(request.getParameter("amountCollected"));
            sewerageDemandDetail.setActualCollection(donationaAmtCollected);
            for (SewerageConnectionFee fees : sewerageApplicationDetails.getConnectionFees()) {
                if (!"DONATIONCHARGE".equals(fees.getFeesDetail().getCode())) continue;
                sewerageDemandDetail.setActualAmount(BigDecimal.valueOf(fees.getAmount()));
            }
            sewerageDemandDetail.setInstallmentId(this.sewerageDemandService.getCurrentInstallment().getId());
            sewerageDemandDetail.setReasonMaster("DONATIONCHARGE");
            sewerageApplicationDetails.getDemandDetailBeanList().add(sewerageDemandDetail);
        }
        if (sewerageApplicationDetails.getCurrentDemand() == null && (demand = this.sewerageDemandService.createDemandOnLegacyConnection(sewerageApplicationDetails.getDemandDetailBeanList(), sewerageApplicationDetails)) != null) {
            SewerageDemandConnection sdc = new SewerageDemandConnection();
            sdc.setDemand(demand);
            sdc.setApplicationDetails(sewerageApplicationDetails);
            sewerageApplicationDetails.addDemandConnections(sdc);
        }
        this.sewerageApplicationDetailsRepository.save((Object)sewerageApplicationDetails);
        this.updateIndexes(sewerageApplicationDetails);
        return sewerageApplicationDetails;
    }

    @Transactional
    public SewerageApplicationDetails createNewSewerageConnection(SewerageApplicationDetails sewerageApplicationDetails, Long approvalPosition, String approvalComent, String additionalRule, MultipartFile[] files, String workFlowAction, HttpServletRequest request) {
        Set<FileStoreMapper> fileStoreSet;
        EgDemand demand;
        SewerageApplicationNumberGenerator sewerageApplnNumberGenerator;
        if (sewerageApplicationDetails.getApplicationNumber() == null && (sewerageApplnNumberGenerator = (SewerageApplicationNumberGenerator)this.beanResolver.getAutoNumberServiceFor(SewerageApplicationNumberGenerator.class)) != null) {
            sewerageApplicationDetails.setApplicationNumber(sewerageApplnNumberGenerator.generateNextApplicationNumber(sewerageApplicationDetails));
        }
        sewerageApplicationDetails.setApplicationDate(new Date());
        Date disposalDate = this.getDisposalDate(sewerageApplicationDetails, sewerageApplicationDetails.getApplicationType().getProcessingTime());
        sewerageApplicationDetails.setDisposalDate(disposalDate);
        if (LOG.isDebugEnabled()) {
            LOG.debug(APPLICATION_WORKFLOW_INITIALIZATION_DONE);
        }
        if (!sewerageApplicationDetails.getApplicationType().getCode().equalsIgnoreCase("CLOSESEWERAGECONNECTION") && sewerageApplicationDetails != null && sewerageApplicationDetails.getCurrentDemand() == null && (demand = this.sewerageDemandService.createDemandOnNewConnection(sewerageApplicationDetails.getConnectionFees(), sewerageApplicationDetails)) != null) {
            SewerageDemandConnection sdc = new SewerageDemandConnection();
            sdc.setDemand(demand);
            sdc.setApplicationDetails(sewerageApplicationDetails);
            sewerageApplicationDetails.addDemandConnections(sdc);
        }
        if ((fileStoreSet = this.sewerageTaxUtils.addToFileStore(files)) != null && !fileStoreSet.isEmpty()) {
            ArrayList<SewerageApplicationDetailsDocument> appDetailDocList = new ArrayList<SewerageApplicationDetailsDocument>();
            SewerageApplicationDetailsDocument appDetailDoc = new SewerageApplicationDetailsDocument();
            appDetailDoc.setApplicationDetails(sewerageApplicationDetails);
            appDetailDoc.setDocumentTypeMaster(this.documentTypeMasterService.findByApplicationTypeAndDescription(sewerageApplicationDetails.getApplicationType(), "Others"));
            appDetailDoc.setFileStore(fileStoreSet);
            appDetailDocList.add(appDetailDoc);
            sewerageApplicationDetails.setAppDetailsDocument(appDetailDocList);
        }
        SewerageApplicationDetails savedSewerageApplicationDetails = (SewerageApplicationDetails)((Object)this.sewerageApplicationDetailsRepository.save((Object)sewerageApplicationDetails));
        if (sewerageApplicationDetails.getApplicationType().getCode().equalsIgnoreCase("CLOSESEWERAGECONNECTION")) {
            this.applicationWorkflowCustomDefaultImpl.createCloseConnectionWorkflowTransition(sewerageApplicationDetails, approvalPosition, approvalComent, additionalRule, workFlowAction);
        } else {
            this.applicationWorkflowCustomDefaultImpl.createCommonWorkflowTransition(sewerageApplicationDetails, approvalPosition, approvalComent, additionalRule, workFlowAction);
        }
        if (this.sewerageWorkflowService.isCitizenPortalUser(this.securityUtils.getCurrentUser()).booleanValue()) {
            this.pushPortalMessage(savedSewerageApplicationDetails);
        }
        this.updateIndexes(sewerageApplicationDetails);
        if ("COLLECTINSPECTIONFEE".equalsIgnoreCase(sewerageApplicationDetails.getStatus().getCode()) || "CREATED".equalsIgnoreCase(sewerageApplicationDetails.getStatus().getCode())) {
            this.sewerageConnectionSmsAndEmailService.sendSmsAndEmail(sewerageApplicationDetails, request);
        }
        return sewerageApplicationDetails;
    }

    @Transactional
    public void save(SewerageApplicationDetails detail) {
        this.sewerageApplicationDetailsRepository.save((Object)detail);
    }

    public Date getDisposalDate(SewerageApplicationDetails sewerageApplicationDetails, Integer appProcessTime) {
        Calendar c = Calendar.getInstance();
        c.setTime(sewerageApplicationDetails.getApplicationDate());
        c.add(5, appProcessTime);
        return c.getTime();
    }

    public List<SewerageApplicationDetails> getSewerageConnectionDetailsByPropertyIDentifier(String propertyIdentifier) {
        return this.sewerageApplicationDetailsRepository.getSewerageConnectionDetailsByPropertyID(propertyIdentifier);
    }

    public SewerageApplicationDetails findByConnection_ShscNumberAndIsActive(String shscNumber) {
        return this.sewerageApplicationDetailsRepository.getActiveSewerageApplicationByShscNumber(shscNumber);
    }

    public String checkValidPropertyAssessmentNumber(String asessmentNumber) {
        String errorMessage = "";
        AssessmentDetails assessmentDetails = this.sewerageTaxUtils.getAssessmentDetailsForFlag(asessmentNumber, PropertyExternalService.FLAG_FULL_DETAILS);
        errorMessage = this.validateProperty(assessmentDetails);
        if (errorMessage.isEmpty()) {
            errorMessage = this.validatePTDue(asessmentNumber, assessmentDetails);
        }
        return errorMessage;
    }

    private String validateProperty(AssessmentDetails assessmentDetails) {
        String errorMessage = "";
        if (assessmentDetails.getErrorDetails() != null && assessmentDetails.getErrorDetails().getErrorCode() != null) {
            errorMessage = assessmentDetails.getErrorDetails().getErrorMessage();
        }
        return errorMessage;
    }

    private String validatePTDue(String asessmentNumber, AssessmentDetails assessmentDetails) {
        String errorMessage = "";
        if (assessmentDetails.getPropertyDetails() != null && assessmentDetails.getPropertyDetails().getTaxDue() != null && assessmentDetails.getPropertyDetails().getTaxDue().doubleValue() > 0.0 && !this.sewerageTaxUtils.isNewConnectionAllowedIfPTDuePresent().booleanValue()) {
            errorMessage = this.stmsMessageSource.getMessage("err.validate.seweragenewconnection.property.taxdue", (Object[])new String[]{assessmentDetails.getPropertyDetails().getTaxDue().toString(), asessmentNumber, "new"}, null);
        }
        return errorMessage;
    }

    public String checkConnectionPresentForProperty(String propertyID) {
        String validationMessage = "";
        List<SewerageApplicationDetails> sewerageApplicationDetails = this.getSewerageConnectionDetailsByPropertyIDentifier(propertyID);
        if (sewerageApplicationDetails != null && !sewerageApplicationDetails.isEmpty()) {
            if (sewerageApplicationDetails.get(0).getConnection().getStatus().toString().equalsIgnoreCase(SewerageConnectionStatus.ACTIVE.toString())) {
                validationMessage = this.stmsMessageSource.getMessage("err.validate.seweragenewconnection.active", (Object[])new String[]{sewerageApplicationDetails.get(0).getConnection().getShscNumber(), propertyID}, null);
            } else if (sewerageApplicationDetails.get(0).getConnection().getStatus().toString().equalsIgnoreCase(SewerageConnectionStatus.INPROGRESS.toString())) {
                validationMessage = this.stmsMessageSource.getMessage("err.validate.seweragenewconnection.application.inprocess", (Object[])new String[]{propertyID, sewerageApplicationDetails.get(0).getApplicationNumber()}, null);
            } else if (sewerageApplicationDetails.get(0).getConnection().getStatus().toString().equalsIgnoreCase(SewerageConnectionStatus.INACTIVE.toString())) {
                validationMessage = this.stmsMessageSource.getMessage("err.validate.seweragenewconnection.inactive", (Object[])new String[]{sewerageApplicationDetails.get(0).getConnection().getShscNumber(), propertyID}, null);
            }
        }
        return validationMessage;
    }

    public void updateIndexes(SewerageApplicationDetails sewerageApplicationDetails) {
        SimpleDateFormat myFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        try {
            if (sewerageApplicationDetails.getConnection() != null && sewerageApplicationDetails.getConnection().getExecutionDate() != null) {
                String executionDate = myFormat.format(sewerageApplicationDetails.getConnection().getExecutionDate());
                sewerageApplicationDetails.getConnection().setExecutionDate(myFormat.parse(executionDate));
            }
            if (sewerageApplicationDetails.getDisposalDate() != null) {
                String disposalDate = myFormat.format(sewerageApplicationDetails.getDisposalDate());
                sewerageApplicationDetails.setDisposalDate(myFormat.parse(disposalDate));
            }
            if (sewerageApplicationDetails.getApplicationDate() != null) {
                String applicationDate = myFormat.format(sewerageApplicationDetails.getApplicationDate());
                sewerageApplicationDetails.setApplicationDate(myFormat.parse(applicationDate));
            }
            if (sewerageApplicationDetails.getEstimationDate() != null) {
                String estimationDate = myFormat.format(sewerageApplicationDetails.getEstimationDate());
                sewerageApplicationDetails.setEstimationDate(myFormat.parse(estimationDate));
            }
            if (sewerageApplicationDetails.getWorkOrderDate() != null) {
                String workOrderDate = myFormat.format(sewerageApplicationDetails.getWorkOrderDate());
                sewerageApplicationDetails.setWorkOrderDate(myFormat.parse(workOrderDate));
            }
            if (sewerageApplicationDetails.getClosureNoticeDate() != null) {
                String closureNoticeDate = myFormat.format(sewerageApplicationDetails.getClosureNoticeDate());
                sewerageApplicationDetails.setClosureNoticeDate(myFormat.parse(closureNoticeDate));
            }
        }
        catch (ParseException e) {
            LOG.error("Exception parsing Date " + e.getMessage());
        }
        AssessmentDetails assessmentDetails = this.sewerageTaxUtils.getAssessmentDetailsForFlag(sewerageApplicationDetails.getConnectionDetail().getPropertyIdentifier(), PropertyExternalService.FLAG_FULL_DETAILS);
        if (LOG.isDebugEnabled()) {
            LOG.debug(" updating Indexes Started... ");
        }
        Iterator ownerNameItr = null;
        if (null != assessmentDetails.getOwnerNames()) {
            ownerNameItr = assessmentDetails.getOwnerNames().iterator();
        }
        StringBuilder consumerName = new StringBuilder();
        StringBuilder mobileNumber = new StringBuilder();
        Assignment assignment = null;
        User user = null;
        StringBuilder aadharNumber = new StringBuilder();
        if (null != ownerNameItr && ownerNameItr.hasNext()) {
            OwnerName primaryOwner = (OwnerName)ownerNameItr.next();
            consumerName.append(primaryOwner.getOwnerName() != null ? primaryOwner.getOwnerName() : "");
            mobileNumber.append(primaryOwner.getMobileNumber() != null ? primaryOwner.getMobileNumber() : "");
            aadharNumber.append(primaryOwner.getAadhaarNumber() != null ? primaryOwner.getAadhaarNumber() : "");
            while (ownerNameItr.hasNext()) {
                OwnerName secondaryOwner = (OwnerName)ownerNameItr.next();
                consumerName.append(",").append(secondaryOwner.getOwnerName() != null ? secondaryOwner.getOwnerName() : "");
                mobileNumber.append(",").append(secondaryOwner.getMobileNumber() != null ? secondaryOwner.getMobileNumber() : "");
                aadharNumber.append(",").append(secondaryOwner.getAadhaarNumber() != null ? secondaryOwner.getAadhaarNumber() : "");
            }
        }
        List<Object> asignList = null;
        if (sewerageApplicationDetails.getState() != null && sewerageApplicationDetails.getState().getOwnerPosition() != null) {
            assignment = this.assignmentService.getPrimaryAssignmentForPositionAndDate(((Position)sewerageApplicationDetails.getState().getOwnerPosition()).getId(), new Date());
            if (assignment != null) {
                asignList = new ArrayList<Assignment>();
                asignList.add(assignment);
            } else if (assignment == null) {
                asignList = this.assignmentService.getAssignmentsForPosition(((Position)sewerageApplicationDetails.getState().getOwnerPosition()).getId(), new Date());
            }
            if (!asignList.isEmpty()) {
                user = this.userService.getUserById(((Assignment)asignList.get(0)).getEmployee().getId());
            }
        } else {
            user = this.securityUtils.getCurrentUser();
        }
        if (sewerageApplicationDetails.getConnection().getLegacy() && (null == sewerageApplicationDetails.getId() || null != sewerageApplicationDetails.getId() && sewerageApplicationDetails.getStatus().getCode().equalsIgnoreCase("SANCTIONED"))) {
            this.sewerageIndexService.createSewarageIndex(sewerageApplicationDetails, assessmentDetails);
            return;
        }
        ApplicationIndex applicationIndex = this.applicationIndexService.findByApplicationNumber(sewerageApplicationDetails.getApplicationNumber());
        if (applicationIndex != null && null != sewerageApplicationDetails.getId()) {
            applicationIndex.setStatus(sewerageApplicationDetails.getStatus().getDescription());
            applicationIndex.setOwnerName(user != null ? user.getUsername() + "::" + user.getName() : "");
            if (sewerageApplicationDetails.getStatus().getCode().equals("SANCTIONED")) {
                applicationIndex.setApproved(ApprovalStatus.APPROVED);
                applicationIndex.setClosed(ClosureStatus.YES);
            } else if (sewerageApplicationDetails.getStatus().getCode().equals("CANCELLED")) {
                applicationIndex.setApproved(ApprovalStatus.REJECTED);
                applicationIndex.setClosed(ClosureStatus.YES);
            }
            if (sewerageApplicationDetails.getConnection().getShscNumber() != null) {
                applicationIndex.setConsumerCode(sewerageApplicationDetails.getConnection().getShscNumber());
            }
            this.applicationIndexService.updateApplicationIndex(applicationIndex);
            this.sewerageIndexService.createSewarageIndex(sewerageApplicationDetails, assessmentDetails);
        } else {
            if (sewerageApplicationDetails.getApplicationDate() == null) {
                sewerageApplicationDetails.setApplicationDate(new Date());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Application Index creation Started... ");
            }
            AppConfigValues slaForSewerageConn = null;
            if (sewerageApplicationDetails != null && sewerageApplicationDetails.getApplicationType() != null && "New Sewerage Connection".equals(sewerageApplicationDetails.getApplicationType().getName())) {
                slaForSewerageConn = this.getSlaAppConfigValuesForMarriageReg("Sewerage Tax Management", "SLAFORNEWSEWERAGECONNECTION");
            } else if (sewerageApplicationDetails != null && sewerageApplicationDetails.getApplicationType() != null && "Change In Closets".equals(sewerageApplicationDetails.getApplicationType().getName())) {
                slaForSewerageConn = this.getSlaAppConfigValuesForMarriageReg("Sewerage Tax Management", "SLAFORCHANGEINCLOSET");
            }
            applicationIndex = ApplicationIndex.builder().withModuleName("Sewerage Tax").withApplicationNumber(sewerageApplicationDetails.getApplicationNumber()).withApplicationDate(sewerageApplicationDetails.getApplicationDate()).withApplicationType(sewerageApplicationDetails.getApplicationType().getName()).withApplicantName(consumerName.toString()).withStatus(sewerageApplicationDetails.getStatus().getDescription()).withUrl(String.format(STMS_APPLICATION_VIEW, sewerageApplicationDetails.getApplicationNumber(), sewerageApplicationDetails.getConnectionDetail().getPropertyIdentifier())).withApplicantAddress(assessmentDetails.getPropertyAddress()).withOwnername(user.getUsername() + "::" + user.getName()).withChannel(sewerageApplicationDetails.getSource() == null ? Source.SYSTEM.toString() : sewerageApplicationDetails.getSource()).withDisposalDate(sewerageApplicationDetails.getDisposalDate()).withMobileNumber(mobileNumber.toString()).withClosed(ClosureStatus.NO).withAadharNumber(aadharNumber.toString()).withSla(Integer.valueOf(slaForSewerageConn != null && slaForSewerageConn.getValue() != null ? Integer.valueOf(slaForSewerageConn.getValue()) : 0)).withApproved(ApprovalStatus.INPROGRESS).build();
            this.applicationIndexService.createApplicationIndex(applicationIndex);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Application Index creation completed...");
            }
            this.sewerageIndexService.createSewarageIndex(sewerageApplicationDetails, assessmentDetails);
        }
    }

    public AppConfigValues getSlaAppConfigValuesForMarriageReg(String moduleName, String keyName) {
        List appConfigValues = this.appConfigValuesService.getConfigValuesByModuleAndKey(moduleName, keyName);
        return !appConfigValues.isEmpty() ? (AppConfigValues)appConfigValues.get(0) : null;
    }

    public BigDecimal getTotalAmount(SewerageApplicationDetails sewerageApplicationDetails) {
        EgDemand currentDemand;
        BigDecimal balance = BigDecimal.ZERO;
        if (sewerageApplicationDetails == null || (currentDemand = sewerageApplicationDetails.getCurrentDemand()) != null) {
            // empty if block
        }
        return balance;
    }

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public Map<String, String> showApprovalDetailsByApplcationCurState(SewerageApplicationDetails sewerageApplicationDetails) {
        HashMap<String, String> modelParams = new HashMap<String, String>();
        if (sewerageApplicationDetails.getState() != null) {
            String currentState = sewerageApplicationDetails.getState().getValue();
            if (currentState.equalsIgnoreCase("Inspection Fee Pending") || currentState.equalsIgnoreCase("Assistant Engineer Approved") || currentState.equalsIgnoreCase("Deputy Exe Engineer Approved") || currentState.equalsIgnoreCase("Payment Done Against Estimation")) {
                modelParams.put("showApprovalDtls", "no");
            } else {
                modelParams.put("showApprovalDtls", "yes");
            }
            if (currentState.equalsIgnoreCase("Inspection Fee Collected") || currentState.equalsIgnoreCase("Clerk Approved")) {
                modelParams.put("mode", "edit");
            } else if (currentState.equalsIgnoreCase("Rejected")) {
                modelParams.put("mode", "editOnReject");
            } else if ("NEW".equalsIgnoreCase(currentState) && ("CSCCREATED".equalsIgnoreCase(sewerageApplicationDetails.getStatus().getCode()) || "ANONYMOUSCREATED".equalsIgnoreCase(sewerageApplicationDetails.getStatus().getCode()) || "CITIZENCREATED".equalsIgnoreCase(sewerageApplicationDetails.getStatus().getCode()))) {
                modelParams.put("mode", "closetview");
            } else {
                modelParams.put("mode", "view");
            }
        }
        return modelParams;
    }

    public SewerageApplicationDetails updateSewerageApplicationDetails(SewerageApplicationDetails sewerageApplicationDetails) {
        return (SewerageApplicationDetails)((Object)this.sewerageApplicationDetailsRepository.saveAndFlush((Object)sewerageApplicationDetails));
    }

    @Transactional
    public SewerageApplicationDetails updateSewerageApplicationDetails(SewerageApplicationDetails sewerageApplicationDetails, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction, String mode, ReportOutput reportOutput, HttpServletRequest request, HttpSession session) {
        SewerageNotice sewerageNotice;
        SewerageNotice existingSewerageNotice;
        SewerageEstimationNumberGenerator estimationNumberGenerator;
        if (sewerageApplicationDetails.getStatus().getCode().equalsIgnoreCase("ESTIMATIONAMOUNTPAID") && sewerageApplicationDetails.getState().getValue().equalsIgnoreCase("Payment Done Against Estimation") || sewerageApplicationDetails.getStatus().getCode().equalsIgnoreCase("DEEAPPROVED") && additionalRule != null && additionalRule.equalsIgnoreCase("CHANGEINCLOSETS NOCOLLECTION")) {
            SewerageSHSCNumberGenerator shscNumberGenerator;
            SewerageWorkOrderNumberGenerator workOrderNumberGenerator;
            if (sewerageApplicationDetails.getWorkOrderNumber() == null && (workOrderNumberGenerator = (SewerageWorkOrderNumberGenerator)this.beanResolver.getAutoNumberServiceFor(SewerageWorkOrderNumberGenerator.class)) != null) {
                sewerageApplicationDetails.setWorkOrderNumber(workOrderNumberGenerator.generateSewerageWorkOrderNumber());
                sewerageApplicationDetails.setWorkOrderDate(new Date());
            }
            if (sewerageApplicationDetails.getConnection().getShscNumber() == null && (shscNumberGenerator = (SewerageSHSCNumberGenerator)this.beanResolver.getAutoNumberServiceFor(SewerageSHSCNumberGenerator.class)) != null) {
                sewerageApplicationDetails.getConnection().setShscNumber(shscNumberGenerator.generateNextSHSCNumber(sewerageApplicationDetails));
            }
        }
        if (sewerageApplicationDetails.getStatus().getCode() != null && sewerageApplicationDetails.getStatus().getCode().equalsIgnoreCase("INITIALAPPROVED") || sewerageApplicationDetails.getStatus().getCode().equalsIgnoreCase("INSPECTIONFEEPAID") || sewerageApplicationDetails.getStatus().getCode().equalsIgnoreCase("CREATED")) {
            if (sewerageApplicationDetails != null && sewerageApplicationDetails.getCurrentDemand() == null) {
                EgDemand demand = this.sewerageDemandService.createDemandOnNewConnection(sewerageApplicationDetails.getConnectionFees(), sewerageApplicationDetails);
                if (demand != null) {
                    SewerageDemandConnection sdc = new SewerageDemandConnection();
                    sdc.setDemand(demand);
                    sdc.setApplicationDetails(sewerageApplicationDetails);
                    sewerageApplicationDetails.addDemandConnections(sdc);
                }
            } else if (sewerageApplicationDetails.getApplicationType().getCode().equalsIgnoreCase("CHANGEINCLOSETS")) {
                SewerageApplicationDetails oldSewerageAppDtls = this.findByConnection_ShscNumberAndIsActive(sewerageApplicationDetails.getConnection().getShscNumber());
                if (!workFlowAction.equals("Reject")) {
                    if (sewerageApplicationDetails.getStatus().getCode().equalsIgnoreCase("INITIALAPPROVED")) {
                        this.sewerageDemandService.updateDemandOnChangeInClosets(oldSewerageAppDtls, sewerageApplicationDetails.getConnectionFees(), sewerageApplicationDetails.getCurrentDemand(), Boolean.TRUE);
                    } else {
                        this.sewerageDemandService.updateDemandOnChangeInClosets(oldSewerageAppDtls, sewerageApplicationDetails.getConnectionFees(), sewerageApplicationDetails.getCurrentDemand(), Boolean.FALSE);
                    }
                }
            } else {
                this.sewerageDemandService.updateDemand(sewerageApplicationDetails.getConnectionFees(), sewerageApplicationDetails.getCurrentDemand());
            }
        }
        if (sewerageApplicationDetails.getStatus().getCode().equalsIgnoreCase("DEEAPPROVED") && sewerageApplicationDetails.getState().getValue().equalsIgnoreCase("Deputy Exe Engineer Approved") && additionalRule != null && !additionalRule.equalsIgnoreCase("CHANGEINCLOSETS NOCOLLECTION") && sewerageApplicationDetails.getEstimationNumber() == null && (estimationNumberGenerator = (SewerageEstimationNumberGenerator)this.beanResolver.getAutoNumberServiceFor(SewerageEstimationNumberGenerator.class)) != null) {
            sewerageApplicationDetails.setEstimationNumber(estimationNumberGenerator.generateEstimationNumber());
            sewerageApplicationDetails.setEstimationDate(new Date());
        }
        if (additionalRule != null && additionalRule.equalsIgnoreCase("CHANGEINCLOSETS NOCOLLECTION")) {
            this.applicationStatusChange(sewerageApplicationDetails, workFlowAction, additionalRule, request, session);
        } else {
            this.applicationStatusChange(sewerageApplicationDetails, workFlowAction, mode, request, session);
        }
        if (sewerageApplicationDetails.getStatus().getCode().equalsIgnoreCase("ESTIMATIONNOTICEGENERATED")) {
            SewerageNotice sewerageNotice2 = this.sewerageNoticeService.generateReportForEstimation(sewerageApplicationDetails);
            if (sewerageNotice2 != null) {
                sewerageApplicationDetails.addNotice(sewerageNotice2);
            }
        } else if (("WORKORDERGENERATED".equalsIgnoreCase(sewerageApplicationDetails.getStatus().getCode()) || "FINALAPPROVED".equalsIgnoreCase(sewerageApplicationDetails.getStatus().getCode())) && (existingSewerageNotice = this.sewerageNoticeService.findByNoticeNoAndNoticeType(sewerageApplicationDetails.getWorkOrderNumber(), "Workorder Notice")) == null && (sewerageNotice = this.sewerageNoticeService.generateReportForWorkOrder(sewerageApplicationDetails)) != null) {
            sewerageApplicationDetails.addNotice(sewerageNotice);
        }
        SewerageApplicationDetails updatedSewerageApplicationDetails = (SewerageApplicationDetails)((Object)this.sewerageApplicationDetailsRepository.save((Object)sewerageApplicationDetails));
        if (LOG.isDebugEnabled()) {
            LOG.debug(APPLICATION_WORKFLOW_INITIALIZATION_DONE);
        }
        this.applicationWorkflowCustomDefaultImpl.createCommonWorkflowTransition(updatedSewerageApplicationDetails, approvalPosition, approvalComent, additionalRule, workFlowAction);
        if (sewerageApplicationDetails.getApplicationType().getCode().equalsIgnoreCase("CHANGEINCLOSETS") && sewerageApplicationDetails.getParent() != null) {
            this.updateIndexes(sewerageApplicationDetails.getParent());
        }
        this.updatePortalMessage(updatedSewerageApplicationDetails);
        this.updateIndexes(sewerageApplicationDetails);
        if ("COLLECTINSPECTIONFEE".equalsIgnoreCase(sewerageApplicationDetails.getStatus().getCode()) || "DEEAPPROVED".equalsIgnoreCase(sewerageApplicationDetails.getStatus().getCode()) || "CREATED".equalsIgnoreCase(sewerageApplicationDetails.getStatus().getCode())) {
            sewerageApplicationDetails.setApprovalComent(approvalComent);
            this.sewerageConnectionSmsAndEmailService.sendSmsAndEmail(sewerageApplicationDetails, request);
        } else if ("FINALAPPROVED".equalsIgnoreCase(sewerageApplicationDetails.getStatus().getCode()) || "REJECTED".equalsIgnoreCase(sewerageApplicationDetails.getStatus().getCode())) {
            sewerageApplicationDetails.setApprovalComent(approvalComent);
            this.sewerageConnectionSmsAndEmailService.sendSmsAndEmail(sewerageApplicationDetails, request);
        }
        return updatedSewerageApplicationDetails;
    }

    public void applicationStatusChange(SewerageApplicationDetails sewerageApplicationDetails, String workFlowAction, String mode, HttpServletRequest request, HttpSession session) {
        if (null != sewerageApplicationDetails && null != sewerageApplicationDetails.getStatus() && null != sewerageApplicationDetails.getStatus().getCode()) {
            if ("Reject".equalsIgnoreCase(workFlowAction)) {
                sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("REJECTED", "SEWERAGETAXAPPLICATION"));
            } else if ("Cancel".equalsIgnoreCase(workFlowAction)) {
                SewerageNotice sewerageNotice;
                SewerageRejectionNoticeNumberGenerator rejectionNumberGenerator;
                if (sewerageApplicationDetails.getApplicationType().getCode().equalsIgnoreCase("CHANGEINCLOSETS")) {
                    sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("CANCELLED", "SEWERAGETAXAPPLICATION"));
                    sewerageApplicationDetails.getConnection().setStatus(SewerageConnectionStatus.ACTIVE);
                } else {
                    sewerageApplicationDetails.getConnection().setStatus(SewerageConnectionStatus.INACTIVE);
                    sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("CANCELLED", "SEWERAGETAXAPPLICATION"));
                }
                if (sewerageApplicationDetails.getRejectionNumber() == null && (rejectionNumberGenerator = (SewerageRejectionNoticeNumberGenerator)this.beanResolver.getAutoNumberServiceFor(SewerageRejectionNoticeNumberGenerator.class)) != null) {
                    sewerageApplicationDetails.setRejectionNumber(rejectionNumberGenerator.generateRejectionNoticeNumber());
                    sewerageApplicationDetails.setRejectionDate(new Date());
                }
                if ((sewerageNotice = this.sewerageNoticeService.generateReportForRejection(sewerageApplicationDetails, session, request)) != null) {
                    sewerageApplicationDetails.addNotice(sewerageNotice);
                }
            } else if ("NEW".equalsIgnoreCase(sewerageApplicationDetails.getState().getValue()) && ("CSCCREATED".equalsIgnoreCase(sewerageApplicationDetails.getStatus().getCode()) || "ANONYMOUSCREATED".equalsIgnoreCase(sewerageApplicationDetails.getStatus().getCode()))) {
                if (this.sewerageTaxUtils.isInspectionFeeCollectionRequired()) {
                    sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("COLLECTINSPECTIONFEE", "SEWERAGETAXAPPLICATION"));
                } else {
                    sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("CREATED", "SEWERAGETAXAPPLICATION"));
                }
            } else if ("FEECOLLECTIONPENDING".equalsIgnoreCase(sewerageApplicationDetails.getStatus().getCode())) {
                sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("INSPECTIONFEEPAID", "SEWERAGETAXAPPLICATION"));
            } else if (sewerageApplicationDetails.getStatus().getCode().equals("CREATED") || sewerageApplicationDetails.getStatus().getCode().equals("INSPECTIONFEEPAID") && !sewerageApplicationDetails.getState().getValue().equalsIgnoreCase("NEW")) {
                sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("INITIALAPPROVED", "SEWERAGETAXAPPLICATION"));
            } else if (sewerageApplicationDetails.getStatus().getCode().equals("COLLECTINSPECTIONFEE")) {
                sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("INSPECTIONFEEPAID", "SEWERAGETAXAPPLICATION"));
            } else if (sewerageApplicationDetails.getStatus().getCode().equals("INITIALAPPROVED")) {
                sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("DEEAPPROVED", "SEWERAGETAXAPPLICATION"));
            } else if (sewerageApplicationDetails.getStatus().getCode().equals("DEEAPPROVED")) {
                if (mode != null && mode.equalsIgnoreCase("CHANGEINCLOSETS NOCOLLECTION")) {
                    sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("FINALAPPROVED", "SEWERAGETAXAPPLICATION"));
                } else {
                    sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("ESTIMATIONNOTICEGENERATED", "SEWERAGETAXAPPLICATION"));
                }
            } else if (sewerageApplicationDetails.getStatus().getCode().equals("ESTIMATIONNOTICEGENERATED")) {
                sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("ESTIMATIONAMOUNTPAID", "SEWERAGETAXAPPLICATION"));
            } else if (sewerageApplicationDetails.getStatus().getCode().equals("ESTIMATIONAMOUNTPAID") && sewerageApplicationDetails.getState().getValue().equalsIgnoreCase("Payment Done Against Estimation")) {
                sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("FINALAPPROVED", "SEWERAGETAXAPPLICATION"));
            } else if (sewerageApplicationDetails.getStatus().getCode().equals("FINALAPPROVED")) {
                sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("WORKORDERGENERATED", "SEWERAGETAXAPPLICATION"));
            } else if (sewerageApplicationDetails.getStatus().getCode().equals("WORKORDERGENERATED")) {
                sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("SANCTIONED", "SEWERAGETAXAPPLICATION"));
                if (sewerageApplicationDetails.getConnection().getStatus().equals((Object)SewerageConnectionStatus.INPROGRESS)) {
                    sewerageApplicationDetails.getConnection().setStatus(SewerageConnectionStatus.ACTIVE);
                }
                sewerageApplicationDetails.setActive(true);
            } else if (sewerageApplicationDetails.getStatus().getCode().equals("REJECTED")) {
                if (this.sewerageTaxUtils.isInspectionFeeCollectionRequired()) {
                    if (sewerageApplicationDetails.getCurrentDemand().getAmtCollected().compareTo(BigDecimal.ZERO) == 0) {
                        sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("COLLECTINSPECTIONFEE", "SEWERAGETAXAPPLICATION"));
                    } else {
                        sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("INSPECTIONFEEPAID", "SEWERAGETAXAPPLICATION"));
                    }
                } else {
                    sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("CREATED", "SEWERAGETAXAPPLICATION"));
                }
            }
        }
    }

    @Transactional
    public SewerageApplicationDetails updateCloseSewerageApplicationDetails(SewerageApplicationDetails sewerageApplicationDetails, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction, ReportOutput reportOutput, HttpServletRequest request, HttpSession session) {
        SewerageNotice sewerageNotice;
        SewerageCloseConnectionNoticeNumberGenerator closeConnectionNoticeNumberGenerator;
        if (sewerageApplicationDetails.getStatus().getCode().equalsIgnoreCase("DEEAPPROVED") && sewerageApplicationDetails.getApplicationType().getCode().equalsIgnoreCase("CLOSESEWERAGECONNECTION") && "Approve".equalsIgnoreCase(workFlowAction) && (closeConnectionNoticeNumberGenerator = (SewerageCloseConnectionNoticeNumberGenerator)this.beanResolver.getAutoNumberServiceFor(SewerageCloseConnectionNoticeNumberGenerator.class)) != null && sewerageApplicationDetails.getClosureNoticeNumber() == null) {
            sewerageApplicationDetails.setClosureNoticeNumber(closeConnectionNoticeNumberGenerator.generateCloserNoticeNumber());
            sewerageApplicationDetails.setClosureNoticeDate(new Date());
        }
        if (null != sewerageApplicationDetails && null != sewerageApplicationDetails.getStatus() && null != sewerageApplicationDetails.getStatus().getCode()) {
            if ("Reject".equalsIgnoreCase(workFlowAction)) {
                sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("REJECTED", "SEWERAGETAXAPPLICATION"));
            } else if ("Cancel".equalsIgnoreCase(workFlowAction)) {
                sewerageApplicationDetails.getConnection().setStatus(SewerageConnectionStatus.ACTIVE);
                sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("CANCELLED", "SEWERAGETAXAPPLICATION"));
            } else if (sewerageApplicationDetails.getStatus().getCode().equals("CREATED")) {
                sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("INITIALAPPROVED", "SEWERAGETAXAPPLICATION"));
            } else if (sewerageApplicationDetails.getStatus().getCode().equals("INITIALAPPROVED")) {
                sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("DEEAPPROVED", "SEWERAGETAXAPPLICATION"));
            } else if (sewerageApplicationDetails.getStatus().getCode().equals("DEEAPPROVED")) {
                sewerageApplicationDetails.getConnection().setStatus(SewerageConnectionStatus.CLOSED);
                sewerageApplicationDetails.setActive(true);
                sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("CLOSERSANCTIONED", "SEWERAGETAXAPPLICATION"));
            } else if (sewerageApplicationDetails.getStatus().getCode().equals("REJECTED")) {
                sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("CREATED", "SEWERAGETAXAPPLICATION"));
            }
        }
        if (sewerageApplicationDetails.getStatus().getCode().equalsIgnoreCase("CLOSERSANCTIONED") && "Approve".equalsIgnoreCase(workFlowAction) && (sewerageNotice = this.sewerageNoticeService.generateReportForCloseConnection(sewerageApplicationDetails, session)) != null) {
            sewerageApplicationDetails.addNotice(sewerageNotice);
        }
        SewerageApplicationDetails updatedSewerageApplicationDetails = (SewerageApplicationDetails)((Object)this.sewerageApplicationDetailsRepository.save((Object)sewerageApplicationDetails));
        if (LOG.isDebugEnabled()) {
            LOG.debug(APPLICATION_WORKFLOW_INITIALIZATION_DONE);
        }
        this.applicationWorkflowCustomDefaultImpl.createCloseConnectionWorkflowTransition(updatedSewerageApplicationDetails, approvalPosition, approvalComent, additionalRule, workFlowAction);
        if (sewerageApplicationDetails.getParent() != null) {
            this.updateIndexes(sewerageApplicationDetails.getParent());
        }
        this.updateIndexes(sewerageApplicationDetails);
        if ("CLOSERSANCTIONED".equalsIgnoreCase(sewerageApplicationDetails.getStatus().getCode()) && "Approve".equalsIgnoreCase(workFlowAction) || "CREATED".equalsIgnoreCase(sewerageApplicationDetails.getStatus().getCode()) || "REJECTED".equalsIgnoreCase(sewerageApplicationDetails.getStatus().getCode())) {
            sewerageApplicationDetails.setApprovalComent(approvalComent);
            this.sewerageConnectionSmsAndEmailService.sendSmsAndEmail(sewerageApplicationDetails, request);
        }
        return updatedSewerageApplicationDetails;
    }

    public List<HashMap<String, Object>> getHistory(SewerageApplicationDetails sewerageApplicationDetails) {
        ArrayList<HashMap<String, Object>> historyTable = new ArrayList<HashMap<String, Object>>();
        State state = sewerageApplicationDetails.getState();
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (null != state) {
            User user;
            if (!sewerageApplicationDetails.getStateHistory().isEmpty() && sewerageApplicationDetails.getStateHistory() != null) {
                Collections.reverse(sewerageApplicationDetails.getStateHistory());
            }
            for (StateHistory stateHistory : sewerageApplicationDetails.getStateHistory()) {
                HashMap<String, Object> HistoryMap = new HashMap<String, Object>();
                HistoryMap.put("date", stateHistory.getDateInfo());
                HistoryMap.put("comments", stateHistory.getComments());
                HistoryMap.put("updatedBy", stateHistory.getLastModifiedBy().getUsername() + "::" + stateHistory.getLastModifiedBy().getName());
                HistoryMap.put("status", stateHistory.getValue());
                Position owner = (Position)stateHistory.getOwnerPosition();
                user = stateHistory.getOwnerUser();
                if (null != user && !user.getType().toString().equals("CITIZEN")) {
                    HistoryMap.put("user", user.getUsername() + "::" + user.getName());
                    HistoryMap.put(DEPARTMENT, null != this.eisCommonService.getDepartmentForUser(user.getId()) ? this.eisCommonService.getDepartmentForUser(user.getId()).getName() : "");
                } else if (null != owner && null != owner.getDeptDesig()) {
                    user = this.eisCommonService.getUserForPosition(owner.getId(), new Date());
                    HistoryMap.put("user", null != user.getUsername() ? user.getUsername() + "::" + user.getName() : "");
                    HistoryMap.put(DEPARTMENT, null != owner.getDeptDesig().getDepartment() ? owner.getDeptDesig().getDepartment().getName() : "");
                }
                historyTable.add(HistoryMap);
            }
            map.put("date", state.getDateInfo());
            map.put("comments", state.getComments() != null ? state.getComments() : "");
            map.put("updatedBy", state.getLastModifiedBy().getUsername() + "::" + state.getLastModifiedBy().getName());
            map.put("status", state.getValue());
            Position ownerPosition = (Position)state.getOwnerPosition();
            user = state.getOwnerUser();
            if (null != user && !user.getType().toString().equals("CITIZEN")) {
                map.put("user", user.getUsername() + "::" + user.getName());
                map.put(DEPARTMENT, null != this.eisCommonService.getDepartmentForUser(user.getId()) ? this.eisCommonService.getDepartmentForUser(user.getId()).getName() : "");
            } else if (null != ownerPosition && null != ownerPosition.getDeptDesig()) {
                user = this.eisCommonService.getUserForPosition(ownerPosition.getId(), new Date());
                map.put("user", null != user.getUsername() ? user.getUsername() + "::" + user.getName() : "");
                map.put(DEPARTMENT, null != ownerPosition.getDeptDesig().getDepartment() ? ownerPosition.getDeptDesig().getDepartment().getName() : "");
            }
            historyTable.add(map);
        }
        return historyTable;
    }

    public void updateStateTransition(SewerageApplicationDetails sewerageApplicationDetails, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction) {
        if (approvalPosition != null && additionalRule != null && StringUtils.isNotEmpty((String)workFlowAction)) {
            this.applicationWorkflowCustomDefaultImpl.createCommonWorkflowTransition(sewerageApplicationDetails, approvalPosition, approvalComent, additionalRule, workFlowAction);
        }
    }

    public SewerageApplicationDetails isApplicationInProgress(String shscNumber) {
        return this.sewerageApplicationDetailsRepository.getSewerageApplicationInWorkFlow(shscNumber);
    }

    public BigDecimal getPendingTaxAmount(SewerageApplicationDetails sewerageApplicationDetails) {
        return this.sewerageDemandService.checkForPendingTaxAmountToCollect(sewerageApplicationDetails.getCurrentDemand());
    }

    public String isConnectionExistsForProperty(String propertyId) {
        return this.checkConnectionPresentForProperty(propertyId);
    }

    @Transactional
    public List<SewerageApplicationDetails> findActiveSewerageApplnsByCurrentInstallmentAndNumberOfResultToFetch(Installment installment, int noOfResultToFetch) {
        Criteria sewerageCriteria = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(SewerageApplicationDetails.class, "sewerageDetails").createAlias("sewerageDetails.demandConnections", "demandConnections").createAlias("demandConnections.demand", "demand");
        sewerageCriteria.add((Criterion)Restrictions.eq((String)"demand.isHistory", (Object)"N"));
        sewerageCriteria.add((Criterion)Restrictions.eq((String)"sewerageDetails.isActive", (Object)true));
        if (installment != null) {
            sewerageCriteria.add((Criterion)Restrictions.eq((String)"demand.egInstallmentMaster.id", (Object)installment.getId()));
        }
        sewerageCriteria.setMaxResults(noOfResultToFetch);
        sewerageCriteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        return sewerageCriteria.list();
    }

    public AppConfigValues getAppConfigValuesForDonationCharge(String moduleName, String keyName) {
        List appConfigValues = this.appConfigValuesService.getConfigValuesByModuleAndKey(moduleName, keyName);
        return !appConfigValues.isEmpty() ? (AppConfigValues)appConfigValues.get(0) : null;
    }

    @Transactional
    public SewerageApplicationDetails updateLegacySewerageConnection(SewerageApplicationDetails sewerageApplicationDetails, HttpServletRequest request) {
        if (this.sewerageTaxUtils.isDonationChargeCollectionRequiredForLegacy()) {
            SewerageDemandDetail sewerageDemandDetail = new SewerageDemandDetail();
            BigDecimal donationaAmtCollected = new BigDecimal(request.getParameter("amountCollected"));
            sewerageDemandDetail.setActualCollection(donationaAmtCollected);
            for (SewerageConnectionFee fees : sewerageApplicationDetails.getConnectionFees()) {
                if (!"DONATIONCHARGE".equals(fees.getFeesDetail().getCode())) continue;
                sewerageDemandDetail.setActualAmount(BigDecimal.valueOf(fees.getAmount()));
            }
            sewerageDemandDetail.setInstallmentId(this.sewerageDemandService.getCurrentInstallment().getId());
            sewerageDemandDetail.setReasonMaster("DONATIONCHARGE");
            sewerageApplicationDetails.getDemandDetailBeanList().add(sewerageDemandDetail);
        }
        this.sewerageDemandService.updateLegacyDemand(sewerageApplicationDetails.getDemandDetailBeanList(), sewerageApplicationDetails.getCurrentDemand());
        this.sewerageApplicationDetailsRepository.saveAndFlush((Object)sewerageApplicationDetails);
        this.updateIndexes(sewerageApplicationDetails);
        return sewerageApplicationDetails;
    }

    public ReportOutput getReportParamsForSewerageAcknowdgement(SewerageApplicationDetails sewerageApplicationDetails, String municipalityName, String cityName) {
        Iterator iterator;
        HashMap<String, String> reportParams = new HashMap<String, String>();
        String ownerName = "";
        reportParams.put(MUNICIPALITY, municipalityName);
        reportParams.put(CITYNAME, cityName);
        AssessmentDetails assessmentDetails = this.sewerageTaxUtils.getAssessmentDetailsForFlag(sewerageApplicationDetails.getConnectionDetail().getPropertyIdentifier(), PropertyExternalService.FLAG_FULL_DETAILS);
        if (null != assessmentDetails.getOwnerNames() && (iterator = assessmentDetails.getOwnerNames().iterator()).hasNext()) {
            OwnerName names = (OwnerName)iterator.next();
            ownerName = names.getOwnerName();
        }
        reportParams.put(ZONE_NAME, assessmentDetails.getBoundaryDetails() != null ? assessmentDetails.getBoundaryDetails().getZoneName() : "");
        reportParams.put(ELECTION_WARD, assessmentDetails.getBoundaryDetails() != null ? assessmentDetails.getBoundaryDetails().getWardName() : "");
        reportParams.put(ADDRESS, assessmentDetails.getPropertyAddress());
        reportParams.put(APPLICANT_NAME, ownerName);
        reportParams.put(ACKNOWLEDGEMENT_NO, sewerageApplicationDetails.getApplicationNumber());
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
        reportParams.put(CURRENT_DATE, formatter.format(new Date()));
        reportParams.put(DUE_DATE, formatter.format(this.calculateDueDate(sewerageApplicationDetails)));
        reportParams.put(PARTY_S_COPY, PARTY_S_COPY);
        reportParams.put(OFFICE_S_COPY, OFFICE_S_COPY);
        reportParams.put(APPLICATION_CENTRE, this.stmsMessageSource.getMessage("msg.application.centre", (Object[])new String[0], Locale.getDefault()));
        reportParams.put(APP_TYPE, WordUtils.capitalize((String)sewerageApplicationDetails.getApplicationType().getName()));
        ReportRequest reportInput = new ReportRequest("sewerageAcknowledgementReceipt", (Object)sewerageApplicationDetails, reportParams);
        return this.reportService.createReport(reportInput);
    }

    private Date calculateDueDate(SewerageApplicationDetails sewerageApplicationDetails) {
        String slaapptype = null;
        slaapptype = "CHANGEINCLOSETS".equalsIgnoreCase(sewerageApplicationDetails.getApplicationType().getCode()) ? "SLAFORCHANGEINCLOSET" : "SLAFORNEWSEWERAGECONNECTION";
        Date currentDate = new Date();
        AppConfigValues slaForSewerageConn = this.getSlaAppConfigValuesForSewerage("Sewerage Tax Management", slaapptype);
        Date dueDate = DateUtils.addDays((Date)currentDate, (int)(slaForSewerageConn != null && slaForSewerageConn.getValue() != null ? Integer.valueOf(slaForSewerageConn.getValue()) : 0));
        return dueDate;
    }

    public AppConfigValues getSlaAppConfigValuesForSewerage(String moduleName, String keyName) {
        List appConfigValues = this.appConfigValuesService.getConfigValuesByModuleAndKey(moduleName, keyName);
        return !appConfigValues.isEmpty() ? (AppConfigValues)appConfigValues.get(0) : null;
    }

    @Transactional
    public void pushPortalMessage(SewerageApplicationDetails sewerageApplicationDetails) {
        SewerageConnection sewerageConnection = sewerageApplicationDetails.getConnection();
        Module module = this.moduleDao.getModuleByName("Sewerage Tax Management");
        PortalInboxBuilder portalInboxBuilder = new PortalInboxBuilder(module, sewerageApplicationDetails.getState().getNatureOfTask() + " : " + module.getDisplayName(), sewerageApplicationDetails.getApplicationNumber(), sewerageConnection.getShscNumber(), sewerageConnection.getId(), sewerageApplicationDetails.getCloseConnectionReason(), "Sucess", String.format(STMS_APPLICATION_UPDATE, sewerageApplicationDetails.getApplicationNumber()), this.isResolved(sewerageApplicationDetails), sewerageApplicationDetails.getStatus().getDescription(), this.calculateDueDate(sewerageApplicationDetails), sewerageApplicationDetails.getState(), Arrays.asList(this.securityUtils.getCurrentUser()));
        PortalInbox portalInbox = portalInboxBuilder.build();
        this.portalInboxService.pushInboxMessage(portalInbox);
    }

    private boolean isResolved(SewerageApplicationDetails sewerageApplicationDetails) {
        return "END".equalsIgnoreCase(sewerageApplicationDetails.getState().getValue()) || "CLOSED".equalsIgnoreCase(sewerageApplicationDetails.getState().getValue());
    }

    public PortalInbox getPortalInbox(String applicationNumber) {
        Module module = this.moduleDao.getModuleByName("Sewerage Tax Management");
        return this.portalInboxService.getPortalInboxByApplicationNo(applicationNumber, module.getId());
    }

    @Transactional
    public void updatePortalMessage(SewerageApplicationDetails sewerageApplicationDetails) {
        String status;
        String url;
        Module module = this.moduleDao.getModuleByName("Sewerage Tax Management");
        SewerageConnection sewerageConnection = sewerageApplicationDetails.getConnection();
        if (sewerageApplicationDetails.getStatus().getCode().equalsIgnoreCase("FEECOLLECTIONPENDING")) {
            url = STMS_APPLICATION_UPDATE;
            status = "Inspection fee paid";
        } else {
            url = STMS_APPLICATION_VIEW;
            status = sewerageApplicationDetails.getStatus().getDescription();
        }
        this.portalInboxService.updateInboxMessage(sewerageApplicationDetails.getApplicationNumber(), module.getId(), status, Boolean.valueOf(this.isResolved(sewerageApplicationDetails)), this.calculateDueDate(sewerageApplicationDetails), sewerageApplicationDetails.getState(), null, sewerageConnection.getShscNumber(), String.format(url, sewerageApplicationDetails.getApplicationNumber(), sewerageApplicationDetails.getConnectionDetail().getPropertyIdentifier()));
    }
}

