/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.transactions.entity;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.egov.commons.EgwStatus;
import org.egov.demand.model.EgDemand;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.pims.commons.Position;
import org.egov.stms.masters.entity.SewerageApplicationType;
import org.egov.stms.notice.entity.SewerageNotice;
import org.egov.stms.transactions.entity.SewerageApplicationDetailsDocument;
import org.egov.stms.transactions.entity.SewerageConnection;
import org.egov.stms.transactions.entity.SewerageConnectionDetail;
import org.egov.stms.transactions.entity.SewerageConnectionEstimationDetails;
import org.egov.stms.transactions.entity.SewerageConnectionFee;
import org.egov.stms.transactions.entity.SewerageDemandConnection;
import org.egov.stms.transactions.entity.SewerageDemandDetail;
import org.egov.stms.transactions.entity.SewerageFieldInspection;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.SafeHtml;

@Entity
@Table(name="egswtax_applicationdetails")
@SequenceGenerator(name="SEQ_EGSWTAX_APPLICATIONDETAILS", sequenceName="SEQ_EGSWTAX_APPLICATIONDETAILS", allocationSize=1)
public class SewerageApplicationDetails
extends StateAware<Position> {
    public static final String SEQ_APPLICATIONDETAILS = "SEQ_EGSWTAX_APPLICATIONDETAILS";
    private static final long serialVersionUID = 734228413287149091L;
    @Id
    @GeneratedValue(generator="SEQ_EGSWTAX_APPLICATIONDETAILS", strategy=GenerationType.SEQUENCE)
    private Long id;
    @ManyToOne
    @NotNull
    @JoinColumn(name="applicationtype", nullable=false)
    private SewerageApplicationType applicationType;
    @ManyToOne(cascade={CascadeType.ALL})
    @Valid
    @NotNull
    @JoinColumn(name="connection", nullable=false)
    private SewerageConnection connection;
    @SafeHtml
    private String applicationNumber;
    @Temporal(value=TemporalType.DATE)
    private Date applicationDate;
    @Temporal(value=TemporalType.DATE)
    private Date disposalDate;
    @ManyToOne
    @JoinColumn(name="status", nullable=false)
    private EgwStatus status;
    @SafeHtml
    @Length(min=3, max=50)
    private String estimationNumber;
    @Temporal(value=TemporalType.DATE)
    private Date estimationDate;
    @SafeHtml
    private String workOrderNumber;
    @Temporal(value=TemporalType.DATE)
    private Date workOrderDate;
    @SafeHtml
    @Length(min=3, max=50)
    private String rejectionNumber;
    @Temporal(value=TemporalType.DATE)
    private Date rejectionDate;
    @SafeHtml
    private String closureNoticeNumber;
    @Temporal(value=TemporalType.DATE)
    private Date closureNoticeDate;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="parent")
    private SewerageApplicationDetails parent;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @NotNull
    @JoinColumn(name="connectiondetail", nullable=false)
    private SewerageConnectionDetail connectionDetail;
    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="filestoreid")
    private FileStoreMapper fileStore;
    private String source;
    @OneToMany(mappedBy="applicationDetails", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private List<SewerageApplicationDetailsDocument> appDetailsDocument = new ArrayList<SewerageApplicationDetailsDocument>(0);
    private boolean isActive;
    @OrderBy(value="id desc")
    @OneToMany(mappedBy="applicationDetails", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private List<SewerageConnectionEstimationDetails> estimationDetails = new ArrayList<SewerageConnectionEstimationDetails>(0);
    @OrderBy(value="id desc")
    @OneToMany(mappedBy="applicationDetails", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private List<SewerageFieldInspection> fieldInspections = new ArrayList<SewerageFieldInspection>();
    @OrderBy(value="id desc")
    @OneToMany(mappedBy="applicationDetails", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private List<SewerageConnectionFee> connectionFees = new ArrayList<SewerageConnectionFee>();
    @OrderBy(value="id desc")
    @OneToMany(mappedBy="applicationDetails", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private List<SewerageDemandConnection> demandConnections = new ArrayList<SewerageDemandConnection>();
    @Transient
    private List<SewerageConnectionEstimationDetails> estimationDetailsForUpdate = new ArrayList<SewerageConnectionEstimationDetails>();
    @OneToMany(mappedBy="applicationDetails", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private Set<SewerageNotice> sewerageNotice = new HashSet<SewerageNotice>();
    @Transient
    private Long approvalDepartment;
    @Transient
    private String approvalComent;
    @Transient
    private String ownerName;
    @Transient
    private List<SewerageDemandDetail> demandDetailBeanList = new ArrayList<SewerageDemandDetail>();
    private String closeConnectionReason;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public SewerageApplicationType getApplicationType() {
        return this.applicationType;
    }

    public void setApplicationType(SewerageApplicationType applicationType) {
        this.applicationType = applicationType;
    }

    public SewerageConnection getConnection() {
        return this.connection;
    }

    public void setConnection(SewerageConnection connection) {
        this.connection = connection;
    }

    public String getApplicationNumber() {
        return this.applicationNumber;
    }

    public void setApplicationNumber(String applicationNumber) {
        this.applicationNumber = applicationNumber;
    }

    public Date getApplicationDate() {
        return this.applicationDate;
    }

    public void setApplicationDate(Date applicationDate) {
        this.applicationDate = applicationDate;
    }

    public Date getDisposalDate() {
        return this.disposalDate;
    }

    public void setDisposalDate(Date disposalDate) {
        this.disposalDate = disposalDate;
    }

    public EgwStatus getStatus() {
        return this.status;
    }

    public void setStatus(EgwStatus status) {
        this.status = status;
    }

    public String getEstimationNumber() {
        return this.estimationNumber;
    }

    public void setEstimationNumber(String estimationNumber) {
        this.estimationNumber = estimationNumber;
    }

    public Date getEstimationDate() {
        return this.estimationDate;
    }

    public void setEstimationDate(Date estimationDate) {
        this.estimationDate = estimationDate;
    }

    public String getWorkOrderNumber() {
        return this.workOrderNumber;
    }

    public void setWorkOrderNumber(String workOrderNumber) {
        this.workOrderNumber = workOrderNumber;
    }

    public Date getWorkOrderDate() {
        return this.workOrderDate;
    }

    public void setWorkOrderDate(Date workOrderDate) {
        this.workOrderDate = workOrderDate;
    }

    public FileStoreMapper getFileStore() {
        return this.fileStore;
    }

    public void setFileStore(FileStoreMapper fileStore) {
        this.fileStore = fileStore;
    }

    public List<SewerageConnectionEstimationDetails> getEstimationDetails() {
        return this.estimationDetails;
    }

    public void setEstimationDetails(List<SewerageConnectionEstimationDetails> estimationDetails) {
        this.estimationDetails = estimationDetails;
    }

    public void deleteEstimationDetails(SewerageConnectionEstimationDetails estimationDetails) {
        if (this.estimationDetails != null && !this.estimationDetails.isEmpty()) {
            this.estimationDetails.remove((Object)estimationDetails);
        }
    }

    public Long getApprovalDepartment() {
        return this.approvalDepartment;
    }

    public void setApprovalDepartment(Long approvalDepartment) {
        this.approvalDepartment = approvalDepartment;
    }

    public String getApprovalComent() {
        return this.approvalComent;
    }

    public void setApprovalComent(String approvalComent) {
        this.approvalComent = approvalComent;
    }

    public String myLinkId() {
        return this.applicationNumber != null ? this.applicationNumber : this.connection.getShscNumber();
    }

    public String getStateDetails() {
        SimpleDateFormat formatter = new SimpleDateFormat("dd-MM-yyyy");
        return String.format("Sewerage Application Number %s with application date %s.", this.applicationNumber != null ? this.applicationNumber : this.connection.getShscNumber(), this.applicationDate != null ? formatter.format(this.applicationDate) : formatter.format(new Date()));
    }

    public List<SewerageConnectionFee> getConnectionFees() {
        return this.connectionFees;
    }

    public void setConnectionFees(List<SewerageConnectionFee> connectionFees) {
        this.connectionFees = connectionFees;
    }

    public void addConnectionFees(SewerageConnectionFee connectionFees) {
        this.connectionFees.add(connectionFees);
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    public List<SewerageFieldInspection> getFieldInspections() {
        return this.fieldInspections;
    }

    public void setFieldInspections(List<SewerageFieldInspection> fieldInspections) {
        this.fieldInspections = fieldInspections;
    }

    public List<SewerageApplicationDetailsDocument> getAppDetailsDocument() {
        return this.appDetailsDocument;
    }

    public void setAppDetailsDocument(List<SewerageApplicationDetailsDocument> appDetailsDocument) {
        this.appDetailsDocument = appDetailsDocument;
    }

    public SewerageApplicationDetails getParent() {
        return this.parent;
    }

    public void setParent(SewerageApplicationDetails parent) {
        this.parent = parent;
    }

    public SewerageConnectionDetail getConnectionDetail() {
        return this.connectionDetail;
    }

    public void setConnectionDetail(SewerageConnectionDetail connectionDetail) {
        this.connectionDetail = connectionDetail;
    }

    public List<SewerageDemandConnection> getDemandConnections() {
        return this.demandConnections;
    }

    public void setDemandConnections(List<SewerageDemandConnection> demandConnections) {
        this.demandConnections = demandConnections;
    }

    public void addDemandConnections(SewerageDemandConnection demandConnections) {
        this.getDemandConnections().add(demandConnections);
    }

    public List<SewerageConnectionEstimationDetails> getEstimationDetailsForUpdate() {
        return this.estimationDetailsForUpdate;
    }

    public void setEstimationDetailsForUpdate(List<SewerageConnectionEstimationDetails> estimationDetailsForUpdate) {
        this.estimationDetailsForUpdate = estimationDetailsForUpdate;
    }

    public EgDemand getCurrentDemand() {
        for (SewerageDemandConnection sdc : this.getDemandConnections()) {
            if (!sdc.getDemand().getIsHistory().equalsIgnoreCase("N")) continue;
            return sdc.getDemand();
        }
        return null;
    }

    public Set<SewerageNotice> getSewerageNotice() {
        return this.sewerageNotice;
    }

    public void setSewerageNotice(Set<SewerageNotice> sewerageNotice) {
        this.sewerageNotice = sewerageNotice;
    }

    public void addNotice(SewerageNotice swNotice) {
        this.getSewerageNotice().add(swNotice);
    }

    public void removeNotice(SewerageNotice swNotice) {
        this.getSewerageNotice().remove(swNotice);
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public List<SewerageDemandDetail> getDemandDetailBeanList() {
        return this.demandDetailBeanList;
    }

    public void setDemandDetailBeanList(List<SewerageDemandDetail> demandDetailBeanList) {
        this.demandDetailBeanList = demandDetailBeanList;
    }

    public String getCloseConnectionReason() {
        return this.closeConnectionReason;
    }

    public void setCloseConnectionReason(String closeConnectionReason) {
        this.closeConnectionReason = closeConnectionReason;
    }

    public String getClosureNoticeNumber() {
        return this.closureNoticeNumber;
    }

    public void setClosureNoticeNumber(String closureNoticeNumber) {
        this.closureNoticeNumber = closureNoticeNumber;
    }

    public Date getClosureNoticeDate() {
        return this.closureNoticeDate;
    }

    public void setClosureNoticeDate(Date closureNoticeDate) {
        this.closureNoticeDate = closureNoticeDate;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getRejectionNumber() {
        return this.rejectionNumber;
    }

    public void setRejectionNumber(String rejectionNumber) {
        this.rejectionNumber = rejectionNumber;
    }

    public Date getRejectionDate() {
        return this.rejectionDate;
    }

    public void setRejectionDate(Date rejectionDate) {
        this.rejectionDate = rejectionDate;
    }

    public static enum WorkFlowState {
        CREATED,
        CHECKED,
        APPROVED,
        REJECTED,
        CANCELLED;

    }
}

