/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.transactions.charges;

import java.math.BigDecimal;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.stms.masters.entity.enums.PropertyType;
import org.egov.stms.masters.service.DonationMasterService;
import org.egov.stms.masters.service.SewerageRatesMasterService;
import org.egov.stms.transactions.charges.SewerageChargeCalculationService;
import org.egov.stms.transactions.entity.SewerageApplicationDetails;
import org.egov.stms.transactions.entity.SewerageConnectionDetail;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SewerageChargeCalculationServiceImpl
implements SewerageChargeCalculationService {
    @Autowired
    private DonationMasterService donationMasterService;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private SewerageRatesMasterService sewerageRatesMasterService;

    @Override
    public BigDecimal calculateDonationCharges(SewerageApplicationDetails sewerageApplicationDetails) {
        BigDecimal amount = BigDecimal.ZERO;
        if (sewerageApplicationDetails.getConnection() != null && sewerageApplicationDetails.getConnectionDetail() != null) {
            SewerageConnectionDetail sewerageConnectionDetail = sewerageApplicationDetails.getConnectionDetail();
            if (sewerageConnectionDetail != null && sewerageConnectionDetail.getPropertyType().equals((Object)PropertyType.MIXED)) {
                BigDecimal amountForResidential = this.donationMasterService.getDonationAmountByNoOfClosetsAndPropertytypeForCurrentDate(sewerageConnectionDetail.getNoOfClosetsResidential(), PropertyType.RESIDENTIAL);
                BigDecimal amountForNonResidential = this.donationMasterService.getDonationAmountByNoOfClosetsAndPropertytypeForCurrentDate(sewerageConnectionDetail.getNoOfClosetsNonResidential(), PropertyType.NON_RESIDENTIAL);
                if (amountForResidential != null) {
                    return amountForNonResidential != null ? amountForResidential.add(amountForNonResidential) : amountForResidential;
                }
                return amountForNonResidential != null ? amountForNonResidential : BigDecimal.ZERO;
            }
            Integer noOfClosets = sewerageConnectionDetail.getPropertyType().equals((Object)PropertyType.RESIDENTIAL) ? sewerageConnectionDetail.getNoOfClosetsResidential() : (sewerageConnectionDetail.getPropertyType().equals((Object)PropertyType.NON_RESIDENTIAL) ? sewerageConnectionDetail.getNoOfClosetsNonResidential() : 0);
            amount = this.donationMasterService.getDonationAmountByNoOfClosetsAndPropertytypeForCurrentDate(noOfClosets, sewerageConnectionDetail.getPropertyType());
        }
        return amount != null ? amount : BigDecimal.ZERO;
    }

    @Override
    public BigDecimal calculateSewerageCharges(SewerageApplicationDetails sewerageApplicationDetails) {
        SewerageConnectionDetail sewerageConnectionDetail;
        Integer numberOfInstallments = 1;
        BigDecimal sewerateRate = BigDecimal.ZERO;
        Double monthlyRateAmount = 0.0;
        if (sewerageApplicationDetails.getConnection() != null && sewerageApplicationDetails.getConnectionDetail() != null && (sewerageConnectionDetail = sewerageApplicationDetails.getConnectionDetail()) != null) {
            AppConfigValues showmonthlyrates;
            AppConfigValues advanceSewerageTaxInmonths = (AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey("Sewerage Tax Management", "SEWERAGE_ADVANCESEWERAGETAX_INMONTHS").get(0);
            if (advanceSewerageTaxInmonths != null && advanceSewerageTaxInmonths.getValue() != null && !"".equals(advanceSewerageTaxInmonths.getValue()) && (numberOfInstallments = Integer.valueOf(advanceSewerageTaxInmonths.getValue())) == 0) {
                numberOfInstallments = 1;
            }
            if ((showmonthlyrates = this.sewerageRatesMasterService.getAppConfigValuesForSeweargeRate("Sewerage Tax Management", "SEWERAGE MONTHLY RATES BY MULTIPLE CLOSETS")) != null && showmonthlyrates.getValue().equalsIgnoreCase("YES")) {
                if (sewerageConnectionDetail.getPropertyType().equals((Object)PropertyType.MIXED)) {
                    Integer noOfClosets = sewerageConnectionDetail.getNoOfClosetsResidential();
                    monthlyRateAmount = this.sewerageRatesMasterService.getSewerageMonthlyRatesByPropertytype(sewerageConnectionDetail.getNoOfClosetsResidential(), PropertyType.RESIDENTIAL);
                    if (monthlyRateAmount != null) {
                        sewerateRate = BigDecimal.valueOf((double)numberOfInstallments.intValue() * monthlyRateAmount);
                    }
                    noOfClosets = sewerageConnectionDetail.getNoOfClosetsNonResidential();
                    monthlyRateAmount = this.sewerageRatesMasterService.getSewerageMonthlyRatesByPropertytype(sewerageConnectionDetail.getNoOfClosetsNonResidential(), PropertyType.NON_RESIDENTIAL);
                    if (monthlyRateAmount != null) {
                        sewerateRate = sewerateRate.add(BigDecimal.valueOf((double)numberOfInstallments.intValue() * monthlyRateAmount));
                    }
                    return sewerateRate;
                }
                Integer noOfClosets = sewerageConnectionDetail.getPropertyType().equals((Object)PropertyType.RESIDENTIAL) ? sewerageConnectionDetail.getNoOfClosetsResidential() : (sewerageConnectionDetail.getPropertyType().equals((Object)PropertyType.NON_RESIDENTIAL) ? sewerageConnectionDetail.getNoOfClosetsNonResidential() : 0);
                monthlyRateAmount = this.sewerageRatesMasterService.getSewerageMonthlyRatesByPropertytype(noOfClosets, sewerageConnectionDetail.getPropertyType());
                if (monthlyRateAmount != null) {
                    sewerateRate = BigDecimal.valueOf((double)numberOfInstallments.intValue() * monthlyRateAmount);
                }
            } else {
                if (sewerageConnectionDetail.getPropertyType().equals((Object)PropertyType.MIXED)) {
                    Integer noOfClosets = sewerageConnectionDetail.getNoOfClosetsResidential();
                    monthlyRateAmount = this.sewerageRatesMasterService.getSewerageMonthlyRatesByPropertytype(PropertyType.RESIDENTIAL);
                    if (monthlyRateAmount != null) {
                        sewerateRate = BigDecimal.valueOf((double)(numberOfInstallments * noOfClosets) * monthlyRateAmount);
                    }
                    noOfClosets = sewerageConnectionDetail.getNoOfClosetsNonResidential();
                    monthlyRateAmount = this.sewerageRatesMasterService.getSewerageMonthlyRatesByPropertytype(PropertyType.NON_RESIDENTIAL);
                    if (monthlyRateAmount != null) {
                        sewerateRate = sewerateRate.add(BigDecimal.valueOf((double)(numberOfInstallments * noOfClosets) * monthlyRateAmount));
                    }
                    return sewerateRate;
                }
                Integer noOfClosets = sewerageConnectionDetail.getPropertyType().equals((Object)PropertyType.RESIDENTIAL) ? sewerageConnectionDetail.getNoOfClosetsResidential() : (sewerageConnectionDetail.getPropertyType().equals((Object)PropertyType.NON_RESIDENTIAL) ? sewerageConnectionDetail.getNoOfClosetsNonResidential() : 0);
                monthlyRateAmount = this.sewerageRatesMasterService.getSewerageMonthlyRatesByPropertytype(sewerageConnectionDetail.getPropertyType());
                if (monthlyRateAmount != null) {
                    sewerateRate = BigDecimal.valueOf((double)numberOfInstallments.intValue() * monthlyRateAmount * (double)noOfClosets.intValue());
                }
            }
        }
        return sewerateRate != null ? sewerateRate : BigDecimal.ZERO;
    }
}

