/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.service.es;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.utils.DateUtils;
import org.egov.stms.elasticsearch.entity.SewerageCollectFeeSearchRequest;
import org.egov.stms.elasticsearch.entity.SewerageConnSearchRequest;
import org.egov.stms.elasticsearch.entity.SewerageNoticeSearchRequest;
import org.egov.stms.elasticsearch.entity.SewerageSearchResult;
import org.egov.stms.entity.es.SewerageIndex;
import org.egov.stms.service.es.SewerageIndexService;
import org.egov.stms.transactions.entity.SewerageApplicationDetails;
import org.egov.stms.transactions.service.SewerageApplicationDetailsService;
import org.egov.stms.utils.SewerageActionDropDownUtil;
import org.egov.stms.utils.SewerageTaxUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class SeweragePaginationService {
    private static final String SHSC_NUMBER = "shscNumber";
    private static final String YYYY_MM_DD = "yyyy-MM-dd";
    @Autowired
    private SewerageIndexService sewerageIndexService;
    @Autowired
    private SewerageApplicationDetailsService sewerageApplicationDetailsService;
    @Autowired
    private SewerageTaxUtils sewerageTaxUtils;

    public Page<SewerageIndex> searchResultObj(SewerageConnSearchRequest searchRequest, List<SewerageSearchResult> searchResultFomatted) {
        HashMap<String, String> actionMap = new HashMap<String, String>();
        ArrayList<String> roleList = new ArrayList<String>();
        BoolQueryBuilder boolQuery = this.sewerageIndexService.getQueryFilter(searchRequest);
        for (Role userRole : this.sewerageTaxUtils.getLoginUserRoles()) {
            roleList.add(userRole.getName());
        }
        SewerageApplicationDetails sewerageApplicationDetails = null;
        SewerageSearchResult searchActions = null;
        FieldSortBuilder sort = new FieldSortBuilder(SHSC_NUMBER).order(SortOrder.DESC);
        Page<SewerageIndex> searchResult = this.sewerageIndexService.getSearchResultByBoolQuery(boolQuery, sort, searchRequest);
        for (SewerageIndex sewerageIndexObject : searchResult) {
            SewerageSearchResult searchResultObject = new SewerageSearchResult();
            this.buildSearchResult(sewerageIndexObject, searchResultObject);
            if (sewerageIndexObject.getApplicationNumber() != null) {
                sewerageApplicationDetails = this.sewerageApplicationDetailsService.findByApplicationNumber(sewerageIndexObject.getApplicationNumber());
            }
            if (sewerageApplicationDetails != null) {
                searchActions = SewerageActionDropDownUtil.getSearchResultWithActions(roleList, sewerageIndexObject.getApplicationStatus(), sewerageApplicationDetails);
            }
            if (searchActions != null && searchActions.getActions() != null) {
                this.getActions(searchActions, actionMap, searchRequest);
            }
            searchResultObject.setActions(actionMap);
            searchResultFomatted.add(searchResultObject);
        }
        return searchResult;
    }

    private void buildSearchResult(SewerageIndex sewerageIndexObject, SewerageSearchResult searchResultObject) {
        searchResultObject.setApplicationNumber(sewerageIndexObject.getApplicationNumber());
        searchResultObject.setAssessmentNumber(sewerageIndexObject.getPropertyIdentifier());
        searchResultObject.setShscNumber(sewerageIndexObject.getShscNumber());
        searchResultObject.setApplicantName(sewerageIndexObject.getConsumerName());
        searchResultObject.setApplicationType(sewerageIndexObject.getApplicationType());
        searchResultObject.setPropertyType(sewerageIndexObject.getPropertyType().replace("_", " "));
        searchResultObject.setRevenueWard(sewerageIndexObject.getWard());
        searchResultObject.setAddress(sewerageIndexObject.getAddress());
        searchResultObject.setApplicationStatus(sewerageIndexObject.getApplicationStatus());
    }

    private void getActions(SewerageSearchResult searchActions, Map<String, String> actionMap, SewerageConnSearchRequest searchRequest) {
        for (Map.Entry<String, String> entry : searchActions.getActions().entrySet()) {
            if (entry.getValue().equals("Modify Legacy Connection") && searchRequest.getLegacy() == null) {
                actionMap.remove(entry.getKey(), entry.getValue());
                continue;
            }
            if (entry.getValue().equals("Collect Fee")) continue;
            actionMap.put(entry.getKey(), entry.getValue());
        }
    }

    public Page<SewerageIndex> sewerageCollectSearchObj(SewerageCollectFeeSearchRequest searchRequest, List<SewerageSearchResult> searchResultList, List<String> roleList, Map<String, String> actionMap) {
        BoolQueryBuilder boolQuery = this.sewerageIndexService.getSearchQueryFilter(searchRequest);
        FieldSortBuilder sort = new FieldSortBuilder(SHSC_NUMBER).order(SortOrder.DESC);
        SewerageApplicationDetails sewerageApplicationDetails = null;
        Page<SewerageIndex> resultList = this.sewerageIndexService.getCollectSearchResult(boolQuery, sort, searchRequest);
        for (SewerageIndex sewerageIndex : resultList) {
            SewerageSearchResult searchResult = new SewerageSearchResult();
            this.buildSearchResult(sewerageIndex, searchResult);
            if (sewerageIndex.getApplicationNumber() != null) {
                sewerageApplicationDetails = this.sewerageApplicationDetailsService.findByApplicationNumber(sewerageIndex.getApplicationNumber());
            }
            for (Role role : this.sewerageTaxUtils.getLoginUserRoles()) {
                roleList.add(role.getName());
            }
            if (sewerageApplicationDetails != null && ("COLLECTINSPECTIONFEE".equals(sewerageApplicationDetails.getStatus().getCode()) || "ESTIMATIONNOTICEGENERATED".equals(sewerageApplicationDetails.getStatus().getCode()) || "SANCTIONED".equalsIgnoreCase(sewerageApplicationDetails.getStatus().getCode()) && sewerageApplicationDetails.getCurrentDemand() != null)) {
                SewerageSearchResult searchActions = SewerageActionDropDownUtil.getSearchResultWithActions(roleList, sewerageIndex.getApplicationStatus(), sewerageApplicationDetails);
                if (searchActions != null && searchActions.getActions() != null) {
                    for (Map.Entry<String, String> entry : searchActions.getActions().entrySet()) {
                        if (!"Collect Fee".equals(entry.getValue())) continue;
                        actionMap.put(entry.getKey(), entry.getValue());
                    }
                }
                searchResult.setActions(actionMap);
            }
            searchResultList.add(searchResult);
        }
        return resultList;
    }

    public Pageable sewerageNoticeSearch(SewerageNoticeSearchRequest searchRequest, List<SewerageSearchResult> searchResultFomatted, Page<SewerageIndex> searchResult) {
        PageRequest pageable = new PageRequest(searchRequest.pageNumber(), searchRequest.pageSize(), searchRequest.orderDir(), new String[]{searchRequest.orderBy()});
        for (SewerageIndex sewerageIndexObject : searchResult) {
            SewerageSearchResult searchResultObject = new SewerageSearchResult();
            searchResultObject.setApplicationNumber(sewerageIndexObject.getApplicationNumber());
            if (searchRequest.getNoticeType() != null) {
                if (searchRequest.getNoticeType().equals("WO")) {
                    searchResultObject.setNoticeNumber(sewerageIndexObject.getWorkOrderNumber());
                    searchResultObject.setNoticeDate(DateUtils.getFormattedDate((Date)sewerageIndexObject.getWorkOrderDate(), (String)YYYY_MM_DD));
                } else if (searchRequest.getNoticeType().equals("EM")) {
                    searchResultObject.setNoticeNumber(sewerageIndexObject.getEstimationNumber());
                    searchResultObject.setNoticeDate(DateUtils.getFormattedDate((Date)sewerageIndexObject.getEstimationDate(), (String)YYYY_MM_DD));
                } else if (searchRequest.getNoticeType().equals("CC")) {
                    searchResultObject.setNoticeNumber(sewerageIndexObject.getClosureNoticeNumber());
                    searchResultObject.setNoticeDate(DateUtils.getFormattedDate((Date)sewerageIndexObject.getClosureNoticeDate(), (String)YYYY_MM_DD));
                } else if (searchRequest.getNoticeType().equals("RN")) {
                    searchResultObject.setNoticeNumber(sewerageIndexObject.getRejectionNoticeNumber());
                    searchResultObject.setNoticeDate(DateUtils.getFormattedDate((Date)sewerageIndexObject.getRejectionNoticeDate(), (String)YYYY_MM_DD));
                }
            }
            searchResultObject.setShscNumber(sewerageIndexObject.getShscNumber());
            searchResultObject.setDoorNumber(sewerageIndexObject.getDoorNo());
            searchResultObject.setAddress(sewerageIndexObject.getAddress());
            searchResultObject.setApplicantName(sewerageIndexObject.getConsumerName());
            searchResultFomatted.add(searchResultObject);
        }
        return pageable;
    }

    public Page<SewerageIndex> buildPaymentSearch(SewerageConnSearchRequest sewerageConnSearchRequest, List<SewerageSearchResult> searchResultList) {
        BoolQueryBuilder boolQuery = this.sewerageIndexService.getQueryFilter(sewerageConnSearchRequest);
        FieldSortBuilder sort = new FieldSortBuilder(SHSC_NUMBER).order(SortOrder.DESC);
        Page<SewerageIndex> resultList = this.sewerageIndexService.getOnlinePaymentSearchResult(boolQuery, sort, sewerageConnSearchRequest);
        for (SewerageIndex sewerageIndex : resultList) {
            SewerageSearchResult searchResult = new SewerageSearchResult();
            searchResult.setApplicationNumber(sewerageIndex.getApplicationNumber());
            searchResult.setAssessmentNumber(sewerageIndex.getPropertyIdentifier());
            searchResult.setShscNumber(sewerageIndex.getShscNumber());
            searchResult.setApplicantName(sewerageIndex.getConsumerName());
            searchResultList.add(searchResult);
        }
        return resultList;
    }
}

