/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.service.es;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.egov.collection.entity.es.CollectionDocument;
import org.egov.collection.repository.es.CollectionDocumentRepository;
import org.egov.commons.dao.InstallmentDao;
import org.egov.commons.entity.Source;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.utils.DateUtils;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.OwnerName;
import org.egov.stms.elasticsearch.entity.DailySTCollectionReportSearch;
import org.egov.stms.elasticsearch.entity.SewerageBulkExecutionResponse;
import org.egov.stms.elasticsearch.entity.SewerageCollectFeeSearchRequest;
import org.egov.stms.elasticsearch.entity.SewerageConnSearchRequest;
import org.egov.stms.elasticsearch.entity.SewerageExecutionResult;
import org.egov.stms.elasticsearch.entity.SewerageNoticeSearchRequest;
import org.egov.stms.entity.es.SewerageIndex;
import org.egov.stms.masters.entity.enums.SewerageConnectionStatus;
import org.egov.stms.masters.pojo.SewerageRateDCBResult;
import org.egov.stms.reports.entity.SewerageBaseRegisterResult;
import org.egov.stms.reports.entity.SewerageNoOfConnReportResult;
import org.egov.stms.repository.es.SewerageIndexRepository;
import org.egov.stms.transactions.entity.SewerageApplicationDetails;
import org.egov.stms.transactions.entity.SewerageConnectionFee;
import org.egov.stms.transactions.service.SewerageApplicationDetailsService;
import org.egov.stms.transactions.service.SewerageDCBReporService;
import org.egov.stms.transactions.service.SewerageDemandService;
import org.egov.stms.utils.SewerageTaxUtils;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsBuilder;
import org.elasticsearch.search.aggregations.metrics.sum.Sum;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.joda.time.DateTime;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class SewerageIndexService {
    private static final String APPLICATION_TYPE = "applicationType";
    private static final String DESC = "desc";
    private static final String TOTALDEMAND_AMOUNT_SUM = "totaldemandAmountSum";
    private static final String DEMAND_AMOUNT_SUM = "demandAmountSum";
    private static final String ARREARSSUM = "arrearssum";
    private static final String PROPERTY_TYPE = "propertyType";
    private static final String WARD = "ward";
    private static final String ACTIVE = "active";
    private static final String SEWERAGE = "sewerage";
    private static final String APPLICATION_DATE = "applicationDate";
    private static final String COLLECTED_ARREAR_AMOUNT = "collectedArrearAmount";
    private static final String EXTRA_ADVANCE_AMOUNT = "extraAdvanceAmount";
    private static final String COLLECTED_DEMAND_AMOUNT = "collectedDemandAmount";
    private static final String DOOR_NO = "doorNo";
    private static final String MOBILE_NUMBER = "mobileNumber";
    private static final String CONSUMER_NAME = "consumerName";
    private static final String SHSC_NUMBER = "shscNumber";
    private static final String CONSUMER_NUMBER = "consumerNumber";
    private static final String ULB_NAME = "ulbName";
    private static final String APPLICATION_STARTDATE = "1998-04-01T00:00:00.000Z";
    private static final String EXECUTION_DATE = "executionDate";
    @Autowired
    private CityService cityService;
    @Autowired
    private SewerageIndexRepository sewerageIndexRepository;
    @Autowired
    private CollectionDocumentRepository collectionDocumentRepository;
    @Autowired
    private ElasticsearchTemplate elasticsearchTemplate;
    @Autowired
    private SewerageApplicationDetailsService sewerageApplicationDetailsService;
    @Autowired
    private SewerageDemandService sewerageDemandService;
    @Autowired
    private SewerageDCBReporService sewerageDCBReporService;
    @Autowired
    private InstallmentDao installmentDao;
    @Autowired
    private ModuleService moduleDao;
    @Autowired
    private SewerageTaxUtils sewerageTaxUtils;

    public SewerageIndex createSewarageIndex(SewerageApplicationDetails sewerageApplicationDetails, AssessmentDetails assessmentDetails) {
        City cityWebsite = this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName());
        SewerageIndex sewarageIndex = new SewerageIndex();
        sewarageIndex.setUlbName(cityWebsite.getName());
        sewarageIndex.setDistrictName(cityWebsite.getDistrictName());
        sewarageIndex.setRegionName(cityWebsite.getRegionName());
        sewarageIndex.setUlbGrade(cityWebsite.getGrade());
        sewarageIndex.setUlbCode(cityWebsite.getCode());
        sewarageIndex.setApplicationCreatedBy(sewerageApplicationDetails.getCreatedBy().getName());
        sewarageIndex.setId(cityWebsite.getCode().concat("-").concat(sewerageApplicationDetails.getApplicationNumber()));
        sewarageIndex.setApplicationDate(sewerageApplicationDetails.getApplicationDate());
        sewarageIndex.setApplicationNumber(sewerageApplicationDetails.getApplicationNumber());
        sewarageIndex.setApplicationStatus(sewerageApplicationDetails.getStatus() != null ? sewerageApplicationDetails.getStatus().getDescription() : "");
        sewarageIndex.setConsumerNumber(sewerageApplicationDetails.getApplicationNumber());
        sewarageIndex.setApplicationType(sewerageApplicationDetails.getApplicationType() != null ? sewerageApplicationDetails.getApplicationType().getName() : "");
        sewarageIndex.setConnectionStatus(sewerageApplicationDetails.getConnection().getStatus() != null ? sewerageApplicationDetails.getConnection().getStatus().name() : "");
        sewarageIndex.setCreatedDate(sewerageApplicationDetails.getCreatedDate());
        sewarageIndex.setShscNumber(sewerageApplicationDetails.getConnection().getShscNumber() != null ? sewerageApplicationDetails.getConnection().getShscNumber() : "");
        sewarageIndex.setDisposalDate(sewerageApplicationDetails.getDisposalDate());
        sewarageIndex.setExecutionDate(sewerageApplicationDetails.getConnection().getExecutionDate());
        sewarageIndex.setIslegacy(sewerageApplicationDetails.getConnection().getLegacy());
        sewarageIndex.setNoOfClosets_nonResidential(sewerageApplicationDetails.getConnectionDetail().getNoOfClosetsNonResidential());
        sewarageIndex.setNoOfClosets_residential(sewerageApplicationDetails.getConnectionDetail().getNoOfClosetsResidential());
        sewarageIndex.setPropertyIdentifier(sewerageApplicationDetails.getConnectionDetail().getPropertyIdentifier() != null ? sewerageApplicationDetails.getConnectionDetail().getPropertyIdentifier() : "");
        sewarageIndex.setPropertyType(sewerageApplicationDetails.getConnectionDetail().getPropertyType() != null ? sewerageApplicationDetails.getConnectionDetail().getPropertyType().name() : "");
        if (sewerageApplicationDetails.getEstimationDate() != null) {
            sewarageIndex.setEstimationDate(sewerageApplicationDetails.getEstimationDate());
        }
        sewarageIndex.setEstimationNumber(sewerageApplicationDetails.getEstimationNumber() != null ? sewerageApplicationDetails.getEstimationNumber() : "");
        if (sewerageApplicationDetails.getWorkOrderDate() != null) {
            sewarageIndex.setWorkOrderDate(sewerageApplicationDetails.getWorkOrderDate());
        }
        sewarageIndex.setWorkOrderNumber(sewerageApplicationDetails.getWorkOrderNumber() != null ? sewerageApplicationDetails.getWorkOrderNumber() : "");
        if (sewerageApplicationDetails.getClosureNoticeDate() != null) {
            sewarageIndex.setClosureNoticeDate(sewerageApplicationDetails.getClosureNoticeDate());
        }
        sewarageIndex.setClosureNoticeNumber(sewerageApplicationDetails.getClosureNoticeNumber() != null ? sewerageApplicationDetails.getClosureNoticeNumber() : "");
        if (sewerageApplicationDetails.getRejectionDate() != null) {
            sewarageIndex.setRejectionNoticeDate(sewerageApplicationDetails.getRejectionDate());
        }
        sewarageIndex.setRejectionNoticeNumber(sewerageApplicationDetails.getRejectionNumber() != null ? sewerageApplicationDetails.getRejectionNumber() : "");
        Iterator ownerNameItr = null;
        if (null != assessmentDetails.getOwnerNames()) {
            ownerNameItr = assessmentDetails.getOwnerNames().iterator();
        }
        StringBuilder consumerName = new StringBuilder();
        StringBuilder mobileNumber = new StringBuilder();
        if (null != ownerNameItr && ownerNameItr.hasNext()) {
            OwnerName primaryOwner = (OwnerName)ownerNameItr.next();
            consumerName.append(primaryOwner.getOwnerName() != null ? primaryOwner.getOwnerName() : "");
            mobileNumber.append(primaryOwner.getMobileNumber() != null ? primaryOwner.getMobileNumber() : "");
            while (ownerNameItr.hasNext()) {
                OwnerName secondaryOwner = (OwnerName)ownerNameItr.next();
                consumerName.append(",").append(secondaryOwner.getOwnerName() != null ? secondaryOwner.getOwnerName() : "");
                mobileNumber.append(",").append(secondaryOwner.getMobileNumber() != null ? secondaryOwner.getMobileNumber() : "");
            }
        }
        sewarageIndex.setMobileNumber(mobileNumber.toString());
        sewarageIndex.setConsumerName(consumerName.toString());
        sewarageIndex.setDoorNo(assessmentDetails.getHouseNo() != null ? assessmentDetails.getHouseNo() : "");
        sewarageIndex.setWard(assessmentDetails.getBoundaryDetails() != null ? assessmentDetails.getBoundaryDetails().getWardName() : "");
        sewarageIndex.setRevenueBlock(assessmentDetails.getBoundaryDetails() != null ? assessmentDetails.getBoundaryDetails().getBlockName() : "");
        sewarageIndex.setLocationName(assessmentDetails.getBoundaryDetails() != null ? assessmentDetails.getBoundaryDetails().getLocalityName() : "");
        sewarageIndex.setAddress(assessmentDetails.getPropertyAddress() != null ? assessmentDetails.getPropertyAddress() : "");
        sewarageIndex.setSource(sewerageApplicationDetails.getSource() != null ? sewerageApplicationDetails.getSource() : Source.SYSTEM.toString());
        sewarageIndex.setActive(sewerageApplicationDetails.isActive());
        for (SewerageConnectionFee scf : sewerageApplicationDetails.getConnectionFees()) {
            if (scf.getFeesDetail().getCode().equals("SEWERAGETAX")) {
                sewarageIndex.setSewerageTax(BigDecimal.valueOf(scf.getAmount()));
            }
            if (scf.getFeesDetail().getCode().equals("DONATIONCHARGE")) {
                sewarageIndex.setDonationAmount(BigDecimal.valueOf(scf.getAmount()));
            }
            if (scf.getFeesDetail().getCode().equals("INSPECTIONCHARGE")) {
                sewarageIndex.setInspectionCharge(BigDecimal.valueOf(scf.getAmount()));
            }
            if (!scf.getFeesDetail().getCode().equals("ESTIMATIONCHARGE")) continue;
            sewarageIndex.setEstimationCharge(BigDecimal.valueOf(scf.getAmount()));
        }
        List<SewerageRateDCBResult> rateResultList = this.sewerageDCBReporService.getSewerageRateDCBReport(sewerageApplicationDetails);
        Date currentInstallmentYear = this.sewerageDemandService.getCurrentInstallment().getInstallmentYear();
        BigDecimal totalDemandAmount = BigDecimal.ZERO;
        BigDecimal totalCollectedDemandamount = BigDecimal.ZERO;
        BigDecimal totalArrearamount = BigDecimal.ZERO;
        BigDecimal totalCollectedArearamount = BigDecimal.ZERO;
        GregorianCalendar calendar = new GregorianCalendar();
        for (SewerageRateDCBResult demand : rateResultList) {
            int year;
            Date installmentYear = this.installmentDao.getInsatllmentByModuleAndDescription(this.moduleDao.getModuleByName("Sewerage Tax Management"), demand.getInstallmentYearDescription()).getInstallmentYear();
            String period = null;
            if (sewerageApplicationDetails.getConnection().getExecutionDate() != null) {
                calendar.setTime(sewerageApplicationDetails.getConnection().getExecutionDate());
            }
            sewarageIndex.setPeriod((period = (year = calendar.get(1)) + "-" + demand.getInstallmentYearDescription().substring(5, 9)) != null ? period : "");
            if (installmentYear.equals(currentInstallmentYear) || installmentYear.after(currentInstallmentYear)) {
                totalDemandAmount = totalDemandAmount.add(demand.getDemandAmount());
                totalCollectedDemandamount = totalCollectedDemandamount.add(demand.getCollectedDemandAmount());
            }
            if (installmentYear.before(currentInstallmentYear)) {
                totalArrearamount = totalArrearamount.add(demand.getDemandAmount());
                totalCollectedArearamount = totalCollectedArearamount.add(demand.getCollectedDemandAmount());
            }
            if (demand.getCollectedAdvanceAmount() == null) continue;
            sewarageIndex.setExtraAdvanceAmount(demand.getCollectedAdvanceAmount());
        }
        sewarageIndex.setDemandAmount(totalDemandAmount != null ? totalDemandAmount : BigDecimal.ZERO);
        sewarageIndex.setCollectedDemandAmount(totalCollectedDemandamount != null ? totalCollectedDemandamount : BigDecimal.ZERO);
        sewarageIndex.setArrearAmount(totalArrearamount != null ? totalArrearamount : BigDecimal.ZERO);
        sewarageIndex.setCollectedArrearAmount(totalCollectedArearamount != null ? totalCollectedArearamount : BigDecimal.ZERO);
        sewarageIndex.setTotalAmount(totalDemandAmount.add(totalArrearamount));
        this.sewerageIndexRepository.save(sewarageIndex);
        return sewarageIndex;
    }

    public BoolQueryBuilder getQueryFilter(SewerageConnSearchRequest searchRequest) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.matchQuery((String)ACTIVE, (Object)true));
        if (StringUtils.isNotBlank((String)searchRequest.getUlbName())) {
            boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)ULB_NAME, (Object)searchRequest.getUlbName()));
        }
        if (StringUtils.isNotBlank((String)searchRequest.getConsumerNumber())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)CONSUMER_NUMBER, (Object)searchRequest.getConsumerNumber()));
        }
        if (StringUtils.isNotBlank((String)searchRequest.getShscNumber())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)SHSC_NUMBER, (Object)searchRequest.getShscNumber()));
        }
        if (StringUtils.isNotBlank((String)searchRequest.getApplicantName())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)CONSUMER_NAME, (Object)searchRequest.getApplicantName()));
        }
        if (StringUtils.isNotBlank((String)searchRequest.getMobileNumber())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)MOBILE_NUMBER, (Object)searchRequest.getMobileNumber()));
        }
        if (StringUtils.isNotBlank((String)searchRequest.getRevenueWard())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)WARD, (Object)searchRequest.getRevenueWard()));
        }
        if (StringUtils.isNotBlank((String)searchRequest.getDoorNumber())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)DOOR_NO, (Object)searchRequest.getDoorNumber()));
        }
        if (searchRequest.getLegacy() != null) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"islegacy", (Object)searchRequest.getLegacy()));
        }
        return boolQuery;
    }

    public Page<SewerageIndex> getSearchResultByBoolQuery(BoolQueryBuilder boolQuery, FieldSortBuilder sort, SewerageConnSearchRequest searchRequest) {
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{SEWERAGE}).withQuery((QueryBuilder)boolQuery).withPageable((Pageable)new PageRequest(searchRequest.pageNumber(), searchRequest.pageSize(), searchRequest.orderDir(), new String[]{searchRequest.orderBy()})).withSort((SortBuilder)sort).build();
        Page resultList = this.elasticsearchTemplate.queryForPage((SearchQuery)searchQuery, SewerageIndex.class);
        return resultList;
    }

    public BoolQueryBuilder getSearchQueryFilter(SewerageCollectFeeSearchRequest searchRequest) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.matchQuery((String)ULB_NAME, (Object)searchRequest.getUlbName()));
        if (StringUtils.isNotBlank((String)searchRequest.getConsumerNumber())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)CONSUMER_NUMBER, (Object)searchRequest.getConsumerNumber()));
        }
        if (StringUtils.isNotBlank((String)searchRequest.getShscNumber())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)SHSC_NUMBER, (Object)searchRequest.getShscNumber()));
        }
        if (StringUtils.isNotBlank((String)searchRequest.getApplicantName())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)CONSUMER_NAME, (Object)searchRequest.getApplicantName()));
        }
        if (StringUtils.isNotBlank((String)searchRequest.getMobileNumber())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)MOBILE_NUMBER, (Object)searchRequest.getMobileNumber()));
        }
        if (StringUtils.isNotBlank((String)searchRequest.getRevenueWard())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)WARD, (Object)searchRequest.getRevenueWard()));
        }
        if (StringUtils.isNotBlank((String)searchRequest.getDoorNumber())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)DOOR_NO, (Object)searchRequest.getDoorNumber()));
        }
        return boolQuery;
    }

    public BoolQueryBuilder getSearchQueryForExecuteConnection(SewerageExecutionResult sewerageExecutionResult) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.matchQuery((String)ULB_NAME, (Object)sewerageExecutionResult.getUlbName()));
        if (StringUtils.isNotBlank((String)sewerageExecutionResult.getRevenueWard())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)WARD, (Object)sewerageExecutionResult.getRevenueWard()));
        }
        if (StringUtils.isNotBlank((String)sewerageExecutionResult.getApplicationNumber())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)CONSUMER_NUMBER, (Object)sewerageExecutionResult.getApplicationNumber()));
        }
        if (StringUtils.isNotBlank((String)sewerageExecutionResult.getShscNumber())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)SHSC_NUMBER, (Object)sewerageExecutionResult.getShscNumber()));
        }
        if (StringUtils.isNotBlank((String)sewerageExecutionResult.getApplicationType())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)APPLICATION_TYPE, (Object)sewerageExecutionResult.getApplicationType()));
        }
        if (StringUtils.isNotBlank((String)sewerageExecutionResult.getFromDate()) && StringUtils.isNotBlank((String)sewerageExecutionResult.getToDate())) {
            boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)APPLICATION_DATE).from(DateUtils.startOfGivenDate((DateTime)DateUtils.toDateTimeUsingDefaultPattern((String)sewerageExecutionResult.getFromDate())).toString("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")).to(DateUtils.endOfGivenDate((DateTime)DateUtils.toDateTimeUsingDefaultPattern((String)sewerageExecutionResult.getToDate())).toString("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")));
        } else if (StringUtils.isNotBlank((String)sewerageExecutionResult.getFromDate())) {
            boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)APPLICATION_DATE).from(DateUtils.startOfGivenDate((DateTime)DateUtils.toDateTimeUsingDefaultPattern((String)sewerageExecutionResult.getFromDate())).toString("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")).to(DateTime.now().toString("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")));
        } else if (StringUtils.isNotBlank((String)sewerageExecutionResult.getToDate())) {
            boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)APPLICATION_DATE).from(APPLICATION_STARTDATE).to(DateUtils.endOfGivenDate((DateTime)DateUtils.toDateTimeUsingDefaultPattern((String)sewerageExecutionResult.getToDate())).toString("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")));
        }
        boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"applicationStatus", (Object)"Final Approved"));
        return boolQuery;
    }

    public Page<SewerageIndex> getCollectSearchResult(BoolQueryBuilder boolQuery, FieldSortBuilder sort, SewerageCollectFeeSearchRequest searchRequest) {
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{SEWERAGE}).withQuery((QueryBuilder)boolQuery).withPageable((Pageable)new PageRequest(searchRequest.pageNumber(), searchRequest.pageSize(), searchRequest.orderDir(), new String[]{searchRequest.orderBy()})).withSort((SortBuilder)sort).build();
        Page resultList = this.elasticsearchTemplate.queryForPage((SearchQuery)searchQuery, SewerageIndex.class);
        return resultList;
    }

    public List<SewerageIndex> getSearchResultForExecuteConnection(BoolQueryBuilder boolQuery, FieldSortBuilder sort) {
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{SEWERAGE}).withQuery((QueryBuilder)boolQuery).withSort((SortBuilder)sort).build();
        if (searchQuery != null) {
            return this.elasticsearchTemplate.queryForList((SearchQuery)searchQuery, SewerageIndex.class);
        }
        return Collections.emptyList();
    }

    public BoolQueryBuilder getDCRSearchResult(DailySTCollectionReportSearch searchRequest) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.matchQuery((String)"cityName", (Object)searchRequest.getUlbName()));
        if (StringUtils.isNotBlank((String)searchRequest.getFromDate())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"receiptDate").gte(DateUtils.startOfGivenDate((DateTime)DateUtils.toDateTimeUsingDefaultPattern((String)searchRequest.getFromDate())).toString("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")).lte(DateUtils.endOfGivenDate((DateTime)DateUtils.toDateTimeUsingDefaultPattern((String)searchRequest.getToDate())).toString("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")));
        }
        if (StringUtils.isNotBlank((String)searchRequest.getCollectionMode())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"channel", (Object)searchRequest.getCollectionMode()));
        }
        if (StringUtils.isNotBlank((String)searchRequest.getCollectionOperator())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"receiptCreator", (Object)searchRequest.getCollectionOperator()));
        }
        if (StringUtils.isNotBlank((String)searchRequest.getStatus())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"status", (Object)searchRequest.getStatus()));
        }
        return boolQuery;
    }

    public BoolQueryBuilder getDCRSewerageSearchResult(DailySTCollectionReportSearch searchRequest) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.matchQuery((String)ULB_NAME, (Object)searchRequest.getUlbName()));
        if (StringUtils.isNotBlank((String)searchRequest.getRevenueWard())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)WARD, (Object)searchRequest.getRevenueWard()));
        }
        return boolQuery;
    }

    public List<DailySTCollectionReportSearch> getDCRSewerageReportResult(DailySTCollectionReportSearch searchRequest, BoolQueryBuilder boolQuery) {
        ArrayList<CollectionDocument> collectionResultList = new ArrayList<CollectionDocument>();
        ArrayList<DailySTCollectionReportSearch> dcrCollectionList = new ArrayList<DailySTCollectionReportSearch>();
        ArrayList<DailySTCollectionReportSearch> resultList = new ArrayList<DailySTCollectionReportSearch>();
        ArrayList<SewerageIndex> sewerageResultList = new ArrayList<SewerageIndex>();
        Iterable receiptResultList = this.collectionDocumentRepository.search((QueryBuilder)boolQuery);
        for (CollectionDocument document : receiptResultList) {
            collectionResultList.add(document);
        }
        for (CollectionDocument collectionObject : collectionResultList) {
            DailySTCollectionReportSearch dcrReportObject = new DailySTCollectionReportSearch();
            dcrReportObject.setConsumerNumber(collectionObject.getConsumerCode());
            dcrReportObject.setReceiptNumber(collectionObject.getReceiptNumber());
            dcrReportObject.setReceiptDate(DateUtils.toDefaultDateTimeFormat((Date)collectionObject.getReceiptDate()));
            dcrReportObject.setPaidAt(collectionObject.getChannel());
            dcrReportObject.setPaymentMode(collectionObject.getPaymentMode());
            dcrReportObject.setStatus(collectionObject.getStatus());
            if (StringUtils.isNotBlank((String)collectionObject.getInstallmentFrom())) {
                dcrReportObject.setFromDate(collectionObject.getInstallmentFrom());
            }
            if (StringUtils.isNotBlank((String)collectionObject.getInstallmentTo())) {
                dcrReportObject.setToDate(collectionObject.getInstallmentTo());
            }
            dcrReportObject.setArrearAmount(collectionObject.getArrearAmount());
            dcrReportObject.setCurrentAmount(collectionObject.getCurrentAmount());
            dcrReportObject.setTotalAmount(collectionObject.getTotalAmount());
            dcrCollectionList.add(dcrReportObject);
        }
        BoolQueryBuilder sewerageBoolQuery = this.getDCRSewerageSearchResult(searchRequest);
        Iterable iterableResultList = this.sewerageIndexRepository.search((QueryBuilder)sewerageBoolQuery);
        for (SewerageIndex index : iterableResultList) {
            sewerageResultList.add(index);
        }
        for (SewerageIndex sewerageIndex : sewerageResultList) {
            for (DailySTCollectionReportSearch dcrReportObj : dcrCollectionList) {
                if (!dcrReportObj.getConsumerNumber().equals(sewerageIndex.getConsumerNumber())) continue;
                dcrReportObj.setDoorNo(sewerageIndex.getDoorNo());
                dcrReportObj.setShscNumber(sewerageIndex.getShscNumber());
                dcrReportObj.setOwnerName(sewerageIndex.getConsumerName());
                dcrReportObj.setRevenueWard(sewerageIndex.getWard());
                resultList.add(dcrReportObj);
            }
        }
        return resultList;
    }

    public BoolQueryBuilder getQueryFilterForNotice(SewerageNoticeSearchRequest searchRequest) {
        BoolQueryBuilder boolQuery = null;
        if (searchRequest.getNoticeType() != null) {
            if (searchRequest.getNoticeType().equals("WO")) {
                boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.rangeQuery((String)"workOrderDate").from(DateUtils.startOfGivenDate((DateTime)DateUtils.toDateTimeUsingDefaultPattern((String)searchRequest.getNoticeGeneratedFrom())).toString("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")).to(DateUtils.endOfGivenDate((DateTime)DateUtils.toDateTimeUsingDefaultPattern((String)searchRequest.getNoticeGeneratedTo())).toString("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")));
            } else if (searchRequest.getNoticeType().equals("EM")) {
                boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.rangeQuery((String)"estimationDate").from(DateUtils.startOfGivenDate((DateTime)DateUtils.toDateTimeUsingDefaultPattern((String)searchRequest.getNoticeGeneratedFrom())).toString("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")).to(DateUtils.endOfGivenDate((DateTime)DateUtils.toDateTimeUsingDefaultPattern((String)searchRequest.getNoticeGeneratedTo())).toString("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")));
            } else if (searchRequest.getNoticeType().equals("CC")) {
                boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.rangeQuery((String)"closureNoticeDate").from(DateUtils.startOfGivenDate((DateTime)DateUtils.toDateTimeUsingDefaultPattern((String)searchRequest.getNoticeGeneratedFrom())).toString("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")).to(DateUtils.endOfGivenDate((DateTime)DateUtils.toDateTimeUsingDefaultPattern((String)searchRequest.getNoticeGeneratedTo())).toString("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")));
            } else if (searchRequest.getNoticeType().equals("RN")) {
                boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.rangeQuery((String)"rejectionNoticeDate").from(DateUtils.startOfGivenDate((DateTime)DateUtils.toDateTimeUsingDefaultPattern((String)searchRequest.getNoticeGeneratedFrom())).toString("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")).to(DateUtils.endOfGivenDate((DateTime)DateUtils.toDateTimeUsingDefaultPattern((String)searchRequest.getNoticeGeneratedTo())).toString("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")));
            }
        }
        if (boolQuery != null) {
            if (StringUtils.isNotBlank((String)searchRequest.getUlbName())) {
                boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)ULB_NAME, (Object)searchRequest.getUlbName()));
            }
            if (StringUtils.isNotBlank((String)searchRequest.getShscNumber())) {
                boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)SHSC_NUMBER, (Object)searchRequest.getShscNumber()));
            }
            if (StringUtils.isNotBlank((String)searchRequest.getApplicantName())) {
                boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)CONSUMER_NAME, (Object)searchRequest.getApplicantName()));
            }
            if (StringUtils.isNotBlank((String)searchRequest.getMobileNumber())) {
                boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)MOBILE_NUMBER, (Object)searchRequest.getMobileNumber()));
            }
            if (StringUtils.isNotBlank((String)searchRequest.getRevenueWard())) {
                boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)WARD, (Object)searchRequest.getRevenueWard()));
            }
            if (StringUtils.isNotBlank((String)searchRequest.getDoorNumber())) {
                boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)DOOR_NO, (Object)searchRequest.getDoorNumber()));
            }
        }
        return boolQuery;
    }

    public List<SewerageIndex> getNoticeSearchResultByBoolQuery(BoolQueryBuilder boolQuery) {
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{SEWERAGE}).withQuery((QueryBuilder)boolQuery).withSort((SortBuilder)new FieldSortBuilder(CONSUMER_NAME).order(SortOrder.DESC)).build();
        List resultList = this.elasticsearchTemplate.queryForList((SearchQuery)searchQuery, SewerageIndex.class);
        return resultList;
    }

    public Page<SewerageIndex> getPagedNoticeSearchResultByBoolQuery(BoolQueryBuilder boolQuery, SewerageNoticeSearchRequest searchRequest) {
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{SEWERAGE}).withQuery((QueryBuilder)boolQuery).withPageable((Pageable)new PageRequest(searchRequest.pageNumber(), searchRequest.pageSize(), searchRequest.orderDir(), new String[]{searchRequest.orderBy()})).build();
        Page resultList = this.elasticsearchTemplate.queryForPage((SearchQuery)searchQuery, SewerageIndex.class);
        return resultList;
    }

    public Map<String, List<SewerageApplicationDetails>> wardWiseBoolQueryFilter(String ulbName, List<String> wardList, List<String> propertyTypeList) {
        HashMap<String, List<SewerageApplicationDetails>> dcbMap = new HashMap<String, List<SewerageApplicationDetails>>();
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.matchQuery((String)ULB_NAME, (Object)ulbName));
        boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.termsQuery((String)PROPERTY_TYPE, propertyTypeList));
        boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.termsQuery((String)WARD, wardList));
        boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)ACTIVE, (Object)true));
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{SEWERAGE}).withQuery((QueryBuilder)boolQuery).withPageable((Pageable)new PageRequest(0, 250)).withSort((SortBuilder)new FieldSortBuilder(APPLICATION_DATE).order(SortOrder.DESC)).build();
        Page searchResultList = this.sewerageIndexRepository.search((SearchQuery)searchQuery);
        for (SewerageIndex indexObj : searchResultList) {
            SewerageApplicationDetails sewerageApplicationDetails = this.sewerageApplicationDetailsService.findByApplicationNumber(indexObj.getApplicationNumber());
            if (sewerageApplicationDetails == null || sewerageApplicationDetails.getApplicationType().getCode().equals("CLOSESEWERAGECONNECTION")) continue;
            if (dcbMap.get(indexObj.getWard()) != null) {
                ((List)dcbMap.get(indexObj.getWard())).add(sewerageApplicationDetails);
                continue;
            }
            ArrayList<SewerageApplicationDetails> appList = new ArrayList<SewerageApplicationDetails>();
            appList.add(sewerageApplicationDetails);
            dcbMap.put(indexObj.getWard(), appList);
        }
        return dcbMap;
    }

    public Map<String, List<SewerageApplicationDetails>> wardWiseConnectionQueryFilter(List<String> propertyTypeList, String ward, String ulbName) {
        HashMap<String, List<SewerageApplicationDetails>> resultMap = new HashMap<String, List<SewerageApplicationDetails>>();
        ArrayList<SewerageApplicationDetails> resultList = new ArrayList<SewerageApplicationDetails>();
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.matchQuery((String)ULB_NAME, (Object)ulbName));
        boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.termsQuery((String)PROPERTY_TYPE, propertyTypeList));
        if (StringUtils.isNotBlank((String)ward)) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)WARD, (Object)ward));
        }
        boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)ACTIVE, (Object)true));
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{SEWERAGE}).withQuery((QueryBuilder)boolQuery).withPageable((Pageable)new PageRequest(0, 250)).withSort((SortBuilder)new FieldSortBuilder(APPLICATION_DATE).order(SortOrder.DESC)).build();
        Page indexList = this.sewerageIndexRepository.search((SearchQuery)searchQuery);
        for (SewerageIndex index : indexList) {
            ArrayList<SewerageApplicationDetails> appList = new ArrayList<SewerageApplicationDetails>();
            SewerageApplicationDetails applicationDetails = this.sewerageApplicationDetailsService.findByApplicationNumber(index.getApplicationNumber());
            if (resultList.isEmpty()) {
                resultList.add(applicationDetails);
            }
            if (applicationDetails == null) continue;
            applicationDetails.setOwnerName(index.getConsumerName());
            if (resultMap.isEmpty()) {
                resultMap.put(applicationDetails.getApplicationNumber(), resultList);
                continue;
            }
            if (resultMap.get(applicationDetails.getApplicationNumber()) != null) {
                ((List)resultMap.get(applicationDetails.getApplicationNumber())).add(applicationDetails);
                continue;
            }
            appList.add(applicationDetails);
            resultMap.put(applicationDetails.getApplicationNumber(), appList);
        }
        return resultMap;
    }

    public List<SewerageNoOfConnReportResult> searchNoOfApplnQuery(String ward, String block, String locality) {
        ArrayList<SewerageNoOfConnReportResult> resultList = new ArrayList<SewerageNoOfConnReportResult>();
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.matchQuery((String)ULB_NAME, (Object)ApplicationThreadLocals.getCityName()));
        boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)ACTIVE, (Object)true));
        if (StringUtils.isNotBlank((String)ward)) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)WARD, (Object)ward));
        }
        if (StringUtils.isNotBlank((String)block)) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"revenueBlock", (Object)block));
        }
        if (StringUtils.isNotBlank((String)locality)) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"locationName", (Object)locality));
        }
        SearchResponse consolidatedResponse = (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{SEWERAGE}).setQuery((QueryBuilder)boolQuery).addAggregation((AbstractAggregationBuilder)SewerageIndexService.getCountWithGroupingWardAndOrder("groupByField", WARD, WARD, DESC).subAggregation((AbstractAggregationBuilder)SewerageIndexService.getCountWithGroupingWardAndOrder("groupByField", APPLICATION_TYPE, WARD, DESC))).execute().actionGet();
        Terms terms = (Terms)consolidatedResponse.getAggregations().get("groupByField");
        for (Terms.Bucket bucket : terms.getBuckets()) {
            SewerageNoOfConnReportResult resultObject = new SewerageNoOfConnReportResult();
            resultObject.setName(bucket.getKey().toString());
            Terms subTerms = (Terms)bucket.getAggregations().get("groupByField");
            for (Terms.Bucket bucket1 : subTerms.getBuckets()) {
                if ("New Sewerage Connection".equals(bucket1.getKey())) {
                    resultObject.setNewconnection(bucket1.getDocCount());
                }
                if ("Change In Closets".equals(bucket1.getKey())) {
                    resultObject.setChangeinclosets(bucket1.getDocCount());
                }
                if ("Close Sewerage Connection".equals(bucket1.getKey())) {
                    resultObject.setCloseconnection(bucket1.getDocCount());
                }
                resultObject.setTotal(resultObject.getNewconnection() + resultObject.getChangeinclosets() + resultObject.getCloseconnection());
            }
            resultList.add(resultObject);
        }
        return resultList;
    }

    public static AggregationBuilder getCountWithGroupingWardAndOrder(String aggregationName, String fieldName, String sortField, String sortOrder) {
        TermsBuilder aggregation = ((TermsBuilder)AggregationBuilders.terms((String)aggregationName).field(fieldName)).size(75);
        if (StringUtils.isNotBlank((String)sortField) && StringUtils.isNotEmpty((String)sortField) && WARD.equalsIgnoreCase(sortField)) {
            Boolean order = true;
            if (StringUtils.isNotEmpty((String)sortOrder) && StringUtils.isNotBlank((String)sortOrder) && StringUtils.equalsIgnoreCase((String)sortOrder, (String)DESC)) {
                order = false;
            }
            aggregation.order(Terms.Order.aggregation((String)"_count", (boolean)order));
        }
        return aggregation;
    }

    public Page<SewerageIndex> wardwiseBaseRegisterQueryFilter(String ulbName, List<String> wardList, SewerageBaseRegisterResult sewerageBaseRegisterResult) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.matchQuery((String)ULB_NAME, (Object)ulbName));
        boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.termsQuery((String)WARD, wardList));
        boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)ACTIVE, (Object)true));
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{SEWERAGE}).withQuery((QueryBuilder)boolQuery).withPageable((Pageable)new PageRequest(sewerageBaseRegisterResult.pageNumber(), sewerageBaseRegisterResult.pageSize(), sewerageBaseRegisterResult.orderDir(), new String[]{sewerageBaseRegisterResult.orderBy()})).build();
        return this.elasticsearchTemplate.queryForPage((SearchQuery)searchQuery, SewerageIndex.class);
    }

    public List<SewerageIndex> getAllwardwiseBaseRegisterOrderByShscNumberAsc(String ulbName, List<String> wardList) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.matchQuery((String)ULB_NAME, (Object)ulbName));
        boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.termsQuery((String)WARD, wardList));
        boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)ACTIVE, (Object)true));
        FieldSortBuilder sort = new FieldSortBuilder(SHSC_NUMBER).order(SortOrder.ASC);
        NativeSearchQuery countQuery = new NativeSearchQueryBuilder().withIndices(new String[]{SEWERAGE}).withQuery((QueryBuilder)boolQuery).build();
        long count = this.elasticsearchTemplate.queryForPage((SearchQuery)countQuery, SewerageIndex.class).getTotalElements();
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{SEWERAGE}).withPageable((Pageable)new PageRequest(0, (int)count)).withSort((SortBuilder)sort).withQuery((QueryBuilder)boolQuery).build();
        return this.elasticsearchTemplate.queryForList((SearchQuery)searchQuery, SewerageIndex.class);
    }

    public List<BigDecimal> getGrandTotal(String ulbName, List<String> wardList) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.matchQuery((String)ULB_NAME, (Object)ulbName));
        boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.termsQuery((String)WARD, wardList));
        ArrayList<BigDecimal> totalValues = new ArrayList<BigDecimal>();
        SearchRequestBuilder searchRequestBuilder = this.elasticsearchTemplate.getClient().prepareSearch(new String[]{SEWERAGE}).setQuery((QueryBuilder)boolQuery).addAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)ARREARSSUM).field("arrearAmount")).addAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)DEMAND_AMOUNT_SUM).field("demandAmount")).addAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)TOTALDEMAND_AMOUNT_SUM).field("totalAmount")).addAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)COLLECTED_ARREAR_AMOUNT).field(COLLECTED_ARREAR_AMOUNT)).addAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)COLLECTED_DEMAND_AMOUNT).field(COLLECTED_DEMAND_AMOUNT)).addAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)EXTRA_ADVANCE_AMOUNT).field(EXTRA_ADVANCE_AMOUNT));
        SearchResponse searchResponse = (SearchResponse)searchRequestBuilder.execute().actionGet();
        if (searchResponse != null && searchResponse.getAggregations() != null) {
            Aggregations collAggr = searchResponse.getAggregations();
            Sum arresrsaggr = (Sum)collAggr.get(ARREARSSUM);
            Sum demanAmountagr = (Sum)collAggr.get(DEMAND_AMOUNT_SUM);
            Sum totalDemandaggr = (Sum)collAggr.get(TOTALDEMAND_AMOUNT_SUM);
            Sum collectedArrearAmount = (Sum)collAggr.get(COLLECTED_ARREAR_AMOUNT);
            Sum collectedDemandAmount = (Sum)collAggr.get(COLLECTED_DEMAND_AMOUNT);
            Sum extraAdvanceAmount = (Sum)collAggr.get(EXTRA_ADVANCE_AMOUNT);
            totalValues.add(BigDecimal.valueOf(arresrsaggr.getValue()).setScale(0, 4));
            totalValues.add(BigDecimal.valueOf(demanAmountagr.getValue()).setScale(0, 4));
            totalValues.add(BigDecimal.valueOf(totalDemandaggr.getValue()).setScale(0, 4));
            totalValues.add(BigDecimal.valueOf(collectedArrearAmount.getValue()).setScale(0, 4));
            totalValues.add(BigDecimal.valueOf(collectedDemandAmount.getValue()).setScale(0, 4));
            totalValues.add(BigDecimal.valueOf(collectedArrearAmount.getValue()).setScale(0, 4).add(BigDecimal.valueOf(collectedDemandAmount.getValue()).setScale(0, 4)));
            totalValues.add(BigDecimal.valueOf(extraAdvanceAmount.getValue()).setScale(0, 4));
        }
        return totalValues;
    }

    public Page<SewerageIndex> getOnlinePaymentSearchResult(BoolQueryBuilder boolQuery, FieldSortBuilder sort, SewerageConnSearchRequest searchRequest) {
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{SEWERAGE}).withQuery((QueryBuilder)boolQuery).withPageable((Pageable)new PageRequest(searchRequest.pageNumber(), searchRequest.pageSize(), searchRequest.orderDir(), new String[]{searchRequest.orderBy()})).withSort((SortBuilder)sort).build();
        Page resultList = this.elasticsearchTemplate.queryForPage((SearchQuery)searchQuery, SewerageIndex.class);
        return resultList;
    }

    public List<SewerageExecutionResult> getConnectionExecutionList(SewerageExecutionResult sewerageExecutionResult) {
        sewerageExecutionResult.setUlbName(this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName()).getName());
        BoolQueryBuilder boolQuery = this.getSearchQueryForExecuteConnection(sewerageExecutionResult);
        FieldSortBuilder sort = new FieldSortBuilder(SHSC_NUMBER).order(SortOrder.DESC);
        List<SewerageIndex> searchResultList = this.getSearchResultForExecuteConnection(boolQuery, sort);
        ArrayList<SewerageExecutionResult> connectionExecutionList = new ArrayList<SewerageExecutionResult>();
        if (null != searchResultList && !searchResultList.isEmpty()) {
            for (SewerageIndex searchResult : searchResultList) {
                SewerageExecutionResult executionResult = new SewerageExecutionResult();
                executionResult.setApplicationType(searchResult.getApplicationType());
                executionResult.setApplicationDate(DateUtils.getDefaultFormattedDate((Date)searchResult.getApplicationDate()));
                executionResult.setApplicationNumber(searchResult.getApplicationNumber());
                executionResult.setShscNumber(searchResult.getShscNumber());
                executionResult.setRevenueWard(searchResult.getWard());
                executionResult.setStatus(searchResult.getApplicationStatus());
                executionResult.setOwnerName(searchResult.getConsumerName());
                executionResult.setId(this.sewerageApplicationDetailsService.findByApplicationNumber(searchResult.getApplicationNumber()).getId());
                connectionExecutionList.add(executionResult);
            }
        }
        return connectionExecutionList;
    }

    public String validateDate(SewerageBulkExecutionResponse sewerageBulkExecutionResponse, List<SewerageApplicationDetails> sewerageApplicationDetailsList) {
        JSONObject obj = new JSONObject((Object)sewerageBulkExecutionResponse);
        JSONArray jsonArray = obj.getJSONArray("sewerageExecutionResult");
        String status = "";
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonobj = jsonArray.getJSONObject(i);
            SewerageApplicationDetails sewerageApplnDetailsObj = this.sewerageApplicationDetailsService.findBy(jsonobj.getLong("id"));
            if (jsonobj.getString(EXECUTION_DATE).isEmpty()) continue;
            sewerageApplnDetailsObj.getConnection().setExecutionDate(DateUtils.toDateUsingDefaultPattern((String)jsonobj.getString(EXECUTION_DATE)));
            if (sewerageApplnDetailsObj.getConnection().getExecutionDate() == null || !StringUtils.isNotEmpty((String)sewerageApplnDetailsObj.getConnection().getExecutionDate().toString())) continue;
            if (sewerageApplnDetailsObj.getConnection().getExecutionDate().compareTo(DateUtils.toDateUsingDefaultPattern((String)DateUtils.getDefaultFormattedDate((Date)sewerageApplnDetailsObj.getApplicationDate()))) <= 0) {
                status = "DateValidationFailed";
                continue;
            }
            sewerageApplicationDetailsList.add(sewerageApplnDetailsObj);
        }
        return status;
    }

    public Boolean update(List<SewerageApplicationDetails> sewerageList) {
        if (!sewerageList.isEmpty()) {
            for (SewerageApplicationDetails sewerageObj : sewerageList) {
                sewerageObj.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("SANCTIONED", "SEWERAGETAXAPPLICATION"));
                sewerageObj.getConnection().setStatus(SewerageConnectionStatus.ACTIVE);
                sewerageObj.setActive(true);
                SewerageApplicationDetails parentSewerageAppDtls = this.sewerageApplicationDetailsService.findByConnection_ShscNumberAndIsActive(sewerageObj.getConnection().getShscNumber());
                if (parentSewerageAppDtls != null) {
                    parentSewerageAppDtls.setActive(false);
                    sewerageObj.setParent(parentSewerageAppDtls);
                }
                this.sewerageApplicationDetailsService.updateExecutionDate(sewerageObj);
                this.sewerageApplicationDetailsService.updatePortalMessage(sewerageObj);
                this.sewerageApplicationDetailsService.updateIndexes(sewerageObj);
            }
            return true;
        }
        return false;
    }
}

