/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.egov.stms.entity.SewerageTaxDueDetails;
import org.egov.stms.transactions.entity.SewerageApplicationDetails;
import org.egov.stms.transactions.service.SewerageApplicationDetailsService;
import org.egov.stms.transactions.service.SewerageDemandService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class SewerageTaxService {
    @Autowired
    private SewerageApplicationDetailsService sewerageApplicationDetailsService;
    @Autowired
    private SewerageDemandService sewerageDemandService;

    public SewerageTaxDueDetails getSewerageDuesByPropertyIdentifier(String propertyIdentifier) {
        SewerageTaxDueDetails sewerageTaxDue;
        BigDecimal arrDmd = BigDecimal.ZERO;
        BigDecimal arrColl = BigDecimal.ZERO;
        BigDecimal currDmd = BigDecimal.ZERO;
        BigDecimal currColl = BigDecimal.ZERO;
        BigDecimal totalDue = BigDecimal.ZERO;
        BigDecimal currentInstDue = BigDecimal.ZERO;
        List<SewerageApplicationDetails> sewerageList = this.sewerageApplicationDetailsService.getSewerageConnectionDetailsByPropertyIDentifier(propertyIdentifier);
        if (sewerageList.isEmpty()) {
            sewerageTaxDue = new SewerageTaxDueDetails();
            sewerageTaxDue.setConnectionCount(0);
            sewerageTaxDue.setIsSuccess(false);
            sewerageTaxDue.setErrorCode("STAX101");
            sewerageTaxDue.setErrorMessage("Sewerage Connection details with Assessment Number " + propertyIdentifier + " does not exist");
        } else {
            sewerageTaxDue = new SewerageTaxDueDetails();
            HashMap<String, String> consumerCodes = new HashMap<String, String>();
            for (SewerageApplicationDetails sewerageApplicationDetails : sewerageList) {
                if (sewerageApplicationDetails.getConnection().getShscNumber() == null) continue;
                sewerageTaxDue = this.getDueInfo(sewerageApplicationDetails);
                sewerageTaxDue.setPropertyID(propertyIdentifier);
                consumerCodes.put(sewerageApplicationDetails.getApplicationType().getCode(), sewerageApplicationDetails.getConnection().getShscNumber());
                arrDmd = arrDmd.add(sewerageTaxDue.getArrearDemand().setScale(2, 4));
                arrColl = arrColl.add(sewerageTaxDue.getArrearCollection().setScale(2, 4));
                currDmd = currDmd.add(sewerageTaxDue.getCurrentDemand().setScale(2, 4));
                currColl = currColl.add(sewerageTaxDue.getCurrentCollection().setScale(2, 4));
                currentInstDue = currentInstDue.add(sewerageTaxDue.getCurrentInstDemand().setScale(2, 4));
                totalDue = totalDue.add(sewerageTaxDue.getTotalTaxDue().setScale(2, 4));
            }
            sewerageTaxDue.setArrearDemand(arrDmd);
            sewerageTaxDue.setArrearCollection(arrColl);
            sewerageTaxDue.setCurrentDemand(currDmd);
            sewerageTaxDue.setCurrentCollection(currColl);
            sewerageTaxDue.setTotalTaxDue(totalDue);
            sewerageTaxDue.setCurrentInstDemand(currentInstDue);
            sewerageTaxDue.setConsumerCode(consumerCodes);
            sewerageTaxDue.setConnectionCount(sewerageList.size());
            sewerageTaxDue.setIsSuccess(true);
            sewerageTaxDue.setIsInWorkFlow(false);
        }
        for (SewerageApplicationDetails sewerageApplicationDetails : sewerageList) {
            if (!"INPROGRESS".equalsIgnoreCase(sewerageApplicationDetails.getConnection().getStatus().toString())) continue;
            sewerageTaxDue.setIsInWorkFlow(true);
        }
        return sewerageTaxDue;
    }

    private SewerageTaxDueDetails getDueInfo(SewerageApplicationDetails sewerageApplicationDetails) {
        Map<String, BigDecimal> resultmap = this.sewerageDemandService.getDemandDetailsMap(sewerageApplicationDetails);
        SewerageTaxDueDetails sewerageTaxDueDetails = new SewerageTaxDueDetails();
        if (null != resultmap && !resultmap.isEmpty()) {
            BigDecimal currDmd = resultmap.get("CURR_DMD");
            sewerageTaxDueDetails.setCurrentDemand(currDmd);
            BigDecimal arrDmd = resultmap.get("ARR_DMD");
            sewerageTaxDueDetails.setArrearDemand(arrDmd);
            BigDecimal currCollection = resultmap.get("CURR_COLL");
            sewerageTaxDueDetails.setCurrentCollection(currCollection);
            BigDecimal arrCollection = resultmap.get("ARR_COLL");
            sewerageTaxDueDetails.setArrearCollection(arrCollection);
            BigDecimal taxDue = currDmd.add(arrDmd).subtract(currCollection).subtract(arrCollection);
            sewerageTaxDueDetails.setTotalTaxDue(taxDue);
            BigDecimal currentInstDemand = this.sewerageDemandService.getCurrentDue(sewerageApplicationDetails);
            sewerageTaxDueDetails.setCurrentInstDemand(currentInstDemand);
        }
        return sewerageTaxDueDetails;
    }
}

