/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.report.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.config.persistence.datasource.routing.annotation.ReadOnly;
import org.egov.stms.entity.es.SewerageIndex;
import org.egov.stms.reports.entity.SewerageBaseRegisterResult;
import org.egov.stms.service.es.SewerageIndexService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.ui.Model;

@Service
public class SewerageBaseRegisterReportService {
    @Autowired
    private CityService cityService;
    @Autowired
    private SewerageIndexService sewerageIndexService;
    @Autowired
    private BoundaryService boundaryService;

    @ReadOnly
    public Page<SewerageIndex> getBaseRegisterDetails(SewerageBaseRegisterResult sewerageBaseRegisterResult, Model model) {
        Page<SewerageIndex> searchResult = null;
        City cityWebsite = this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName());
        if (cityWebsite != null) {
            searchResult = this.sewerageIndexService.wardwiseBaseRegisterQueryFilter(cityWebsite.getName(), this.getWardNames(sewerageBaseRegisterResult, model), sewerageBaseRegisterResult);
        }
        return searchResult;
    }

    public List<SewerageBaseRegisterResult> getAllBaseRegisterRecords(SewerageBaseRegisterResult sewerageBaseRegisterResult, Model model) {
        List<SewerageIndex> resultList = null;
        ArrayList<SewerageBaseRegisterResult> baseRegisterResultList = new ArrayList<SewerageBaseRegisterResult>();
        City cityWebsite = this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName());
        if (cityWebsite != null) {
            resultList = this.sewerageIndexService.getAllwardwiseBaseRegisterOrderByShscNumberAsc(cityWebsite.getName(), this.getWardNames(sewerageBaseRegisterResult, model));
        }
        for (SewerageIndex sewerageIndex : resultList) {
            SewerageBaseRegisterResult searchResult = new SewerageBaseRegisterResult();
            searchResult.setShscNumber(sewerageIndex.getShscNumber());
            searchResult.setRevenueWard(sewerageIndex.getWard());
            searchResult.setAssementNo(sewerageIndex.getPropertyIdentifier());
            searchResult.setOwnerName(sewerageIndex.getConsumerName());
            searchResult.setDoorNo(sewerageIndex.getDoorNo());
            searchResult.setPropertyType(sewerageIndex.getPropertyType());
            searchResult.setResidentialClosets(sewerageIndex.getNoOfClosets_residential());
            searchResult.setNonResidentialClosets(sewerageIndex.getNoOfClosets_nonResidential());
            searchResult.setPeriod(sewerageIndex.getPeriod() != null ? sewerageIndex.getPeriod() : "");
            searchResult.setArrears(sewerageIndex.getArrearAmount().setScale(0, 6));
            searchResult.setCurrentDemand(sewerageIndex.getDemandAmount().setScale(0, 6));
            searchResult.setAdvanceAmount(sewerageIndex.getExtraAdvanceAmount() != null ? sewerageIndex.getExtraAdvanceAmount().setScale(0, 6) : BigDecimal.ZERO);
            searchResult.setArrearsCollected(sewerageIndex.getCollectedArrearAmount().setScale(0, 6));
            searchResult.setCurrentTaxCollected(sewerageIndex.getCollectedDemandAmount().setScale(0, 6));
            searchResult.setTotalTaxCollected(sewerageIndex.getCollectedArrearAmount().add(sewerageIndex.getCollectedDemandAmount()).setScale(0, 6));
            searchResult.setTotalDemand(sewerageIndex.getTotalAmount().setScale(0, 6));
            baseRegisterResultList.add(searchResult);
        }
        return baseRegisterResultList;
    }

    public List<String> getWardNames(SewerageBaseRegisterResult sewerageBaseRegisterResult, Model model) {
        ArrayList<String> wardNames = new ArrayList<String>();
        ArrayList<Boundary> wardList = new ArrayList<Boundary>();
        if (sewerageBaseRegisterResult.getMode() != null) {
            String[] wardIds = sewerageBaseRegisterResult.getMode().split("~");
            for (String idValue : wardIds) {
                Boundary ward = this.boundaryService.getBoundaryById(Long.valueOf(Long.parseLong(idValue)));
                if (ward == null) continue;
                wardList.add(ward);
            }
        }
        if (wardList != null && !wardList.isEmpty()) {
            sewerageBaseRegisterResult.setWards(wardList);
        }
        if (null != sewerageBaseRegisterResult.getWards() && !sewerageBaseRegisterResult.getWards().isEmpty()) {
            for (Boundary boundary : sewerageBaseRegisterResult.getWards()) {
                if (boundary == null) continue;
                sewerageBaseRegisterResult.setRevenueWard(boundary.getLocalName());
                model.addAttribute("wardId", (Object)boundary.getId());
                if (boundary.getLocalName() == null) continue;
                wardNames.add(boundary.getLocalName());
            }
        }
        return wardNames;
    }

    public List<BigDecimal> baseRegisterGrandTotal(SewerageBaseRegisterResult sewerageBaseRegisterResult, Model model) {
        City cityWebsite = this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName());
        return this.sewerageIndexService.getGrandTotal(cityWebsite.getName(), this.getWardNames(sewerageBaseRegisterResult, model));
    }
}

