/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.notice.service;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.WordUtils;
import org.apache.log4j.Logger;
import org.egov.demand.model.EgDemand;
import org.egov.demand.model.EgDemandDetails;
import org.egov.demand.model.EgdmCollectedReceipt;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.DesignationService;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.OwnerName;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.stms.notice.entity.SewerageNotice;
import org.egov.stms.transactions.entity.SewerageApplicationDetails;
import org.egov.stms.transactions.entity.SewerageConnectionFee;
import org.egov.stms.transactions.repository.SewerageNoticeRepository;
import org.egov.stms.utils.SewerageTaxUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Scope(value="prototype")
@Transactional(readOnly=true)
public class SewerageNoticeService {
    public static final String ESTIMATION_NOTICE = "sewerageEstimationNotice";
    public static final String REJECTION_NOTICE = "sewerageRejectionNotice";
    public static final String WORKORDERNOTICE = "sewerageWorkOrderNotice";
    public static final String CLOSECONNECTIONNOTICE = "sewerageCloseConnectionNotice";
    private static final Logger LOGGER = Logger.getLogger(SewerageNoticeService.class);
    private static final String APPLICATION_PDF = "application/pdf";
    @Autowired
    @Qualifier(value="fileStoreService")
    private FileStoreService fileStoreService;
    @Autowired
    private ModuleService moduleDao;
    @Autowired
    private SewerageNoticeRepository sewerageNoticeRepository;
    private InputStream generateNoticePDF;
    @Autowired
    private ReportService reportService;
    @Autowired
    private SewerageTaxUtils sewerageTaxUtils;
    @Autowired
    @Qualifier(value="parentMessageSource")
    private MessageSource stmsMessageSource;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private DesignationService designationService;
    @Autowired
    private CityService cityService;
    private BigDecimal donationCharges = BigDecimal.ZERO;
    private BigDecimal sewerageCharges = BigDecimal.ZERO;
    private BigDecimal estimationCharges = BigDecimal.ZERO;

    public SewerageNotice findByNoticeTypeAndApplicationNumber(String noticeType, String applicationNumber) {
        return this.sewerageNoticeRepository.findByNoticeTypeAndApplicationNumber(noticeType, applicationNumber);
    }

    public List<SewerageNotice> findByNoticeType(String noticeType) {
        return this.sewerageNoticeRepository.findByNoticeType(noticeType);
    }

    public SewerageNotice findByNoticeNoAndNoticeType(String noticeNo, String noticeType) {
        return this.sewerageNoticeRepository.findByNoticeNoAndNoticeType(noticeNo, noticeType);
    }

    public SewerageNotice saveEstimationNotice(SewerageApplicationDetails sewerageApplicationDetails, InputStream fileStream) {
        SewerageNotice sewerageNotice = null;
        if (sewerageApplicationDetails != null) {
            sewerageNotice = new SewerageNotice();
            String estNoticeNo = sewerageApplicationDetails.getEstimationNumber();
            this.buildSewerageNotice(sewerageApplicationDetails, sewerageNotice, estNoticeNo, sewerageApplicationDetails.getEstimationDate(), "Estimation Notice");
            String fileName = estNoticeNo + ".pdf";
            FileStoreMapper fileStore = this.fileStoreService.store(fileStream, fileName, APPLICATION_PDF, "STMS");
            sewerageNotice.setFileStore(fileStore);
        }
        return sewerageNotice;
    }

    public SewerageNotice saveRejectionNotice(SewerageApplicationDetails sewerageApplicationDetails, InputStream fileStream) {
        SewerageNotice sewerageNotice = null;
        if (sewerageApplicationDetails != null) {
            sewerageNotice = new SewerageNotice();
            String rejectionNoticeNo = sewerageApplicationDetails.getRejectionNumber();
            this.buildSewerageNotice(sewerageApplicationDetails, sewerageNotice, rejectionNoticeNo, sewerageApplicationDetails.getEstimationDate(), "Rejection Notice");
            String fileName = rejectionNoticeNo + ".pdf";
            FileStoreMapper fileStore = this.fileStoreService.store(fileStream, fileName, APPLICATION_PDF, "STMS");
            sewerageNotice.setFileStore(fileStore);
        }
        return sewerageNotice;
    }

    private void buildSewerageNotice(SewerageApplicationDetails sewerageApplicationDetails, SewerageNotice sewerageNotice, String noticeNumber, Date noticeDate, String noticeType) {
        Module module = this.moduleDao.getModuleByName("Sewerage Tax Management");
        sewerageNotice.setModule(module);
        sewerageNotice.setApplicationNumber(sewerageApplicationDetails.getApplicationNumber());
        sewerageNotice.setNoticeType(noticeType);
        sewerageNotice.setNoticeNo(noticeNumber);
        sewerageNotice.setNoticeDate(noticeDate);
        sewerageNotice.setApplicationDetails(sewerageApplicationDetails);
    }

    public SewerageNotice saveWorkOrderNotice(SewerageApplicationDetails sewerageApplicationDetails, InputStream fileStream) {
        SewerageNotice sewerageNotice = null;
        if (sewerageApplicationDetails != null) {
            sewerageNotice = new SewerageNotice();
            String workOrederNo = sewerageApplicationDetails.getWorkOrderNumber();
            this.buildSewerageNotice(sewerageApplicationDetails, sewerageNotice, workOrederNo, sewerageApplicationDetails.getWorkOrderDate(), "Workorder Notice");
            String fileName = workOrederNo + ".pdf";
            FileStoreMapper fileStore = this.fileStoreService.store(fileStream, fileName, APPLICATION_PDF, "STMS");
            sewerageNotice.setFileStore(fileStore);
        }
        return sewerageNotice;
    }

    public SewerageNotice generateReportForEstimation(SewerageApplicationDetails sewerageApplicationDetails) {
        ReportOutput reportOutput = null;
        SewerageNotice sewerageNotice = null;
        reportOutput = this.generateReportOutputDataForEstimation(sewerageApplicationDetails);
        if (reportOutput != null && reportOutput.getReportOutputData() != null) {
            this.generateNoticePDF = new ByteArrayInputStream(reportOutput.getReportOutputData());
            sewerageNotice = this.saveEstimationNotice(sewerageApplicationDetails, this.generateNoticePDF);
        }
        return sewerageNotice;
    }

    public SewerageNotice generateReportForRejection(SewerageApplicationDetails sewerageApplicationDetails, HttpSession session, HttpServletRequest request) {
        SewerageNotice sewerageNotice = null;
        ReportOutput reportOutput = this.generateReportOutputDataForRejection(sewerageApplicationDetails, session, request);
        if (reportOutput != null && reportOutput.getReportOutputData() != null) {
            this.generateNoticePDF = new ByteArrayInputStream(reportOutput.getReportOutputData());
            sewerageNotice = this.saveRejectionNotice(sewerageApplicationDetails, this.generateNoticePDF);
        }
        return sewerageNotice;
    }

    public SewerageNotice generateReportForWorkOrder(SewerageApplicationDetails sewerageApplicationDetails) {
        SewerageNotice sewerageNotice = null;
        ReportOutput reportOutput = this.generateReportOutputForWorkOrder(sewerageApplicationDetails);
        if (reportOutput != null && reportOutput.getReportOutputData() != null) {
            this.generateNoticePDF = new ByteArrayInputStream(reportOutput.getReportOutputData());
            sewerageNotice = this.saveWorkOrderNotice(sewerageApplicationDetails, this.generateNoticePDF);
        }
        return sewerageNotice;
    }

    public ReportOutput generateReportOutputDataForEstimation(SewerageApplicationDetails sewerageApplicationDetails) {
        ReportRequest reportInput = null;
        HashMap<String, Object> reportParams = new HashMap<String, Object>();
        if (sewerageApplicationDetails != null) {
            Iterator<Object> iterator;
            AssessmentDetails assessmentDetails = this.sewerageTaxUtils.getAssessmentDetailsForFlag(sewerageApplicationDetails.getConnectionDetail().getPropertyIdentifier(), PropertyExternalService.FLAG_FULL_DETAILS);
            String[] doorNo = null;
            if (null != assessmentDetails.getPropertyAddress()) {
                doorNo = assessmentDetails.getPropertyAddress().split(",");
            }
            String ownerName = "";
            if (null != assessmentDetails.getOwnerNames() && (iterator = assessmentDetails.getOwnerNames().iterator()).hasNext()) {
                OwnerName names = (OwnerName)iterator.next();
                ownerName = names.getOwnerName();
            }
            if ("NEWSEWERAGECONNECTION".equalsIgnoreCase(sewerageApplicationDetails.getApplicationType().getCode())) {
                reportParams.put("applicationType", WordUtils.capitalize((String)sewerageApplicationDetails.getApplicationType().getName()));
            } else {
                reportParams.put("applicationType", WordUtils.capitalize((String)sewerageApplicationDetails.getApplicationType().getName()));
            }
            reportParams.put("cityName", this.cityService.getMunicipalityName());
            reportParams.put("district", this.cityService.getDistrictName());
            reportParams.put("estimationDate", DateUtils.getDefaultFormattedDate((Date)sewerageApplicationDetails.getApplicationDate()));
            reportParams.put("cityLogo", this.cityService.getCityLogoURL());
            if (sewerageApplicationDetails.getCurrentDemand() != null) {
                for (EgDemandDetails egDmdDetails : sewerageApplicationDetails.getCurrentDemand().getEgDemandDetails()) {
                    if (!egDmdDetails.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("DONATIONCHARGE")) continue;
                    this.donationCharges = egDmdDetails.getAmount().subtract(egDmdDetails.getAmtCollected());
                }
            }
            for (SewerageConnectionFee scf : sewerageApplicationDetails.getConnectionFees()) {
                if (!scf.getFeesDetail().getCode().equalsIgnoreCase("ESTIMATIONCHARGE")) continue;
                this.estimationCharges = BigDecimal.valueOf(scf.getAmount());
            }
            reportParams.put("estimationCharges", this.estimationCharges);
            reportParams.put("donationCharges", this.donationCharges);
            reportParams.put("totalCharges", this.estimationCharges.add(this.donationCharges));
            reportParams.put("applicationDate", DateUtils.getDefaultFormattedDate((Date)sewerageApplicationDetails.getApplicationDate()));
            reportParams.put("applicantName", ownerName);
            reportParams.put("address", assessmentDetails.getPropertyAddress());
            reportParams.put("inspectionDetails", sewerageApplicationDetails.getFieldInspections().get(0).getFieldInspectionDetails());
            reportParams.put("houseNo", doorNo != null ? doorNo[0] : "");
            reportInput = new ReportRequest(ESTIMATION_NOTICE, sewerageApplicationDetails.getEstimationDetails(), reportParams);
        }
        return this.reportService.createReport(reportInput);
    }

    public ReportOutput generateReportOutputDataForRejection(SewerageApplicationDetails sewerageApplicationDetails, HttpSession session, HttpServletRequest request) {
        ReportRequest reportInput = null;
        HashMap<String, Object> reportParams = new HashMap<String, Object>();
        if (sewerageApplicationDetails != null) {
            Iterator iterator;
            AssessmentDetails assessmentDetails = this.sewerageTaxUtils.getAssessmentDetailsForFlag(sewerageApplicationDetails.getConnectionDetail().getPropertyIdentifier(), PropertyExternalService.FLAG_FULL_DETAILS);
            String ownerName = "";
            if (null != assessmentDetails.getOwnerNames() && (iterator = assessmentDetails.getOwnerNames().iterator()).hasNext()) {
                OwnerName names = (OwnerName)iterator.next();
                ownerName = names.getOwnerName();
            }
            reportParams.put("applicationType", WordUtils.capitalize((String)sewerageApplicationDetails.getApplicationType().getName()));
            reportParams.put("applicantName", ownerName);
            reportParams.put("cityName", session.getAttribute("citymunicipalityname"));
            reportParams.put("remarks", request.getParameter("approvalComent"));
            reportParams.put("rejectionDate", DateUtils.getDefaultFormattedDate((Date)sewerageApplicationDetails.getRejectionDate()));
            reportParams.put("rejectionNumber", sewerageApplicationDetails.getRejectionNumber());
            reportParams.put("presentCommissioner", ((Assignment)this.assignmentService.getAllActiveAssignments(this.designationService.getDesignationByName("Commissioner").getId()).get(0)).getEmployee().getName());
            reportInput = new ReportRequest(REJECTION_NOTICE, (Object)sewerageApplicationDetails, reportParams);
        }
        return this.reportService.createReport(reportInput);
    }

    public ReportOutput generateReportOutputForWorkOrder(SewerageApplicationDetails sewerageApplicationDetails) {
        ReportRequest reportInput = null;
        HashMap<String, Object> reportParams = new HashMap<String, Object>();
        if (null != sewerageApplicationDetails) {
            AssessmentDetails assessmentDetails = this.sewerageTaxUtils.getAssessmentDetailsForFlag(sewerageApplicationDetails.getConnectionDetail().getPropertyIdentifier(), PropertyExternalService.FLAG_FULL_DETAILS);
            String[] doorno = assessmentDetails.getPropertyAddress().split(",");
            String ownerName = "";
            Iterator<Object> iterator = assessmentDetails.getOwnerNames().iterator();
            if (iterator.hasNext()) {
                OwnerName names = (OwnerName)iterator.next();
                ownerName = names.getOwnerName();
            }
            if ("NEWSEWERAGECONNECTION".equalsIgnoreCase(sewerageApplicationDetails.getApplicationType().getCode())) {
                reportParams.put("conntitle", WordUtils.capitalize((String)sewerageApplicationDetails.getApplicationType().getName()));
            } else {
                reportParams.put("conntitle", WordUtils.capitalize((String)sewerageApplicationDetails.getApplicationType().getName()));
            }
            reportParams.put("applicationtype", this.stmsMessageSource.getMessage("msg.new.sewerage.conn", null, null));
            reportParams.put("municipality", this.cityService.getMunicipalityName());
            reportParams.put("district", this.cityService.getDistrictName());
            reportParams.put("purpose", null);
            reportParams.put("presentCommissioner", ((Assignment)this.assignmentService.getAllActiveAssignments(this.designationService.getDesignationByName("Commissioner").getId()).get(0)).getEmployee().getName());
            if (sewerageApplicationDetails.getApplicationType().getCode().equalsIgnoreCase("NEWSEWERAGECONNECTION")) {
                for (SewerageConnectionFee scf : sewerageApplicationDetails.getConnectionFees()) {
                    if (scf.getFeesDetail().getCode().equalsIgnoreCase("ESTIMATIONCHARGE")) {
                        this.estimationCharges = BigDecimal.valueOf(scf.getAmount());
                        continue;
                    }
                    if (scf.getFeesDetail().getCode().equalsIgnoreCase("DONATIONCHARGE")) {
                        this.donationCharges = BigDecimal.valueOf(scf.getAmount());
                        continue;
                    }
                    if (!scf.getFeesDetail().getCode().equalsIgnoreCase("SEWERAGETAX")) continue;
                    this.sewerageCharges = BigDecimal.valueOf(scf.getAmount());
                }
            } else if (sewerageApplicationDetails.getCurrentDemand() != null) {
                Map<String, BigDecimal> donationSewerageFeesDtls = this.getFeesForChangeInClosets(sewerageApplicationDetails.getCurrentDemand());
                this.estimationCharges = donationSewerageFeesDtls.get("estimationCharges");
                this.donationCharges = donationSewerageFeesDtls.get("donationCharges");
                this.sewerageCharges = donationSewerageFeesDtls.get("sewerageTax");
            }
            reportParams.put("cityLogo", this.cityService.getCityLogoURL());
            reportParams.put("estimationCharges", this.estimationCharges);
            reportParams.put("donationCharges", this.donationCharges);
            reportParams.put("sewerageTax", this.sewerageCharges);
            reportParams.put("totalCharges", this.donationCharges.add(this.sewerageCharges).add(this.estimationCharges));
            reportParams.put("assessmentNo", sewerageApplicationDetails.getConnectionDetail().getPropertyIdentifier());
            reportParams.put("noOfSeatsResidential", sewerageApplicationDetails.getConnectionDetail().getNoOfClosetsResidential());
            reportParams.put("noOfSeatsNonResidential", sewerageApplicationDetails.getConnectionDetail().getNoOfClosetsNonResidential());
            reportParams.put("revenueWardNo", assessmentDetails.getBoundaryDetails().getWardName());
            reportParams.put("locality", assessmentDetails.getBoundaryDetails().getLocalityName());
            reportParams.put("workorderdate", sewerageApplicationDetails.getWorkOrderDate() != null ? DateUtils.getDefaultFormattedDate((Date)sewerageApplicationDetails.getWorkOrderDate()) : "");
            reportParams.put("workorderno", sewerageApplicationDetails.getWorkOrderNumber());
            if (sewerageApplicationDetails.getConnection().getShscNumber() != null) {
                reportParams.put("consumerNumber", sewerageApplicationDetails.getConnection().getShscNumber());
            }
            reportParams.put("applicantname", WordUtils.capitalize((String)ownerName));
            reportParams.put("address", assessmentDetails.getPropertyAddress());
            reportParams.put("doorno", doorno[0]);
            reportParams.put("applicationDate", DateUtils.getDefaultFormattedDate((Date)sewerageApplicationDetails.getApplicationDate()));
            reportInput = new ReportRequest(WORKORDERNOTICE, (Object)sewerageApplicationDetails, reportParams);
        }
        return this.reportService.createReport(reportInput);
    }

    public Map<String, BigDecimal> getFeesForChangeInClosets(EgDemand demand) {
        BigDecimal currentEstimationCharges = BigDecimal.ZERO;
        BigDecimal totalDontationCharge = BigDecimal.ZERO;
        BigDecimal totalSewerageTax = BigDecimal.ZERO;
        HashMap<String, BigDecimal> donationSewerageFees = new HashMap<String, BigDecimal>();
        for (EgDemandDetails dmdDtl : demand.getEgDemandDetails()) {
            for (EgdmCollectedReceipt collectedReceipt : dmdDtl.getEgdmCollectedReceipts()) {
                if ("DONATIONCHARGE".equalsIgnoreCase(dmdDtl.getEgDemandReason().getEgDemandReasonMaster().getCode())) {
                    totalDontationCharge = totalDontationCharge.add(collectedReceipt.getReasonAmount());
                    continue;
                }
                if ("SEWERAGETAX".equalsIgnoreCase(dmdDtl.getEgDemandReason().getEgDemandReasonMaster().getCode())) {
                    totalSewerageTax = totalSewerageTax.add(collectedReceipt.getReasonAmount());
                    continue;
                }
                if (!"ESTIMATIONCHARGE".equalsIgnoreCase(dmdDtl.getEgDemandReason().getEgDemandReasonMaster().getCode())) continue;
                currentEstimationCharges = currentEstimationCharges.add(collectedReceipt.getReasonAmount());
            }
        }
        donationSewerageFees.put("donationCharges", totalDontationCharge);
        donationSewerageFees.put("sewerageTax", totalSewerageTax);
        donationSewerageFees.put("estimationCharges", currentEstimationCharges);
        return donationSewerageFees;
    }

    public ZipOutputStream addFilesToZip(InputStream inputStream, String noticeNo, ZipOutputStream out) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Entered into addFilesToZip method");
        }
        byte[] buffer = new byte[1024];
        try {
            int len;
            out.setLevel(-1);
            out.putNextEntry(new ZipEntry(noticeNo.replaceAll("/", "_")));
            while ((len = inputStream.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
            inputStream.close();
        }
        catch (IllegalArgumentException iae) {
            LOGGER.error((Object)"Exception in addFilesToZip : ", (Throwable)iae);
            throw new ValidationException(Arrays.asList(new ValidationError("error", iae.getMessage())));
        }
        catch (FileNotFoundException fnfe) {
            LOGGER.error((Object)"Exception in addFilesToZip : ", (Throwable)fnfe);
            throw new ValidationException(Arrays.asList(new ValidationError("error", fnfe.getMessage())));
        }
        catch (IOException ioe) {
            LOGGER.error((Object)"Exception in addFilesToZip : ", (Throwable)ioe);
            throw new ValidationException(Arrays.asList(new ValidationError("error", ioe.getMessage())));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Exit from addFilesToZip method");
        }
        return out;
    }

    public SewerageNotice generateReportForCloseConnection(SewerageApplicationDetails sewerageApplicationDetails, HttpSession session) {
        ReportOutput reportOutput = null;
        SewerageNotice sewerageNotice = null;
        reportOutput = this.generateReportOutputForSewerageCloseConnection(sewerageApplicationDetails, session);
        if (reportOutput != null && reportOutput.getReportOutputData() != null) {
            this.generateNoticePDF = new ByteArrayInputStream(reportOutput.getReportOutputData());
            sewerageNotice = this.saveCloseConnectionNotice(sewerageApplicationDetails, this.generateNoticePDF);
        }
        return sewerageNotice;
    }

    public ReportOutput generateReportOutputForSewerageCloseConnection(SewerageApplicationDetails sewerageApplicationDetails, HttpSession session) {
        ReportRequest reportInput = null;
        HashMap<String, Object> reportParams = new HashMap<String, Object>();
        if (null != sewerageApplicationDetails) {
            AssessmentDetails assessmentDetails = this.sewerageTaxUtils.getAssessmentDetailsForFlag(sewerageApplicationDetails.getConnectionDetail().getPropertyIdentifier(), PropertyExternalService.FLAG_FULL_DETAILS);
            String[] doorno = assessmentDetails.getPropertyAddress().split(",");
            String ownerName = "";
            Iterator iterator = assessmentDetails.getOwnerNames().iterator();
            if (iterator.hasNext()) {
                OwnerName names = (OwnerName)iterator.next();
                ownerName = names.getOwnerName();
            }
            reportParams.put("conntitle", WordUtils.capitalize((String)sewerageApplicationDetails.getApplicationType().getName()));
            reportParams.put("municipality", session.getAttribute("citymunicipalityname"));
            reportParams.put("district", session.getAttribute("districtName"));
            reportParams.put("presentCommissioner", ((Assignment)this.assignmentService.getAllActiveAssignments(this.designationService.getDesignationByName("Commissioner").getId()).get(0)).getEmployee().getName());
            reportParams.put("assessmentNo", sewerageApplicationDetails.getConnectionDetail().getPropertyIdentifier());
            reportParams.put("noOfSeatsResidential", sewerageApplicationDetails.getConnectionDetail().getNoOfClosetsResidential());
            reportParams.put("noOfSeatsNonResidential", sewerageApplicationDetails.getConnectionDetail().getNoOfClosetsNonResidential());
            reportParams.put("revenueWardNo", assessmentDetails.getBoundaryDetails().getWardName());
            reportParams.put("locality", assessmentDetails.getBoundaryDetails().getLocalityName());
            reportParams.put("eeApprovalDate", DateUtils.getDefaultFormattedDate((Date)sewerageApplicationDetails.getLastModifiedDate()));
            reportParams.put("consumerNumber", sewerageApplicationDetails.getConnection().getShscNumber());
            reportParams.put("applicantname", WordUtils.capitalize((String)ownerName));
            reportParams.put("address", assessmentDetails.getPropertyAddress());
            reportParams.put("doorno", doorno[0]);
            reportParams.put("applicationDate", DateUtils.getDefaultFormattedDate((Date)sewerageApplicationDetails.getApplicationDate()));
            reportInput = new ReportRequest(CLOSECONNECTIONNOTICE, (Object)sewerageApplicationDetails, reportParams);
        }
        return this.reportService.createReport(reportInput);
    }

    public SewerageNotice saveCloseConnectionNotice(SewerageApplicationDetails sewerageApplicationDetails, InputStream fileStream) {
        SewerageNotice sewerageNotice = null;
        if (sewerageApplicationDetails != null) {
            sewerageNotice = new SewerageNotice();
            this.buildSewerageNotice(sewerageApplicationDetails, sewerageNotice, sewerageApplicationDetails.getClosureNoticeNumber(), new Date(), "Close Connection Notice");
            String fileName = sewerageApplicationDetails.getClosureNoticeNumber() + ".pdf";
            FileStoreMapper fileStore = this.fileStoreService.store(fileStream, fileName, APPLICATION_PDF, "STMS");
            sewerageNotice.setFileStore(fileStore);
        }
        return sewerageNotice;
    }

    @Transactional
    public SewerageNotice buildDemandBillNotice(SewerageApplicationDetails sewerageApplicationDetails, InputStream fileStream, String demandBillNumber) {
        SewerageNotice sewerageNotice = null;
        if (sewerageApplicationDetails != null) {
            sewerageNotice = new SewerageNotice();
            this.buildSewerageNotice(sewerageApplicationDetails, sewerageNotice, demandBillNumber, new Date(), "Demand Bill");
        }
        String fileName = demandBillNumber + ".pdf";
        FileStoreMapper fileStoreMapper = this.fileStoreService.store(fileStream, fileName, APPLICATION_PDF, "STMS");
        sewerageNotice.setFileStore(fileStoreMapper);
        return sewerageNotice;
    }
}

