/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.masters.service;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.stms.masters.entity.SewerageRatesMaster;
import org.egov.stms.masters.entity.SewerageRatesMasterDetails;
import org.egov.stms.masters.entity.enums.PropertyType;
import org.egov.stms.masters.pojo.SewerageRatesSearch;
import org.egov.stms.masters.repository.SewerageRatesMasterRepository;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class SewerageRatesMasterService {
    SimpleDateFormat myFormat = new SimpleDateFormat("dd-MM-yyyy");
    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private SewerageRatesMasterRepository sewerageRatesMasterRepository;

    public SewerageRatesMaster findBy(Long id) {
        return (SewerageRatesMaster)((Object)this.sewerageRatesMasterRepository.findOne(id));
    }

    @Transactional
    public SewerageRatesMaster create(SewerageRatesMaster sewerageRatesMaster) {
        return (SewerageRatesMaster)((Object)this.sewerageRatesMasterRepository.save((Object)sewerageRatesMaster));
    }

    @Transactional
    public SewerageRatesMaster update(SewerageRatesMaster sewerageRatesMaster) {
        return (SewerageRatesMaster)((Object)this.sewerageRatesMasterRepository.saveAndFlush((Object)sewerageRatesMaster));
    }

    public List<SewerageRatesMaster> findAll() {
        return this.sewerageRatesMasterRepository.findAll(new Sort(Sort.Direction.DESC, new String[]{"propertyType", "fromDate"}));
    }

    public List<SewerageRatesMaster> findAllByConnectionType(PropertyType propertyType) {
        return this.sewerageRatesMasterRepository.findAllByPropertyType(propertyType);
    }

    public SewerageRatesMaster load(Long id) {
        return (SewerageRatesMaster)((Object)this.sewerageRatesMasterRepository.getOne(id));
    }

    public SewerageRatesMaster findByPropertyTypeAndFromDateAndActive(PropertyType propertyType, Date fromDate, boolean active) {
        return this.sewerageRatesMasterRepository.findByPropertyTypeAndFromDateAndActive(propertyType, fromDate, active);
    }

    public SewerageRatesMaster findByPropertyTypeAndActive(PropertyType propertyType, boolean active) {
        return this.sewerageRatesMasterRepository.findByPropertyTypeAndActive(propertyType, active);
    }

    public Double getSewerageMonthlyRatesByPropertytype(PropertyType propertyType) {
        return this.sewerageRatesMasterRepository.getSewerageMonthlyRatesByPropertytype(propertyType);
    }

    public List<SewerageRatesMaster> getLatestActiveRecord(PropertyType propertyType, boolean active) {
        return this.sewerageRatesMasterRepository.getLatestActiveRecord(propertyType, true, new Date());
    }

    public List<Date> findFromDateByPropertyType(PropertyType propertyType) {
        return this.sewerageRatesMasterRepository.findFromDateByPropertyType(propertyType);
    }

    public List<SewerageRatesSearch> getSewerageMasters(PropertyType propertyType, String date, String status) {
        ArrayList<SewerageRatesSearch> sewerageMasterSearchRecords = new ArrayList<SewerageRatesSearch>();
        List<SewerageRatesMaster> sewerageMasterRecords = this.searchConnectionRecordsBySearchParams(propertyType, date, status);
        for (SewerageRatesMaster sewerageMasterRecord : sewerageMasterRecords) {
            SewerageRatesSearch swsearch = new SewerageRatesSearch();
            swsearch.setPropertyType(sewerageMasterRecord.getPropertyType().toString());
            swsearch.setMonthlyRate(sewerageMasterRecord.getMonthlyRate());
            swsearch.setFromDate(sewerageMasterRecord.getFromDate().toString());
            swsearch.setModifiedDate(sewerageMasterRecord.getLastModifiedDate().toString());
            swsearch.setId(sewerageMasterRecord.getId());
            swsearch.setActive(sewerageMasterRecord.isActive());
            sewerageMasterSearchRecords.add(swsearch);
            String todaysdate = this.myFormat.format(new Date());
            String effectiveFromDate = this.myFormat.format(sewerageMasterRecord.getFromDate());
            if (effectiveFromDate.compareTo(todaysdate) < 0) {
                swsearch.setEditable(false);
                continue;
            }
            swsearch.setEditable(true);
        }
        return sewerageMasterSearchRecords;
    }

    public List<SewerageRatesMaster> searchConnectionRecordsBySearchParams(PropertyType propertyType, String date, String status) {
        Criteria connectionCriteria = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(SewerageRatesMaster.class, "donation");
        if (null != propertyType) {
            connectionCriteria.add((Criterion)Restrictions.eq((String)"propertyType", (Object)((Object)propertyType)));
        }
        if (null != date) {
            String formattedDate = null;
            Date fDate = null;
            try {
                formattedDate = this.formatter.format(this.myFormat.parse(date));
                fDate = this.formatter.parse(formattedDate);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            connectionCriteria.add((Criterion)Restrictions.eq((String)"fromDate", fDate));
        }
        if (null != status) {
            if (status.equals("ACTIVE")) {
                boolean var = true;
                connectionCriteria.add((Criterion)Restrictions.eq((String)"active", (Object)var));
            } else {
                boolean var = false;
                connectionCriteria.add((Criterion)Restrictions.eq((String)"active", (Object)var));
            }
        } else {
            boolean a = true;
            connectionCriteria.add((Criterion)Restrictions.eq((String)"active", (Object)a));
        }
        connectionCriteria.addOrder(Order.desc((String)"fromDate"));
        return connectionCriteria.list();
    }

    public AppConfigValues getAppConfigValuesForSeweargeRate(String moduleName, String keyName) {
        List appConfigValues = this.appConfigValuesService.getConfigValuesByModuleAndKey(moduleName, keyName);
        return !appConfigValues.isEmpty() ? (AppConfigValues)appConfigValues.get(0) : null;
    }

    @Transactional
    public void updateSewerageRateMaster(SewerageRatesMaster sewerageRateMaster, SewerageRatesMaster sewerageRateMstr, List<SewerageRatesMasterDetails> existingSewerageDetailList) {
        if (!existingSewerageDetailList.isEmpty()) {
            for (SewerageRatesMasterDetails dtlObject : existingSewerageDetailList) {
                if (sewerageRateMaster.getSewerageDetailmaster().contains(dtlObject)) continue;
                sewerageRateMstr.deleteSewerageRateDetail(dtlObject);
            }
            for (SewerageRatesMasterDetails dtlMaster : sewerageRateMaster.getSewerageDetailmaster()) {
                if (dtlMaster.getId() == null) {
                    SewerageRatesMasterDetails sewerageDetailObject = new SewerageRatesMasterDetails();
                    sewerageDetailObject.setNoOfClosets(dtlMaster.getNoOfClosets());
                    sewerageDetailObject.setAmount(dtlMaster.getAmount());
                    sewerageDetailObject.setSewerageratemaster(sewerageRateMstr);
                    sewerageRateMstr.addSewerageRateDetail(sewerageDetailObject);
                    continue;
                }
                if (dtlMaster.getId() == null || !existingSewerageDetailList.contains(dtlMaster)) continue;
                this.updateSewerageRatedetail(sewerageRateMstr, dtlMaster);
            }
        }
        this.update(sewerageRateMstr);
    }

    private void updateSewerageRatedetail(SewerageRatesMaster sewerageMstr, SewerageRatesMasterDetails dtlMaster) {
        for (SewerageRatesMasterDetails dtlObject : sewerageMstr.getSewerageDetailmaster()) {
            if (!dtlObject.getId().equals(dtlMaster.getId())) continue;
            dtlObject.setAmount(dtlMaster.getAmount());
            dtlObject.setNoOfClosets(dtlMaster.getNoOfClosets());
        }
    }

    public Double getSewerageMonthlyRatesByPropertytype(Integer noOfClosetsResidential, PropertyType propertyType) {
        return this.sewerageRatesMasterRepository.getSewerageMonthlyRatesBytNoOfClosetsAndPropertytype(noOfClosetsResidential, propertyType);
    }
}

