/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.masters.service;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.stms.masters.entity.DonationDetailMaster;
import org.egov.stms.masters.entity.DonationMaster;
import org.egov.stms.masters.entity.enums.PropertyType;
import org.egov.stms.masters.pojo.DonationMasterSearch;
import org.egov.stms.masters.repository.DonationMasterRepository;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class DonationMasterService {
    SimpleDateFormat myFormat = new SimpleDateFormat("dd-MM-yyyy");
    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
    private static final Logger LOG = LoggerFactory.getLogger(DonationMasterService.class);
    @Autowired
    private final DonationMasterRepository donationMasterRepository;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    @Qualifier(value="parentMessageSource")
    private MessageSource stmsMessageSource;

    @Autowired
    public DonationMasterService(DonationMasterRepository donationMasterRepository) {
        this.donationMasterRepository = donationMasterRepository;
    }

    public DonationMaster findById(Long id) {
        return (DonationMaster)((Object)this.donationMasterRepository.findOne(id));
    }

    @Transactional
    public DonationMaster create(DonationMaster donationMaster) {
        return (DonationMaster)((Object)this.donationMasterRepository.save((Object)donationMaster));
    }

    @Transactional
    public void update(DonationMaster donationMaster) {
        this.donationMasterRepository.save((Object)donationMaster);
    }

    public List<DonationMaster> findAll() {
        return this.donationMasterRepository.findAll(new Sort(Sort.Direction.DESC, new String[]{"propertyType", "fromDate"}));
    }

    public List<DonationMaster> findAllByPropertyType(PropertyType propertyType) {
        return this.donationMasterRepository.findAllByPropertyType(propertyType);
    }

    public DonationMaster load(Long id) {
        return (DonationMaster)((Object)this.donationMasterRepository.getOne(id));
    }

    public DonationMaster findByPropertyTypeAndFromDateAndActive(PropertyType propertyType, Date fromDate, boolean active) {
        return this.donationMasterRepository.findByPropertyTypeAndFromDateAndActive(propertyType, fromDate, active);
    }

    public DonationMaster findByPropertyTypeAndActive(PropertyType propertyType, boolean active) {
        return this.donationMasterRepository.findByPropertyTypeAndActive(propertyType, active);
    }

    public BigDecimal getDonationAmountByNoOfClosetsAndPropertytypeForCurrentDate(Integer noOfClosetsResidential, PropertyType propertyType) {
        return this.donationMasterRepository.getDonationAmountByNoOfClosetsAndPropertytypeForCurrentDate(noOfClosetsResidential, propertyType);
    }

    public List<DonationMaster> getLatestActiveRecordByPropertyTypeAndActive(PropertyType propertyType, boolean active) {
        return this.donationMasterRepository.getLatestActiveRecordByPropertyTypeAndActive(propertyType, active, new Date());
    }

    public List<DonationMasterSearch> getDonationMasters(PropertyType propertyType, String date, String status) {
        ArrayList<DonationMasterSearch> donationMasterSearchRecords = new ArrayList<DonationMasterSearch>();
        List<DonationMaster> donationMasterRecords = this.searchConnectionRecordsBySearchParams(propertyType, date, status);
        for (DonationMaster donationMasterRecord : donationMasterRecords) {
            DonationMasterSearch dmsearch = new DonationMasterSearch();
            dmsearch.setPropertyType(donationMasterRecord.getPropertyType().toString());
            dmsearch.setSize(donationMasterRecord.getDonationDetail().size());
            dmsearch.setFromDate(donationMasterRecord.getFromDate().toString());
            dmsearch.setModifiedDate(donationMasterRecord.getLastModifiedDate().toString());
            dmsearch.setId(donationMasterRecord.getId());
            dmsearch.setActive(donationMasterRecord.isActive());
            try {
                Date effectivedate = this.myFormat.parse(this.myFormat.format(donationMasterRecord.getFromDate()));
                dmsearch.setEditable(false);
                if (effectivedate.compareTo(this.myFormat.parse(this.myFormat.format(new Date()))) >= 0) {
                    dmsearch.setEditable(true);
                }
            }
            catch (ParseException e) {
                LOG.error("Parse Exception " + e);
            }
            donationMasterSearchRecords.add(dmsearch);
        }
        return donationMasterSearchRecords;
    }

    @Transactional
    public DonationMaster createDonationRate(DonationMaster donationMaster) {
        return (DonationMaster)((Object)this.donationMasterRepository.save((Object)donationMaster));
    }

    @Transactional
    public void delete(DonationMaster donationMaster) {
        this.donationMasterRepository.delete((Object)donationMaster);
    }

    public List<DonationMaster> searchConnectionRecordsBySearchParams(PropertyType propertyType, String date, String status) {
        Criteria connectionCriteria = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(DonationMaster.class, "donation");
        if (null != propertyType) {
            connectionCriteria.add((Criterion)Restrictions.eq((String)"propertyType", (Object)((Object)propertyType)));
        }
        if (null != date) {
            String formattedDate = null;
            Date fDate = null;
            try {
                formattedDate = this.formatter.format(this.myFormat.parse(date));
                fDate = this.formatter.parse(formattedDate);
            }
            catch (ParseException e) {
                LOG.error("Parse Exception " + e);
            }
            connectionCriteria.add((Criterion)Restrictions.eq((String)"fromDate", (Object)fDate));
        }
        if (null != status && !status.equals("ACTIVE")) {
            connectionCriteria.add((Criterion)Restrictions.eq((String)"active", (Object)false));
        } else {
            connectionCriteria.add((Criterion)Restrictions.eq((String)"active", (Object)true));
        }
        connectionCriteria.addOrder(Order.asc((String)"propertyType"));
        connectionCriteria.addOrder(Order.desc((String)"fromDate"));
        connectionCriteria.addOrder(Order.desc((String)"lastModifiedDate"));
        return connectionCriteria.list();
    }

    public List<Date> findFromDateByPropertyType(PropertyType propertyType) {
        return this.donationMasterRepository.findFromDateByPropertyType(propertyType);
    }

    public String checkClosetsPresentForGivenCombination(PropertyType propertyType, Integer noofclosets) {
        String validationMessage = "";
        DonationDetailMaster donationDetailMaster = this.donationMasterRepository.getDonationDetailMasterByNoOfClosetsAndPropertytypeForCurrentDate(propertyType, noofclosets);
        if (donationDetailMaster == null) {
            validationMessage = this.stmsMessageSource.getMessage("err.validate.sewerage.closets.isPresent", (Object[])new String[]{propertyType.toString(), noofclosets.toString()}, null);
        }
        return validationMessage;
    }
}

