/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.masters.repository;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.egov.stms.masters.entity.DonationDetailMaster;
import org.egov.stms.masters.entity.DonationMaster;
import org.egov.stms.masters.entity.enums.PropertyType;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface DonationMasterRepository
extends JpaRepository<DonationMaster, Long> {
    public List<DonationMaster> findAllByPropertyType(PropertyType var1);

    public DonationMaster findByPropertyTypeAndFromDateAndActive(PropertyType var1, Date var2, boolean var3);

    public DonationMaster findByPropertyTypeAndActive(PropertyType var1, boolean var2);

    @Query(value="select ddm.amount from DonationDetailMaster ddm where ddm.donation.propertyType =:propertyType and ddm.noOfClosets =:noofclosets and ddm.donation.active = true and ddm.donation.fromDate  <= current_date and (ddm.donation.toDate >= current_date or ddm.donation.toDate is null)")
    public BigDecimal getDonationAmountByNoOfClosetsAndPropertytypeForCurrentDate(@Param(value="noofclosets") Integer var1, @Param(value="propertyType") PropertyType var2);

    @Query(value="select D from DonationMaster D where D.propertyType=:propertyType and D.active=:active and ( D.fromDate<=:date or (D.toDate is null or D.toDate<=:date)) order by D.fromDate desc")
    public List<DonationMaster> getLatestActiveRecordByPropertyTypeAndActive(@Param(value="propertyType") PropertyType var1, @Param(value="active") boolean var2, @Param(value="date") Date var3);

    @Query(value="select distinct(D.fromDate) from DonationMaster D where D.propertyType=:propertyType order by D.fromDate asc")
    public List<Date> findFromDateByPropertyType(@Param(value="propertyType") PropertyType var1);

    @Query(value="select ddm from DonationDetailMaster ddm where ddm.donation.propertyType =:propertyType and ddm.noOfClosets =:noofclosets and ddm.donation.active = true and ddm.donation.fromDate <=current_date and (ddm.donation.toDate >= current_date or ddm.donation.toDate is null)")
    public DonationDetailMaster getDonationDetailMasterByNoOfClosetsAndPropertytypeForCurrentDate(@Param(value="propertyType") PropertyType var1, @Param(value="noofclosets") Integer var2);
}

