/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.autonumber.impl;

import java.io.Serializable;
import org.egov.infra.persistence.utils.ApplicationSequenceNumberGenerator;
import org.egov.stms.autonumber.SewerageRejectionNoticeNumberGenerator;
import org.egov.stms.utils.SewerageTaxUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SewerageRejectionNoticeNumberGeneratorImpl
implements SewerageRejectionNoticeNumberGenerator {
    private static final String REJECTION_NOTICE_NUMBER_SEQ_PREFIX = "SEQ_EGSWTAX_REJECTION_NOTICE_NUMBER";
    @Autowired
    private ApplicationSequenceNumberGenerator applicationSequenceNumberGenerator;
    @Autowired
    private SewerageTaxUtils sewerageTaxUtils;

    @Override
    public String generateRejectionNoticeNumber() {
        String sequenceName = REJECTION_NOTICE_NUMBER_SEQ_PREFIX;
        Serializable nextSequence = this.applicationSequenceNumberGenerator.getNextSequence(REJECTION_NOTICE_NUMBER_SEQ_PREFIX);
        return String.format("%s%06d", this.sewerageTaxUtils.getCityCode(), nextSequence);
    }
}

