/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.egov.commons.EgwStatus;
import org.egov.commons.Installment;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.commons.dao.InstallmentDao;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.DesignationService;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.workflow.entity.State;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.pims.commons.Designation;
import org.egov.pims.commons.Position;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.enums.BasicPropertyStatus;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.ptis.wtms.PropertyIntegrationService;
import org.egov.stms.transactions.entity.SewerageApplicationDetails;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.multipart.MultipartFile;

@Service
public class SewerageTaxUtils {
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    @Qualifier(value="propertyIntegrationServiceImpl")
    private PropertyIntegrationService propertyIntegrationService;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private DesignationService designationService;
    @Autowired
    private UserService userService;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    private CityService cityService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private InstallmentDao installmentDao;
    @Autowired
    @Qualifier(value="fileStoreService")
    protected FileStoreService fileStoreService;

    public Boolean isNewConnectionAllowedIfPTDuePresent() {
        List appConfigValue = this.appConfigValuesService.getConfigValuesByModuleAndKey("Sewerage Tax Management", "NEWCONNECTIONALLOWEDIFPTDUE");
        if (appConfigValue != null && appConfigValue.size() > 0) {
            return "YES".equalsIgnoreCase(((AppConfigValues)appConfigValue.get(0)).getValue());
        }
        return false;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public EgwStatus getStatusByCodeAndModuleType(String code, String moduleName) {
        return this.egwStatusHibernateDAO.getStatusByModuleAndCode(moduleName, code);
    }

    public AssessmentDetails getAssessmentDetailsForFlag(String asessmentNumber, Integer flagDetail) {
        AssessmentDetails assessmentDetails = this.propertyIntegrationService.getAssessmentDetailsForFlag(asessmentNumber, flagDetail, BasicPropertyStatus.ACTIVE);
        return assessmentDetails;
    }

    public Boolean getCurrentUserRole(User currentUser) {
        return true;
    }

    public String getApproverName(Long approvalPosition) {
        Assignment assignment = null;
        List<Object> asignList = null;
        if (approvalPosition != null) {
            assignment = this.assignmentService.getPrimaryAssignmentForPositionAndDate(approvalPosition, new Date());
        }
        if (assignment != null) {
            asignList = new ArrayList<Assignment>();
            asignList.add(assignment);
        } else if (assignment == null) {
            asignList = this.assignmentService.getAssignmentsForPosition(approvalPosition, new Date());
        }
        return !asignList.isEmpty() ? ((Assignment)asignList.get(0)).getEmployee().getName() : "";
    }

    public Position getZonalLevelClerkForLoggedInUser(String asessmentNumber) {
        AssessmentDetails assessmentDetails = this.getAssessmentDetailsForFlag(asessmentNumber, PropertyExternalService.FLAG_FULL_DETAILS);
        Assignment assignmentObj = null;
        Boundary boundaryObj = this.boundaryService.getBoundaryById(assessmentDetails.getBoundaryDetails().getAdminWardId());
        assignmentObj = this.getUserPositionByZone(asessmentNumber, assessmentDetails, boundaryObj);
        return assignmentObj != null ? assignmentObj.getPosition() : null;
    }

    public Assignment getUserPositionByZone(String asessmentNumber, AssessmentDetails assessmentDetails, Boundary boundaryObj) {
        String designationStr = this.getDesignationForThirdPartyUser();
        String departmentStr = this.getDepartmentForWorkFlow();
        String[] department = departmentStr.split(",");
        String[] designation = designationStr.split(",");
        List assignment = new ArrayList();
        for (String dept : department) {
            for (String desg : designation) {
                assignment = this.assignmentService.findByDepartmentDesignationAndBoundary(this.departmentService.getDepartmentByName(dept).getId(), this.designationService.getDesignationByName(desg).getId(), boundaryObj.getId());
                if (!assignment.isEmpty()) break;
            }
            if (!assignment.isEmpty()) break;
        }
        return !assignment.isEmpty() ? (Assignment)assignment.get(0) : null;
    }

    public String getDesignationForThirdPartyUser() {
        String designation = "";
        List appConfigValue = this.appConfigValuesService.getConfigValuesByModuleAndKey("Sewerage Tax Management", "CLERKDESIGNATIONFORCSCOPERATOR");
        if (null != appConfigValue && !appConfigValue.isEmpty()) {
            designation = ((AppConfigValues)appConfigValue.get(0)).getValue();
        }
        return designation;
    }

    public String getDepartmentForWorkFlow() {
        String department = "";
        List appConfigValue = this.appConfigValuesService.getConfigValuesByModuleAndKey("Sewerage Tax Management", "DEPARTMENTFORWORKFLOW");
        if (null != appConfigValue && !appConfigValue.isEmpty()) {
            department = ((AppConfigValues)appConfigValue.get(0)).getValue();
        }
        return department;
    }

    public Long getApproverPosition(String designationName, SewerageApplicationDetails sewerageApplicationDetails) {
        Set stateHistoryList = sewerageApplicationDetails.getState().getHistory();
        Long approverPosition = 0L;
        String[] desgnArray = designationName.split(",");
        User currentUser = null;
        if (stateHistoryList != null && !stateHistoryList.isEmpty()) {
            currentUser = this.userService.getUserById(sewerageApplicationDetails.getCreatedBy().getId());
            if (currentUser != null && sewerageApplicationDetails.getConnection().getLegacy()) {
                for (Role userrole : currentUser.getRoles()) {
                    if (!userrole.getName().equals("SYSTEM")) continue;
                    Position positionuser = this.getZonalLevelClerkForLoggedInUser(sewerageApplicationDetails.getConnectionDetail().getPropertyIdentifier());
                    approverPosition = positionuser.getId();
                    break;
                }
            } else {
                for (StateHistory stateHistory : stateHistoryList) {
                    if (stateHistory.getOwnerPosition() == null) continue;
                    List assignmentList = this.assignmentService.getAssignmentsForPosition(stateHistory.getOwnerPosition().getId(), new Date());
                    Iterator iterator = assignmentList.iterator();
                    block2: while (iterator.hasNext()) {
                        Assignment assgn = (Assignment)iterator.next();
                        for (String str : desgnArray) {
                            if (!assgn.getDesignation().getName().equalsIgnoreCase(str)) continue;
                            approverPosition = stateHistory.getOwnerPosition().getId();
                            continue block2;
                        }
                    }
                }
                if (approverPosition == 0L) {
                    State stateObj = sewerageApplicationDetails.getState();
                    List assignmentList = this.assignmentService.getAssignmentsForPosition(stateObj.getOwnerPosition().getId(), new Date());
                    for (Assignment assgn : assignmentList) {
                        if (!assgn.getDesignation().getName().equalsIgnoreCase(designationName)) continue;
                        approverPosition = stateObj.getOwnerPosition().getId();
                        break;
                    }
                }
            }
        } else {
            currentUser = this.userService.getUserById(sewerageApplicationDetails.getCreatedBy().getId());
            if (currentUser != null && sewerageApplicationDetails.getConnection().getLegacy()) {
                for (Role userrole : currentUser.getRoles()) {
                    if (!userrole.getName().equals("SYSTEM")) continue;
                    Position positionuser = this.getZonalLevelClerkForLoggedInUser(sewerageApplicationDetails.getConnectionDetail().getPropertyIdentifier());
                    approverPosition = positionuser.getId();
                    break;
                }
            } else {
                Position posObjToClerk = this.positionMasterService.getCurrentPositionForUser(sewerageApplicationDetails.getCreatedBy().getId());
                approverPosition = posObjToClerk.getId();
            }
        }
        return approverPosition;
    }

    public Position getCityLevelExecutiveEngineerPosition(String execEnggDesgn) {
        String execEnggDesgnName = "";
        String[] degnName = execEnggDesgn.split(",");
        execEnggDesgnName = degnName.length > 1 ? degnName[0] : execEnggDesgn;
        Designation desgnObj = this.designationService.getDesignationByName(execEnggDesgn);
        if (execEnggDesgn.equals("Executive engineer")) {
            Department deptObj = this.departmentService.getDepartmentByName("Engineering");
            List assignlist = null;
            assignlist = this.assignmentService.getAssignmentsByDeptDesigAndDates(deptObj.getId(), desgnObj.getId(), new Date(), new Date());
            if (assignlist.isEmpty()) {
                assignlist = this.assignmentService.getAllPositionsByDepartmentAndDesignationForGivenRange(null, desgnObj.getId(), new Date());
            }
            if (assignlist.isEmpty()) {
                assignlist = this.assignmentService.getAllActiveAssignments(desgnObj.getId());
            }
            return ((Assignment)assignlist.get(0)).getPosition();
        }
        return !this.assignmentService.findPrimaryAssignmentForDesignationName(execEnggDesgnName).isEmpty() ? ((Assignment)this.assignmentService.findPrimaryAssignmentForDesignationName(execEnggDesgnName).get(0)).getPosition() : null;
    }

    public Position getCityLevelDeputyEngineerPosition(String deputyEngineerDesgn) {
        String deputydesgnname = "";
        String[] degnName = deputyEngineerDesgn.split(",");
        deputydesgnname = degnName.length > 1 ? degnName[0] : deputyEngineerDesgn;
        Designation desgnObj = this.designationService.getDesignationByName(deputyEngineerDesgn);
        if (deputyEngineerDesgn.equalsIgnoreCase("Deputy executive engineer")) {
            Department deptObj = this.departmentService.getDepartmentByName("Engineering");
            List assignlist = null;
            assignlist = this.assignmentService.getAssignmentsByDeptDesigAndDates(deptObj.getId(), desgnObj.getId(), new Date(), new Date());
            if (assignlist.isEmpty()) {
                assignlist = this.assignmentService.getAllPositionsByDepartmentAndDesignationForGivenRange(null, desgnObj.getId(), new Date());
            }
            if (assignlist.isEmpty()) {
                assignlist = this.assignmentService.getAllActiveAssignments(desgnObj.getId());
            }
            return ((Assignment)assignlist.get(0)).getPosition();
        }
        return !this.assignmentService.findPrimaryAssignmentForDesignationName(deputydesgnname).isEmpty() ? ((Assignment)this.assignmentService.findPrimaryAssignmentForDesignationName(deputydesgnname).get(0)).getPosition() : null;
    }

    public String getCityCode() {
        return this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName()).getCode();
    }

    @ModelAttribute(value="checkOperator")
    public Boolean checkCollectionOperatorRole() {
        User userObj;
        Boolean isCSCOperator = false;
        if (ApplicationThreadLocals.getUserId() != null && (userObj = this.userService.getUserById(ApplicationThreadLocals.getUserId())) != null) {
            for (Role role : userObj.getRoles()) {
                if (role == null || !role.getName().contains("Collection Operator")) continue;
                isCSCOperator = true;
                break;
            }
        }
        return isCSCOperator;
    }

    public Boolean getCitizenUserRole() {
        Boolean citizenrole = Boolean.FALSE;
        if (ApplicationThreadLocals.getUserId() != null) {
            User currentUser = this.userService.getUserById(ApplicationThreadLocals.getUserId());
            if (currentUser.getRoles().isEmpty() && this.securityUtils.getCurrentUser().getUsername().equals("anonymous")) {
                citizenrole = Boolean.TRUE;
            }
            for (Role userrole : currentUser.getRoles()) {
                if (userrole == null || !userrole.getName().equals("CITIZEN")) continue;
                citizenrole = Boolean.TRUE;
                break;
            }
        } else {
            citizenrole = Boolean.TRUE;
        }
        return citizenrole;
    }

    public boolean isInspectionFeeCollectionRequired() {
        AppConfigValues inspectionFeeCollectionRqd = (AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey("Sewerage Tax Management", "SEWERAGE_COLLECTINSPECTION_FEE").get(0);
        return inspectionFeeCollectionRqd != null && inspectionFeeCollectionRqd.getValue() != null && inspectionFeeCollectionRqd.getValue().equals("YES");
    }

    public List<Role> getLoginUserRoles() {
        ArrayList<Role> roleList = new ArrayList<Role>();
        if (ApplicationThreadLocals.getUserId() != null) {
            User currentUser = this.userService.getUserById(ApplicationThreadLocals.getUserId());
            for (Role userrole : currentUser.getRoles()) {
                roleList.add(userrole);
            }
        }
        return roleList;
    }

    public String getMunicipalityName() {
        return ApplicationThreadLocals.getMunicipalityName();
    }

    public List<Installment> getInstallmentsForCurrYear(Date currDate) {
        Module module = this.moduleService.getModuleByName("Sewerage Tax Management");
        List installments = this.installmentDao.getAllInstallmentsByModuleAndStartDate(module, currDate);
        return installments;
    }

    public List<Installment> getInstallmentsByModuledescendingorder(Module module, int year) {
        List installments = this.installmentDao.getInstallmentsByModuleAndInstallmentYearOrderByInstallmentYearDescending(this.moduleService.getModuleByName("Sewerage Tax Management"), year);
        return installments;
    }

    public Set<FileStoreMapper> addToFileStore(MultipartFile[] files) {
        if (ArrayUtils.isNotEmpty((Object[])files)) {
            return Arrays.asList(files).stream().filter(file -> !file.isEmpty()).map(file -> {
                try {
                    return this.fileStoreService.store(file.getInputStream(), file.getOriginalFilename(), file.getContentType(), "STMS");
                }
                catch (Exception e) {
                    throw new ApplicationRuntimeException("Error occurred while getting inputstream", (Throwable)e);
                }
            }).collect(Collectors.toSet());
        }
        return null;
    }

    public boolean isDonationChargeCollectionRequiredForLegacy() {
        AppConfigValues donationChargeConfig = (AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey("Sewerage Tax Management", "LEGACY_DONATION_CHARGE").get(0);
        return donationChargeConfig != null && donationChargeConfig.getValue() != null && "YES".equals(donationChargeConfig.getValue());
    }
}

