/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.transactions.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.log4j.Logger;
import org.egov.commons.Installment;
import org.egov.commons.dao.InstallmentDao;
import org.egov.demand.dao.DemandGenericDao;
import org.egov.demand.model.BillReceipt;
import org.egov.demand.model.EgDemand;
import org.egov.demand.model.EgDemandDetails;
import org.egov.demand.model.EgDemandReason;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.stms.entity.SewerageDemandGenerationLog;
import org.egov.stms.masters.entity.enums.SewerageProcessStatus;
import org.egov.stms.transactions.entity.SewerageApplicationDetails;
import org.egov.stms.transactions.entity.SewerageConnectionFee;
import org.egov.stms.transactions.entity.SewerageDemandConnection;
import org.egov.stms.transactions.entity.SewerageDemandDetail;
import org.egov.stms.transactions.repository.SewerageDemandGenerationLogRepository;
import org.egov.stms.transactions.service.SewerageApplicationDetailsService;
import org.egov.stms.transactions.service.SewerageDemandGenerationLogService;
import org.egov.stms.utils.SewerageTaxUtils;
import org.hibernate.Query;
import org.hibernate.Session;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

@Service
@Transactional(readOnly=true)
public class SewerageDemandService {
    private static final Logger LOGGER = Logger.getLogger(SewerageDemandService.class);
    private static final String SUCCESSFUL = "Successful";
    private final List<EgDemandDetails> detailList = new ArrayList<EgDemandDetails>();
    @Autowired
    protected SewerageApplicationDetailsService sewerageApplicationDetailsService;
    @Autowired
    private InstallmentDao installmentDao;
    @Autowired
    private DemandGenericDao demandGenericDao;
    @Autowired
    private ModuleService moduleService;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private SewerageDemandGenerationLogService stDemandGenerationLogService;
    @Autowired
    private SewerageDemandGenerationLogRepository demandGenerationLogRepository;
    @Autowired
    private SewerageTaxUtils sewerageTaxUtils;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public EgDemandReason getDemandReasonByCodeAndInstallment(String demandReason, Integer installment) {
        Query demandQuery = this.getCurrentSession().getNamedQuery("DEMANDREASONBY_CODE_AND_INSTALLMENTID");
        demandQuery.setParameter(0, (Object)demandReason);
        demandQuery.setParameter(1, (Object)installment);
        return (EgDemandReason)demandQuery.uniqueResult();
    }

    private EgDemand createDemand(Set<EgDemandDetails> demandDetailSet, Installment installment, BigDecimal totalDemandAmount) {
        EgDemand egDemand = new EgDemand();
        egDemand.setEgInstallmentMaster(installment);
        egDemand.getEgDemandDetails().addAll(demandDetailSet);
        egDemand.setIsHistory("N");
        egDemand.setCreateDate(new Date());
        egDemand.setBaseDemand(totalDemandAmount.setScale(0, 4));
        egDemand.setModifiedDate(new Date());
        return egDemand;
    }

    public Installment getCurrentInstallment() {
        return this.installmentDao.getInsatllmentByModuleForGivenDate(this.moduleService.getModuleByName("Sewerage Tax Management"), new Date());
    }

    public Installment getNextInstallment() {
        Installment currentInstlalment = this.getCurrentInstallment();
        if (currentInstlalment != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(currentInstlalment.getToDate());
            calendar.add(5, 1);
            return this.installmentDao.getInsatllmentByModuleForGivenDate(this.moduleService.getModuleByName("Sewerage Tax Management"), calendar.getTime());
        }
        return null;
    }

    public Installment getInstallmentByDescription(String description) {
        return this.installmentDao.getInsatllmentByModuleAndDescription(this.moduleService.getModuleByName("Sewerage Tax Management"), description);
    }

    public Installment getInsatllmentByModuleForGivenDate(Date installmentDate) {
        return this.installmentDao.getInsatllmentByModuleForGivenDate(this.moduleService.getModuleByName("Sewerage Tax Management"), installmentDate);
    }

    public List<Installment> getPreviousInstallment(Date curentInstalmentEndate) {
        return this.installmentDao.fetchPreviousInstallmentsInDescendingOrderByModuleAndDate(this.moduleService.getModuleByName("Sewerage Tax Management"), curentInstalmentEndate, 1);
    }

    public EgDemandDetails createDemandDetails(EgDemand demand, BigDecimal dmdAmount, EgDemandReason egDemandReason, BigDecimal amtCollected) {
        EgDemandDetails demandDetail = EgDemandDetails.fromReasonAndAmounts((BigDecimal)dmdAmount.setScale(0, 4), (EgDemandReason)egDemandReason, (BigDecimal)amtCollected);
        if (demandDetail != null) {
            demandDetail.setEgDemand(demand);
            return demandDetail;
        }
        return null;
    }

    public EgDemandDetails createDemandDetails(BigDecimal dmdAmount, EgDemandReason egDemandReason, BigDecimal amtCollected) {
        return EgDemandDetails.fromReasonAndAmounts((BigDecimal)dmdAmount.setScale(0, 4), (EgDemandReason)egDemandReason, (BigDecimal)amtCollected);
    }

    public Boolean checkAnyTaxIsPendingToCollect(EgDemand demand) {
        Boolean pendingTaxCollection = false;
        if (demand != null) {
            for (EgDemandDetails demandDtl : demand.getEgDemandDetails()) {
                if (demandDtl.getAmount().subtract(demandDtl.getAmtCollected()).compareTo(BigDecimal.ZERO) <= 0) continue;
                pendingTaxCollection = true;
                break;
            }
        }
        return pendingTaxCollection;
    }

    public BigDecimal checkForPendingTaxAmountToCollect(EgDemand demand) {
        BigDecimal pendingTaxCollection = BigDecimal.ZERO;
        if (demand != null) {
            for (EgDemandDetails demandDtl : demand.getEgDemandDetails()) {
                if (demandDtl.getEgDemandReason().getEgDemandReasonMaster().getCode().equals("SEWERAGEADVANCE") || demandDtl.getAmount().subtract(demandDtl.getAmtCollected()).compareTo(BigDecimal.ZERO) <= 0) continue;
                pendingTaxCollection = pendingTaxCollection.add(demandDtl.getAmount().subtract(demandDtl.getAmtCollected()));
            }
        }
        return pendingTaxCollection;
    }

    public Boolean checkAnyTaxIsPendingToCollectExcludingAdvance(EgDemand demand) {
        Boolean taxPendingForCollection = false;
        if (demand != null) {
            for (EgDemandDetails demandDtl : demand.getEgDemandDetails()) {
                if (demandDtl.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("SEWERAGEADVANCE") || demandDtl.getAmount().subtract(demandDtl.getAmtCollected()).compareTo(BigDecimal.ZERO) <= 0) continue;
                taxPendingForCollection = true;
                break;
            }
        }
        return taxPendingForCollection;
    }

    public Boolean checkAnyTaxPendingForSelectedFinancialYear(SewerageDemandConnection sewerageDemandConnection, Installment installment) {
        Boolean pendingTaxCollection = false;
        if (sewerageDemandConnection != null && sewerageDemandConnection.getDemand() != null) {
            for (EgDemandDetails demandDtl : sewerageDemandConnection.getDemand().getEgDemandDetails()) {
                if (!demandDtl.getEgDemandReason().getEgInstallmentMaster().getId().equals(installment.getId()) || demandDtl.getAmount().subtract(demandDtl.getAmtCollected()).compareTo(BigDecimal.ZERO) <= 0) continue;
                pendingTaxCollection = true;
                break;
            }
        }
        return pendingTaxCollection;
    }

    public boolean anyDemandPendingForCollection(SewerageApplicationDetails sewerageApplicationDetails) {
        return this.checkAnyTaxIsPendingToCollect(sewerageApplicationDetails.getCurrentDemand());
    }

    public List<EgDemandDetails> getDemandDetailByPassingDemandDemandReason(EgDemand demand, EgDemandReason demandReason) {
        return this.demandGenericDao.getDemandDetailsForDemandAndReasons(demand, Arrays.asList(demandReason));
    }

    public List<BillReceipt> getBilReceiptsByDemand(EgDemand demand) {
        List billReceiptList = this.demandGenericDao.getBillReceipts(demand);
        return billReceiptList;
    }

    public EgDemand createDemandOnNewConnection(List<SewerageConnectionFee> connectionFees, SewerageApplicationDetails sewerageApplicationDetail) {
        EgDemand demand = null;
        HashSet<EgDemandDetails> demandDetailSet = new HashSet<EgDemandDetails>();
        BigDecimal totalDemandAmount = BigDecimal.ZERO;
        if (sewerageApplicationDetail != null && sewerageApplicationDetail.getCurrentDemand() == null) {
            Installment installment = this.getCurrentInstallment();
            for (SewerageConnectionFee fees : connectionFees) {
                EgDemandReason pendingTaxReason = this.getDemandReasonByCodeAndInstallment(fees.getFeesDetail().getCode(), installment.getId());
                if (pendingTaxReason != null) {
                    demandDetailSet.add(this.createDemandDetails(BigDecimal.valueOf(fees.getAmount()), pendingTaxReason, BigDecimal.ZERO));
                    totalDemandAmount = totalDemandAmount.add(BigDecimal.valueOf(fees.getAmount()));
                    continue;
                }
                throw new ApplicationRuntimeException("SEWERAGE.001");
            }
            demand = this.createDemand(demandDetailSet, installment, totalDemandAmount);
        }
        return demand;
    }

    public EgDemand createDemandOnLegacyConnection(List<SewerageDemandDetail> sewerageDemandDetail, SewerageApplicationDetails sewerageApplicationDetail) {
        EgDemand demand = null;
        HashSet<EgDemandDetails> demandDetailSet = new HashSet<EgDemandDetails>();
        BigDecimal totalDemandAmount = BigDecimal.ZERO;
        BigDecimal totalCollectedAmount = BigDecimal.ZERO;
        if (sewerageApplicationDetail != null && sewerageApplicationDetail.getCurrentDemand() == null) {
            List<Installment> installmentList = this.sewerageTaxUtils.getInstallmentsByModuledescendingorder(this.moduleService.getModuleByName("Sewerage Tax Management"), new DateTime().getYear());
            for (SewerageDemandDetail sdd : sewerageDemandDetail) {
                EgDemandReason pendingTaxReason = this.getDemandReasonByCodeAndInstallment(sdd.getReasonMaster(), sdd.getInstallmentId());
                if (pendingTaxReason != null) {
                    if (sdd.getActualAmount() == null) {
                        sdd.setActualAmount(BigDecimal.ZERO);
                    }
                    if (sdd.getActualCollection() == null) {
                        sdd.setActualCollection(BigDecimal.ZERO);
                    }
                    demandDetailSet.add(this.createDemandDetails(sdd.getActualAmount(), pendingTaxReason, sdd.getActualCollection()));
                    totalDemandAmount = totalDemandAmount.add(sdd.getActualAmount());
                    totalCollectedAmount = totalCollectedAmount.add(sdd.getActualCollection());
                    continue;
                }
                throw new ApplicationRuntimeException("SEWERAGE.001");
            }
            demand = this.createDemand(demandDetailSet, installmentList.get(0), totalDemandAmount);
            demand.setAmtCollected(totalCollectedAmount);
        }
        return demand;
    }

    public EgDemand updateLegacyDemand(List<SewerageDemandDetail> sewerageDemandDetail, EgDemand demand) {
        boolean demandDtlPresent;
        BigDecimal totalDemandAmount = BigDecimal.ZERO;
        BigDecimal totalCollectedAmount = BigDecimal.ZERO;
        ArrayList<EgDemandDetails> removableDemandDetailList = new ArrayList<EgDemandDetails>();
        for (SewerageDemandDetail sdd : sewerageDemandDetail) {
            demandDtlPresent = false;
            if (sdd.getActualAmount() == null) {
                sdd.setActualAmount(BigDecimal.ZERO);
            }
            if (sdd.getActualCollection() == null) {
                sdd.setActualCollection(BigDecimal.ZERO);
            }
            for (EgDemandDetails dmdDtl : demand.getEgDemandDetails()) {
                if (!sdd.getReasonMaster().equalsIgnoreCase(dmdDtl.getEgDemandReason().getEgDemandReasonMaster().getCode()) || !sdd.getInstallmentId().equals(dmdDtl.getEgDemandReason().getEgInstallmentMaster().getId())) continue;
                demandDtlPresent = true;
                dmdDtl.setAmount(sdd.getActualAmount());
                dmdDtl.setAmtCollected(sdd.getActualCollection());
                totalDemandAmount = totalDemandAmount.add(sdd.getActualAmount());
                totalCollectedAmount = totalCollectedAmount.add(sdd.getActualCollection());
            }
            if (demandDtlPresent) continue;
            EgDemandReason pendingTaxReason = this.getDemandReasonByCodeAndInstallment(sdd.getReasonMaster(), sdd.getInstallmentId());
            demand.addEgDemandDetails(this.createDemandDetails(sdd.getActualAmount(), pendingTaxReason, sdd.getActualCollection()));
            totalDemandAmount = totalDemandAmount.add(sdd.getActualAmount());
            totalCollectedAmount = totalCollectedAmount.add(sdd.getActualCollection());
        }
        for (EgDemandDetails dmdDtls : demand.getEgDemandDetails()) {
            demandDtlPresent = false;
            for (SewerageDemandDetail sewDmdDtl : sewerageDemandDetail) {
                if (!sewDmdDtl.getReasonMaster().equalsIgnoreCase(dmdDtls.getEgDemandReason().getEgDemandReasonMaster().getCode()) || !sewDmdDtl.getInstallmentId().equals(dmdDtls.getEgDemandReason().getEgInstallmentMaster().getId())) continue;
                demandDtlPresent = true;
            }
            if (demandDtlPresent) continue;
            removableDemandDetailList.add(dmdDtls);
        }
        for (EgDemandDetails removableDmdDtl : removableDemandDetailList) {
            demand.removeEgDemandDetails(removableDmdDtl);
        }
        demand.setBaseDemand(totalDemandAmount.setScale(0, 4));
        demand.setAmtCollected(totalCollectedAmount.setScale(0, 4));
        return demand;
    }

    public EgDemand updateDemand(List<SewerageConnectionFee> connectionFees, EgDemand demand) {
        Installment installment = this.getCurrentInstallment();
        BigDecimal totalDemandAmount = BigDecimal.ZERO;
        for (SewerageConnectionFee scf : connectionFees) {
            boolean demandDtlPresent = false;
            for (EgDemandDetails dmdDtl : demand.getEgDemandDetails()) {
                if (!scf.getFeesDetail().getCode().equalsIgnoreCase(dmdDtl.getEgDemandReason().getEgDemandReasonMaster().getCode())) continue;
                demandDtlPresent = true;
                totalDemandAmount = totalDemandAmount.subtract(dmdDtl.getAmount());
                dmdDtl.setAmount(BigDecimal.valueOf(scf.getAmount()));
                totalDemandAmount = totalDemandAmount.add(BigDecimal.valueOf(scf.getAmount()));
            }
            if (demandDtlPresent) continue;
            demand.addEgDemandDetails(this.createDemandDetails(BigDecimal.valueOf(scf.getAmount()), this.getDemandReasonByCodeAndInstallment(scf.getFeesDetail().getCode(), installment.getId()), BigDecimal.ZERO));
            totalDemandAmount = totalDemandAmount.add(BigDecimal.valueOf(scf.getAmount()));
        }
        demand.addBaseDemand(totalDemandAmount.setScale(0, 4));
        return demand;
    }

    public EgDemand updateDemandOnChangeInClosets(SewerageApplicationDetails oldSewerageApplicationDetails, List<SewerageConnectionFee> connectionFees, EgDemand demand, Boolean updateOldSewerageApplicationAdvance) {
        Installment installment = this.getCurrentInstallment();
        BigDecimal totalDemandAmount = BigDecimal.ZERO;
        BigDecimal oldDonationCharge = BigDecimal.ZERO;
        BigDecimal oldSewerageTax = BigDecimal.ZERO;
        BigDecimal oldApplicationAdvanceAmount = BigDecimal.ZERO;
        Boolean oldAdvanceUsedInSewerageTaxOrAddedAsAdvance = false;
        BigDecimal currentDonationCharge = BigDecimal.ZERO;
        BigDecimal currentSewerageTax = BigDecimal.ZERO;
        boolean demandDtlPresent = false;
        if (oldSewerageApplicationDetails != null) {
            for (SewerageConnectionFee oldSewerageConnectionFee : oldSewerageApplicationDetails.getConnectionFees()) {
                if (oldSewerageConnectionFee.getFeesDetail().getCode().equalsIgnoreCase("SEWERAGETAX")) {
                    oldSewerageTax = oldSewerageTax.add(BigDecimal.valueOf(oldSewerageConnectionFee.getAmount()));
                }
                if (!oldSewerageConnectionFee.getFeesDetail().getCode().equalsIgnoreCase("DONATIONCHARGE")) continue;
                oldDonationCharge = oldDonationCharge.add(BigDecimal.valueOf(oldSewerageConnectionFee.getAmount()));
            }
            if (oldSewerageApplicationDetails.getCurrentDemand() != null && updateOldSewerageApplicationAdvance.booleanValue()) {
                for (EgDemandDetails dmdDtl : oldSewerageApplicationDetails.getCurrentDemand().getEgDemandDetails()) {
                    if (!dmdDtl.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("SEWERAGEADVANCE")) continue;
                    oldApplicationAdvanceAmount = oldApplicationAdvanceAmount.add(dmdDtl.getAmtCollected());
                    dmdDtl.setAmount(BigDecimal.ZERO);
                    dmdDtl.setAmtCollected(BigDecimal.ZERO);
                }
            }
        }
        if (demand != null) {
            for (EgDemandDetails dmdDtl : demand.getEgDemandDetails()) {
                if (!dmdDtl.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("SEWERAGEADVANCE")) continue;
                oldApplicationAdvanceAmount = oldApplicationAdvanceAmount.add(dmdDtl.getAmtCollected());
            }
        }
        for (SewerageConnectionFee scf : connectionFees) {
            if (scf.getFeesDetail().getCode().equalsIgnoreCase("SEWERAGETAX")) {
                currentSewerageTax = currentSewerageTax.add(BigDecimal.valueOf(scf.getAmount()));
            }
            if (!scf.getFeesDetail().getCode().equalsIgnoreCase("DONATIONCHARGE")) continue;
            currentDonationCharge = currentDonationCharge.add(BigDecimal.valueOf(scf.getAmount()));
        }
        for (SewerageConnectionFee scf : connectionFees) {
            for (EgDemandDetails dmdDtl : demand.getEgDemandDetails()) {
                if (!scf.getFeesDetail().getCode().equalsIgnoreCase(dmdDtl.getEgDemandReason().getEgDemandReasonMaster().getCode()) || scf.getFeesDetail().getCode().equalsIgnoreCase("INSPECTIONCHARGE")) continue;
                demandDtlPresent = true;
                if (scf.getFeesDetail().getCode().equalsIgnoreCase("DONATIONCHARGE")) {
                    if (currentDonationCharge.compareTo(oldDonationCharge) <= 0) continue;
                    totalDemandAmount = totalDemandAmount.subtract(dmdDtl.getAmount().subtract(dmdDtl.getAmtCollected()));
                    dmdDtl.setAmount(currentDonationCharge);
                    dmdDtl.setAmtCollected(oldDonationCharge);
                    totalDemandAmount = totalDemandAmount.add(currentDonationCharge.subtract(oldDonationCharge));
                    continue;
                }
                if (scf.getFeesDetail().getCode().equalsIgnoreCase("SEWERAGETAX")) {
                    if (currentSewerageTax.compareTo(oldSewerageTax) > 0) {
                        totalDemandAmount = totalDemandAmount.subtract(dmdDtl.getAmount().subtract(dmdDtl.getAmtCollected()));
                        dmdDtl.setAmount(currentSewerageTax);
                        BigDecimal differenceAmount = currentSewerageTax.subtract(oldSewerageTax);
                        if (oldApplicationAdvanceAmount.compareTo(BigDecimal.ZERO) > 0) {
                            if (differenceAmount.compareTo(oldApplicationAdvanceAmount) > 0) {
                                dmdDtl.setAmtCollected(oldSewerageTax.add(oldApplicationAdvanceAmount));
                                oldApplicationAdvanceAmount = BigDecimal.ZERO;
                                oldAdvanceUsedInSewerageTaxOrAddedAsAdvance = true;
                                this.createAdvanceDemandDetail(demand, oldApplicationAdvanceAmount);
                                continue;
                            }
                            dmdDtl.setAmtCollected(oldSewerageTax.add(differenceAmount));
                            oldApplicationAdvanceAmount = oldApplicationAdvanceAmount.subtract(differenceAmount);
                            this.createAdvanceDemandDetail(demand, oldApplicationAdvanceAmount);
                            oldAdvanceUsedInSewerageTaxOrAddedAsAdvance = true;
                            continue;
                        }
                        dmdDtl.setAmtCollected(oldSewerageTax);
                        totalDemandAmount = totalDemandAmount.add(differenceAmount);
                        continue;
                    }
                    if (oldSewerageTax.compareTo(BigDecimal.ZERO) <= 0) continue;
                    totalDemandAmount = totalDemandAmount.subtract(dmdDtl.getAmount().subtract(dmdDtl.getAmtCollected()));
                    dmdDtl.setAmount(currentSewerageTax);
                    dmdDtl.setAmtCollected(currentSewerageTax);
                    totalDemandAmount = totalDemandAmount.add(currentSewerageTax);
                    if (oldSewerageTax.compareTo(currentSewerageTax) <= 0 && oldApplicationAdvanceAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
                    this.createAdvanceDemandDetail(demand, oldSewerageTax.subtract(currentSewerageTax).add(oldApplicationAdvanceAmount));
                    oldAdvanceUsedInSewerageTaxOrAddedAsAdvance = true;
                    continue;
                }
                totalDemandAmount = totalDemandAmount.subtract(dmdDtl.getAmount());
                dmdDtl.setAmount(BigDecimal.valueOf(scf.getAmount()));
                totalDemandAmount = totalDemandAmount.add(BigDecimal.valueOf(scf.getAmount()));
            }
            if (demandDtlPresent || !(scf.getAmount() > 0.0) || scf.getFeesDetail().getCode().equalsIgnoreCase("INSPECTIONCHARGE")) continue;
            if (scf.getFeesDetail().getCode().equalsIgnoreCase("DONATIONCHARGE")) {
                if (currentDonationCharge.compareTo(oldDonationCharge) <= 0) continue;
                demand.addEgDemandDetails(this.createDemandDetails(currentDonationCharge, this.getDemandReasonByCodeAndInstallment(scf.getFeesDetail().getCode(), installment.getId()), oldDonationCharge));
                totalDemandAmount = totalDemandAmount.add(currentDonationCharge.subtract(oldDonationCharge));
                continue;
            }
            if (scf.getFeesDetail().getCode().equalsIgnoreCase("SEWERAGETAX")) {
                if (currentSewerageTax.compareTo(oldSewerageTax) > 0) {
                    BigDecimal differenceAmount = currentSewerageTax.subtract(oldSewerageTax);
                    BigDecimal amoountCollected = oldSewerageTax;
                    if (oldApplicationAdvanceAmount.compareTo(BigDecimal.ZERO) > 0) {
                        if (differenceAmount.compareTo(oldApplicationAdvanceAmount) > 0) {
                            amoountCollected = oldSewerageTax.add(oldApplicationAdvanceAmount);
                            oldApplicationAdvanceAmount = BigDecimal.ZERO;
                            oldAdvanceUsedInSewerageTaxOrAddedAsAdvance = true;
                            this.createAdvanceDemandDetail(demand, oldApplicationAdvanceAmount);
                        } else {
                            amoountCollected = oldSewerageTax.add(differenceAmount);
                            oldApplicationAdvanceAmount = oldApplicationAdvanceAmount.subtract(differenceAmount);
                            this.createAdvanceDemandDetail(demand, oldApplicationAdvanceAmount);
                            oldAdvanceUsedInSewerageTaxOrAddedAsAdvance = true;
                        }
                    }
                    demand.addEgDemandDetails(this.createDemandDetails(currentSewerageTax, this.getDemandReasonByCodeAndInstallment(scf.getFeesDetail().getCode(), installment.getId()), amoountCollected));
                    totalDemandAmount = totalDemandAmount.add(currentSewerageTax.subtract(amoountCollected));
                    continue;
                }
                if ((oldSewerageTax.compareTo(BigDecimal.ZERO) <= 0 || oldSewerageTax.compareTo(currentSewerageTax) < 0) && oldApplicationAdvanceAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
                demand.addEgDemandDetails(this.createDemandDetails(currentSewerageTax, this.getDemandReasonByCodeAndInstallment(scf.getFeesDetail().getCode(), installment.getId()), currentSewerageTax));
                this.createAdvanceDemandDetail(demand, oldSewerageTax.subtract(currentSewerageTax).add(oldApplicationAdvanceAmount));
                totalDemandAmount = totalDemandAmount.add(currentSewerageTax);
                oldAdvanceUsedInSewerageTaxOrAddedAsAdvance = true;
                continue;
            }
            demand.addEgDemandDetails(this.createDemandDetails(BigDecimal.valueOf(scf.getAmount()), this.getDemandReasonByCodeAndInstallment(scf.getFeesDetail().getCode(), installment.getId()), BigDecimal.ZERO));
            totalDemandAmount = totalDemandAmount.add(BigDecimal.valueOf(scf.getAmount()));
        }
        if (updateOldSewerageApplicationAdvance.booleanValue() && !this.detailList.isEmpty()) {
            demand.addEgDemandDetails(this.detailList.get(0));
        }
        if (!oldAdvanceUsedInSewerageTaxOrAddedAsAdvance.booleanValue() && oldApplicationAdvanceAmount.compareTo(BigDecimal.ZERO) > 0) {
            this.createAdvanceDemandDetail(demand, oldApplicationAdvanceAmount);
        }
        demand.addBaseDemand(totalDemandAmount.setScale(0, 4));
        return demand;
    }

    private void createAdvanceDemandDetail(EgDemand demand, BigDecimal amount) {
        Installment nextInstallment = this.getNextInstallment();
        Boolean advancePresent = false;
        for (EgDemandDetails dmdDtl : demand.getEgDemandDetails()) {
            if (!dmdDtl.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("SEWERAGEADVANCE") || nextInstallment == null || !nextInstallment.getDescription().equalsIgnoreCase(dmdDtl.getEgDemandReason().getEgInstallmentMaster().getDescription())) continue;
            dmdDtl.getEgDemand().getBaseDemand().subtract(dmdDtl.getAmtCollected());
            dmdDtl.setAmtCollected(amount);
            dmdDtl.getEgDemand().getBaseDemand().add(amount);
            advancePresent = true;
        }
        if (!advancePresent.booleanValue()) {
            this.detailList.clear();
            this.detailList.add(this.createDemandDetails(demand, BigDecimal.ZERO, this.getDemandReasonByCodeAndInstallment("SEWERAGEADVANCE", nextInstallment.getId()), amount));
        }
    }

    public EgDemand generateNextYearDemandForSewerage(SewerageApplicationDetails applicationDetails, EgDemandReason oldtaxReasonInstallment, EgDemandReason newtaxReasonInstallment) {
        BigDecimal totalDemandAmount = BigDecimal.ZERO;
        EgDemand demand = applicationDetails.getCurrentDemand();
        Boolean taxFeeAlreadyExistInDemand = false;
        EgDemandDetails oldTaxDemandDetail = null;
        for (EgDemandDetails dmdDtl : demand.getEgDemandDetails()) {
            if (dmdDtl.getEgDemandReason().getId() == oldtaxReasonInstallment.getId()) {
                oldTaxDemandDetail = dmdDtl;
            }
            if (dmdDtl.getEgDemandReason().getId() != newtaxReasonInstallment.getId()) continue;
            taxFeeAlreadyExistInDemand = true;
        }
        if (!taxFeeAlreadyExistInDemand.booleanValue() && oldTaxDemandDetail != null) {
            demand.addEgDemandDetails(this.createDemandDetails(oldTaxDemandDetail.getAmount(), newtaxReasonInstallment, BigDecimal.ZERO));
            totalDemandAmount = totalDemandAmount.add(oldTaxDemandDetail.getAmount());
        }
        demand.setEgInstallmentMaster(newtaxReasonInstallment.getEgInstallmentMaster());
        demand.addBaseDemand(totalDemandAmount.setScale(0, 4));
        return demand;
    }

    public Integer[] generateDemandForNextInstallment(List<SewerageApplicationDetails> sewerageApplicationDetails, List<Installment> previousInstallment, Installment sewerageDmdGenerationInstallment) {
        int totalNoOfRecords = 0;
        int noOfSuccessRecords = 0;
        int noOfFailureRecords = 0;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("*************************************** total records " + sewerageApplicationDetails.size()));
        }
        if (!sewerageApplicationDetails.isEmpty()) {
            EgDemandReason taxReasonOldInstallment = this.getDemandReasonByCodeAndInstallment("SEWERAGETAX", previousInstallment.get(0).getId());
            EgDemandReason taxReasonNewInstallment = this.getDemandReasonByCodeAndInstallment("SEWERAGETAX", sewerageDmdGenerationInstallment.getId());
            SewerageDemandGenerationLog demandGenerationLog = (SewerageDemandGenerationLog)((Object)this.transactionTemplate.execute(result -> this.stDemandGenerationLogService.createDemandGenerationLog(sewerageDmdGenerationInstallment.getDescription())));
            for (SewerageApplicationDetails applicationDetails : sewerageApplicationDetails) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info((Object)("*************************************** demand id " + applicationDetails.getCurrentDemand().getId()));
                }
                Boolean status = false;
                try {
                    status = (Boolean)this.transactionTemplate.execute(result -> {
                        if (LOGGER.isInfoEnabled()) {
                            LOGGER.info((Object)("SHSC Number ---> " + applicationDetails.getConnection().getShscNumber()));
                        }
                        this.generateNextYearDemandForSewerage(applicationDetails, taxReasonOldInstallment, taxReasonNewInstallment);
                        this.sewerageApplicationDetailsService.updateSewerageApplicationDetails(applicationDetails);
                        if (demandGenerationLog != null) {
                            SewerageDemandGenerationLog demandGenerationLogObj = (SewerageDemandGenerationLog)((Object)((Object)this.demandGenerationLogRepository.findOne(demandGenerationLog.getId())));
                            this.stDemandGenerationLogService.createOrGetDemandGenerationLogDetail(demandGenerationLogObj, applicationDetails, SewerageProcessStatus.COMPLETED, SUCCESSFUL);
                        }
                        return Boolean.TRUE;
                    });
                }
                catch (Exception e) {
                    status = (Boolean)this.transactionTemplate.execute(result -> {
                        if (demandGenerationLog != null) {
                            SewerageDemandGenerationLog demandGenerationLogObj = (SewerageDemandGenerationLog)((Object)((Object)this.demandGenerationLogRepository.findOne(demandGenerationLog.getId())));
                            demandGenerationLogObj.setDemandGenerationStatus(SewerageProcessStatus.INCOMPLETE);
                            this.stDemandGenerationLogService.createOrGetDemandGenerationLogDetail(demandGenerationLogObj, applicationDetails, SewerageProcessStatus.INCOMPLETE, this.getErrorMessage(e));
                        }
                        LOGGER.error((Object)("Error in generating demand bill for SHSC Number ---> " + applicationDetails.getConnection().getShscNumber() + " and executeJob" + e));
                        return Boolean.FALSE;
                    });
                }
                noOfSuccessRecords = status != false ? noOfSuccessRecords + 1 : noOfSuccessRecords;
                noOfFailureRecords = status == false ? noOfFailureRecords + 1 : noOfFailureRecords;
                totalNoOfRecords = noOfSuccessRecords + noOfFailureRecords;
            }
        }
        Integer[] res = new Integer[]{totalNoOfRecords, noOfSuccessRecords, noOfFailureRecords};
        return res;
    }

    private String getErrorMessage(Exception exception) {
        String error = exception instanceof ValidationException ? ((ValidationError)((ValidationException)exception).getErrors().get(0)).getMessage() : "Error : " + exception;
        return error;
    }
}

