/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.transactions.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.stms.masters.service.DocumentTypeMasterService;
import org.egov.stms.transactions.entity.SewerageApplicationDetails;
import org.egov.stms.transactions.entity.SewerageApplicationDetailsDocument;
import org.egov.stms.transactions.entity.SewerageConnection;
import org.egov.stms.transactions.repository.SewerageConnectionRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.BindingResult;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional(readOnly=true)
public class SewerageConnectionService {
    private final SewerageConnectionRepository sewerageConnectionRepository;
    @Autowired
    private DocumentTypeMasterService documentTypeMasterService;
    @Autowired
    @Qualifier(value="fileStoreService")
    protected FileStoreService fileStoreService;

    @Autowired
    public SewerageConnectionService(SewerageConnectionRepository sewerageConnectionRepository) {
        this.sewerageConnectionRepository = sewerageConnectionRepository;
    }

    public SewerageConnection findBy(Long id) {
        return (SewerageConnection)((Object)this.sewerageConnectionRepository.findOne(id));
    }

    public List<SewerageConnection> findAll() {
        return this.sewerageConnectionRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"shscNumber"}));
    }

    public SewerageConnection findByShscNumber(String shscNumber) {
        return this.sewerageConnectionRepository.findByShscNumber(shscNumber);
    }

    public SewerageConnection load(Long id) {
        return (SewerageConnection)((Object)this.sewerageConnectionRepository.getOne(id));
    }

    public Page<SewerageConnection> getListSewerageConnections(Integer pageNumber, Integer pageSize) {
        PageRequest pageable = new PageRequest(pageNumber - 1, pageSize.intValue(), Sort.Direction.ASC, new String[]{"shscNumber"});
        return this.sewerageConnectionRepository.findAll((Pageable)pageable);
    }

    public List<SewerageConnection> findByPropertyIdentifier(String propertyIdentifier) {
        return null;
    }

    public List<SewerageApplicationDetailsDocument> processAndStoreApplicationDocuments(SewerageApplicationDetails sewerageApplicationDetails) {
        ArrayList<SewerageApplicationDetailsDocument> applicationDocsList = new ArrayList<SewerageApplicationDetailsDocument>();
        if (!sewerageApplicationDetails.getAppDetailsDocument().isEmpty()) {
            for (SewerageApplicationDetailsDocument applicationDocument : sewerageApplicationDetails.getAppDetailsDocument()) {
                applicationDocument.setDocumentTypeMaster(this.documentTypeMasterService.load(applicationDocument.getDocumentTypeMaster().getId()));
                applicationDocument.setApplicationDetails(sewerageApplicationDetails);
                applicationDocument.setFileStore(this.addToFileStore(applicationDocument.getFiles()));
                applicationDocsList.add(applicationDocument);
            }
        }
        return applicationDocsList;
    }

    public List<SewerageApplicationDetailsDocument> getSewerageApplicationDoc(SewerageApplicationDetails sewerageApplicationDetails) {
        ArrayList<SewerageApplicationDetailsDocument> tempDocList = new ArrayList<SewerageApplicationDetailsDocument>(0);
        if (sewerageApplicationDetails != null) {
            for (SewerageApplicationDetailsDocument appDoc : sewerageApplicationDetails.getAppDetailsDocument()) {
                if (appDoc.getDocumentTypeMaster() == null) continue;
                tempDocList.add(appDoc);
            }
        }
        return tempDocList;
    }

    public Set<FileStoreMapper> addToFileStore(MultipartFile[] files) {
        if (ArrayUtils.isNotEmpty((Object[])files)) {
            return Arrays.asList(files).stream().filter(file -> !file.isEmpty()).map(file -> {
                try {
                    return this.fileStoreService.store(file.getInputStream(), file.getOriginalFilename(), file.getContentType(), "STMS");
                }
                catch (Exception e) {
                    throw new ApplicationRuntimeException("Error occurred while getting inputstream", (Throwable)e);
                }
            }).collect(Collectors.toSet());
        }
        return null;
    }

    public boolean validApplicationDocument(SewerageApplicationDetailsDocument applicationDocument) {
        return applicationDocument.getDocumentTypeMaster().isMandatory() || applicationDocument.getDocumentNumber() != null || applicationDocument.getDocumentDate() != null;
    }

    public void validateDocuments(List<SewerageApplicationDetailsDocument> applicationDocs, SewerageApplicationDetailsDocument applicationDocument, int i, BindingResult resultBinder) {
        if (applicationDocument != null && applicationDocument.getDocumentTypeMaster().isMandatory()) {
            String fieldError;
            if (applicationDocument.getDocumentNumber() == null) {
                fieldError = "appDetailsDocument[" + i + "].documentNumber";
                resultBinder.rejectValue(fieldError, "documentNumber.required");
            }
            if (applicationDocument.getDocumentDate() == null) {
                fieldError = "appDetailsDocument[" + i + "].documentDate";
                resultBinder.rejectValue(fieldError, "documentDate.required");
            }
            Iterator stream = null;
            if (ArrayUtils.isNotEmpty((Object[])applicationDocument.getFiles())) {
                stream = Arrays.asList(applicationDocument.getFiles()).stream().filter(file -> !file.isEmpty()).iterator();
            }
            if (ArrayUtils.isEmpty((Object[])applicationDocument.getFiles()) || stream == null || stream != null && !stream.hasNext()) {
                String fieldError2 = "appDetailsDocument[" + i + "].files";
                resultBinder.rejectValue(fieldError2, "files.required");
            } else if (this.validApplicationDocument(applicationDocument)) {
                applicationDocs.add(applicationDocument);
            }
        } else {
            String fieldError;
            if (applicationDocument.getDocumentNumber() == null && applicationDocument.getDocumentDate() != null) {
                fieldError = "appDetailsDocument[" + i + "].documentNumber";
                resultBinder.rejectValue(fieldError, "documentNumber.required");
            }
            if (applicationDocument.getDocumentNumber() != null && applicationDocument.getDocumentDate() == null) {
                fieldError = "appDetailsDocument[" + i + "].documentDate";
                resultBinder.rejectValue(fieldError, "documentDate.required");
            }
            if (applicationDocument.getDocumentNumber() != null && applicationDocument.getDocumentDate() != null) {
                Iterator stream = null;
                if (ArrayUtils.isNotEmpty((Object[])applicationDocument.getFiles())) {
                    stream = Arrays.asList(applicationDocument.getFiles()).stream().filter(file -> !file.isEmpty()).iterator();
                }
                if (ArrayUtils.isEmpty((Object[])applicationDocument.getFiles()) || stream == null || stream != null && !stream.hasNext()) {
                    String fieldError3 = "appDetailsDocument[" + i + "].files";
                    resultBinder.rejectValue(fieldError3, "files.required");
                }
            }
            if (this.validApplicationDocument(applicationDocument)) {
                applicationDocs.add(applicationDocument);
            }
        }
    }
}

