/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.transactions.service;

import java.util.List;
import org.apache.log4j.Logger;
import org.egov.commons.Installment;
import org.egov.demand.dao.EgDemandDao;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.stms.entity.SewerageTaxBatchDemandGenerate;
import org.egov.stms.transactions.entity.SewerageApplicationDetails;
import org.egov.stms.transactions.repository.SewerageTaxBatchDemandGenRepository;
import org.egov.stms.transactions.service.SewerageApplicationDetailsService;
import org.egov.stms.transactions.service.SewerageDemandService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

@Service
@Transactional(readOnly=true)
public class SewerageBatchDemandGenService {
    private static final Logger LOGGER = Logger.getLogger(SewerageBatchDemandGenService.class);
    @Autowired
    private EgDemandDao egDemandDao;
    @Autowired
    private SewerageApplicationDetailsService sewerageApplicationDetailsService;
    @Autowired
    private SewerageDemandService sewerageDemandService;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private SewerageTaxBatchDemandGenRepository sewerageTaxBatchDemandGenRepository;
    @Autowired
    private TransactionTemplate transactionTemplate;

    public SewerageTaxBatchDemandGenerate getBatchDemandGenById(Long id) {
        return (SewerageTaxBatchDemandGenerate)((Object)this.sewerageTaxBatchDemandGenRepository.findOne(id));
    }

    public List<SewerageTaxBatchDemandGenerate> findActiveBatchDemands() {
        return this.sewerageTaxBatchDemandGenRepository.findActiveBatchDemands();
    }

    @Transactional
    public SewerageTaxBatchDemandGenerate createSewerageTaxBatchDemandGenerate(SewerageTaxBatchDemandGenerate advBatchDmd) {
        return (SewerageTaxBatchDemandGenerate)((Object)this.sewerageTaxBatchDemandGenRepository.save((Object)advBatchDmd));
    }

    @Transactional
    public SewerageTaxBatchDemandGenerate updateSewerageTaxBatchDemandGenerate(SewerageTaxBatchDemandGenerate advBatchDmd) {
        return (SewerageTaxBatchDemandGenerate)((Object)this.sewerageTaxBatchDemandGenRepository.save((Object)advBatchDmd));
    }

    public int generateSewerageDemandForNextFinYear() {
        Integer[] recordsResult = null;
        List<SewerageTaxBatchDemandGenerate> sewerageBatchDmdGenResult = this.findActiveBatchDemands();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("SewerageBatchDmdGenResult " + sewerageBatchDmdGenResult.size()));
        }
        if (!sewerageBatchDmdGenResult.isEmpty()) {
            SewerageTaxBatchDemandGenerate sewerageDmdGen;
            AppConfigValues totalRecordToFeatch = (AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey("Sewerage Tax Management", "Number of Records used in next year demand generation").get(0);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("*************************************** totalRecordToFeatch records " + totalRecordToFeatch.getValue()));
            }
            if ((sewerageDmdGen = sewerageBatchDmdGenResult.get(0)) != null && sewerageDmdGen.getInstallment() != null) {
                List<Installment> previousInstallment = this.sewerageDemandService.getPreviousInstallment(sewerageDmdGen.getInstallment().getToDate());
                Installment sewerageDmdGenerationInstallment = this.sewerageDemandService.getInsatllmentByModuleForGivenDate(sewerageDmdGen.getInstallment().getToDate());
                if (sewerageDmdGenerationInstallment != null && previousInstallment != null && !previousInstallment.isEmpty()) {
                    List<SewerageApplicationDetails> sewerageApplnsDetails = this.sewerageApplicationDetailsService.findActiveSewerageApplnsByCurrentInstallmentAndNumberOfResultToFetch(previousInstallment.get(0), Integer.valueOf(totalRecordToFeatch.getValue()));
                    for (SewerageApplicationDetails applicationDetails : sewerageApplnsDetails) {
                        applicationDetails.getDemandConnections().get(0).setDemand(this.egDemandDao.findById(applicationDetails.getDemandConnections().get(0).getDemand().getId(), false));
                    }
                    recordsResult = this.sewerageDemandService.generateDemandForNextInstallment(sewerageApplnsDetails, previousInstallment, sewerageDmdGenerationInstallment);
                }
            }
            sewerageDmdGen.setActive(false);
            sewerageDmdGen.setTotalRecords(recordsResult != null && recordsResult.length > 0 && recordsResult[0] != null ? recordsResult[0].intValue() : 0);
            sewerageDmdGen.setSuccessfullRecords(recordsResult != null && recordsResult.length >= 2 && recordsResult[1] != null ? recordsResult[1].intValue() : 0);
            sewerageDmdGen.setFailureRecords(recordsResult != null && recordsResult.length >= 3 && recordsResult[2] != null ? recordsResult[2].intValue() : 0);
            TransactionTemplate txTemplate = new TransactionTemplate(this.transactionTemplate.getTransactionManager());
            txTemplate.setPropagationBehavior(3);
            txTemplate.execute(result -> {
                this.updateSewerageTaxBatchDemandGenerate(sewerageDmdGen);
                return Boolean.TRUE;
            });
        }
        return recordsResult != null && recordsResult.length >= 2 && recordsResult[1] != null ? recordsResult[1].intValue() : 0;
    }
}

