/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.transactions.entity;

import java.util.Date;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.stms.masters.entity.DocumentTypeMaster;
import org.egov.stms.transactions.entity.SewerageApplicationDetails;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.SafeHtml;
import org.springframework.web.multipart.MultipartFile;

@Entity
@Table(name="egswtax_applicationdetails_documents")
@SequenceGenerator(name="SEQ_EGSWTAX_APPLICATIONDETAILS_DOCUMENTS", sequenceName="SEQ_EGSWTAX_APPLICATIONDETAILS_DOCUMENTS", allocationSize=1)
public class SewerageApplicationDetailsDocument
extends AbstractAuditable {
    private static final long serialVersionUID = 8860169180238684889L;
    public static final String SEQ_APPLICATIONDETAILS_DOCUMENT = "SEQ_EGSWTAX_APPLICATIONDETAILS_DOCUMENTS";
    @Id
    @GeneratedValue(generator="SEQ_EGSWTAX_APPLICATIONDETAILS_DOCUMENTS", strategy=GenerationType.SEQUENCE)
    private Long id;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="applicationdetails", nullable=false)
    private SewerageApplicationDetails applicationDetails;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinTable(name="egswtax_documents", joinColumns={@JoinColumn(name="applicationDetailDocument")}, inverseJoinColumns={@JoinColumn(name="filestoreid")})
    private Set<FileStoreMapper> fileStore;
    @ManyToOne
    @NotNull
    @JoinColumn(name="documenttypemaster", nullable=false)
    private DocumentTypeMaster documentTypeMaster;
    @SafeHtml
    @Length(max=50)
    private String documentNumber;
    @Temporal(value=TemporalType.DATE)
    private Date documentDate;
    private transient MultipartFile[] files;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public SewerageApplicationDetails getApplicationDetails() {
        return this.applicationDetails;
    }

    public void setApplicationDetails(SewerageApplicationDetails applicationDetails) {
        this.applicationDetails = applicationDetails;
    }

    public Set<FileStoreMapper> getFileStore() {
        return this.fileStore;
    }

    public void setFileStore(Set<FileStoreMapper> fileStore) {
        this.fileStore = fileStore;
    }

    public DocumentTypeMaster getDocumentTypeMaster() {
        return this.documentTypeMaster;
    }

    public void setDocumentTypeMaster(DocumentTypeMaster documentTypeMaster) {
        this.documentTypeMaster = documentTypeMaster;
    }

    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public Date getDocumentDate() {
        return this.documentDate;
    }

    public void setDocumentDate(Date documentDate) {
        this.documentDate = documentDate;
    }

    public MultipartFile[] getFiles() {
        return this.files;
    }

    public void setFiles(MultipartFile[] files) {
        this.files = files;
    }
}

