/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.config;

import java.util.HashMap;
import javax.sql.DataSource;
import org.egov.infra.config.scheduling.QuartzSchedulerConfiguration;
import org.egov.infra.config.scheduling.SchedulerConfigCondition;
import org.egov.stms.service.scheduler.jobs.GenerateDemandForSewerageTaxJob;
import org.quartz.Trigger;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.quartz.CronTriggerFactoryBean;
import org.springframework.scheduling.quartz.JobDetailFactoryBean;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

@Configuration
@Conditional(value={SchedulerConfigCondition.class})
public class StmsSchedulerConfiguration
extends QuartzSchedulerConfiguration {
    @Bean(destroyMethod="destroy")
    public SchedulerFactoryBean stmsScheduler(DataSource dataSource) {
        SchedulerFactoryBean stmsScheduler = this.createScheduler(dataSource);
        stmsScheduler.setSchedulerName("stms-scheduler");
        stmsScheduler.setAutoStartup(true);
        stmsScheduler.setOverwriteExistingJobs(true);
        stmsScheduler.setTriggers(new Trigger[]{this.stmsDemandGenerationCronTrigger().getObject()});
        return stmsScheduler;
    }

    @Bean(value={"generateDemandForSewerageTaxJob"})
    public GenerateDemandForSewerageTaxJob generateDemandForSewerageTaxJob() {
        return new GenerateDemandForSewerageTaxJob();
    }

    @Bean
    public JobDetailFactoryBean stmsDemandGenerationJobDetail() {
        JobDetailFactoryBean stmsDemandGenerationJobDetail = new JobDetailFactoryBean();
        stmsDemandGenerationJobDetail.setGroup("STMS_JOB_GROUP");
        stmsDemandGenerationJobDetail.setName("STMS_DEMAND_GENERATION_JOB");
        stmsDemandGenerationJobDetail.setDurability(true);
        stmsDemandGenerationJobDetail.setJobClass(GenerateDemandForSewerageTaxJob.class);
        stmsDemandGenerationJobDetail.setRequestsRecovery(true);
        HashMap<String, String> jobDetailMap = new HashMap<String, String>();
        jobDetailMap.put("jobBeanName", "generateDemandForSewerageTaxJob");
        jobDetailMap.put("userName", "egovernments");
        jobDetailMap.put("cityDataRequired", "true");
        jobDetailMap.put("moduleName", "stms");
        stmsDemandGenerationJobDetail.setJobDataAsMap(jobDetailMap);
        return stmsDemandGenerationJobDetail;
    }

    @Bean
    public CronTriggerFactoryBean stmsDemandGenerationCronTrigger() {
        CronTriggerFactoryBean demandGenerationCron = new CronTriggerFactoryBean();
        demandGenerationCron.setJobDetail(this.stmsDemandGenerationJobDetail().getObject());
        demandGenerationCron.setGroup("STMS_TRIGGER_GROUP");
        demandGenerationCron.setName("STMS_DEMAND_GENERATION_TRIGGER");
        demandGenerationCron.setCronExpression("0 */30 * * * ?");
        demandGenerationCron.setMisfireInstruction(2);
        return demandGenerationCron;
    }
}

