/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.service.es;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.egov.collection.entity.es.CollectionDocument;
import org.egov.collection.repository.es.CollectionDocumentRepository;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.OwnerName;
import org.egov.stms.elasticSearch.entity.DailySTCollectionReportSearch;
import org.egov.stms.elasticSearch.entity.SewerageCollectFeeSearchRequest;
import org.egov.stms.elasticSearch.entity.SewerageConnSearchRequest;
import org.egov.stms.elasticSearch.entity.SewerageNoticeSearchRequest;
import org.egov.stms.entity.es.SewerageIndex;
import org.egov.stms.reports.entity.SewerageNoOfConnReportResult;
import org.egov.stms.repository.es.SewerageIndexRepository;
import org.egov.stms.transactions.entity.SewerageApplicationDetails;
import org.egov.stms.transactions.service.SewerageApplicationDetailsService;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class SewerageIndexService {
    @Autowired
    private CityService cityService;
    @Autowired
    private SewerageIndexRepository sewerageIndexRepository;
    @Autowired
    private CollectionDocumentRepository collectionDocumentRepository;
    @Autowired
    private ElasticsearchTemplate elasticsearchTemplate;
    @Autowired
    private SewerageApplicationDetailsService sewerageApplicationDetailsService;

    public SewerageIndex createSewarageIndex(SewerageApplicationDetails sewerageApplicationDetails, AssessmentDetails assessmentDetails) {
        City cityWebsite = this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName());
        SewerageIndex sewarageIndex = new SewerageIndex();
        sewarageIndex.setUlbName(cityWebsite.getName());
        sewarageIndex.setApplicationCreatedBy(sewerageApplicationDetails.getCreatedBy().getName());
        sewarageIndex.setId(cityWebsite.getCode().concat("-").concat(sewerageApplicationDetails.getApplicationNumber()));
        sewarageIndex.setApplicationDate(sewerageApplicationDetails.getApplicationDate());
        sewarageIndex.setApplicationNumber(sewerageApplicationDetails.getApplicationNumber());
        sewarageIndex.setApplicationStatus(sewerageApplicationDetails.getStatus() != null ? sewerageApplicationDetails.getStatus().getDescription() : "");
        sewarageIndex.setConsumerNumber(sewerageApplicationDetails.getApplicationNumber());
        sewarageIndex.setApplicationType(sewerageApplicationDetails.getApplicationType() != null ? sewerageApplicationDetails.getApplicationType().getName() : "");
        sewarageIndex.setConnectionStatus(sewerageApplicationDetails.getConnection().getStatus() != null ? sewerageApplicationDetails.getConnection().getStatus().name() : "");
        sewarageIndex.setCreatedDate(sewerageApplicationDetails.getCreatedDate());
        sewarageIndex.setShscNumber(sewerageApplicationDetails.getConnection().getShscNumber() != null ? sewerageApplicationDetails.getConnection().getShscNumber() : "");
        sewarageIndex.setDisposalDate(sewerageApplicationDetails.getDisposalDate());
        sewarageIndex.setExecutionDate(sewerageApplicationDetails.getConnection().getExecutionDate());
        sewarageIndex.setIslegacy(sewerageApplicationDetails.getConnection().getLegacy());
        sewarageIndex.setNoOfClosets_nonResidential(sewerageApplicationDetails.getConnectionDetail().getNoOfClosetsNonResidential());
        sewarageIndex.setNoOfClosets_residential(sewerageApplicationDetails.getConnectionDetail().getNoOfClosetsResidential());
        sewarageIndex.setPropertyIdentifier(sewerageApplicationDetails.getConnectionDetail().getPropertyIdentifier() != null ? sewerageApplicationDetails.getConnectionDetail().getPropertyIdentifier() : "");
        sewarageIndex.setPropertyType(sewerageApplicationDetails.getConnectionDetail().getPropertyType() != null ? sewerageApplicationDetails.getConnectionDetail().getPropertyType().name() : "");
        if (sewerageApplicationDetails.getEstimationDate() != null) {
            sewarageIndex.setEstimationDate(sewerageApplicationDetails.getEstimationDate());
        }
        sewarageIndex.setEstimationNumber(sewerageApplicationDetails.getEstimationNumber() != null ? sewerageApplicationDetails.getEstimationNumber() : "");
        if (sewerageApplicationDetails.getWorkOrderDate() != null) {
            sewarageIndex.setWorkOrderDate(sewerageApplicationDetails.getWorkOrderDate());
        }
        sewarageIndex.setWorkOrderNumber(sewerageApplicationDetails.getWorkOrderNumber() != null ? sewerageApplicationDetails.getWorkOrderNumber() : "");
        if (sewerageApplicationDetails.getClosureNoticeDate() != null) {
            sewarageIndex.setClosureNoticeDate(sewerageApplicationDetails.getClosureNoticeDate());
        }
        sewarageIndex.setClosureNoticeNumber(sewerageApplicationDetails.getClosureNoticeNumber() != null ? sewerageApplicationDetails.getClosureNoticeNumber() : "");
        Iterator ownerNameItr = null;
        if (null != assessmentDetails.getOwnerNames()) {
            ownerNameItr = assessmentDetails.getOwnerNames().iterator();
        }
        StringBuilder consumerName = new StringBuilder();
        StringBuilder mobileNumber = new StringBuilder();
        if (null != ownerNameItr && ownerNameItr.hasNext()) {
            OwnerName primaryOwner = (OwnerName)ownerNameItr.next();
            consumerName.append(primaryOwner.getOwnerName() != null ? primaryOwner.getOwnerName() : "");
            mobileNumber.append(primaryOwner.getMobileNumber() != null ? primaryOwner.getMobileNumber() : "");
            while (ownerNameItr.hasNext()) {
                OwnerName secondaryOwner = (OwnerName)ownerNameItr.next();
                consumerName.append(",").append(secondaryOwner.getOwnerName() != null ? secondaryOwner.getOwnerName() : "");
                mobileNumber.append(",").append(secondaryOwner.getMobileNumber() != null ? secondaryOwner.getMobileNumber() : "");
            }
        }
        sewarageIndex.setMobileNumber(mobileNumber.toString());
        sewarageIndex.setConsumerName(consumerName.toString());
        sewarageIndex.setDoorNo(assessmentDetails.getHouseNo() != null ? assessmentDetails.getHouseNo() : "");
        sewarageIndex.setWard(assessmentDetails.getBoundaryDetails() != null ? assessmentDetails.getBoundaryDetails().getWardName() : "");
        sewarageIndex.setRevenueBlock(assessmentDetails.getBoundaryDetails() != null ? assessmentDetails.getBoundaryDetails().getBlockName() : "");
        sewarageIndex.setLocationName(assessmentDetails.getBoundaryDetails() != null ? assessmentDetails.getBoundaryDetails().getLocalityName() : "");
        sewarageIndex.setAddress(assessmentDetails.getPropertyAddress() != null ? assessmentDetails.getPropertyAddress() : "");
        sewarageIndex.setActive(sewerageApplicationDetails.isActive());
        this.sewerageIndexRepository.save(sewarageIndex);
        return sewarageIndex;
    }

    public BoolQueryBuilder getQueryFilter(SewerageConnSearchRequest searchRequest) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.matchQuery((String)"active", (Object)true));
        if (StringUtils.isNotBlank((String)searchRequest.getConsumerNumber())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"consumerNumber", (Object)searchRequest.getConsumerNumber()));
        }
        if (StringUtils.isNotBlank((String)searchRequest.getShscNumber())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"shscNumber", (Object)searchRequest.getShscNumber()));
        }
        if (StringUtils.isNotBlank((String)searchRequest.getApplicantName())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"consumerName", (Object)searchRequest.getApplicantName()));
        }
        if (StringUtils.isNotBlank((String)searchRequest.getMobileNumber())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"mobileNumber", (Object)searchRequest.getMobileNumber()));
        }
        if (StringUtils.isNotBlank((String)searchRequest.getRevenueWard())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"ward", (Object)searchRequest.getRevenueWard()));
        }
        if (StringUtils.isNotBlank((String)searchRequest.getDoorNumber())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"doorNo", (Object)searchRequest.getDoorNumber()));
        }
        return boolQuery;
    }

    public List<SewerageIndex> getSearchResultByBoolQuery(BoolQueryBuilder boolQuery, FieldSortBuilder sort) {
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{"sewerage"}).withQuery((QueryBuilder)boolQuery).withSort((SortBuilder)sort).build();
        List resultList = this.elasticsearchTemplate.queryForList((SearchQuery)searchQuery, SewerageIndex.class);
        return resultList;
    }

    public BoolQueryBuilder getSearchQueryFilter(SewerageCollectFeeSearchRequest searchRequest) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.matchQuery((String)"ulbName", (Object)searchRequest.getUlbName()));
        if (StringUtils.isNotBlank((String)searchRequest.getConsumerNumber())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"consumerNumber", (Object)searchRequest.getConsumerNumber()));
        }
        if (StringUtils.isNotBlank((String)searchRequest.getShscNumber())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"shscNumber", (Object)searchRequest.getShscNumber()));
        }
        if (StringUtils.isNotBlank((String)searchRequest.getApplicantName())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"consumerName", (Object)searchRequest.getApplicantName()));
        }
        if (StringUtils.isNotBlank((String)searchRequest.getMobileNumber())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"mobileNumber", (Object)searchRequest.getMobileNumber()));
        }
        if (StringUtils.isNotBlank((String)searchRequest.getRevenueWard())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"ward", (Object)searchRequest.getRevenueWard()));
        }
        if (StringUtils.isNotBlank((String)searchRequest.getDoorNumber())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"doorNo", (Object)searchRequest.getDoorNumber()));
        }
        return boolQuery;
    }

    public List<SewerageIndex> getCollectSearchResult(BoolQueryBuilder boolQuery, FieldSortBuilder sort) {
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{"sewerage"}).withQuery((QueryBuilder)boolQuery).withSort((SortBuilder)sort).build();
        List resultList = this.elasticsearchTemplate.queryForList((SearchQuery)searchQuery, SewerageIndex.class);
        return resultList;
    }

    public BoolQueryBuilder getDCRSearchResult(DailySTCollectionReportSearch searchRequest) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
        SimpleDateFormat newFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.matchQuery((String)"cityName", (Object)searchRequest.getUlbName()));
        if (StringUtils.isNotBlank((String)searchRequest.getFromDate())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"receiptDate").gte(newFormat.format(formatter.parse(searchRequest.getFromDate()))).lte((Object)new DateTime((Object)newFormat.format(formatter.parse(searchRequest.getToDate()))).plusDays(1).toDate()));
        }
        if (StringUtils.isNotBlank((String)searchRequest.getCollectionMode())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"channel", (Object)searchRequest.getCollectionMode()));
        }
        if (StringUtils.isNotBlank((String)searchRequest.getCollectionOperator())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"receiptCreator", (Object)searchRequest.getCollectionOperator()));
        }
        if (StringUtils.isNotBlank((String)searchRequest.getStatus())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"status", (Object)searchRequest.getStatus()));
        }
        return boolQuery;
    }

    public BoolQueryBuilder getDCRSewerageSearchResult(DailySTCollectionReportSearch searchRequest) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.matchQuery((String)"ulbName", (Object)searchRequest.getUlbName()));
        if (StringUtils.isNotBlank((String)searchRequest.getRevenueWard())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"ward", (Object)searchRequest.getRevenueWard()));
        }
        return boolQuery;
    }

    public List<DailySTCollectionReportSearch> getDCRSewerageReportResult(DailySTCollectionReportSearch searchRequest, BoolQueryBuilder boolQuery) throws ParseException {
        ArrayList<CollectionDocument> collectionResultList = new ArrayList<CollectionDocument>();
        ArrayList<DailySTCollectionReportSearch> dcrCollectionList = new ArrayList<DailySTCollectionReportSearch>();
        ArrayList<DailySTCollectionReportSearch> resultList = new ArrayList<DailySTCollectionReportSearch>();
        ArrayList<SewerageIndex> sewerageResultList = new ArrayList<SewerageIndex>();
        Iterable receiptResultList = this.collectionDocumentRepository.search((QueryBuilder)boolQuery);
        for (CollectionDocument document : receiptResultList) {
            collectionResultList.add(document);
        }
        for (CollectionDocument collectionObject : collectionResultList) {
            DailySTCollectionReportSearch dcrReportObject = new DailySTCollectionReportSearch();
            dcrReportObject.setConsumerNumber(collectionObject.getConsumerCode());
            dcrReportObject.setReceiptNumber(collectionObject.getReceiptNumber());
            SimpleDateFormat dateFormat = new SimpleDateFormat("E MMM dd HH:mm:ss Z yyyy");
            SimpleDateFormat myFormat = new SimpleDateFormat("dd/MM/yyyy");
            dcrReportObject.setReceiptDate(myFormat.format(dateFormat.parse(collectionObject.getReceiptDate().toString())));
            dcrReportObject.setPaidAt(collectionObject.getChannel());
            dcrReportObject.setPaymentMode(collectionObject.getPaymentMode());
            dcrReportObject.setStatus(collectionObject.getStatus());
            if (StringUtils.isNotBlank((String)collectionObject.getInstallmentFrom())) {
                dcrReportObject.setFromDate(collectionObject.getInstallmentFrom());
            }
            if (StringUtils.isNotBlank((String)collectionObject.getInstallmentTo())) {
                dcrReportObject.setToDate(collectionObject.getInstallmentTo());
            }
            dcrReportObject.setArrearAmount(collectionObject.getArrearAmount());
            dcrReportObject.setCurrentAmount(collectionObject.getCurrentAmount());
            dcrReportObject.setTotalAmount(collectionObject.getTotalAmount());
            dcrCollectionList.add(dcrReportObject);
        }
        BoolQueryBuilder sewerageBoolQuery = this.getDCRSewerageSearchResult(searchRequest);
        Iterable iterableResultList = this.sewerageIndexRepository.search((QueryBuilder)sewerageBoolQuery);
        for (SewerageIndex index : iterableResultList) {
            sewerageResultList.add(index);
        }
        for (SewerageIndex sewerageIndex : sewerageResultList) {
            for (DailySTCollectionReportSearch dcrReportObj : dcrCollectionList) {
                if (!dcrReportObj.getConsumerNumber().equals(sewerageIndex.getConsumerNumber())) continue;
                dcrReportObj.setDoorNo(sewerageIndex.getDoorNo());
                dcrReportObj.setShscNumber(sewerageIndex.getShscNumber());
                dcrReportObj.setOwnerName(sewerageIndex.getConsumerName());
                dcrReportObj.setRevenueWard(sewerageIndex.getWard());
                resultList.add(dcrReportObj);
            }
        }
        return resultList;
    }

    public BoolQueryBuilder getQueryFilterForNotice(SewerageNoticeSearchRequest searchRequest) {
        BoolQueryBuilder boolQuery = null;
        if (searchRequest.getNoticeType() != null) {
            if (searchRequest.getNoticeType().equals("WO")) {
                boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.rangeQuery((String)"workOrderDate").from(searchRequest.getNoticeGeneratedFrom()).to(searchRequest.getNoticeGeneratedTo()));
            } else if (searchRequest.getNoticeType().equals("EM")) {
                boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.rangeQuery((String)"estimationDate").from(searchRequest.getNoticeGeneratedFrom()).to(searchRequest.getNoticeGeneratedTo()));
            } else if (searchRequest.getNoticeType().equals("CC")) {
                boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.rangeQuery((String)"closureNoticeDate").from(searchRequest.getNoticeGeneratedFrom()).to(searchRequest.getNoticeGeneratedTo()));
            }
        }
        if (boolQuery != null) {
            if (StringUtils.isNotBlank((String)searchRequest.getUlbName())) {
                boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"ulbName", (Object)searchRequest.getUlbName()));
            }
            if (StringUtils.isNotBlank((String)searchRequest.getShscNumber())) {
                boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"shscNumber", (Object)searchRequest.getShscNumber()));
            }
            if (StringUtils.isNotBlank((String)searchRequest.getApplicantName())) {
                boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"consumerName", (Object)searchRequest.getApplicantName()));
            }
            if (StringUtils.isNotBlank((String)searchRequest.getMobileNumber())) {
                boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"mobileNumber", (Object)searchRequest.getMobileNumber()));
            }
            if (StringUtils.isNotBlank((String)searchRequest.getRevenueWard())) {
                boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"ward", (Object)searchRequest.getRevenueWard()));
            }
            if (StringUtils.isNotBlank((String)searchRequest.getDoorNumber())) {
                boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"doorNo", (Object)searchRequest.getDoorNumber()));
            }
        }
        return boolQuery;
    }

    public List<SewerageIndex> getNoticeSearchResultByBoolQuery(BoolQueryBuilder boolQuery) {
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{"sewerage"}).withQuery((QueryBuilder)boolQuery).withSort((SortBuilder)new FieldSortBuilder("consumerName").order(SortOrder.DESC)).build();
        List resultList = this.elasticsearchTemplate.queryForList((SearchQuery)searchQuery, SewerageIndex.class);
        return resultList;
    }

    public Map<String, List<SewerageApplicationDetails>> wardWiseBoolQueryFilter(String ulbName, List<String> wardList, List<String> propertyTypeList) {
        HashMap<String, List<SewerageApplicationDetails>> dcbMap = new HashMap<String, List<SewerageApplicationDetails>>();
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.matchQuery((String)"ulbName", (Object)ulbName));
        boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.termsQuery((String)"propertyType", propertyTypeList));
        boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.termsQuery((String)"ward", wardList));
        boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"active", (Object)true));
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{"sewerage"}).withQuery((QueryBuilder)boolQuery).withPageable((Pageable)new PageRequest(0, 250)).withSort((SortBuilder)new FieldSortBuilder("applicationDate").order(SortOrder.DESC)).build();
        Page searchResultList = this.sewerageIndexRepository.search((SearchQuery)searchQuery);
        for (SewerageIndex indexObj : searchResultList) {
            SewerageApplicationDetails sewerageApplicationDetails = this.sewerageApplicationDetailsService.findByApplicationNumber(indexObj.getApplicationNumber());
            if (sewerageApplicationDetails == null || sewerageApplicationDetails.getApplicationType().getCode().equals("CLOSESEWERAGECONNECTION")) continue;
            if (dcbMap.get(indexObj.getWard()) != null) {
                ((List)dcbMap.get(indexObj.getWard())).add(sewerageApplicationDetails);
                continue;
            }
            ArrayList<SewerageApplicationDetails> appList = new ArrayList<SewerageApplicationDetails>();
            appList.add(sewerageApplicationDetails);
            dcbMap.put(indexObj.getWard(), appList);
        }
        return dcbMap;
    }

    public Map<String, List<SewerageApplicationDetails>> wardWiseConnectionQueryFilter(List<String> propertyTypeList, String ward, String ulbName) {
        HashMap<String, List<SewerageApplicationDetails>> resultMap = new HashMap<String, List<SewerageApplicationDetails>>();
        ArrayList<SewerageApplicationDetails> resultList = new ArrayList<SewerageApplicationDetails>();
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.matchQuery((String)"ulbName", (Object)ulbName));
        boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.termsQuery((String)"propertyType", propertyTypeList));
        if (StringUtils.isNotBlank((String)ward)) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"ward", (Object)ward));
        }
        boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"active", (Object)true));
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{"sewerage"}).withQuery((QueryBuilder)boolQuery).withPageable((Pageable)new PageRequest(0, 250)).withSort((SortBuilder)new FieldSortBuilder("applicationDate").order(SortOrder.DESC)).build();
        Page indexList = this.sewerageIndexRepository.search((SearchQuery)searchQuery);
        for (SewerageIndex index : indexList) {
            ArrayList<SewerageApplicationDetails> appList = new ArrayList<SewerageApplicationDetails>();
            SewerageApplicationDetails applicationDetails = this.sewerageApplicationDetailsService.findByApplicationNumber(index.getApplicationNumber());
            if (resultList.isEmpty()) {
                resultList.add(applicationDetails);
            }
            if (applicationDetails == null) continue;
            applicationDetails.setOwnerName(index.getConsumerName());
            if (resultMap.isEmpty()) {
                resultMap.put(applicationDetails.getApplicationNumber(), resultList);
                continue;
            }
            if (resultMap.get(applicationDetails.getApplicationNumber()) != null) {
                ((List)resultMap.get(applicationDetails.getApplicationNumber())).add(applicationDetails);
                continue;
            }
            appList.add(applicationDetails);
            resultMap.put(applicationDetails.getApplicationNumber(), appList);
        }
        return resultMap;
    }

    public List<SewerageNoOfConnReportResult> searchNoOfApplnQuery(String ward, String block, String locality) {
        ArrayList<SewerageNoOfConnReportResult> resultList = new ArrayList<SewerageNoOfConnReportResult>();
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.matchQuery((String)"ulbName", (Object)ApplicationThreadLocals.getCityName()));
        boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"active", (Object)true));
        if (StringUtils.isNotBlank((String)ward)) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"ward", (Object)ward));
        }
        if (StringUtils.isNotBlank((String)block)) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"revenueBlock", (Object)block));
        }
        if (StringUtils.isNotBlank((String)locality)) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"locationName", (Object)locality));
        }
        SearchResponse consolidatedResponse = (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{"sewerage"}).setQuery((QueryBuilder)boolQuery).addAggregation((AbstractAggregationBuilder)SewerageIndexService.getCountWithGroupingWardAndOrder("groupByField", "ward", "ward", "desc").subAggregation((AbstractAggregationBuilder)SewerageIndexService.getCountWithGroupingWardAndOrder("groupByField", "applicationType", "ward", "desc"))).execute().actionGet();
        Terms terms = (Terms)consolidatedResponse.getAggregations().get("groupByField");
        for (Terms.Bucket bucket : terms.getBuckets()) {
            SewerageNoOfConnReportResult resultObject = new SewerageNoOfConnReportResult();
            resultObject.setName(bucket.getKey().toString());
            Terms subTerms = (Terms)bucket.getAggregations().get("groupByField");
            for (Terms.Bucket bucket1 : subTerms.getBuckets()) {
                if ("New Sewerage Connection".equals(bucket1.getKey())) {
                    resultObject.setNewconnection(bucket1.getDocCount());
                }
                if ("Change In Closets".equals(bucket1.getKey())) {
                    resultObject.setChangeinclosets(bucket1.getDocCount());
                }
                if ("Close Sewerage Connection".equals(bucket1.getKey())) {
                    resultObject.setCloseconnection(bucket1.getDocCount());
                }
                resultObject.setTotal(resultObject.getNewconnection() + resultObject.getChangeinclosets() + resultObject.getCloseconnection());
            }
            resultList.add(resultObject);
        }
        return resultList;
    }

    public static AggregationBuilder getCountWithGroupingWardAndOrder(String aggregationName, String fieldName, String sortField, String sortOrder) {
        TermsBuilder aggregation = (TermsBuilder)AggregationBuilders.terms((String)aggregationName).field(fieldName);
        if (StringUtils.isNotBlank((String)sortField) && StringUtils.isNotEmpty((String)sortField) && "ward".equalsIgnoreCase(sortField)) {
            Boolean order = true;
            if (StringUtils.isNotEmpty((String)sortOrder) && StringUtils.isNotBlank((String)sortOrder) && StringUtils.equalsIgnoreCase((String)sortOrder, (String)"desc")) {
                order = false;
            }
            aggregation.order(Terms.Order.aggregation((String)"_count", (boolean)order));
        }
        return aggregation;
    }
}

