/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.transactions.service;

import java.math.BigDecimal;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.egov.infra.rest.client.SimpleRestClient;
import org.egov.infra.web.utils.WebUtils;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.client.RestTemplate;

@Service
@Transactional(readOnly=true)
public class SewerageThirdPartyServices {
    @Autowired
    private SimpleRestClient simpleRestClient;
    private static final String WTMS_TAXDUE_RESTURL = "%s/wtms/rest/watertax/due/byptno/%s";

    public AssessmentDetails getPropertyDetails(String assessmentNumber, HttpServletRequest request) {
        RestTemplate restTemplate = new RestTemplate();
        String url = "http://" + request.getServerName() + ":" + request.getServerPort() + "/ptis/rest/property/{assessmentNumber}";
        AssessmentDetails propertyOwnerDetails = (AssessmentDetails)restTemplate.getForObject(url, AssessmentDetails.class, new Object[]{assessmentNumber});
        return propertyOwnerDetails;
    }

    public HashMap<String, Object> getWaterTaxDueAndCurrentTax(String assessmentNo, HttpServletRequest request) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("WATERTAXDUE", BigDecimal.ZERO);
        result.put("CURRENTWATERCHARGE", BigDecimal.ZERO);
        String wtmsRestURL = String.format(WTMS_TAXDUE_RESTURL, WebUtils.extractRequestDomainURL((HttpServletRequest)request, (boolean)false), assessmentNo);
        HashMap waterTaxInfo = this.simpleRestClient.getRESTResponseAsMap(wtmsRestURL);
        result.put("WATERTAXDUE", waterTaxInfo.get("totalTaxDue") == null ? BigDecimal.ZERO : new BigDecimal((Double)waterTaxInfo.get("totalTaxDue")));
        result.put("CURRENTWATERCHARGE", waterTaxInfo.get("currentDemand") == null ? BigDecimal.ZERO : new BigDecimal((Double)waterTaxInfo.get("currentDemand")));
        result.put("PROPERTYID", waterTaxInfo.get("propertyID"));
        result.put("CONSUMERCODE", waterTaxInfo.get("consumerCode"));
        return result;
    }

    public BigDecimal getCurrentWaterTax(String assessmentNo, HttpServletRequest request) {
        String wtmsRestURL = String.format(WTMS_TAXDUE_RESTURL, WebUtils.extractRequestDomainURL((HttpServletRequest)request, (boolean)false), assessmentNo);
        HashMap waterTaxInfo = this.simpleRestClient.getRESTResponseAsMap(wtmsRestURL);
        return waterTaxInfo.get("currentDemand") == null ? BigDecimal.ZERO : new BigDecimal((Double)waterTaxInfo.get("currentDemand"));
    }
}

