/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.transactions.service;

import org.egov.stms.entity.SewerageDemandGenerationLog;
import org.egov.stms.entity.SewerageDemandGenerationLogDetail;
import org.egov.stms.masters.entity.enums.SewerageProcessStatus;
import org.egov.stms.transactions.entity.SewerageApplicationDetails;
import org.egov.stms.transactions.repository.SewerageDemandGenerationLogDetailRepository;
import org.egov.stms.transactions.repository.SewerageDemandGenerationLogRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class SewerageDemandGenerationLogService {
    @Autowired
    private SewerageDemandGenerationLogRepository demandGenerationLogRepository;
    @Autowired
    private SewerageDemandGenerationLogDetailRepository demandGenerationLogDetailRepository;

    public SewerageDemandGenerationLog getDemandGenerationLogByInstallmentYear(String installmentYearRange) {
        return this.demandGenerationLogRepository.findByInstallmentYear(installmentYearRange);
    }

    public SewerageDemandGenerationLog createDemandGenerationLog(String installmentYearRange) {
        return (SewerageDemandGenerationLog)((Object)this.demandGenerationLogRepository.saveAndFlush((Object)new SewerageDemandGenerationLog(installmentYearRange)));
    }

    @Transactional
    public SewerageDemandGenerationLog completeDemandGenerationLog(SewerageDemandGenerationLog demandGenerationLog) {
        demandGenerationLog.setDemandGenerationStatus(SewerageProcessStatus.COMPLETED);
        for (SewerageDemandGenerationLogDetail detail : demandGenerationLog.getDetails()) {
            if (!detail.getStatus().equals((Object)SewerageProcessStatus.INCOMPLETE)) continue;
            demandGenerationLog.setDemandGenerationStatus(SewerageProcessStatus.INCOMPLETE);
            break;
        }
        demandGenerationLog.setExecutionStatus(SewerageProcessStatus.COMPLETED);
        return (SewerageDemandGenerationLog)((Object)this.demandGenerationLogRepository.saveAndFlush((Object)demandGenerationLog));
    }

    public SewerageDemandGenerationLogDetail createOrGetDemandGenerationLogDetail(SewerageDemandGenerationLog demandGenerationLog, SewerageApplicationDetails applicationDetails, SewerageProcessStatus status, String detailMsg) {
        SewerageDemandGenerationLogDetail logDetail = this.demandGenerationLogDetailRepository.findByDemandGenerationLogIdAndSewerageApplicationDetailsId(demandGenerationLog.getId(), applicationDetails.getId());
        if (logDetail == null) {
            logDetail = new SewerageDemandGenerationLogDetail();
            logDetail.setSewerageApplicationDetails(applicationDetails);
            logDetail.setDemandGenerationLog(demandGenerationLog);
            logDetail.setStatus(status);
            logDetail.setDetail(detailMsg);
            demandGenerationLog.getDetails().add(logDetail);
            logDetail = (SewerageDemandGenerationLogDetail)((Object)this.demandGenerationLogDetailRepository.saveAndFlush((Object)logDetail));
        }
        return logDetail;
    }

    @Transactional
    public SewerageDemandGenerationLogDetail completeDemandGenerationLogDetail(SewerageDemandGenerationLogDetail demandGenerationLogDetail) {
        return (SewerageDemandGenerationLogDetail)((Object)this.demandGenerationLogDetailRepository.saveAndFlush((Object)demandGenerationLogDetail));
    }
}

