/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.transactions.service;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.log4j.Logger;
import org.egov.commons.Installment;
import org.egov.demand.dao.EgDemandDao;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.stms.entity.SewerageTaxBatchDemandGenerate;
import org.egov.stms.transactions.entity.SewerageApplicationDetails;
import org.egov.stms.transactions.repository.SewerageTaxBatchDemandGenRepository;
import org.egov.stms.transactions.service.SewerageApplicationDetailsService;
import org.egov.stms.transactions.service.SewerageDemandService;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

@Service
@Transactional(readOnly=true)
public class SewerageBatchDemandGenService {
    private static final Logger LOGGER = Logger.getLogger(SewerageBatchDemandGenService.class);
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private EgDemandDao egDemandDao;
    @Autowired
    private SewerageApplicationDetailsService sewerageApplicationDetailsService;
    @Autowired
    private SewerageDemandService sewerageDemandService;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private SewerageTaxBatchDemandGenRepository sewerageTaxBatchDemandGenRepository;
    @Autowired
    private TransactionTemplate transactionTemplate;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public SewerageTaxBatchDemandGenerate getBatchDemandGenById(Long id) {
        return (SewerageTaxBatchDemandGenerate)((Object)this.sewerageTaxBatchDemandGenRepository.findOne(id));
    }

    public List<SewerageTaxBatchDemandGenerate> findActiveBatchDemands() {
        return this.sewerageTaxBatchDemandGenRepository.findActiveBatchDemands();
    }

    @Transactional
    public SewerageTaxBatchDemandGenerate createSewerageTaxBatchDemandGenerate(SewerageTaxBatchDemandGenerate advBatchDmd) {
        return (SewerageTaxBatchDemandGenerate)((Object)this.sewerageTaxBatchDemandGenRepository.save((Object)advBatchDmd));
    }

    public SewerageTaxBatchDemandGenerate updateSewerageTaxBatchDemandGenerate(SewerageTaxBatchDemandGenerate advBatchDmd) {
        return (SewerageTaxBatchDemandGenerate)((Object)this.sewerageTaxBatchDemandGenRepository.save((Object)advBatchDmd));
    }

    public int generateSewerageDemandForNextFinYear() {
        Integer[] recordsResult = null;
        List<SewerageTaxBatchDemandGenerate> sewerageBatchDmdGenResult = this.findActiveBatchDemands();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("SewerageBatchDmdGenResult " + sewerageBatchDmdGenResult.size()));
        }
        List<Object> sewerageApplnsDetails = new ArrayList();
        if (!sewerageBatchDmdGenResult.isEmpty()) {
            SewerageTaxBatchDemandGenerate sewerageDmdGen;
            AppConfigValues totalRecordToFeatch = (AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey("Sewerage Tax Management", "Number of Records used in next year demand generation").get(0);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("*************************************** totalRecordToFeatch records " + totalRecordToFeatch.getValue()));
            }
            if ((sewerageDmdGen = sewerageBatchDmdGenResult.get(0)) != null && sewerageDmdGen.getInstallment() != null) {
                List<Installment> previousInstallment = this.sewerageDemandService.getPreviousInstallment(sewerageDmdGen.getInstallment().getToDate());
                Installment sewerageDmdGenerationInstallment = this.sewerageDemandService.getInsatllmentByModuleForGivenDate(sewerageDmdGen.getInstallment().getToDate());
                if (sewerageDmdGenerationInstallment != null && previousInstallment != null && !previousInstallment.isEmpty()) {
                    sewerageApplnsDetails = this.sewerageApplicationDetailsService.findActiveSewerageApplnsByCurrentInstallmentAndNumberOfResultToFetch(previousInstallment.get(0), Integer.valueOf(totalRecordToFeatch.getValue()));
                    for (SewerageApplicationDetails sewerageApplicationDetails : sewerageApplnsDetails) {
                        sewerageApplicationDetails.getDemandConnections().get(0).setDemand(this.egDemandDao.findById(sewerageApplicationDetails.getDemandConnections().get(0).getDemand().getId(), false));
                    }
                    recordsResult = this.sewerageDemandService.generateDemandForNextInstallment(sewerageApplnsDetails, previousInstallment, sewerageDmdGenerationInstallment);
                }
            }
            sewerageDmdGen.setActive(false);
            sewerageDmdGen.setTotalRecords((Integer)recordsResult[0]);
            sewerageDmdGen.setSuccessfullRecords((Integer)recordsResult[1]);
            sewerageDmdGen.setFailureRecords((Integer)recordsResult[2]);
            TransactionTemplate txTemplate = new TransactionTemplate(this.transactionTemplate.getTransactionManager());
            txTemplate.setPropagationBehavior(3);
            txTemplate.execute(result -> {
                this.updateSewerageTaxBatchDemandGenerate(sewerageDmdGen);
                return Boolean.TRUE;
            });
        }
        return recordsResult[1].intValue();
    }
}

