/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.entity;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.egov.stms.entity.SewerageDemandGenerationLogDetail;
import org.egov.stms.masters.entity.enums.SewerageProcessStatus;

@Entity
@Table(name="egswtax_demandgenerationlog")
@SequenceGenerator(name="seq_egswtax_demandgenerationlog", sequenceName="seq_egswtax_demandgenerationlog", allocationSize=1)
@Unique(fields={"installmentYear"}, enableDfltMsg=true)
public class SewerageDemandGenerationLog
extends AbstractAuditable {
    public static final String SEQ = "seq_egswtax_demandgenerationlog";
    private static final long serialVersionUID = 3323170307345697375L;
    @Id
    @GeneratedValue(generator="seq_egswtax_demandgenerationlog", strategy=GenerationType.SEQUENCE)
    private Long id;
    private String installmentYear;
    @Enumerated(value=EnumType.STRING)
    private SewerageProcessStatus executionStatus;
    @Enumerated(value=EnumType.STRING)
    private SewerageProcessStatus demandGenerationStatus;
    @OneToMany(mappedBy="demandGenerationLog", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private List<SewerageDemandGenerationLogDetail> details = new ArrayList<SewerageDemandGenerationLogDetail>();

    protected SewerageDemandGenerationLog() {
    }

    public SewerageDemandGenerationLog(String installmentYear) {
        this.installmentYear = installmentYear;
        this.executionStatus = SewerageProcessStatus.COMPLETED;
        this.demandGenerationStatus = SewerageProcessStatus.COMPLETED;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getInstallmentYear() {
        return this.installmentYear;
    }

    public void setInstallmentYear(String installmentYear) {
        this.installmentYear = installmentYear;
    }

    public SewerageProcessStatus getExecutionStatus() {
        return this.executionStatus;
    }

    public void setExecutionStatus(SewerageProcessStatus executionStatus) {
        this.executionStatus = executionStatus;
    }

    public SewerageProcessStatus getDemandGenerationStatus() {
        return this.demandGenerationStatus;
    }

    public void setDemandGenerationStatus(SewerageProcessStatus demandGenerationStatus) {
        this.demandGenerationStatus = demandGenerationStatus;
    }

    public List<SewerageDemandGenerationLogDetail> getDetails() {
        return this.details;
    }

    public void setDetails(List<SewerageDemandGenerationLogDetail> details) {
        this.details = details;
    }
}

