/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.transactions.service.collection;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.egov.demand.dao.EgBillDao;
import org.egov.demand.dao.EgDemandDao;
import org.egov.demand.interfaces.Billable;
import org.egov.demand.model.AbstractBillable;
import org.egov.demand.model.EgBillType;
import org.egov.demand.model.EgDemand;
import org.egov.demand.model.EgDemandDetails;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.BoundaryDetails;
import org.egov.ptis.domain.model.OwnerName;
import org.egov.stms.transactions.entity.SewerageApplicationDetails;
import org.egov.stms.utils.SewerageTaxUtils;
import org.egov.wtms.utils.WaterTaxUtils;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Scope(value="prototype")
@Transactional(readOnly=true)
public class SewerageBillable
extends AbstractBillable
implements Billable {
    private static final Logger LOGGER = Logger.getLogger(SewerageBillable.class);
    @Autowired
    private ModuleService moduleService;
    private SewerageApplicationDetails sewerageApplicationDetails;
    private AssessmentDetails assessmentDetails;
    private Long userId;
    private EgBillType billType;
    private Boolean isCallbackForApportion = Boolean.FALSE;
    private String referenceNumber;
    private String transanctionReferenceNumber;
    @Autowired
    private EgBillDao egBillDAO;
    @Autowired
    private EgDemandDao egDemandDAO;
    @Autowired
    private WaterTaxUtils waterTaxUtils;
    @Autowired
    private SewerageTaxUtils sewerageTaxUtils;

    public String getBillPayee() {
        return this.buildOwnerFullName(this.getAssessmentDetails().getOwnerNames());
    }

    public String getBillAddress() {
        return this.buildAddressDetails(this.assessmentDetails);
    }

    public EgDemand getCurrentDemand() {
        if (this.getSewerageApplicationDetails() != null && this.getSewerageApplicationDetails().getCurrentDemand() != null) {
            return this.getSewerageApplicationDetails().getCurrentDemand();
        }
        return null;
    }

    public String getConsumerType() {
        return "";
    }

    public List<EgDemand> getAllDemands() {
        ArrayList<EgDemand> demands = null;
        if (this.getCurrentDemand() != null) {
            demands = new ArrayList<EgDemand>();
            demands.add(this.getCurrentDemand());
        }
        return demands;
    }

    public EgBillType getBillType() {
        if (this.billType == null) {
            this.billType = this.egBillDAO.getBillTypeByCode("AUTO");
        }
        return this.billType;
    }

    public Date getBillLastDueDate() {
        return new DateTime().plusMonths(1).toDate();
    }

    public Long getBoundaryNum() {
        if (this.getAssessmentDetails() != null && this.getAssessmentDetails().getBoundaryDetails() != null) {
            return this.getAssessmentDetails().getBoundaryDetails().getWardNumber();
        }
        return null;
    }

    public String getBoundaryType() {
        if (this.getAssessmentDetails() != null && this.getAssessmentDetails().getBoundaryDetails() != null) {
            return this.getAssessmentDetails().getBoundaryDetails().getWardBoundaryType();
        }
        return "Ward";
    }

    public String getDepartmentCode() {
        return "REV";
    }

    public BigDecimal getFunctionaryCode() {
        return new BigDecimal("1");
    }

    public String getFundCode() {
        return "01";
    }

    public String getFundSourceCode() {
        return "01";
    }

    public Date getIssueDate() {
        return new Date();
    }

    public Date getLastDate() {
        return this.getBillLastDueDate();
    }

    public Module getModule() {
        return this.moduleService.getModuleByName("Sewerage Tax Management");
    }

    public Boolean getOverrideAccountHeadsAllowed() {
        return false;
    }

    public Boolean getPartPaymentAllowed() {
        return false;
    }

    public String getServiceCode() {
        return "STAX";
    }

    public BigDecimal getTotalAmount() {
        BigDecimal balance = BigDecimal.ZERO;
        if (this.getCurrentDemand() != null) {
            for (EgDemandDetails det : this.getCurrentDemand().getEgDemandDetails()) {
                BigDecimal dmdAmt = det.getAmount();
                BigDecimal collAmt = det.getAmtCollected();
                balance = balance.add(dmdAmt.subtract(collAmt));
            }
        }
        return balance;
    }

    public Long getUserId() {
        return ApplicationThreadLocals.getUserId() == null ? null : Long.valueOf(ApplicationThreadLocals.getUserId());
    }

    public String getDescription() {
        if (null != this.getSewerageApplicationDetails().getConnection().getShscNumber()) {
            return "Sewerage connection H.S.C No: " + this.getSewerageApplicationDetails().getConnection().getShscNumber();
        }
        return "Sewerage connection Application Number: " + this.getSewerageApplicationDetails().getApplicationNumber();
    }

    public String getDisplayMessage() {
        return "Sewerage Tax Collection";
    }

    public String getCollModesNotAllowed() {
        StringBuilder collectionModesNotAllowed = new StringBuilder();
        collectionModesNotAllowed.append("bankchallan");
        return collectionModesNotAllowed.toString();
    }

    public String getConsumerId() {
        return this.getSewerageApplicationDetails().getApplicationNumber();
    }

    public Boolean isCallbackForApportion() {
        return this.isCallbackForApportion;
    }

    public void setCallbackForApportion(Boolean b) {
        this.isCallbackForApportion = b;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public void setBillType(EgBillType billType) {
        this.billType = billType;
    }

    public String buildOwnerFullName(Set<OwnerName> ownerSet) {
        if (ownerSet == null) {
            throw new ApplicationRuntimeException("Property Owner set is null...");
        }
        String ownerFullName = "";
        HashSet<String> ownerNameSet = new HashSet<String>();
        for (OwnerName propOwnerInfo : ownerSet) {
            if (propOwnerInfo.getOwnerName() == null || propOwnerInfo.getOwnerName().trim().equals("") || ownerNameSet.contains(propOwnerInfo.getOwnerName().trim())) continue;
            if (!ownerFullName.trim().equals("") && !ownerFullName.equals("")) {
                ownerFullName = ownerFullName + ", ";
            }
            ownerNameSet.add(propOwnerInfo.getOwnerName().trim());
            ownerFullName = propOwnerInfo.getOwnerName() == null ? "" : propOwnerInfo.getOwnerName();
        }
        return ownerFullName;
    }

    public String buildAddressDetails(AssessmentDetails assessmentDetails) {
        StringBuilder address = new StringBuilder();
        if (assessmentDetails != null) {
            BoundaryDetails boundaryDetails = assessmentDetails.getBoundaryDetails();
            if (assessmentDetails.getPropertyAddress() != null && !"".equals(assessmentDetails.getPropertyAddress())) {
                address.append(assessmentDetails.getPropertyAddress());
            } else {
                if (boundaryDetails.getZoneName() != null) {
                    address.append(boundaryDetails.getZoneName());
                }
                if (boundaryDetails.getWardName() != null) {
                    address.append(", ").append(boundaryDetails.getWardName());
                }
                if (boundaryDetails.getLocalityName() != null) {
                    address.append(", ").append(boundaryDetails.getLocalityName());
                }
                if (boundaryDetails.getBlockName() != null) {
                    address.append(", ").append(boundaryDetails.getBlockName());
                }
                if (boundaryDetails.getStreetName() != null) {
                    address.append(", ").append(boundaryDetails.getStreetName());
                }
            }
        }
        return address.toString();
    }

    public SewerageApplicationDetails getSewerageApplicationDetails() {
        return this.sewerageApplicationDetails;
    }

    public void setSewerageApplicationDetails(SewerageApplicationDetails sewerageApplicationDetails) {
        this.sewerageApplicationDetails = sewerageApplicationDetails;
    }

    public AssessmentDetails getAssessmentDetails() {
        return this.assessmentDetails;
    }

    public void setAssessmentDetails(AssessmentDetails assessmentDetails) {
        this.assessmentDetails = assessmentDetails;
    }

    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    public void setReferenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
    }

    public String getTransanctionReferenceNumber() {
        return this.transanctionReferenceNumber;
    }

    public void setTransanctionReferenceNumber(String transanctionReferenceNumber) {
        this.transanctionReferenceNumber = transanctionReferenceNumber;
    }

    public String getEmailId() {
        return null;
    }
}

