/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.masters.service;

import java.util.List;
import org.egov.stms.masters.entity.SewerageApplicationType;
import org.egov.stms.masters.repository.SewerageApplicationTypeRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class SewerageApplicationTypeService {
    private final SewerageApplicationTypeRepository sewerageApplicationTypeRepository;

    @Autowired
    public SewerageApplicationTypeService(SewerageApplicationTypeRepository sewerageApplicationTypeRepository) {
        this.sewerageApplicationTypeRepository = sewerageApplicationTypeRepository;
    }

    public SewerageApplicationType findBy(Long applicationTypeId) {
        return (SewerageApplicationType)((Object)this.sewerageApplicationTypeRepository.findOne(applicationTypeId));
    }

    @Transactional
    public SewerageApplicationType createApplicationType(SewerageApplicationType sewerageApplicationType) {
        return (SewerageApplicationType)((Object)this.sewerageApplicationTypeRepository.save((Object)sewerageApplicationType));
    }

    @Transactional
    public void updateApplicationType(SewerageApplicationType sewerageApplicationType) {
        this.sewerageApplicationTypeRepository.save((Object)sewerageApplicationType);
    }

    public List<SewerageApplicationType> findAll() {
        return this.sewerageApplicationTypeRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"name"}));
    }

    public List<SewerageApplicationType> findAllByNameLike(String name) {
        return this.sewerageApplicationTypeRepository.findByNameContainingIgnoreCase(name);
    }

    public SewerageApplicationType findByName(String name) {
        return this.sewerageApplicationTypeRepository.findByName(name);
    }

    public SewerageApplicationType load(Long id) {
        return (SewerageApplicationType)((Object)this.sewerageApplicationTypeRepository.getOne(id));
    }

    public Page<SewerageApplicationType> getListOfApplicationTypes(Integer pageNumber, Integer pageSize) {
        PageRequest pageable = new PageRequest(pageNumber - 1, pageSize.intValue(), Sort.Direction.ASC, new String[]{"name"});
        return this.sewerageApplicationTypeRepository.findAll((Pageable)pageable);
    }

    public SewerageApplicationType findByCode(String code) {
        return this.sewerageApplicationTypeRepository.findByCode(code);
    }
}

