/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.autonumber.impl;

import java.io.Serializable;
import org.egov.infra.persistence.utils.ApplicationSequenceNumberGenerator;
import org.egov.stms.autonumber.SewerageWorkOrderNumberGenerator;
import org.egov.stms.utils.SewerageTaxUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SewerageWorkOrderNumberGeneratorImpl
implements SewerageWorkOrderNumberGenerator {
    private static final String WORKORDER_NUMBER_SEQ_PREFIX = "SEQ_EGSWTAX_WORKORDER_NUMBER";
    @Autowired
    private ApplicationSequenceNumberGenerator applicationSequenceNumberGenerator;
    @Autowired
    private SewerageTaxUtils sewerageTaxUtils;

    @Override
    @Transactional
    public String generateSewerageWorkOrderNumber() {
        String sequenceName = WORKORDER_NUMBER_SEQ_PREFIX;
        Serializable nextSequence = this.applicationSequenceNumberGenerator.getNextSequence(WORKORDER_NUMBER_SEQ_PREFIX);
        return String.format("%s%06d", this.sewerageTaxUtils.getCityCode(), nextSequence);
    }
}

