/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.autonumber.impl;

import java.io.Serializable;
import org.egov.infra.persistence.utils.ApplicationSequenceNumberGenerator;
import org.egov.infra.utils.DateUtils;
import org.egov.stms.autonumber.SHSCNumberGenerator;
import org.egov.stms.transactions.entity.SewerageApplicationDetails;
import org.egov.stms.utils.SewerageTaxUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SHSCNumberGeneratorImpl
implements SHSCNumberGenerator {
    private static final String SHSC_NUMBER_SEQ_PREFIX = "SEQ_SHSC_NUMBER%s";
    @Autowired
    private ApplicationSequenceNumberGenerator applicationSequenceNumberGenerator;
    @Autowired
    private SewerageTaxUtils sewerageTaxUtils;

    @Override
    @Transactional
    public String generateNextSHSCNumber(SewerageApplicationDetails sewerageApplicationDetails) {
        String currentYear = DateUtils.currentDateToYearFormat();
        String sequenceName = String.format(SHSC_NUMBER_SEQ_PREFIX, currentYear);
        Serializable nextSequence = this.applicationSequenceNumberGenerator.getNextSequence(sequenceName);
        return String.format("%s%06d", this.sewerageTaxUtils.getCityCode(), nextSequence);
    }
}

