/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.utils;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.egov.stms.elasticSearch.entity.SewerageSearchResult;
import org.egov.stms.transactions.entity.SewerageApplicationDetails;

public class SewerageActionDropDownUtil {
    public static final String DEFAULT = "DEFAULT";
    public static final Map<String, Map<String, String>> actionUrlMap = new HashMap<String, Map<String, String>>();
    public static final Map<String, List<String>> STATUSACTIONMAP = new HashMap<String, List<String>>();
    public static final Map<String, List<String>> SEWERAGEROLEACTIONMAP = new HashMap<String, List<String>>();
    private static Logger LOGGER = Logger.getLogger(SewerageActionDropDownUtil.class);

    private static Map<String, String> getActionWithUrl(String url, String action) {
        LinkedHashMap<String, String> actionwithurl = new LinkedHashMap<String, String>();
        actionwithurl.put(url, action);
        return actionwithurl;
    }

    public static Map<String, String> filterActionsByStatus(List<String> actions, String status, SewerageApplicationDetails sewerageApplicationDetails) {
        if (actions != null && !actions.isEmpty()) {
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            List<String> statusActionList = Collections.EMPTY_LIST;
            if (status != null && !status.equals("")) {
                LOGGER.info((Object)(" ************ registrationStatus  " + status));
                statusActionList = STATUSACTIONMAP.get(status.toUpperCase());
                LOGGER.info((Object)(" ....... statusActionList  " + statusActionList));
                SewerageActionDropDownUtil.selectUserMappingActions(actions, result, statusActionList);
                if (status.equalsIgnoreCase("SANCTIONED") && sewerageApplicationDetails.getCurrentDemand().getBaseDemand().compareTo(sewerageApplicationDetails.getCurrentDemand().getAmtCollected()) == 1) {
                    LOGGER.info((Object)(" ************ registrationStatus  " + status));
                    statusActionList = STATUSACTIONMAP.get("SANCTIONEDWITHDEMAND");
                    LOGGER.info((Object)(" ....... statusActionList  " + statusActionList));
                    SewerageActionDropDownUtil.selectUserMappingActions(actions, result, statusActionList);
                }
                if (result != null && result.size() == 0) {
                    statusActionList = STATUSACTIONMAP.get(DEFAULT);
                    SewerageActionDropDownUtil.selectUserMappingActions(actions, result, statusActionList);
                }
                return result;
            }
            return Collections.EMPTY_MAP;
        }
        return Collections.EMPTY_MAP;
    }

    private static void selectUserMappingActions(List<String> actions, Map<String, String> result, List<String> statusActionList) {
        for (String action : actions) {
            if (statusActionList == null || !statusActionList.contains(action)) continue;
            result.putAll(actionUrlMap.get(action));
        }
    }

    public static Map<String, String> getActionsByRoles(List<String> roleName, String collectionStatus, SewerageApplicationDetails sewerageApplicationDetails) {
        List<String> actionList = Collections.EMPTY_LIST;
        LOGGER.debug((Object)(" ************ Role Name " + roleName));
        LOGGER.debug((Object)(" ************ registrationStatus  " + collectionStatus));
        if (roleName != null && !roleName.isEmpty()) {
            actionList = roleName.contains("Super User") ? SEWERAGEROLEACTIONMAP.get("Super User") : (roleName.contains("CSC Operator") ? SEWERAGEROLEACTIONMAP.get("CSC Operator") : (roleName.contains("ULB Operator") ? SEWERAGEROLEACTIONMAP.get("ULB Operator") : (roleName.contains("Collection Operator") ? SEWERAGEROLEACTIONMAP.get("Collection Operator") : (roleName.contains("Sewerage Tax Creator") ? SEWERAGEROLEACTIONMAP.get("Sewerage Tax Creator") : (roleName.contains("Sewerage Tax Approver") ? SEWERAGEROLEACTIONMAP.get("Sewerage Tax Approver") : (roleName.contains("Sewerage Tax Report Viewer") ? SEWERAGEROLEACTIONMAP.get("Sewerage Tax Report Viewer") : (roleName.contains("Sewerage Tax Administrator") ? SEWERAGEROLEACTIONMAP.get("Sewerage Tax Administrator") : SEWERAGEROLEACTIONMAP.get(DEFAULT))))))));
        }
        return SewerageActionDropDownUtil.filterActionsByStatus(actionList, collectionStatus, sewerageApplicationDetails);
    }

    public static final SewerageSearchResult getSearchResultWithActions(List<String> roleName, String status, SewerageApplicationDetails sewerageApplicationDetails) {
        SewerageSearchResult searchActions = new SewerageSearchResult();
        if (status != null && sewerageApplicationDetails != null) {
            searchActions.setActions(SewerageActionDropDownUtil.getActionsByRoles(roleName, status, sewerageApplicationDetails));
        }
        return searchActions;
    }

    static {
        STATUSACTIONMAP.put(DEFAULT, Arrays.asList("View"));
        STATUSACTIONMAP.put("CREATED", Arrays.asList("View"));
        STATUSACTIONMAP.put("COLLECTINSPECTIONFEE", Arrays.asList("View", "View DCB", "Collect Fee"));
        STATUSACTIONMAP.put("INITIAL APPROVED", Arrays.asList("View", "View DCB"));
        STATUSACTIONMAP.put("ESTIMATION NOTICE GENERATED", Arrays.asList("View", "View DCB", "Collect Fee"));
        STATUSACTIONMAP.put("ESTIMATION AMOUNT PAID", Arrays.asList("View", "View DCB"));
        STATUSACTIONMAP.put("WORK ORDER GENERATED", Arrays.asList("View", "View DCB"));
        STATUSACTIONMAP.put("FINAL APPROVED", Arrays.asList("View", "View DCB"));
        STATUSACTIONMAP.put("SANCTIONED", Arrays.asList("View", "View DCB", "Change number of seats", "Close Sewerage Connection", "Generate Demand Bill"));
        STATUSACTIONMAP.put("SANCTIONEDWITHDEMAND", Arrays.asList("View", "View DCB", "Change number of seats", "Collect Fee"));
        SEWERAGEROLEACTIONMAP.put("Sewerage Tax Creator", Arrays.asList("View", "View DCB", "Change number of seats", "Close Sewerage Connection", "Generate Demand Bill"));
        SEWERAGEROLEACTIONMAP.put("Sewerage Tax Administrator", Arrays.asList("View"));
        SEWERAGEROLEACTIONMAP.put("Sewerage Tax Approver", Arrays.asList("View", "View DCB", "Change number of seats"));
        SEWERAGEROLEACTIONMAP.put("CSC Operator", Arrays.asList("View", "Collect Fee"));
        SEWERAGEROLEACTIONMAP.put("ULB Operator", Arrays.asList("View", "Collect Fee", "View DCB", "Change number of seats", "Close Sewerage Connection", "Generate Demand Bill"));
        SEWERAGEROLEACTIONMAP.put("Collection Operator", Arrays.asList("View", "Collect Fee"));
        SEWERAGEROLEACTIONMAP.put("Super User", Arrays.asList("View", "Collect Fee"));
        SEWERAGEROLEACTIONMAP.put("Sewerage Tax Report Viewer", Arrays.asList("View", "View DCB"));
        SEWERAGEROLEACTIONMAP.put(DEFAULT, Arrays.asList("View"));
        actionUrlMap.put("View", SewerageActionDropDownUtil.getActionWithUrl("/stms/existing/sewerage/view/{consumerno}/{assessmentno}", "View"));
        actionUrlMap.put("Collect Fee", SewerageActionDropDownUtil.getActionWithUrl("/stms/collection/generatebill/{consumerno}/{assessmentno}", "Collect Fee"));
        actionUrlMap.put("View DCB", SewerageActionDropDownUtil.getActionWithUrl("/stms/reports/sewerageRateReportView/{consumerno}/{assessmentno}", "View DCB"));
        actionUrlMap.put("Change number of seats", SewerageActionDropDownUtil.getActionWithUrl("/stms/transactions/modifyConnection/{shscNumber}", "Change number of seats"));
        actionUrlMap.put("Close Sewerage Connection", SewerageActionDropDownUtil.getActionWithUrl("/stms/transactions/closeConnection/{shscNumber}", "Close Sewerage Connection"));
        actionUrlMap.put("Generate Demand Bill", SewerageActionDropDownUtil.getActionWithUrl("/stms/reports/generate-sewerage-demand-bill/{consumerno}/{assessmentno}", "Generate Demand Bill"));
    }
}

