/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.transactions.service.collection;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.collection.integration.models.BillAccountDetails;
import org.egov.commons.Installment;
import org.egov.demand.interfaces.BillServiceInterface;
import org.egov.demand.interfaces.Billable;
import org.egov.demand.model.EgBillDetails;
import org.egov.demand.model.EgDemand;
import org.egov.demand.model.EgDemandDetails;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.stms.transactions.service.SewerageDemandService;
import org.egov.stms.transactions.service.collection.SewerageBillable;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class SewerageBillServiceImpl
extends BillServiceInterface {
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private SewerageDemandService sewerageDemandService;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public List<EgBillDetails> getBilldetails(Billable billObj) {
        ArrayList<EgBillDetails> billDetailList = new ArrayList<EgBillDetails>();
        int orderNo = 1;
        SewerageBillable advBillable = (SewerageBillable)billObj;
        EgDemand dmd = advBillable.getCurrentDemand();
        ArrayList details = new ArrayList(dmd.getEgDemandDetails());
        if (!details.isEmpty()) {
            Collections.sort(details, (c1, c2) -> c1.getEgDemandReason().getEgDemandReasonMaster().getReasonMaster().compareTo(c2.getEgDemandReason().getEgDemandReasonMaster().getReasonMaster()));
        }
        for (EgDemandDetails demandDetail : details) {
            BigDecimal creaditAmt;
            if (demandDetail.getAmount().compareTo(BigDecimal.ZERO) <= 0 || demandDetail.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("SEWERAGEADVANCE") || (creaditAmt = demandDetail.getAmount().subtract(demandDetail.getAmtCollected())).compareTo(BigDecimal.ZERO) <= 0) continue;
            EgBillDetails billdetail = this.createBillDetailObject(orderNo, BigDecimal.ZERO, creaditAmt, demandDetail.getEgDemandReason().getGlcodeId().getGlcode(), this.getReceiptDetailDescription(demandDetail.getEgDemandReason().getEgDemandReasonMaster().getReasonMaster() + " " + "Collection", demandDetail.getEgDemandReason().getEgInstallmentMaster()));
            ++orderNo;
            billDetailList.add(billdetail);
        }
        return billDetailList;
    }

    private String getReceiptDetailDescription(String reasonType, Installment instlment) {
        return reasonType + (instlment != null ? " " + instlment.getDescription() : "");
    }

    private EgBillDetails createBillDetailObject(int orderNo, BigDecimal debitAmount, BigDecimal creditAmount, String glCodeForDemandDetail, String description) {
        AppConfigValues sewerageFunctionCode = (AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey("Sewerage Tax Management", "SEWERAGE_FUNCTION_CODE").get(0);
        EgBillDetails billdetail = new EgBillDetails();
        if (sewerageFunctionCode != null) {
            billdetail.setFunctionCode(sewerageFunctionCode.getValue());
        }
        billdetail.setOrderNo(Integer.valueOf(orderNo));
        billdetail.setCreateDate(new Date());
        billdetail.setModifiedDate(new Date());
        billdetail.setCrAmount(creditAmount);
        billdetail.setDrAmount(debitAmount);
        billdetail.setGlcode(glCodeForDemandDetail);
        billdetail.setDescription(description);
        billdetail.setAdditionalFlag(Integer.valueOf(1));
        billdetail.setPurpose(BillAccountDetails.PURPOSE.OTHERS.toString());
        return billdetail;
    }

    public void cancelBill() {
    }

    public String getBillXML(Billable billObj) {
        String collectXML;
        try {
            collectXML = URLEncoder.encode(super.getBillXML(billObj), "UTF-8");
            LOGGER.info((Object)("collectXML --------------------------> " + collectXML));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage());
        }
        return collectXML;
    }
}

