/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.transactions.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.validation.ValidationException;
import org.apache.commons.lang.StringUtils;
import org.egov.commons.entity.Source;
import org.egov.demand.model.EgDemand;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.EisCommonService;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.elasticsearch.entity.ApplicationIndex;
import org.egov.infra.elasticsearch.entity.enums.ApprovalStatus;
import org.egov.infra.elasticsearch.entity.enums.ClosureStatus;
import org.egov.infra.elasticsearch.service.ApplicationIndexService;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.utils.autonumber.AutonumberServiceBeanResolver;
import org.egov.infra.workflow.entity.State;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.pims.commons.Position;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.OwnerName;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.stms.autonumber.SHSCNumberGenerator;
import org.egov.stms.autonumber.SewerageApplicationNumberGenerator;
import org.egov.stms.autonumber.SewerageCloseConnectionNoticeNumberGenerator;
import org.egov.stms.autonumber.SewerageEstimationNumberGenerator;
import org.egov.stms.autonumber.SewerageWorkOrderNumberGenerator;
import org.egov.stms.masters.entity.enums.SewerageConnectionStatus;
import org.egov.stms.masters.service.DocumentTypeMasterService;
import org.egov.stms.notice.entity.SewerageNotice;
import org.egov.stms.notice.service.SewerageNoticeService;
import org.egov.stms.service.es.SewerageIndexService;
import org.egov.stms.transactions.entity.SewerageApplicationDetails;
import org.egov.stms.transactions.entity.SewerageApplicationDetailsDocument;
import org.egov.stms.transactions.entity.SewerageDemandConnection;
import org.egov.stms.transactions.repository.SewerageApplicationDetailsRepository;
import org.egov.stms.transactions.service.SewerageConnectionSmsAndEmailService;
import org.egov.stms.transactions.service.SewerageDemandService;
import org.egov.stms.transactions.workflow.ApplicationWorkflowCustomDefaultImpl;
import org.egov.stms.utils.SewerageTaxUtils;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional(readOnly=true)
public class SewerageApplicationDetailsService {
    private static final Logger LOG = LoggerFactory.getLogger(SewerageApplicationDetailsService.class);
    private static final String STMS_APPLICATION_VIEW = "/stms/existing/sewerage/view/%s/%s";
    @Autowired
    private SewerageTaxUtils sewerageTaxUtils;
    @Autowired
    @Qualifier(value="parentMessageSource")
    private MessageSource stmsMessageSource;
    protected SewerageApplicationDetailsRepository sewerageApplicationDetailsRepository;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private UserService userService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private ApplicationIndexService applicationIndexService;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private AutonumberServiceBeanResolver beanResolver;
    @Autowired
    private SewerageDemandService sewerageDemandService;
    @Autowired
    @Qualifier(value="seweargeApplicationWorkflowCustomDefaultImpl")
    private ApplicationWorkflowCustomDefaultImpl applicationWorkflowCustomDefaultImpl;
    @Autowired
    private EisCommonService eisCommonService;
    @Autowired
    private SewerageIndexService sewerageIndexService;
    @Autowired
    private SewerageConnectionSmsAndEmailService sewerageConnectionSmsAndEmailService;
    @Autowired
    private SewerageNoticeService sewerageNoticeService;
    @Autowired
    private DocumentTypeMasterService documentTypeMasterService;

    @Autowired
    public SewerageApplicationDetailsService(SewerageApplicationDetailsRepository sewerageApplicationDetailsRepository) {
        this.sewerageApplicationDetailsRepository = sewerageApplicationDetailsRepository;
    }

    public SewerageApplicationDetails findBy(Long id) {
        return (SewerageApplicationDetails)((Object)this.sewerageApplicationDetailsRepository.findOne(id));
    }

    public SewerageApplicationDetails findByApplicationNumber(String applicationNumber) {
        return this.sewerageApplicationDetailsRepository.findByApplicationNumber(applicationNumber);
    }

    public SewerageApplicationDetails findByApplicationNumberAndConnectionStatus(String applicationNumber, SewerageConnectionStatus status) {
        return this.sewerageApplicationDetailsRepository.findByApplicationNumberAndConnection_Status(applicationNumber, status);
    }

    public SewerageApplicationDetails findByConnectionShscNumberAndConnectionStatus(String shscNumber, SewerageConnectionStatus status) {
        return this.sewerageApplicationDetailsRepository.findByConnection_ShscNumberAndConnection_Status(shscNumber, status);
    }

    public List<SewerageApplicationDetails> findByConnectionShscNumber(String shscNumber) {
        return this.sewerageApplicationDetailsRepository.findByConnection_ShscNumber(shscNumber);
    }

    @Transactional
    public SewerageApplicationDetails createLegacySewerageConnection(SewerageApplicationDetails sewerageApplicationDetails, HttpServletRequest request) {
        EgDemand demand;
        SewerageApplicationNumberGenerator sewerageApplnNumberGenerator;
        if (sewerageApplicationDetails.getApplicationNumber() == null && (sewerageApplnNumberGenerator = (SewerageApplicationNumberGenerator)this.beanResolver.getAutoNumberServiceFor(SewerageApplicationNumberGenerator.class)) != null) {
            sewerageApplicationDetails.setApplicationNumber(sewerageApplnNumberGenerator.generateNextApplicationNumber(sewerageApplicationDetails));
        }
        sewerageApplicationDetails.getConnection().setLegacy(true);
        sewerageApplicationDetails.getConnection().setStatus(SewerageConnectionStatus.ACTIVE);
        sewerageApplicationDetails.setActive(true);
        sewerageApplicationDetails.setApplicationDate(new Date());
        Date disposalDate = this.getDisposalDate(sewerageApplicationDetails, sewerageApplicationDetails.getApplicationType().getProcessingTime());
        sewerageApplicationDetails.setDisposalDate(disposalDate);
        if (sewerageApplicationDetails != null && sewerageApplicationDetails.getCurrentDemand() == null && (demand = this.sewerageDemandService.createDemandOnLegacyConnection(sewerageApplicationDetails.getDemandDetailBeanList(), sewerageApplicationDetails)) != null) {
            SewerageDemandConnection sdc = new SewerageDemandConnection();
            sdc.setDemand(demand);
            sdc.setApplicationDetails(sewerageApplicationDetails);
            sewerageApplicationDetails.addDemandConnections(sdc);
        }
        this.sewerageApplicationDetailsRepository.save((Object)sewerageApplicationDetails);
        this.updateIndexes(sewerageApplicationDetails);
        return sewerageApplicationDetails;
    }

    @Transactional
    public SewerageApplicationDetails createNewSewerageConnection(SewerageApplicationDetails sewerageApplicationDetails, Long approvalPosition, String approvalComent, String additionalRule, MultipartFile[] files, String workFlowAction, HttpServletRequest request) {
        Set<FileStoreMapper> fileStoreSet;
        EgDemand demand;
        SewerageApplicationNumberGenerator sewerageApplnNumberGenerator;
        if (sewerageApplicationDetails.getApplicationNumber() == null && (sewerageApplnNumberGenerator = (SewerageApplicationNumberGenerator)this.beanResolver.getAutoNumberServiceFor(SewerageApplicationNumberGenerator.class)) != null) {
            sewerageApplicationDetails.setApplicationNumber(sewerageApplnNumberGenerator.generateNextApplicationNumber(sewerageApplicationDetails));
        }
        sewerageApplicationDetails.setApplicationDate(new Date());
        Date disposalDate = this.getDisposalDate(sewerageApplicationDetails, sewerageApplicationDetails.getApplicationType().getProcessingTime());
        sewerageApplicationDetails.setDisposalDate(disposalDate);
        if (LOG.isDebugEnabled()) {
            LOG.debug("applicationWorkflowCustomDefaultImpl initialization is done");
        }
        if (!sewerageApplicationDetails.getApplicationType().getCode().equalsIgnoreCase("CLOSESEWERAGECONNECTION") && sewerageApplicationDetails != null && sewerageApplicationDetails.getCurrentDemand() == null && (demand = this.sewerageDemandService.createDemandOnNewConnection(sewerageApplicationDetails.getConnectionFees(), sewerageApplicationDetails)) != null) {
            SewerageDemandConnection sdc = new SewerageDemandConnection();
            sdc.setDemand(demand);
            sdc.setApplicationDetails(sewerageApplicationDetails);
            sewerageApplicationDetails.addDemandConnections(sdc);
        }
        if ((fileStoreSet = this.sewerageTaxUtils.addToFileStore(files)) != null && !fileStoreSet.isEmpty()) {
            ArrayList<SewerageApplicationDetailsDocument> appDetailDocList = new ArrayList<SewerageApplicationDetailsDocument>();
            SewerageApplicationDetailsDocument appDetailDoc = new SewerageApplicationDetailsDocument();
            appDetailDoc.setApplicationDetails(sewerageApplicationDetails);
            appDetailDoc.setDocumentTypeMaster(this.documentTypeMasterService.findByApplicationTypeAndDescription(sewerageApplicationDetails.getApplicationType(), "Others"));
            appDetailDoc.setFileStore(fileStoreSet);
            appDetailDocList.add(appDetailDoc);
            sewerageApplicationDetails.setAppDetailsDocument(appDetailDocList);
        }
        this.sewerageApplicationDetailsRepository.save((Object)sewerageApplicationDetails);
        if (sewerageApplicationDetails.getApplicationType().getCode().equalsIgnoreCase("CLOSESEWERAGECONNECTION")) {
            this.applicationWorkflowCustomDefaultImpl.createCloseConnectionWorkflowTransition(sewerageApplicationDetails, approvalPosition, approvalComent, additionalRule, workFlowAction);
        } else {
            this.applicationWorkflowCustomDefaultImpl.createCommonWorkflowTransition(sewerageApplicationDetails, approvalPosition, approvalComent, additionalRule, workFlowAction);
        }
        this.updateIndexes(sewerageApplicationDetails);
        if ("COLLECTINSPECTIONFEE".equalsIgnoreCase(sewerageApplicationDetails.getStatus().getCode()) || "CREATED".equalsIgnoreCase(sewerageApplicationDetails.getStatus().getCode())) {
            this.sewerageConnectionSmsAndEmailService.sendSmsAndEmail(sewerageApplicationDetails, request);
        }
        return sewerageApplicationDetails;
    }

    @Transactional
    public void save(SewerageApplicationDetails detail) {
        this.sewerageApplicationDetailsRepository.save((Object)detail);
    }

    public Date getDisposalDate(SewerageApplicationDetails sewerageApplicationDetails, Integer appProcessTime) {
        Calendar c = Calendar.getInstance();
        c.setTime(sewerageApplicationDetails.getApplicationDate());
        c.add(5, appProcessTime);
        return c.getTime();
    }

    public List<SewerageApplicationDetails> getSewerageConnectionDetailsByPropertyIDentifier(String propertyIdentifier) {
        return this.sewerageApplicationDetailsRepository.getSewerageConnectionDetailsByPropertyID(propertyIdentifier);
    }

    public SewerageApplicationDetails findByConnection_ShscNumberAndIsActive(String shscNumber) {
        return this.sewerageApplicationDetailsRepository.getActiveSewerageApplicationByShscNumber(shscNumber);
    }

    public String checkValidPropertyAssessmentNumber(String asessmentNumber) {
        String errorMessage = "";
        AssessmentDetails assessmentDetails = this.sewerageTaxUtils.getAssessmentDetailsForFlag(asessmentNumber, PropertyExternalService.FLAG_FULL_DETAILS);
        errorMessage = this.validateProperty(assessmentDetails);
        if (errorMessage.isEmpty()) {
            errorMessage = this.validatePTDue(asessmentNumber, assessmentDetails);
        }
        return errorMessage;
    }

    private String validateProperty(AssessmentDetails assessmentDetails) {
        String errorMessage = "";
        if (assessmentDetails.getErrorDetails() != null && assessmentDetails.getErrorDetails().getErrorCode() != null) {
            errorMessage = assessmentDetails.getErrorDetails().getErrorMessage();
        }
        return errorMessage;
    }

    private String validatePTDue(String asessmentNumber, AssessmentDetails assessmentDetails) {
        String errorMessage = "";
        if (assessmentDetails.getPropertyDetails() != null && assessmentDetails.getPropertyDetails().getTaxDue() != null && assessmentDetails.getPropertyDetails().getTaxDue().doubleValue() > 0.0 && !this.sewerageTaxUtils.isNewConnectionAllowedIfPTDuePresent().booleanValue()) {
            errorMessage = this.stmsMessageSource.getMessage("err.validate.seweragenewconnection.property.taxdue", (Object[])new String[]{assessmentDetails.getPropertyDetails().getTaxDue().toString(), asessmentNumber, "new"}, null);
        }
        return errorMessage;
    }

    public String checkConnectionPresentForProperty(String propertyID) {
        String validationMessage = "";
        List<SewerageApplicationDetails> sewerageApplicationDetails = this.getSewerageConnectionDetailsByPropertyIDentifier(propertyID);
        if (sewerageApplicationDetails != null && !sewerageApplicationDetails.isEmpty()) {
            if (sewerageApplicationDetails.get(0).getConnection().getStatus().toString().equalsIgnoreCase(SewerageConnectionStatus.ACTIVE.toString())) {
                validationMessage = this.stmsMessageSource.getMessage("err.validate.seweragenewconnection.active", (Object[])new String[]{sewerageApplicationDetails.get(0).getConnection().getShscNumber(), propertyID}, null);
            } else if (sewerageApplicationDetails.get(0).getConnection().getStatus().toString().equalsIgnoreCase(SewerageConnectionStatus.INPROGRESS.toString())) {
                validationMessage = this.stmsMessageSource.getMessage("err.validate.seweragenewconnection.application.inprocess", (Object[])new String[]{propertyID, sewerageApplicationDetails.get(0).getApplicationNumber()}, null);
            } else if (sewerageApplicationDetails.get(0).getConnection().getStatus().toString().equalsIgnoreCase(SewerageConnectionStatus.INACTIVE.toString())) {
                validationMessage = this.stmsMessageSource.getMessage("err.validate.seweragenewconnection.inactive", (Object[])new String[]{sewerageApplicationDetails.get(0).getConnection().getShscNumber(), propertyID}, null);
            }
        }
        return validationMessage;
    }

    public void updateIndexes(SewerageApplicationDetails sewerageApplicationDetails) {
        AssessmentDetails assessmentDetails = this.sewerageTaxUtils.getAssessmentDetailsForFlag(sewerageApplicationDetails.getConnectionDetail().getPropertyIdentifier(), PropertyExternalService.FLAG_FULL_DETAILS);
        if (LOG.isDebugEnabled()) {
            LOG.debug(" updating Indexes Started... ");
        }
        Iterator ownerNameItr = null;
        if (null != assessmentDetails.getOwnerNames()) {
            ownerNameItr = assessmentDetails.getOwnerNames().iterator();
        }
        StringBuilder consumerName = new StringBuilder();
        StringBuilder mobileNumber = new StringBuilder();
        Assignment assignment = null;
        User user = null;
        Integer elapsedDays = 0;
        StringBuilder aadharNumber = new StringBuilder();
        if (null != ownerNameItr && ownerNameItr.hasNext()) {
            OwnerName primaryOwner = (OwnerName)ownerNameItr.next();
            consumerName.append(primaryOwner.getOwnerName() != null ? primaryOwner.getOwnerName() : "");
            mobileNumber.append(primaryOwner.getMobileNumber() != null ? primaryOwner.getMobileNumber() : "");
            aadharNumber.append(primaryOwner.getAadhaarNumber() != null ? primaryOwner.getAadhaarNumber() : "");
            while (ownerNameItr.hasNext()) {
                OwnerName secondaryOwner = (OwnerName)ownerNameItr.next();
                consumerName.append(",").append(secondaryOwner.getOwnerName() != null ? secondaryOwner.getOwnerName() : "");
                mobileNumber.append(",").append(secondaryOwner.getMobileNumber() != null ? secondaryOwner.getMobileNumber() : "");
                aadharNumber.append(",").append(secondaryOwner.getAadhaarNumber() != null ? secondaryOwner.getAadhaarNumber() : "");
            }
        }
        List<Object> asignList = null;
        if (sewerageApplicationDetails.getState() != null && sewerageApplicationDetails.getState().getOwnerPosition() != null) {
            assignment = this.assignmentService.getPrimaryAssignmentForPositionAndDate(sewerageApplicationDetails.getState().getOwnerPosition().getId(), new Date());
            if (assignment != null) {
                asignList = new ArrayList<Assignment>();
                asignList.add(assignment);
            } else if (assignment == null) {
                asignList = this.assignmentService.getAssignmentsForPosition(sewerageApplicationDetails.getState().getOwnerPosition().getId(), new Date());
            }
            if (!asignList.isEmpty()) {
                user = this.userService.getUserById(((Assignment)asignList.get(0)).getEmployee().getId());
            }
        } else {
            user = this.securityUtils.getCurrentUser();
        }
        if (sewerageApplicationDetails.getConnection().getLegacy() && (null == sewerageApplicationDetails.getId() || null != sewerageApplicationDetails.getId() && sewerageApplicationDetails.getStatus().getCode().equalsIgnoreCase("SANCTIONED"))) {
            this.sewerageIndexService.createSewarageIndex(sewerageApplicationDetails, assessmentDetails);
            return;
        }
        ApplicationIndex applicationIndex = this.applicationIndexService.findByApplicationNumber(sewerageApplicationDetails.getApplicationNumber());
        if (applicationIndex != null && null != sewerageApplicationDetails.getId()) {
            applicationIndex.setStatus(sewerageApplicationDetails.getStatus().getDescription());
            applicationIndex.setOwnername(user != null ? user.getUsername() + "::" + user.getName() : "");
            if (sewerageApplicationDetails.getStatus().getCode().equals("SANCTIONED")) {
                elapsedDays = (int)TimeUnit.DAYS.convert(new Date().getTime() - sewerageApplicationDetails.getApplicationDate().getTime(), TimeUnit.MILLISECONDS);
                applicationIndex.setElapsedDays(elapsedDays);
                applicationIndex.setApproved(ApprovalStatus.APPROVED);
                applicationIndex.setClosed(ClosureStatus.YES);
            } else if (sewerageApplicationDetails.getStatus().getCode().equals("CANCELLED")) {
                elapsedDays = (int)TimeUnit.DAYS.convert(new Date().getTime() - sewerageApplicationDetails.getApplicationDate().getTime(), TimeUnit.MILLISECONDS);
                applicationIndex.setElapsedDays(elapsedDays);
                applicationIndex.setApproved(ApprovalStatus.REJECTED);
                applicationIndex.setClosed(ClosureStatus.YES);
            }
            if (sewerageApplicationDetails.getConnection().getShscNumber() != null) {
                applicationIndex.setConsumerCode(sewerageApplicationDetails.getConnection().getShscNumber());
            }
            this.applicationIndexService.updateApplicationIndex(applicationIndex);
            this.sewerageIndexService.createSewarageIndex(sewerageApplicationDetails, assessmentDetails);
        } else {
            if (sewerageApplicationDetails.getApplicationDate() == null) {
                sewerageApplicationDetails.setApplicationDate(new Date());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Application Index creation Started... ");
            }
            applicationIndex = ApplicationIndex.builder().withModuleName("Sewerage Tax").withApplicationNumber(sewerageApplicationDetails.getApplicationNumber()).withApplicationDate(sewerageApplicationDetails.getApplicationDate()).withApplicationType(sewerageApplicationDetails.getApplicationType().getName()).withApplicantName(consumerName.toString()).withStatus(sewerageApplicationDetails.getStatus().getDescription()).withUrl(String.format(STMS_APPLICATION_VIEW, sewerageApplicationDetails.getApplicationNumber(), sewerageApplicationDetails.getConnectionDetail().getPropertyIdentifier())).withApplicantAddress(assessmentDetails.getPropertyAddress()).withOwnername(user.getUsername() + "::" + user.getName()).withChannel(Source.SYSTEM.toString()).withDisposalDate(sewerageApplicationDetails.getDisposalDate()).withMobileNumber(mobileNumber.toString()).withClosed(ClosureStatus.NO).withAadharNumber(aadharNumber.toString()).withApproved(ApprovalStatus.INPROGRESS).build();
            this.applicationIndexService.createApplicationIndex(applicationIndex);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Application Index creation completed...");
            }
            this.sewerageIndexService.createSewarageIndex(sewerageApplicationDetails, assessmentDetails);
        }
    }

    public BigDecimal getTotalAmount(SewerageApplicationDetails sewerageApplicationDetails) {
        EgDemand currentDemand;
        BigDecimal balance = BigDecimal.ZERO;
        if (sewerageApplicationDetails == null || (currentDemand = sewerageApplicationDetails.getCurrentDemand()) != null) {
            // empty if block
        }
        return balance;
    }

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public Map showApprovalDetailsByApplcationCurState(SewerageApplicationDetails sewerageApplicationDetails) {
        HashMap<String, String> modelParams = new HashMap<String, String>();
        if (sewerageApplicationDetails.getState() != null) {
            String currentState = sewerageApplicationDetails.getState().getValue();
            if (currentState.equalsIgnoreCase("Inspection Fee Pending") || currentState.equalsIgnoreCase("Assistant Engineer Approved") || currentState.equalsIgnoreCase("Deputy Exe Engineer Approved") || currentState.equalsIgnoreCase("Payment Done Against Estimation")) {
                modelParams.put("showApprovalDtls", "no");
            } else {
                modelParams.put("showApprovalDtls", "yes");
            }
            if (currentState.equalsIgnoreCase("Inspection Fee Collected") || currentState.equalsIgnoreCase("Clerk Approved")) {
                modelParams.put("mode", "edit");
            } else if (currentState.equalsIgnoreCase("Rejected")) {
                modelParams.put("mode", "editOnReject");
            } else {
                modelParams.put("mode", "view");
            }
        }
        return modelParams;
    }

    @Transactional
    public SewerageApplicationDetails updateSewerageApplicationDetails(SewerageApplicationDetails sewerageApplicationDetails, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction, String mode, ReportOutput reportOutput, HttpServletRequest request, HttpSession session) throws ValidationException {
        SewerageNotice sewerageNotice;
        SewerageNotice existingSewerageNotice;
        SewerageEstimationNumberGenerator estimationNumberGenerator;
        if (sewerageApplicationDetails.getStatus().getCode().equalsIgnoreCase("ESTIMATIONAMOUNTPAID") && sewerageApplicationDetails.getState().getValue().equalsIgnoreCase("Payment Done Against Estimation") || sewerageApplicationDetails.getStatus().getCode().equalsIgnoreCase("DEEAPPROVED") && additionalRule != null && additionalRule.equalsIgnoreCase("CHANGEINCLOSETS NOCOLLECTION")) {
            SHSCNumberGenerator shscNumberGenerator;
            SewerageWorkOrderNumberGenerator workOrderNumberGenerator;
            if (sewerageApplicationDetails.getWorkOrderNumber() == null && (workOrderNumberGenerator = (SewerageWorkOrderNumberGenerator)this.beanResolver.getAutoNumberServiceFor(SewerageWorkOrderNumberGenerator.class)) != null) {
                sewerageApplicationDetails.setWorkOrderNumber(workOrderNumberGenerator.generateSewerageWorkOrderNumber());
                sewerageApplicationDetails.setWorkOrderDate(new Date());
            }
            if (sewerageApplicationDetails.getConnection().getShscNumber() == null && (shscNumberGenerator = (SHSCNumberGenerator)this.beanResolver.getAutoNumberServiceFor(SHSCNumberGenerator.class)) != null) {
                sewerageApplicationDetails.getConnection().setShscNumber(shscNumberGenerator.generateNextSHSCNumber(sewerageApplicationDetails));
            }
        }
        if (sewerageApplicationDetails.getStatus().getCode() != null && sewerageApplicationDetails.getStatus().getCode().equalsIgnoreCase("INITIALAPPROVED") || sewerageApplicationDetails.getStatus().getCode().equalsIgnoreCase("INSPECTIONFEEPAID") || sewerageApplicationDetails.getStatus().getCode().equalsIgnoreCase("CREATED")) {
            if (sewerageApplicationDetails != null && sewerageApplicationDetails.getCurrentDemand() == null) {
                EgDemand demand = this.sewerageDemandService.createDemandOnNewConnection(sewerageApplicationDetails.getConnectionFees(), sewerageApplicationDetails);
                if (demand != null) {
                    SewerageDemandConnection sdc = new SewerageDemandConnection();
                    sdc.setDemand(demand);
                    sdc.setApplicationDetails(sewerageApplicationDetails);
                    sewerageApplicationDetails.addDemandConnections(sdc);
                }
            } else if (sewerageApplicationDetails.getApplicationType().getCode().equalsIgnoreCase("CHANGEINCLOSETS")) {
                SewerageApplicationDetails oldSewerageAppDtls = this.findByConnection_ShscNumberAndIsActive(sewerageApplicationDetails.getConnection().getShscNumber());
                if (!workFlowAction.equals("Reject")) {
                    if (sewerageApplicationDetails.getStatus().getCode().equalsIgnoreCase("INITIALAPPROVED")) {
                        this.sewerageDemandService.updateDemandOnChangeInClosets(oldSewerageAppDtls, sewerageApplicationDetails.getConnectionFees(), sewerageApplicationDetails.getCurrentDemand(), Boolean.TRUE);
                    } else {
                        this.sewerageDemandService.updateDemandOnChangeInClosets(oldSewerageAppDtls, sewerageApplicationDetails.getConnectionFees(), sewerageApplicationDetails.getCurrentDemand(), Boolean.FALSE);
                    }
                }
            } else {
                this.sewerageDemandService.updateDemand(sewerageApplicationDetails.getConnectionFees(), sewerageApplicationDetails.getCurrentDemand());
            }
        }
        if (sewerageApplicationDetails.getStatus().getCode().equalsIgnoreCase("DEEAPPROVED") && sewerageApplicationDetails.getState().getValue().equalsIgnoreCase("Deputy Exe Engineer Approved") && additionalRule != null && !additionalRule.equalsIgnoreCase("CHANGEINCLOSETS NOCOLLECTION") && sewerageApplicationDetails.getEstimationNumber() == null && (estimationNumberGenerator = (SewerageEstimationNumberGenerator)this.beanResolver.getAutoNumberServiceFor(SewerageEstimationNumberGenerator.class)) != null) {
            sewerageApplicationDetails.setEstimationNumber(estimationNumberGenerator.generateEstimationNumber());
            sewerageApplicationDetails.setEstimationDate(new Date());
        }
        if (additionalRule != null && additionalRule.equalsIgnoreCase("CHANGEINCLOSETS NOCOLLECTION")) {
            this.applicationStatusChange(sewerageApplicationDetails, workFlowAction, additionalRule);
        } else {
            this.applicationStatusChange(sewerageApplicationDetails, workFlowAction, mode);
        }
        if (sewerageApplicationDetails.getStatus().getCode().equalsIgnoreCase("ESTIMATIONNOTICEGENERATED")) {
            SewerageNotice sewerageNotice2 = this.sewerageNoticeService.generateReportForEstimation(sewerageApplicationDetails, session, request);
            if (sewerageNotice2 != null) {
                sewerageApplicationDetails.addNotice(sewerageNotice2);
            }
        } else if (sewerageApplicationDetails.getStatus().getCode().equalsIgnoreCase("WORKORDERGENERATED") && (existingSewerageNotice = this.sewerageNoticeService.findByNoticeNoAndNoticeType(sewerageApplicationDetails.getWorkOrderNumber(), "Workorder Notice")) == null && (sewerageNotice = this.sewerageNoticeService.generateReportForWorkOrder(sewerageApplicationDetails, session, request)) != null) {
            sewerageApplicationDetails.addNotice(sewerageNotice);
        }
        SewerageApplicationDetails updatedSewerageApplicationDetails = (SewerageApplicationDetails)((Object)this.sewerageApplicationDetailsRepository.save((Object)sewerageApplicationDetails));
        if (LOG.isDebugEnabled()) {
            LOG.debug("applicationWorkflowCustomDefaultImpl initialization is done");
        }
        this.applicationWorkflowCustomDefaultImpl.createCommonWorkflowTransition(updatedSewerageApplicationDetails, approvalPosition, approvalComent, additionalRule, workFlowAction);
        if (sewerageApplicationDetails.getApplicationType().getCode().equalsIgnoreCase("CHANGEINCLOSETS") && sewerageApplicationDetails.getParent() != null) {
            this.updateIndexes(sewerageApplicationDetails.getParent());
        }
        this.updateIndexes(sewerageApplicationDetails);
        if ("COLLECTINSPECTIONFEE".equalsIgnoreCase(sewerageApplicationDetails.getStatus().getCode()) || "DEEAPPROVED".equalsIgnoreCase(sewerageApplicationDetails.getStatus().getCode()) || "CREATED".equalsIgnoreCase(sewerageApplicationDetails.getStatus().getCode()) || "FINALAPPROVED".equalsIgnoreCase(sewerageApplicationDetails.getStatus().getCode()) || "REJECTED".equalsIgnoreCase(sewerageApplicationDetails.getStatus().getCode())) {
            sewerageApplicationDetails.setApprovalComent(approvalComent);
            this.sewerageConnectionSmsAndEmailService.sendSmsAndEmail(sewerageApplicationDetails, request);
        }
        return updatedSewerageApplicationDetails;
    }

    public void applicationStatusChange(SewerageApplicationDetails sewerageApplicationDetails, String workFlowAction, String mode) {
        if (null != sewerageApplicationDetails && null != sewerageApplicationDetails.getStatus() && null != sewerageApplicationDetails.getStatus().getCode()) {
            if ("Reject".equalsIgnoreCase(workFlowAction)) {
                sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("REJECTED", "SEWERAGETAXAPPLICATION"));
            } else if ("Cancel".equalsIgnoreCase(workFlowAction)) {
                if (sewerageApplicationDetails.getApplicationType().getCode().equalsIgnoreCase("CHANGEINCLOSETS")) {
                    sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("CANCELLED", "SEWERAGETAXAPPLICATION"));
                    sewerageApplicationDetails.getConnection().setStatus(SewerageConnectionStatus.ACTIVE);
                } else {
                    sewerageApplicationDetails.getConnection().setStatus(SewerageConnectionStatus.INACTIVE);
                    sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("CANCELLED", "SEWERAGETAXAPPLICATION"));
                }
            } else if (sewerageApplicationDetails.getStatus().getCode().equals("CREATED") || sewerageApplicationDetails.getStatus().getCode().equals("INSPECTIONFEEPAID")) {
                sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("INITIALAPPROVED", "SEWERAGETAXAPPLICATION"));
            } else if (sewerageApplicationDetails.getStatus().getCode().equals("COLLECTINSPECTIONFEE")) {
                sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("INSPECTIONFEEPAID", "SEWERAGETAXAPPLICATION"));
            } else if (sewerageApplicationDetails.getStatus().getCode().equals("INITIALAPPROVED")) {
                sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("DEEAPPROVED", "SEWERAGETAXAPPLICATION"));
            } else if (sewerageApplicationDetails.getStatus().getCode().equals("DEEAPPROVED")) {
                if (mode != null && mode.equalsIgnoreCase("CHANGEINCLOSETS NOCOLLECTION")) {
                    sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("FINALAPPROVED", "SEWERAGETAXAPPLICATION"));
                } else {
                    sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("ESTIMATIONNOTICEGENERATED", "SEWERAGETAXAPPLICATION"));
                }
            } else if (sewerageApplicationDetails.getStatus().getCode().equals("ESTIMATIONNOTICEGENERATED")) {
                sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("ESTIMATIONAMOUNTPAID", "SEWERAGETAXAPPLICATION"));
            } else if (sewerageApplicationDetails.getStatus().getCode().equals("ESTIMATIONAMOUNTPAID") && sewerageApplicationDetails.getState().getValue().equalsIgnoreCase("Payment Done Against Estimation")) {
                sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("FINALAPPROVED", "SEWERAGETAXAPPLICATION"));
            } else if (sewerageApplicationDetails.getStatus().getCode().equals("FINALAPPROVED")) {
                sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("WORKORDERGENERATED", "SEWERAGETAXAPPLICATION"));
            } else if (sewerageApplicationDetails.getStatus().getCode().equals("WORKORDERGENERATED")) {
                sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("SANCTIONED", "SEWERAGETAXAPPLICATION"));
                if (sewerageApplicationDetails.getConnection().getStatus().equals((Object)SewerageConnectionStatus.INPROGRESS)) {
                    sewerageApplicationDetails.getConnection().setStatus(SewerageConnectionStatus.ACTIVE);
                }
                sewerageApplicationDetails.setActive(true);
            } else if (sewerageApplicationDetails.getStatus().getCode().equals("REJECTED")) {
                if (this.sewerageTaxUtils.isInspectionFeeCollectionRequired()) {
                    if (sewerageApplicationDetails.getCurrentDemand().getAmtCollected().compareTo(BigDecimal.ZERO) == 0) {
                        sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("COLLECTINSPECTIONFEE", "SEWERAGETAXAPPLICATION"));
                    } else {
                        sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("INSPECTIONFEEPAID", "SEWERAGETAXAPPLICATION"));
                    }
                } else {
                    sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("CREATED", "SEWERAGETAXAPPLICATION"));
                }
            }
        }
    }

    @Transactional
    public SewerageApplicationDetails updateCloseSewerageApplicationDetails(SewerageApplicationDetails sewerageApplicationDetails, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction, ReportOutput reportOutput, HttpServletRequest request, HttpSession session) throws ValidationException {
        SewerageNotice sewerageNotice;
        SewerageCloseConnectionNoticeNumberGenerator closeConnectionNoticeNumberGenerator;
        if (sewerageApplicationDetails.getStatus().getCode().equalsIgnoreCase("DEEAPPROVED") && sewerageApplicationDetails.getApplicationType().getCode().equalsIgnoreCase("CLOSESEWERAGECONNECTION") && "Approve".equalsIgnoreCase(workFlowAction) && (closeConnectionNoticeNumberGenerator = (SewerageCloseConnectionNoticeNumberGenerator)this.beanResolver.getAutoNumberServiceFor(SewerageCloseConnectionNoticeNumberGenerator.class)) != null && sewerageApplicationDetails.getClosureNoticeNumber() == null) {
            sewerageApplicationDetails.setClosureNoticeNumber(closeConnectionNoticeNumberGenerator.generateCloserNoticeNumber());
            sewerageApplicationDetails.setClosureNoticeDate(new Date());
        }
        if (null != sewerageApplicationDetails && null != sewerageApplicationDetails.getStatus() && null != sewerageApplicationDetails.getStatus().getCode()) {
            if ("Reject".equalsIgnoreCase(workFlowAction)) {
                sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("REJECTED", "SEWERAGETAXAPPLICATION"));
            } else if ("Cancel".equalsIgnoreCase(workFlowAction)) {
                sewerageApplicationDetails.getConnection().setStatus(SewerageConnectionStatus.ACTIVE);
                sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("CANCELLED", "SEWERAGETAXAPPLICATION"));
            } else if (sewerageApplicationDetails.getStatus().getCode().equals("CREATED")) {
                sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("INITIALAPPROVED", "SEWERAGETAXAPPLICATION"));
            } else if (sewerageApplicationDetails.getStatus().getCode().equals("INITIALAPPROVED")) {
                sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("DEEAPPROVED", "SEWERAGETAXAPPLICATION"));
            } else if (sewerageApplicationDetails.getStatus().getCode().equals("DEEAPPROVED")) {
                sewerageApplicationDetails.getConnection().setStatus(SewerageConnectionStatus.CLOSED);
                sewerageApplicationDetails.setActive(true);
                sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("CLOSERSANCTIONED", "SEWERAGETAXAPPLICATION"));
            } else if (sewerageApplicationDetails.getStatus().getCode().equals("REJECTED")) {
                sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("CREATED", "SEWERAGETAXAPPLICATION"));
            }
        }
        if (sewerageApplicationDetails.getStatus().getCode().equalsIgnoreCase("CLOSERSANCTIONED") && "Approve".equalsIgnoreCase(workFlowAction) && (sewerageNotice = this.sewerageNoticeService.generateReportForCloseConnection(sewerageApplicationDetails, session)) != null) {
            sewerageApplicationDetails.addNotice(sewerageNotice);
        }
        SewerageApplicationDetails updatedSewerageApplicationDetails = (SewerageApplicationDetails)((Object)this.sewerageApplicationDetailsRepository.save((Object)sewerageApplicationDetails));
        if (LOG.isDebugEnabled()) {
            LOG.debug("applicationWorkflowCustomDefaultImpl initialization is done");
        }
        this.applicationWorkflowCustomDefaultImpl.createCloseConnectionWorkflowTransition(updatedSewerageApplicationDetails, approvalPosition, approvalComent, additionalRule, workFlowAction);
        if (sewerageApplicationDetails.getParent() != null) {
            this.updateIndexes(sewerageApplicationDetails.getParent());
        }
        this.updateIndexes(sewerageApplicationDetails);
        if ("CLOSERSANCTIONED".equalsIgnoreCase(sewerageApplicationDetails.getStatus().getCode()) && "Approve".equalsIgnoreCase(workFlowAction) || "CREATED".equalsIgnoreCase(sewerageApplicationDetails.getStatus().getCode()) || "REJECTED".equalsIgnoreCase(sewerageApplicationDetails.getStatus().getCode())) {
            sewerageApplicationDetails.setApprovalComent(approvalComent);
            this.sewerageConnectionSmsAndEmailService.sendSmsAndEmail(sewerageApplicationDetails, request);
        }
        return updatedSewerageApplicationDetails;
    }

    public List<Hashtable<String, Object>> getHistory(SewerageApplicationDetails sewerageApplicationDetails) {
        User user = null;
        ArrayList<Hashtable<String, Object>> historyTable = new ArrayList<Hashtable<String, Object>>();
        State state = sewerageApplicationDetails.getState();
        Hashtable<String, Object> map = new Hashtable<String, Object>(0);
        if (null != state) {
            if (!sewerageApplicationDetails.getStateHistory().isEmpty() && sewerageApplicationDetails.getStateHistory() != null) {
                Collections.reverse(sewerageApplicationDetails.getStateHistory());
            }
            for (StateHistory stateHistory : sewerageApplicationDetails.getStateHistory()) {
                Hashtable<String, Object> HistoryMap = new Hashtable<String, Object>(0);
                HistoryMap.put("date", stateHistory.getDateInfo());
                HistoryMap.put("comments", stateHistory.getComments());
                HistoryMap.put("updatedBy", stateHistory.getLastModifiedBy().getUsername() + "::" + stateHistory.getLastModifiedBy().getName());
                HistoryMap.put("status", stateHistory.getValue());
                Position owner = stateHistory.getOwnerPosition();
                user = stateHistory.getOwnerUser();
                if (null != user) {
                    HistoryMap.put("user", user.getUsername() + "::" + user.getName());
                    HistoryMap.put("department", null != this.eisCommonService.getDepartmentForUser(user.getId()) ? this.eisCommonService.getDepartmentForUser(user.getId()).getName() : "");
                } else if (null != owner && null != owner.getDeptDesig()) {
                    user = this.eisCommonService.getUserForPosition(owner.getId(), new Date());
                    HistoryMap.put("user", null != user.getUsername() ? user.getUsername() + "::" + user.getName() : "");
                    HistoryMap.put("department", null != owner.getDeptDesig().getDepartment() ? owner.getDeptDesig().getDepartment().getName() : "");
                }
                historyTable.add(HistoryMap);
            }
            map.put("date", state.getDateInfo());
            map.put("comments", state.getComments() != null ? state.getComments() : "");
            map.put("updatedBy", state.getLastModifiedBy().getUsername() + "::" + state.getLastModifiedBy().getName());
            map.put("status", state.getValue());
            Position ownerPosition = state.getOwnerPosition();
            user = state.getOwnerUser();
            if (null != user) {
                map.put("user", user.getUsername() + "::" + user.getName());
                map.put("department", null != this.eisCommonService.getDepartmentForUser(user.getId()) ? this.eisCommonService.getDepartmentForUser(user.getId()).getName() : "");
            } else if (null != ownerPosition && null != ownerPosition.getDeptDesig()) {
                user = this.eisCommonService.getUserForPosition(ownerPosition.getId(), new Date());
                map.put("user", null != user.getUsername() ? user.getUsername() + "::" + user.getName() : "");
                map.put("department", null != ownerPosition.getDeptDesig().getDepartment() ? ownerPosition.getDeptDesig().getDepartment().getName() : "");
            }
            historyTable.add(map);
        }
        return historyTable;
    }

    public void updateStateTransition(SewerageApplicationDetails sewerageApplicationDetails, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction) {
        if (approvalPosition != null && additionalRule != null && StringUtils.isNotEmpty((String)workFlowAction)) {
            this.applicationWorkflowCustomDefaultImpl.createCommonWorkflowTransition(sewerageApplicationDetails, approvalPosition, approvalComent, additionalRule, workFlowAction);
        }
    }

    public SewerageApplicationDetails checkModifyClosetInProgress(String shscNumber) {
        return this.sewerageApplicationDetailsRepository.getSewerageApplicationInWorkFlow(shscNumber);
    }

    public BigDecimal getPendingTaxAmount(SewerageApplicationDetails sewerageApplicationDetails) {
        BigDecimal taxPending = BigDecimal.ZERO;
        taxPending = this.sewerageDemandService.checkForPendingTaxAmountToCollect(sewerageApplicationDetails.getCurrentDemand());
        return taxPending;
    }
}

