/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.transactions.repository;

import java.util.Date;
import java.util.List;
import org.egov.stms.masters.entity.SewerageApplicationType;
import org.egov.stms.masters.entity.enums.SewerageConnectionStatus;
import org.egov.stms.transactions.entity.SewerageApplicationDetails;
import org.egov.stms.transactions.entity.SewerageConnection;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface SewerageApplicationDetailsRepository
extends JpaRepository<SewerageApplicationDetails, Long> {
    public SewerageApplicationDetails findByApplicationNumber(String var1);

    public SewerageApplicationDetails findByApplicationNumberAndConnection_Status(String var1, SewerageConnectionStatus var2);

    public List<SewerageApplicationDetails> findAllByApplicationDateOrderByApplicationNumberAsc(Date var1);

    public List<SewerageApplicationDetails> findAllByApplicationDateAndConnection_StatusOrderByApplicationNumberAsc(Date var1, SewerageConnectionStatus var2);

    public List<SewerageApplicationDetails> findAllByApplicationTypeOrderByApplicationNumberAsc(SewerageApplicationType var1);

    public List<SewerageApplicationDetails> findAllByApplicationTypeAndConnection_StatusOrderByApplicationNumberAsc(SewerageApplicationType var1, SewerageConnectionStatus var2);

    public SewerageApplicationDetails findByConnection_ShscNumberAndConnection_Status(String var1, SewerageConnectionStatus var2);

    public List<SewerageApplicationDetails> findByConnection_ShscNumber(String var1);

    public SewerageApplicationDetails findByConnection(SewerageConnection var1);

    public SewerageApplicationDetails findByConnectionAndConnection_Status(SewerageConnection var1, SewerageConnectionStatus var2);

    @Query(value="select scd from SewerageApplicationDetails scd where scd.connection.status not in ('INACTIVE') and scd.connectionDetail.propertyIdentifier =:propertyIdentifier order by scd.id desc")
    public List<SewerageApplicationDetails> getSewerageConnectionDetailsByPropertyID(@Param(value="propertyIdentifier") String var1);

    @Query(value="select scd from SewerageApplicationDetails scd where scd.isActive='t' and scd.connection.shscNumber =:shscNumber")
    public SewerageApplicationDetails getActiveSewerageApplicationByShscNumber(@Param(value="shscNumber") String var1);

    @Query(value="select scd from SewerageApplicationDetails scd where scd.connection.shscNumber =:shscNumber and scd.isActive='f' and upper(scd.status.code) not in ('CANCELLED','SANCTIONED')")
    public SewerageApplicationDetails getSewerageApplicationInWorkFlow(@Param(value="shscNumber") String var1);
}

