/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.transactions.entity;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.stms.masters.entity.enums.SewerageConnectionStatus;
import org.egov.stms.transactions.entity.SewerageApplicationDetails;
import org.egov.stms.transactions.entity.SewerageConnectionHistory;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.SafeHtml;

@Entity
@Table(name="egswtax_connection")
@SequenceGenerator(name="SEQ_EGSWTAX_CONNECTION", sequenceName="SEQ_EGSWTAX_CONNECTION", allocationSize=1)
public class SewerageConnection
extends AbstractAuditable {
    private static final long serialVersionUID = 1248986191220418633L;
    public static final String SEQ_CONNECTION = "SEQ_EGSWTAX_CONNECTION";
    @Id
    @GeneratedValue(generator="SEQ_EGSWTAX_CONNECTION", strategy=GenerationType.SEQUENCE)
    private Long id;
    @SafeHtml
    @Length(min=3, max=50)
    @Column(name="shsc_number")
    private String shscNumber;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    private SewerageConnectionStatus status;
    private boolean legacy = false;
    @Temporal(value=TemporalType.DATE)
    private Date executionDate;
    @OrderBy(value="id desc")
    @OneToMany(mappedBy="connection", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private List<SewerageConnectionHistory> connectionHistories = new ArrayList<SewerageConnectionHistory>(0);
    @OrderBy(value="id desc")
    @OneToMany(mappedBy="connection", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private List<SewerageApplicationDetails> applicationDetails = new ArrayList<SewerageApplicationDetails>(0);

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getShscNumber() {
        return this.shscNumber;
    }

    public void setShscNumber(String shscNumber) {
        this.shscNumber = shscNumber;
    }

    public boolean getLegacy() {
        return this.legacy;
    }

    public void setLegacy(boolean legacy) {
        this.legacy = legacy;
    }

    public Date getExecutionDate() {
        return this.executionDate;
    }

    public void setExecutionDate(Date executionDate) {
        this.executionDate = executionDate;
    }

    public List<SewerageConnectionHistory> getConnectionHistories() {
        return this.connectionHistories;
    }

    public void setConnectionHistories(List<SewerageConnectionHistory> connectionHistories) {
        this.connectionHistories = connectionHistories;
    }

    public List<SewerageApplicationDetails> getApplicationDetails() {
        return this.applicationDetails;
    }

    public void setApplicationDetails(List<SewerageApplicationDetails> applicationDetails) {
        this.applicationDetails = applicationDetails;
    }

    public SewerageConnectionStatus getStatus() {
        return this.status;
    }

    public void setStatus(SewerageConnectionStatus status) {
        this.status = status;
    }

    public void addApplicantDetails(SewerageApplicationDetails applicationDetails) {
        this.getApplicationDetails().add(applicationDetails);
    }
}

